/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ConceptsTreeDialog;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryEntryPanel;
import com.sun.xml.registry.ebxml.infomodel.ExtrinsicObjectImpl;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExtrinsicObject;

public class ExtrinsicObjectPanel
extends RegistryEntryPanel {
    JTextField objectTypeText = null;
    JCheckBox isOpaqueCheckBox = null;
    JComboBox mimeTypeCombo = null;
    static JFileChooser chooser = new JFileChooser();
    String[] mimeTypes = new String[]{"application/octet-stream", "text/xml", "text/plain"};

    public ExtrinsicObjectPanel() {
        this.setBorder(BorderFactory.createTitledBorder("ExtrinsicObject Details"));
        JLabel mimeTypeLabel = new JLabel("Mime Type:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(mimeTypeLabel, this.c);
        this.add(mimeTypeLabel);
        this.mimeTypeCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.mimeTypes));
        this.mimeTypeCombo.setEditable(true);
        this.c.gridx = 0;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.mimeTypeCombo, this.c);
        this.add(this.mimeTypeCombo);
        JLabel conceptLabel = new JLabel("Object Type:", 2);
        this.c.gridx = 1;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(conceptLabel, this.c);
        this.add(conceptLabel);
        this.objectTypeText = new JTextField();
        this.objectTypeText.setEditable(false);
        this.c.gridx = 1;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(this.objectTypeText, this.c);
        this.add(this.objectTypeText);
        JButton showSchemeButton = new JButton("Select Concept for Object Type...");
        showSchemeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ExtrinsicObjectPanel.this.getSelectedConcept();
            }
        });
        this.c.gridx = 1;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(showSchemeButton, this.c);
        this.add(showSchemeButton);
        this.isOpaqueCheckBox = new JCheckBox("Is Opaque");
        this.isOpaqueCheckBox.setSelected(false);
        this.c.gridx = 0;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.isOpaqueCheckBox, this.c);
        this.add(this.isOpaqueCheckBox);
        JPanel buttonPanel = new JPanel();
        this.c.gridx = 1;
        this.c.gridy = this.row + 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 2;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(buttonPanel, this.c);
        this.add(buttonPanel);
        JButton chooseRepositoryItemButton = new JButton("Choose Repository Item file...");
        chooseRepositoryItemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ExtrinsicObjectPanel.this.getRepositoryItemFromFile();
            }
        });
        buttonPanel.add((Component)chooseRepositoryItemButton, "North");
        JButton removeRepositoryItemButton = new JButton("Remove Repository Item");
        removeRepositoryItemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ExtrinsicObjectPanel.this.removeRepositoryItem();
            }
        });
        buttonPanel.add((Component)removeRepositoryItemButton, "South");
    }

    private void getSelectedConcept() {
        ConceptsTreeDialog dialog = ConceptsTreeDialog.showSchemes(this, true, true);
        if (dialog.getStatus() == 1) {
            ArrayList selectedObjects = dialog.getSelectedObjects();
            int selectionCount = selectedObjects.size();
            if (selectionCount == 0) {
                RegistryBrowser.displayError("Must select a Concept in ClassificationScheme dialog");
            } else {
                if (selectionCount > 1) {
                    RegistryBrowser.displayError("Only one selection allowed in ClassificationScheme dialog. Using last selection");
                }
                ExtrinsicObject eo = (ExtrinsicObject)this.model;
                Object obj = selectedObjects.get(selectionCount - 1);
                try {
                    if (!(obj instanceof Concept)) {
                        throw new JAXRException("Must select a Concept only");
                    }
                    Concept concept = (Concept)obj;
                    ((ExtrinsicObjectImpl)eo).setObjectType(concept);
                    this.objectTypeText.setText(concept.getValue());
                }
                catch (JAXRException e) {
                    RegistryBrowser.displayError(e);
                }
            }
        }
    }

    private void getRepositoryItemFromFile() {
        if (this.model != null) {
            ExtrinsicObject eo = (ExtrinsicObject)this.model;
            try {
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal == 0) {
                    File repositoryItemFile = chooser.getSelectedFile();
                    DataHandler repositoryItemDH = new DataHandler((DataSource)new FileDataSource(repositoryItemFile));
                    eo.setRepositoryItem(repositoryItemDH);
                }
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        }
    }

    private void removeRepositoryItem() {
        if (this.model != null) {
            ExtrinsicObject eo = (ExtrinsicObject)this.model;
            try {
                eo.setRepositoryItem(null);
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        }
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof ExtrinsicObject)) {
            throw new InvalidRequestException("Expecting a ExtrinsicObject. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        ExtrinsicObject eo = (ExtrinsicObject)obj;
        try {
            if (eo != null) {
                this.isOpaqueCheckBox.setSelected(eo.isOpaque());
                Concept objectType = eo.getObjectType();
                if (objectType != null) {
                    this.objectTypeText.setText(objectType.getValue());
                }
                String mimeType = eo.getMimeType();
                this.mimeTypeCombo.insertItemAt(mimeType, 0);
                this.mimeTypeCombo.setSelectedIndex(0);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            ExtrinsicObject eo = (ExtrinsicObject)this.model;
            eo.setOpaque(this.isOpaqueCheckBox.isSelected());
            eo.setMimeType((String)this.mimeTypeCombo.getSelectedItem());
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        ExtrinsicObject eo = (ExtrinsicObject)this.model;
    }

    public void clear() throws JAXRException {
        super.clear();
        this.isOpaqueCheckBox.setSelected(false);
    }
}

