/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.HyperLinkContainer;
import com.sun.xml.registry.client.browser.HyperLinker;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class HyperLinkLabel
extends JLabel
implements HyperLinkContainer {
    Color stdFG = Color.BLACK;
    Font stdFont;
    Font urlFont;
    Color urlNormalFG = Color.BLUE;
    Color urlHiliteFG = Color.RED;
    String url;
    MouseListener mouseListener;
    HyperLinkContainer linkContainer = null;

    public HyperLinkLabel() {
        this(null, null, 0);
    }

    public HyperLinkLabel(Icon image) {
        this(null, image, 0);
    }

    public HyperLinkLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public HyperLinkLabel(String text) {
        this(text, null, 0);
    }

    public HyperLinkLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public HyperLinkLabel(String text, Icon icon, int horizontalAlignment) {
        super(icon, horizontalAlignment);
        this.stdFG = this.getForeground();
        this.stdFont = this.getFont();
        this.urlFont = this.stdFont.deriveFont(1);
        this.setText(text);
        this.mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                String _url = HyperLinkLabel.this.getURL();
                if (_url != null && _url.length() > 0) {
                    HyperLinker.displayURL(_url);
                }
            }

            public void mouseEntered(MouseEvent e) {
                String _url = HyperLinkLabel.this.getURL();
                if (_url != null && _url.length() > 0) {
                    HyperLinkLabel.this.setCursor(new Cursor(12));
                    HyperLinkLabel.this.setForeground(HyperLinkLabel.this.urlHiliteFG);
                }
            }

            public void mouseExited(MouseEvent e) {
                String _url = HyperLinkLabel.this.getURL();
                if (_url != null && _url.length() > 0) {
                    HyperLinkLabel.this.setForeground(HyperLinkLabel.this.urlNormalFG);
                    HyperLinkLabel.this.setCursor(new Cursor(0));
                }
            }
        };
    }

    public String getURL() {
        if (this.linkContainer != null) {
            this.url = this.linkContainer.getURL();
        }
        return this.url;
    }

    public void setURL(String urlString) throws MalformedURLException {
        this.removeMouseListener(this.mouseListener);
        this.url = null;
        this.linkContainer = null;
        this.setForeground(this.stdFG);
        this.setCursor(new Cursor(0));
        URL _url = null;
        if (urlString != null) {
            _url = new URL(urlString);
        }
        if (_url != null) {
            this.url = urlString;
            this.linkContainer = null;
            this.setForeground(this.urlNormalFG);
            this.addMouseListener(this.mouseListener);
        }
    }

    public HyperLinkContainer getHyperLinkContainer() {
        HyperLinkContainer _linkContainer = this.linkContainer;
        if (_linkContainer == null) {
            _linkContainer = this;
        }
        return _linkContainer;
    }

    public void setHyperLinkContainer(HyperLinkContainer linkContainer) {
        this.linkContainer = linkContainer;
        this.setForeground(this.urlNormalFG);
        this.addMouseListener(this.mouseListener);
    }

    public void setText(String text) {
        super.setText(text);
        URL _url = null;
        try {
            _url = new URL(text);
            this.setURL(text);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws MalformedURLException {
        JFrame f = new JFrame("HyperLinkLabel Tester");
        f.setDefaultCloseOperation(0);
        Container c = f.getContentPane();
        HyperLinkLabel lb = new HyperLinkLabel("click me");
        lb.setURL("http://ebxmlrr.sourceforge.net");
        c.add(lb);
        f.pack();
        f.show();
    }
}

