/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.HyperLinkLabel;
import com.sun.xml.registry.client.browser.RegistryObjectsTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import java.net.MalformedURLException;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class JBDefaultTableCellRenderer
extends HyperLinkLabel
implements TableCellRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;

    public JBDefaultTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.setHorizontalAlignment(2);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        value = RegistryObjectsTable.convertValue(value);
        this.setValue(value);
        return this;
    }

    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        try {
            this.setURL(null);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.setText(value == null ? "" : value.toString());
    }

    public static class UIResource
    extends JBDefaultTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

