/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JBEditorDialog;
import com.sun.xml.registry.client.browser.JBList;
import com.sun.xml.registry.client.browser.JBListModel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectPanel;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class OrganizationPanel
extends RegistryObjectPanel {
    RegistryObjectPanel roPanel = null;
    JBList phonesList = null;
    JBList addrsList = null;
    JTextField primContactText = null;
    JBEditorDialog postalAddressDialog = null;
    JBEditorDialog primaryContactDialog = null;

    public OrganizationPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Organization Details"));
        JLabel addrLabel = new JLabel("Postal Address:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(addrLabel, this.c);
        this.add(addrLabel);
        this.addrsList = new JBList("PostalAddress", new JBListModel());
        this.addrsList.setVisibleRowCount(3);
        this.c.gridx = 0;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.addrsList, this.c);
        this.add(this.addrsList);
        JLabel phonesLabel = new JLabel("Telephone Numbers:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(phonesLabel, this.c);
        this.add(phonesLabel);
        this.phonesList = new JBList("TelephoneNumber", new JBListModel());
        this.phonesList.setVisibleRowCount(2);
        JScrollPane phonesListScrollPane = new JScrollPane(this.phonesList);
        this.c.gridx = 0;
        this.c.gridy = this.row + 3;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(phonesListScrollPane, this.c);
        this.add(phonesListScrollPane);
        JLabel primContactLabel = new JLabel("Primary Contact:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 4;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(primContactLabel, this.c);
        this.add(primContactLabel);
        this.primContactText = new JTextField();
        this.primContactText.setEditable(false);
        this.c.gridx = 0;
        this.c.gridy = this.row + 5;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.primContactText, this.c);
        this.add(this.primContactText);
        JButton primContactButton = new JButton("Contact Details...");
        primContactButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    OrganizationPanel.this.getPrimaryContactDialog().setVisible(true);
                }
                catch (JAXRException e) {
                    RegistryBrowser.displayError(e);
                }
            }
        });
        this.c.gridx = 1;
        this.c.gridy = this.row + 5;
        this.c.gridwidth = 1;
        this.c.gridheight = 2;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(primContactButton, this.c);
        this.add(primContactButton);
    }

    private JBEditorDialog getPostalAddressDialog() throws JAXRException {
        if (this.postalAddressDialog == null) {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window instanceof JFrame) {
                this.postalAddressDialog = new JBEditorDialog((JFrame)window, false);
            } else if (window instanceof JDialog) {
                this.postalAddressDialog = new JBEditorDialog((JDialog)window, false);
            }
            this.postalAddressDialog.setLocation(50, 50);
            if (this.model != null) {
                this.postalAddressDialog.setModel(this.getOrganization().getPostalAddress());
            }
            this.postalAddressDialog.setEditable(this.editable);
        }
        return this.postalAddressDialog;
    }

    private JBEditorDialog getPrimaryContactDialog() throws JAXRException {
        if (this.primaryContactDialog == null) {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window instanceof JFrame) {
                this.primaryContactDialog = new JBEditorDialog((JFrame)window, false);
            } else if (window instanceof JDialog) {
                this.primaryContactDialog = new JBEditorDialog((JDialog)window, false);
            }
            this.primaryContactDialog.setLocation(50, 50);
            this.primaryContactDialog.setModel(this.getOrganization().getPrimaryContact());
            this.primaryContactDialog.setEditable(this.editable);
        }
        return this.primaryContactDialog;
    }

    Organization getOrganization() throws JAXRException {
        Organization organization = null;
        if (this.model != null) {
            organization = (Organization)this.getModel();
        }
        return organization;
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof Organization)) {
            throw new InvalidRequestException("Expecting a Organization. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        Organization org = (Organization)obj;
        try {
            RegistryBrowser.getInstance();
            int registryLevel = RegistryBrowser.client.getCapabilityProfile().getCapabilityLevel();
            DefaultListModel phonesModel = (DefaultListModel)this.phonesList.getModel();
            DefaultListModel addrsModel = (DefaultListModel)this.addrsList.getModel();
            if (org != null) {
                PostalAddress addr = org.getPostalAddress();
                String addrStr = "";
                if (addr != null) {
                    addrsModel.addElement(addr);
                }
                Collection phones = org.getTelephoneNumbers(null);
                Iterator iter = phones.iterator();
                while (iter.hasNext()) {
                    TelephoneNumber phone = (TelephoneNumber)iter.next();
                    phonesModel.addElement(phone);
                }
                User primaryContact = org.getPrimaryContact();
                String userName = RegistryBrowser.getUserName(primaryContact, registryLevel);
                this.primContactText.setText(userName);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        Organization org = (Organization)this.model;
        JBListModel phonesModel = (JBListModel)this.phonesList.getModel();
        org.setTelephoneNumbers((Collection)phonesModel.getModels());
    }

    public void clear() throws JAXRException {
        DefaultListModel phonesModel = (DefaultListModel)this.phonesList.getModel();
        phonesModel.clear();
        DefaultListModel addrsModel = (DefaultListModel)this.addrsList.getModel();
        addrsModel.clear();
        this.primContactText.setText("");
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.phonesList.setEditable(editable);
        this.addrsList.setEnabled(editable);
    }
}

