/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.HyperLinkLabel;
import com.sun.xml.registry.client.browser.HyperLinker;
import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.JBDefaultTableCellRenderer;
import com.sun.xml.registry.client.browser.JBEditorDialog;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectsTableModel;
import com.sun.xml.registry.client.browser.TableSorter;
import com.sun.xml.registry.client.browser.graph.JBGraphPanel;
import com.sun.xml.registry.ebxml.ConnectionImpl;
import com.sun.xml.registry.ebxml.infomodel.InternationalStringImpl;
import com.sun.xml.registry.ebxml.util.ProviderProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Slot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistryObjectsTable
extends JTable
implements PropertyChangeListener {
    private static final Log log = LogFactory.getLog((Class)(class$com$sun$xml$registry$client$browser$RegistryObjectsTableModel == null ? (class$com$sun$xml$registry$client$browser$RegistryObjectsTableModel = RegistryObjectsTable.class$("com.sun.xml.registry.client.browser.RegistryObjectsTableModel")) : class$com$sun$xml$registry$client$browser$RegistryObjectsTableModel));
    public static final String SELECTED_ROW_PROP = "selectedRow";
    private static final int maxColWidth = 1000000;
    int selectedRow = -1;
    JPopupMenu popup;
    JMenuItem editMenuItem = null;
    JMenuItem removeMenuItem = null;
    JMenuItem saveMenuItem = null;
    JMenuItem browseMenuItem = null;
    JMenuItem auditTrailMenuItem = null;
    JMenuItem retrieveMenuItem = null;
    MouseListener popupListener;
    private boolean editable = false;
    final RegistryObjectsTableModel tableModel;
    int stdRowHeight = 0;
    static /* synthetic */ Class class$com$sun$xml$registry$client$browser$RegistryObjectsTableModel;

    public RegistryObjectsTable(TableModel model) {
        super(model);
        this.setAutoResizeMode(0);
        if (model instanceof RegistryObjectsTableModel) {
            this.tableModel = (RegistryObjectsTableModel)model;
        } else if (model instanceof TableSorter) {
            this.tableModel = (RegistryObjectsTableModel)((TableSorter)model).getModel();
        } else {
            throw new IllegalArgumentException("Error. Expected RegistryObjectsTableModel or TableSorter, got " + model);
        }
        this.setToolTipText("Use right mouse button to perform actions (e.g. edit, save, browse, show audit trail)");
        this.setSelectionMode(2);
        ListSelectionModel rowSM = this.getSelectionModel();
        this.stdRowHeight = this.getRowHeight();
        this.setRowHeight(this.stdRowHeight * 3);
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    RegistryObjectsTable.this.setSelectedRow(lsm.getMinSelectionIndex());
                } else {
                    RegistryObjectsTable.this.setSelectedRow(-1);
                }
            }
        });
        this.createPopup();
        this.addRenderers();
        this.popupListener = new PopupListener();
        this.addMouseListener(this.popupListener);
        RegistryBrowser.getInstance().addPropertyChangeListener(RegistryBrowser.PROPERTY_AUTHENTICATED, this);
    }

    private void addRenderers() {
        try {
            this.setDefaultRenderer(Class.forName("java.lang.Object"), new JBDefaultTableCellRenderer());
            this.setDefaultRenderer(Class.forName("java.util.Collection"), new CollectionRenderer());
            final JList list = new JList();
            list.setVisibleRowCount(3);
            list.setOpaque(true);
            list.setCellRenderer(new ListDefaultRenderer());
            list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        Object obj = list.getSelectedValue();
                        if ((obj = RegistryObjectsTable.convertValue(obj)) instanceof URL) {
                            HyperLinker.displayURL(obj.toString());
                        } else if (obj instanceof String) {
                            URL _url = null;
                            try {
                                _url = new URL(obj.toString());
                                HyperLinker.displayURL(obj.toString());
                            }
                            catch (MalformedURLException exc) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
            JScrollPane listPane = new JScrollPane(list);
            this.setDefaultEditor(Class.forName("java.util.Collection"), new JBDefaultCellEditor(listPane));
            HyperLinkLabel hyperLinkLabel = new HyperLinkLabel();
            hyperLinkLabel.setHorizontalAlignment(2);
            this.setDefaultEditor(Class.forName("java.lang.Object"), new JBDefaultCellEditor(hyperLinkLabel));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Class getColumnClass(int column) {
        this.setColumnWidth(column);
        Class clazz = this.tableModel.getColumnClass(column);
        return clazz;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = null;
        String columnName = this.tableModel.getColumnName(column);
        Class clazz = null;
        try {
            clazz = this.tableModel.getColumnClass(column);
            renderer = super.getCellRenderer(row, column);
            if (renderer == null) {
                RegistryBrowser.displayError("Configuration error for column: " + columnName + ". Unsupported columnClass:" + clazz);
            }
        }
        catch (Exception e) {
            RegistryBrowser.displayError("Configuration error for column: " + columnName + ". Unsupported columnClass:" + clazz, e);
        }
        return renderer;
    }

    private void createPopup() {
        try {
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            ConnectionImpl connection = (ConnectionImpl)client.getConnection();
            boolean authenticated = connection.isAuthenticated();
            this.popup = new JPopupMenu();
            this.editMenuItem = this.editable ? new JMenuItem("Edit") : new JMenuItem("Show Details");
            this.popup.add(this.editMenuItem);
            this.removeMenuItem = new JMenuItem("Remove");
            this.popup.add(this.removeMenuItem);
            this.saveMenuItem = new JMenuItem("Save");
            this.popup.add(this.saveMenuItem);
            this.browseMenuItem = new JMenuItem("Browse");
            this.popup.add(this.browseMenuItem);
            this.auditTrailMenuItem = new JMenuItem("Show Audit Trail");
            this.popup.add(this.auditTrailMenuItem);
            this.retrieveMenuItem = new JMenuItem("Retrieve Item");
            this.retrieveMenuItem.setVisible(false);
            this.popup.add(this.retrieveMenuItem);
            this.editMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    RegistryObjectsTable.this.editAction();
                }
            });
            this.removeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    RegistryObjectsTable.this.removeAction();
                }
            });
            this.saveMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    RegistryObjectsTable.this.saveAction();
                }
            });
            this.browseMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    RegistryObjectsTable.this.browseAction();
                }
            });
            this.auditTrailMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    RegistryObjectsTable.this.auditTrailAction();
                }
            });
            this.retrieveMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    RegistryObjectsTable.this.retrieveAction();
                }
            });
            this.removeMenuItem.setVisible(authenticated);
            this.saveMenuItem.setVisible(authenticated);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    protected void editAction() {
        RegistryBrowser.setWaitCursor();
        int[] selectedIndices = this.getSelectedRows();
        if (selectedIndices.length == 1) {
            this.showSelectedObjectDetails();
        } else {
            RegistryBrowser.displayError("Exactly one object must be selected in list for Show Details/Edit action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    ArrayList getSelectedRegistryObjects() {
        ArrayList<RegistryObject> selectedObjects = new ArrayList<RegistryObject>();
        int[] selectedIndices = this.getSelectedRows();
        for (int i = 0; i < selectedIndices.length; ++i) {
            RegistryObject ro = (RegistryObject)this.dataModel.getValueAt(selectedIndices[i], -1);
            selectedObjects.add(ro);
        }
        return selectedObjects;
    }

    protected void removeAction() {
        RegistryBrowser.setWaitCursor();
        int[] selectedIndices = this.getSelectedRows();
        if (selectedIndices.length >= 1) {
            try {
                int option;
                ArrayList selectedObjects = this.getSelectedRegistryObjects();
                ArrayList<Key> removeKeys = new ArrayList<Key>();
                int size = selectedObjects.size();
                for (int i = size - 1; i >= 0; --i) {
                    RegistryObject obj = (RegistryObject)selectedObjects.get(i);
                    Key key = obj.getKey();
                    removeKeys.add(key);
                }
                boolean confirmRemoves = true;
                String confirmRemovesStr = ProviderProperties.getInstance().getProperty("jaxr-ebxml.registryBrowser.confirmRemoves", "true");
                if (confirmRemovesStr.toLowerCase().equals("false") || confirmRemovesStr.toLowerCase().equals("off")) {
                    confirmRemoves = false;
                }
                if (confirmRemoves && (option = JOptionPane.showConfirmDialog(null, "Are you sure you want to remove the selected items from the system?", "Confirm Remove", 0)) == 1) {
                    RegistryBrowser.setDefaultCursor();
                    return;
                }
                JAXRClient client = RegistryBrowser.getInstance().getClient();
                BusinessLifeCycleManager lcm = client.getBusinessLifeCycleManager();
                BulkResponse resp = lcm.deleteObjects(removeKeys);
                client.checkBulkResponse(resp);
                if (resp.getStatus() == 0) {
                    ArrayList objects = (ArrayList)this.tableModel.getRegistryObjects().clone();
                    size = selectedIndices.length;
                    for (int i = size - 1; i >= 0; --i) {
                        RegistryObject ro = (RegistryObject)this.dataModel.getValueAt(selectedIndices[i], -1);
                        objects.remove(ro);
                    }
                    this.tableModel.setRegistryObjects(objects);
                }
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        } else {
            RegistryBrowser.displayError("One or more objects must be selected in list for Remove action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    protected void saveAction() {
        RegistryBrowser.setWaitCursor();
        int[] selectedIndices = this.getSelectedRows();
        if (selectedIndices.length >= 1) {
            ArrayList selectedObjects = this.getSelectedRegistryObjects();
            try {
                JAXRClient client = RegistryBrowser.getInstance().getClient();
                client.saveObjects(selectedObjects);
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        } else {
            RegistryBrowser.displayError("One or more objects must be selected in list for Save action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    protected void browseAction() {
        RegistryBrowser.setWaitCursor();
        int[] selectedIndices = this.getSelectedRows();
        if (selectedIndices.length >= 1) {
            ArrayList selectedObjects = this.getSelectedRegistryObjects();
            Component parent = SwingUtilities.getRoot(this);
            if (parent instanceof JFrame) {
                JBGraphPanel.browseObjects((JFrame)parent, selectedObjects, this.editable);
            } else if (parent instanceof JDialog) {
                JBGraphPanel.browseObjects((JDialog)parent, selectedObjects, this.editable);
            }
        } else {
            RegistryBrowser.displayError("One or more objects must be selected in list for Browse action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    protected void auditTrailAction() {
        RegistryBrowser.setWaitCursor();
        int[] selectedIndices = this.getSelectedRows();
        if (selectedIndices.length == 1) {
            RegistryObject ro = (RegistryObject)this.dataModel.getValueAt(this.selectedRow, -1);
            RegistryBrowser.showAuditTrail(ro);
        } else {
            RegistryBrowser.displayError("Exactly one object must be selected in list for Show Audit Trail action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    protected void retrieveAction() {
        RegistryBrowser.setWaitCursor();
        int[] selectedIndices = this.getSelectedRows();
        if (selectedIndices.length == 1) {
            RegistryObject ro = (RegistryObject)this.dataModel.getValueAt(selectedIndices[0], -1);
            Component parent = SwingUtilities.getRoot(this);
            RegistryBrowser.retrieveItem(ro);
        } else {
            RegistryBrowser.displayError("Exactly one object must be selected in list for Retrieve action.");
        }
        RegistryBrowser.setDefaultCursor();
    }

    private void setColumnWidth(int col) {
        TableColumnModel colModel = this.getColumnModel();
        TableColumn tcol = colModel.getColumn(col);
        Container parent = this.getParent();
        if (tcol.getMaxWidth() > 1000000 && parent != null) {
            int parentWidth = parent.getWidth();
            if (this.tableModel != null) {
                int width = this.tableModel.getColumnWidth(col);
                int cols = this.tableModel.getColumnCount();
                width = width == 0 ? parentWidth / cols : width * parentWidth / 100;
                tcol.setPreferredWidth(width);
                tcol.setMaxWidth(1000000);
            }
        }
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.selectedRow == -1 && e.getType() == 1) {
            ListSelectionModel rowSM = this.getSelectionModel();
            rowSM.setSelectionInterval(0, 0);
        }
    }

    private void setSelectedRow(int index) {
        Integer oldIndex = new Integer(this.selectedRow);
        this.selectedRow = index;
        this.firePropertyChange(SELECTED_ROW_PROP, oldIndex, new Integer(index));
    }

    public void setVisible(boolean makeVisible) {
        if (makeVisible) {
            // empty if block
        }
        super.setVisible(makeVisible);
    }

    private void showSelectedObjectDetails() {
        if (this.selectedRow >= 0) {
            RegistryObject ro = (RegistryObject)this.dataModel.getValueAt(this.selectedRow, -1);
            JBEditorDialog.showObjectDetails(this, ro, false, this.editable);
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals(RegistryBrowser.PROPERTY_AUTHENTICATED)) {
            boolean authenticated = (Boolean)ev.getNewValue();
            this.setEditable(authenticated);
        }
    }

    protected static Object convertValue(Object value) {
        Object finalValue = null;
        Locale selectedLocale = RegistryBrowser.getInstance().getSelectedLocale();
        try {
            if (value instanceof InternationalString) {
                finalValue = ((InternationalStringImpl)value).getClosestValue(selectedLocale);
            } else if (value instanceof ExternalLink) {
                finalValue = ((ExternalLink)value).getExternalURI();
                try {
                    URL url = new URL(((ExternalLink)value).getExternalURI());
                    finalValue = url;
                }
                catch (MalformedURLException e) {}
            } else if (value instanceof Collection) {
                Collection c1 = (Collection)value;
                ArrayList<Object> c2 = new ArrayList<Object>();
                Iterator iter = c1.iterator();
                while (iter.hasNext()) {
                    c2.add(RegistryObjectsTable.convertValue(iter.next()));
                }
                finalValue = c2;
            } else if (value instanceof Slot) {
                Collection c = ((Slot)value).getValues();
                finalValue = c;
            } else {
                finalValue = value instanceof Concept ? ((Concept)value).getValue() : value;
            }
        }
        catch (JAXRException e) {
            log.error((Object)e);
        }
        return finalValue;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.createPopup();
    }

    public boolean isEditable() {
        return this.editable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            Point p = new Point(e.getX(), e.getY());
            int index = RegistryObjectsTable.this.rowAtPoint(p);
            Object ro = RegistryObjectsTable.this.dataModel.getValueAt(index, -1);
            if (ro instanceof ExtrinsicObject) {
                RegistryObjectsTable.this.retrieveMenuItem.setVisible(true);
            } else {
                RegistryObjectsTable.this.retrieveMenuItem.setVisible(false);
            }
            this.maybeShowPopup(e);
            if (e.getClickCount() > 1) {
                // empty if block
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int[] selectedIndices = RegistryObjectsTable.this.getSelectedRows();
                RegistryObjectsTable.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class ListDefaultRenderer
    extends HyperLinkLabel
    implements ListCellRenderer {
        public ListDefaultRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Font font = RegistryObjectsTable.this.getFont();
            this.setFont(font);
            list.setFont(font);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            value = RegistryObjectsTable.convertValue(value);
            this.setText(value.toString());
            return this;
        }
    }

    class JBDefaultCellEditor
    extends DefaultCellEditor {
        public JBDefaultCellEditor(JScrollPane scrollPane) {
            super(new JTextField());
            this.editorComponent = scrollPane;
            this.clickCountToStart = 1;
            Component comp = scrollPane.getViewport().getView();
            this.delegate = new DefaultCellEditor.EditorDelegate(this, RegistryObjectsTable.this, comp){
                private final /* synthetic */ RegistryObjectsTable val$this$0;
                private final /* synthetic */ Component val$comp;
                private final /* synthetic */ JBDefaultCellEditor this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    this.val$comp = val$comp;
                }

                public void setValue(Object value) {
                    value = RegistryObjectsTable.convertValue(value);
                    if (this.val$comp instanceof JList) {
                        JList list = (JList)this.val$comp;
                        DefaultListModel<E> model = new DefaultListModel<E>();
                        if (value instanceof Collection) {
                            Collection c = (Collection)value;
                            Iterator<E> iter = c.iterator();
                            while (iter.hasNext()) {
                                E obj = iter.next();
                                model.addElement(obj);
                            }
                        }
                        list.setModel(model);
                    }
                }

                public Object getCellEditorValue() {
                    ArrayList<E> value = null;
                    if (this.val$comp instanceof JList) {
                        ArrayList<E> c = new ArrayList<E>();
                        JList list = (JList)this.val$comp;
                        ListModel<E> model = list.getModel();
                        for (int i = 0; i < model.getSize(); ++i) {
                            c.add(model.getElementAt(i));
                        }
                        value = c;
                    }
                    return value;
                }
            };
        }

        public JBDefaultCellEditor(HyperLinkLabel label) {
            super(new JTextField());
            this.editorComponent = label;
            this.clickCountToStart = 1;
            this.delegate = new DefaultCellEditor.EditorDelegate(this, RegistryObjectsTable.this, label){
                private final /* synthetic */ RegistryObjectsTable val$this$0;
                private final /* synthetic */ HyperLinkLabel val$label;
                private final /* synthetic */ JBDefaultCellEditor this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    this.val$label = val$label;
                }

                public void setValue(Object value) {
                    try {
                        this.val$label.setURL(null);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    this.val$label.setText(value.toString());
                }

                public Object getCellEditorValue() {
                    return this.val$label.getText();
                }
            };
        }
    }

    class CollectionRenderer
    extends JScrollPane
    implements TableCellRenderer {
        JList list = new JList();

        public CollectionRenderer() {
            Font font = RegistryObjectsTable.this.getFont();
            this.list.setFont(font);
            this.list.setVisibleRowCount(3);
            this.list.setOpaque(true);
            ListDefaultRenderer renderer = new ListDefaultRenderer();
            renderer.setHorizontalAlignment(2);
            this.list.setCellRenderer(renderer);
            this.list.setBorder(BorderFactory.createEmptyBorder());
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setViewportView(this.list);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            value = RegistryObjectsTable.convertValue(value);
            if (isSelected) {
                this.list.setBackground(table.getSelectionBackground());
                this.list.setForeground(table.getSelectionForeground());
            } else {
                this.list.setBackground(table.getBackground());
                this.list.setForeground(table.getForeground());
            }
            DefaultListModel model = new DefaultListModel();
            Collection c = (Collection)value;
            if (c != null) {
                Iterator iter = c.iterator();
                while (iter.hasNext()) {
                    model.addElement(iter.next());
                }
            }
            this.list.setModel(model);
            return this;
        }
    }
}

