/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.conf.bindings.Configuration;
import com.sun.xml.registry.client.browser.conf.bindings.MethodParameter;
import com.sun.xml.registry.client.browser.conf.bindings.ObjectTypeConfig;
import com.sun.xml.registry.client.browser.conf.bindings.SearchResultsColumn;
import com.sun.xml.registry.client.browser.conf.bindings.SearchResultsConfig;
import com.sun.xml.registry.ebxml.infomodel.ConceptImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistryObjectsTableModel
extends AbstractTableModel {
    private static final Log log = LogFactory.getLog((Class)(class$com$sun$xml$registry$client$browser$RegistryObjectsTableModel == null ? (class$com$sun$xml$registry$client$browser$RegistryObjectsTableModel = RegistryObjectsTableModel.class$("com.sun.xml.registry.client.browser.RegistryObjectsTableModel")) : class$com$sun$xml$registry$client$browser$RegistryObjectsTableModel));
    ArrayList registryObjects = new ArrayList();
    RegistryBrowser registryBrowser;
    HashMap objectTypeToConfigMap = new HashMap();
    ObjectTypeConfig otCfg = null;
    SearchResultsConfig srCfg = null;
    SearchResultsColumn[] srCols = null;
    static /* synthetic */ Class class$com$sun$xml$registry$client$browser$RegistryObjectsTableModel;

    public RegistryObjectsTableModel() {
        this.registryBrowser = RegistryBrowser.getInstance();
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        Configuration cfg = RegistryBrowser.getInstance().getConfiguration();
        int count = cfg.getObjectTypeConfigCount();
        ObjectTypeConfig[] otCfgs = cfg.getObjectTypeConfig();
        for (int i = 0; i < count; ++i) {
            ObjectTypeConfig otCfg = otCfgs[i];
            String id = otCfg.getId();
            this.objectTypeToConfigMap.put(id, otCfg);
        }
    }

    public int getColumnCount() {
        int cols = 0;
        if (this.srCols != null) {
            cols = this.srCols.length;
        }
        return cols;
    }

    public int getColumnWidth(int col) {
        int width = 10;
        SearchResultsColumn srCol = this.srCols[col];
        width = srCol.getColumnWidth();
        return width;
    }

    public int getRowCount() {
        return this.registryObjects.size();
    }

    public Class getColumnClass(int column) {
        Class<?> clazz = null;
        try {
            SearchResultsColumn srCol = this.srCols[column];
            String columnClass = srCol.getColumnClass();
            if (columnClass == null) {
                columnClass = "java.lang.Object";
            }
            clazz = Class.forName(columnClass);
        }
        catch (ClassNotFoundException e) {
            RegistryBrowser.displayError(e);
        }
        return clazz;
    }

    public boolean isCellEditable(int row, int col) {
        boolean editable = false;
        SearchResultsColumn srCol = this.srCols[col];
        editable = srCol.getEditable();
        return editable;
    }

    public Object getValueAt(int row, int col) {
        RegistryObject ro = (RegistryObject)this.registryObjects.get(row);
        Object value = null;
        try {
            switch (col) {
                case -1: {
                    value = ro;
                    break;
                }
                default: {
                    SearchResultsColumn srCol = this.srCols[col];
                    String className = this.otCfg.getClassName();
                    String methodName = srCol.getMethod();
                    Class<?> clazz = Class.forName(className);
                    int numParams = srCol.getMethodParameterCount();
                    Class[] parameterTypes = new Class[numParams];
                    for (int i = 0; i < numParams; ++i) {
                        MethodParameter mp = srCol.getMethodParameter(i);
                        String paramTypeName = mp.getType();
                        parameterTypes[i] = Class.forName(paramTypeName);
                    }
                    Method method = clazz.getMethod(methodName, parameterTypes);
                    Object[] parameterValues = new Object[numParams];
                    for (int i = 0; i < numParams; ++i) {
                        MethodParameter mp = srCol.getMethodParameter(i);
                        String paramValue = mp.getValue();
                        parameterValues[i] = paramValue;
                    }
                    value = method.invoke((Object)ro, parameterValues);
                    break;
                }
            }
        }
        catch (ClassNotFoundException e) {
            RegistryBrowser.displayError(e);
        }
        catch (NoSuchMethodException e) {
            RegistryBrowser.displayError("Invalid configuration: No such method:", e);
        }
        catch (IllegalArgumentException e) {
            RegistryBrowser.displayError(e);
        }
        catch (IllegalAccessException e) {
            RegistryBrowser.displayError(e);
        }
        catch (InvocationTargetException e) {
        }
        catch (ExceptionInInitializerError e) {
            RegistryBrowser.displayError(e);
        }
        return value;
    }

    public String getColumnName(int col) {
        String columnName = null;
        try {
            columnName = this.srCols[col].getColumnHeader();
        }
        catch (IndexOutOfBoundsException ex) {
            log.warn((Object)("Index out of bounds" + ex.getMessage()));
        }
        return columnName;
    }

    void update(BulkResponse response) {
        String errMsg = "An error occured in the registry during the request.";
        ArrayList registryObjects = null;
        try {
            Collection exceptions = response.getExceptions();
            if (exceptions != null) {
                Iterator iter = exceptions.iterator();
                Exception exception = null;
                while (iter.hasNext()) {
                    exception = (Exception)iter.next();
                    RegistryBrowser.displayError(errMsg, exception);
                }
            }
            registryObjects = response.getCollection();
            Concept commonObjectType = this.getCommonObjectType(registryObjects);
            this.updateConfiguration(commonObjectType);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
            registryObjects = new ArrayList();
        }
        if (registryObjects.isEmpty()) {
            JOptionPane.showMessageDialog(null, "No objects were found.", "Registry Browser", 1);
            registryObjects = new ArrayList();
        }
        this.setRegistryObjects(registryObjects);
    }

    ArrayList getRegistryObjects() {
        return this.registryObjects;
    }

    void setRegistryObjects(Collection objs) {
        this.registryObjects.clear();
        this.registryObjects.addAll(objs);
        this.fireTableDataChanged();
    }

    private Concept getCommonObjectType(Collection registryObjects) throws JAXRException {
        Concept commonType = null;
        String commonPath = null;
        Iterator iter = registryObjects.iterator();
        block0: while (iter.hasNext()) {
            RegistryObject ro = (RegistryObject)iter.next();
            ConceptImpl type = (ConceptImpl)ro.getObjectType();
            String path = type.getPath();
            if (commonPath == null) {
                commonPath = path;
                continue;
            }
            if (commonPath.equals(path)) continue;
            if (commonPath.startsWith(path + "/")) {
                commonPath = path;
                continue;
            }
            if (path.startsWith(commonPath + "/")) continue;
            String smallerPath = commonPath;
            String biggerPath = path;
            boolean swap = false;
            if (commonPath.length() > path.length()) {
                smallerPath = path;
                biggerPath = commonPath;
                swap = true;
            }
            int len = smallerPath.length();
            for (int i = 0; i < len; ++i) {
                if (smallerPath.charAt(i) == biggerPath.charAt(i)) continue;
                commonPath = smallerPath.substring(0, smallerPath.lastIndexOf(47, i));
                continue block0;
            }
        }
        if (commonPath == null) {
            commonPath = "/urn:uuid:3188a449-18ac-41fb-be9f-99a1adca02cb/RegistryObject";
        }
        JAXRClient client = RegistryBrowser.getInstance().getClient();
        RegistryBrowser.getInstance();
        Connection connection = RegistryBrowser.client.getConnection();
        RegistryService service = connection.getRegistryService();
        BusinessQueryManager bqm = service.getBusinessQueryManager();
        commonType = bqm.findConceptByPath(commonPath);
        return commonType;
    }

    private ObjectTypeConfig getObjectTypeConfig(Concept commonObjectType) throws JAXRException {
        ObjectTypeConfig cfg = null;
        while ((cfg = (ObjectTypeConfig)this.objectTypeToConfigMap.get(commonObjectType.getKey().getId())) == null) {
            Concept parent = commonObjectType.getParentConcept();
            if (parent == null) {
                cfg = (ObjectTypeConfig)this.objectTypeToConfigMap.get("urn:uuid:a7ec3db9-9342-4016-820c-cff66c0bb021");
                break;
            }
            commonObjectType = parent;
        }
        return cfg;
    }

    private void updateConfiguration(Concept objectType) throws JAXRException {
        this.otCfg = this.getObjectTypeConfig(objectType);
        this.srCfg = this.otCfg.getSearchResultsConfig();
        this.srCols = this.srCfg.getSearchResultsColumn();
        this.fireTableStructureChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

