/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectsList;
import com.sun.xml.registry.client.browser.SlotsListModel;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Slot;

public class SlotsList
extends RegistryObjectsList {
    public SlotsList() {
        this(new SlotsListModel());
    }

    public SlotsList(SlotsListModel model) {
        super("Slot", model);
        this.setCellRenderer(new SlotRenderer());
    }

    public static String slotToString(Slot slot) throws JAXRException {
        String str = "name=" + slot.getName() + " type=" + slot.getSlotType() + " values=";
        Collection values = slot.getValues();
        if (values == null) {
            str = str + values;
        } else {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                String value = (String)iter.next();
                str = str + value;
                if (!iter.hasNext()) continue;
                str = str + ", ";
            }
        }
        return str;
    }

    class SlotRenderer
    extends JLabel
    implements ListCellRenderer {
        public SlotRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            try {
                SlotsListModel model = (SlotsListModel)list.getModel();
                Slot slot = (Slot)model.elementAt(index);
                this.setText(SlotsList.slotToString(slot));
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
            return this;
        }
    }
}

