/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.graph;

import com.jgraph.graph.DefaultGraphCell;
import com.jgraph.graph.DefaultPort;
import com.jgraph.graph.GraphConstants;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import java.awt.Color;
import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.User;

public class JBGraphCell
extends DefaultGraphCell {
    RegistryObject registryObject = null;

    private JBGraphCell() {
    }

    public JBGraphCell(RegistryObject ro, boolean createIcon) {
        super((Object)JBGraphCell.getLabel(ro));
        ImageIcon icon;
        String objectType = ro.getClass().getName().substring(ro.getClass().getName().lastIndexOf(46) + 1, ro.getClass().getName().length() - 4);
        try {
            objectType = ro.getObjectType().getValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.registryObject = ro;
        GraphConstants.setOpaque((Map)this.attributes, (boolean)false);
        GraphConstants.setBorderColor((Map)this.attributes, (Color)Color.black);
        GraphConstants.setAutoSize((Map)this.attributes, (boolean)true);
        GraphConstants.setFontStyle((Map)this.attributes, (int)1);
        int u = 1000;
        DefaultPort port = new DefaultPort((Object)"Center");
        this.add((MutableTreeNode)port);
        if (createIcon && (icon = this.getIcon(objectType)) != null) {
            GraphConstants.setIcon((Map)this.attributes, (ImageIcon)icon);
        }
    }

    private ImageIcon getIcon(String objectType) {
        ImageIcon icon = null;
        String resourceName = "icons/" + objectType + ".gif";
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
        if (url != null) {
            icon = new ImageIcon(url);
        } else if (!objectType.equals("ExtrinsicObject")) {
            icon = this.getIcon("ExtrinsicObject");
        }
        return icon;
    }

    private static String getLabel(RegistryObject ro) {
        String label = "";
        try {
            Connection connection = RegistryBrowser.getInstance().getClient().getConnection();
            RegistryService service = connection.getRegistryService();
            int registryLevel = service.getCapabilityProfile().getCapabilityLevel();
            if (ro != null && ((label = ro instanceof User ? RegistryBrowser.getUserName((User)ro, registryLevel) : RegistryBrowser.getName(ro)) == null || label.length() == 0)) {
                if (ro instanceof Concept) {
                    label = ((Concept)ro).getValue();
                } else if (ro instanceof Classification) {
                    label = ((Classification)ro).getValue();
                }
            }
        }
        catch (JAXRException e) {
            e.printStackTrace();
        }
        return label;
    }

    RegistryObject getRegistryObject() {
        return this.registryObject;
    }
}

