/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.graph;

import com.sun.xml.registry.client.browser.AssociationPanel;
import com.sun.xml.registry.client.browser.CardManagerPanel;
import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.graph.ReferencePanel;
import com.sun.xml.registry.ebxml.BusinessQueryManagerImpl;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;

public class RelationshipPanel
extends CardManagerPanel {
    private GridBagConstraints c = new GridBagConstraints();
    private RegistryObject src = null;
    private RegistryObject target = null;
    public static final String RELATIONSHIP_TYPE_ASSOCIATION = "Association";
    public static final String RELATIONSHIP_TYPE_REFERENCE = "Reference";
    private String relationshipType = "Association";
    private AssociationPanel assPanel;
    private ReferencePanel refPanel;
    private ArrayList map = new ArrayList();
    private static final String REL_CLASSIFICATION_RO = "classifiedObject";
    private static final String REL_CLASSIFICATION_SCHEME = "classificationScheme";
    private static final String REL_CLASSIFICATION_CONCEPT = "concept";
    private static final String REL_CONCEPT_PARENT = "parent";
    private static final String REL_EXTERNALID_IDSCHEME = "identificationScheme";
    private static final String REL_ORGANIZATION_CHILDORGS = "childOrganizations";
    private static final String REL_ORGANIZATION_CONTACT = "primaryContact";
    private static final String REL_BINDING_SPECLINKS = "specificationLinks";
    private static final String REL_SERVICE_BINDINGS = "serviceBindings";
    private static final String REL_SPECLINK_SPEC = "specificationObject";
    private String[][][] refMatrix = new String[][][]{{new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]}, {new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]}, {{"classifiedObject"}, {"classifiedObject"}, {"classifiedObject"}, {"classificationScheme", "classifiedObject"}, {"concept", "classifiedObject"}, {"classifiedObject"}, {"classifiedObject"}, {"classifiedObject"}, {"classifiedObject"}, {"classifiedObject"}, {"classifiedObject"}, {"classifiedObject"}, {"classifiedObject"}, {"classifiedObject"}}, {new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]}, {new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]}, {new String[0], new String[0], new String[0], {"identificationScheme"}, new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]}, {new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]}, {new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]}, {new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], {"childOrganizations"}, new String[0], new String[0], new String[0], new String[0], {"primaryContact"}}, {new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]}, {new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], {"specificationLinks"}, new String[0]}, {new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], {"serviceBindings"}, new String[0], new String[0], new String[0]}, {new String[0], new String[0], new String[0], new String[0], {"specificationObject"}, new String[0], new String[0], {"specificationObject"}, new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]}, {new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0]}};

    public RelationshipPanel(RegistryObject src, RegistryObject target) {
        super(new String[]{RELATIONSHIP_TYPE_ASSOCIATION, RELATIONSHIP_TYPE_REFERENCE}, new JPanel[]{new AssociationPanel(), new ReferencePanel(src, target)});
        this.assPanel = (AssociationPanel)this.cardPanels[0];
        this.refPanel = (ReferencePanel)this.cardPanels[1];
        this.src = src;
        this.target = target;
        this.map.add(RELATIONSHIP_TYPE_ASSOCIATION);
        this.map.add("AuditableEvent");
        this.map.add("Classification");
        this.map.add("ClassificationScheme");
        this.map.add("Concept");
        this.map.add("ExternalIdentifier");
        this.map.add("ExternalLink");
        this.map.add("ExtrinsicObject");
        this.map.add("Organization");
        this.map.add("RegistryPackage");
        this.map.add("ServiceBinding");
        this.map.add("Service");
        this.map.add("SpecificationLink");
        this.map.add("User");
        int row = this.map.indexOf(this.getJAXRName(src));
        int col = this.map.indexOf(this.getJAXRName(target));
        String[] refs = this.refMatrix[row][col];
        try {
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            BusinessLifeCycleManager lcm = client.getBusinessLifeCycleManager();
            BusinessQueryManagerImpl bqm = (BusinessQueryManagerImpl)client.getBusinessQueryManager();
            if (refs.length == 0) {
                this.remove(this.selectorPanel);
                this.initAssociationPanel();
            } else {
                this.relationshipType = RELATIONSHIP_TYPE_REFERENCE;
                this.refPanel.setReferenceAttributes(refs);
            }
            this.showCard(this.relationshipType);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    private void initAssociationPanel() throws JAXRException {
        JAXRClient client = RegistryBrowser.getInstance().getClient();
        BusinessLifeCycleManager lcm = client.getBusinessLifeCycleManager();
        BusinessQueryManagerImpl bqm = (BusinessQueryManagerImpl)client.getBusinessQueryManager();
        this.relationshipType = RELATIONSHIP_TYPE_ASSOCIATION;
        Concept assType = null;
        if (this.src instanceof RegistryPackage) {
            assType = bqm.findConceptByPath("/urn:uuid:6902675f-2f18-44b8-888b-c91db8b96b4d/HasMember");
        } else if (this.src instanceof ExternalLink) {
            assType = bqm.findConceptByPath("/urn:uuid:6902675f-2f18-44b8-888b-c91db8b96b4d/ExternallyLinks");
        } else if (this.src instanceof Organization && this.target instanceof Service) {
            assType = bqm.findConceptByPath("/urn:uuid:6902675f-2f18-44b8-888b-c91db8b96b4d/OffersService");
        }
        Association ass = lcm.createAssociation(this.target, assType);
        this.src.addAssociation(ass);
        this.assPanel.setModel(ass);
    }

    protected void showCardAction(String card) {
        if (card.equals(RELATIONSHIP_TYPE_ASSOCIATION)) {
            try {
                if (this.assPanel.getModel() == null) {
                    this.initAssociationPanel();
                }
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        }
        super.showCardAction(card);
    }

    public void setReferenceAttributeOnSourceObject() throws JAXRException {
        if (this.relationshipType == RELATIONSHIP_TYPE_REFERENCE) {
            this.refPanel.setReferenceAttributeOnSourceObject();
        }
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public String getRelationshipName() {
        String relName = "";
        try {
            if (this.relationshipType == RELATIONSHIP_TYPE_ASSOCIATION) {
                Concept assType = ((Association)this.assPanel.getModel()).getAssociationType();
                if (assType != null) {
                    relName = assType.getValue();
                }
            } else if (this.relationshipType == RELATIONSHIP_TYPE_REFERENCE) {
                relName = this.refPanel.getReferenceAttribute();
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relName;
    }

    public Association getAssociation() throws JAXRException {
        return (Association)this.assPanel.getModel();
    }

    String getJAXRName(RegistryObject ro) {
        String newClassName = ro.getClass().getName();
        if ((newClassName = newClassName.substring(newClassName.lastIndexOf(".") + 1)).endsWith("Impl")) {
            newClassName = newClassName.substring(0, newClassName.length() - 4);
        }
        return newClassName;
    }
}

