/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml;

import com.sun.ebxml.registry.RegistryException;
import com.sun.xml.registry.ebxml.BulkResponseImpl;
import com.sun.xml.registry.ebxml.BusinessLifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import com.sun.xml.registry.ebxml.util.SecurityUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.messaging.URLEndpoint;
import javax.xml.registry.JAXRException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.oasis.ebxml.registry.bindings.rs.RegistryResponse;
import org.w3c.dom.Node;

public class SoapMessenger {
    static final String EBXML_NS = "urn:oasis:names:tc:ebxml-regrep:query:xsd:2.0";
    private URLEndpoint endpoint;
    private RegistryServiceImpl regService;
    private BusinessLifeCycleManagerImpl lcm;
    private Log log;
    private boolean isCredentialValidated;
    private X509Certificate cert;
    private Certificate[] certChain;
    private PrivateKey privateKey;
    private String signingAlgo;
    private static final SecurityUtil su = SecurityUtil.getInstance();

    SoapMessenger(RegistryServiceImpl regService, String registryUrl, BusinessLifeCycleManagerImpl lcm) {
        this.regService = regService;
        this.endpoint = new URLEndpoint(registryUrl);
        this.log = regService.getConnection().getConnectionFactory().getLog();
        this.lcm = lcm;
    }

    void dumpMessage(String info, SOAPMessage msg) throws SOAPException {
        if (info != null) {
            System.err.print(info);
        }
        try {
            msg.writeTo((OutputStream)System.err);
            System.err.println();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BulkResponseImpl sendSoapRequest(String requestString) throws JAXRException {
        return this.sendSoapRequest(requestString, null, false);
    }

    public BulkResponseImpl sendSoapRequest(String requestString, HashMap attachments) throws JAXRException {
        return this.sendSoapRequest(requestString, attachments, false);
    }

    public BulkResponseImpl sendSoapRequest(String requestString, HashMap attachments, boolean doSignature) throws JAXRException {
        if (doSignature && !this.isCredentialValidated) {
            this.validateCredential();
            this.isCredentialValidated = true;
        }
        if (requestString.startsWith("<?xml")) {
            requestString = requestString.substring(requestString.indexOf("?>") + 2).trim();
        }
        StringBuffer soapText = new StringBuffer("<soap-env:Envelope xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        soapText.append("<soap-env:Header/>");
        soapText.append("<soap-env:Body>");
        soapText.append(requestString);
        soapText.append("</soap-env:Body>");
        soapText.append("</soap-env:Envelope>");
        this.log.trace((Object)("requestString=\"" + requestString + "\""));
        try {
            ByteArrayInputStream soapStream = new ByteArrayInputStream(soapText.toString().getBytes("utf-8"));
            if (doSignature) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                com.sun.ebxml.registry.security.SecurityUtil.getInstance().signSOAPMessage(soapStream, baos, this.privateKey, this.certChain, this.signingAlgo);
                soapStream = new ByteArrayInputStream(baos.toByteArray());
            }
            MessageFactory factory = MessageFactory.newInstance();
            SOAPMessage msg = factory.createMessage();
            SOAPPart soapPart = msg.getSOAPPart();
            soapPart.setContent((Source)new StreamSource(soapStream));
            if (attachments != null && !attachments.isEmpty()) {
                this.addAttachments(msg, attachments);
            }
            SOAPMessage response = this.send(msg);
            Reader reader = this.processResponseBody(response, "RegistryResponse");
            RegistryResponse ebResponse = null;
            try {
                ebResponse = RegistryResponse.unmarshal(reader);
            }
            catch (Exception x) {
                this.log.debug((Object)x);
                throw new JAXRException("Invalid registry server response");
            }
            HashMap responseAttachments = this.processResponseAttachments(response);
            return new BulkResponseImpl(this.lcm, ebResponse, responseAttachments);
        }
        catch (UnsupportedEncodingException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (MessagingException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (FileNotFoundException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (SOAPException x) {
            x.printStackTrace();
            throw new JAXRException("Error. Cannot connect to specified URL. Please check the URL and try again.", (Throwable)x);
        }
        catch (TransformerConfigurationException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (TransformerException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (RegistryException x) {
            throw new JAXRException((Throwable)x);
        }
    }

    private void validateCredential() throws JAXRException {
        PasswordAuthentication pwdauth = this.regService.getConnection().getPasswordAuthentication();
        X500PrivateCredential cred = this.regService.getConnection().getX500PrivateCredential();
        if (cred == null && pwdauth == null) {
            throw new JAXRException("No credentials have been set on Connection");
        }
        if (pwdauth != null) {
            return;
        }
        if (cred.isDestroyed()) {
            throw new JAXRException("Credential has been destroyed");
        }
        this.cert = cred.getCertificate();
        if (this.cert == null) {
            throw new JAXRException("X509Certificate not found in X500PrivateCredential");
        }
        this.privateKey = cred.getPrivateKey();
        if (this.privateKey == null) {
            throw new JAXRException("PrivateKey not found in X500PrivateCredential");
        }
        this.certChain = su.getCertificateChain(this.cert);
        this.signingAlgo = this.privateKey.getAlgorithm();
        if (this.signingAlgo.equalsIgnoreCase("DSA")) {
            this.signingAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else if (this.signingAlgo.equalsIgnoreCase("RSA")) {
            this.signingAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            throw new JAXRException("Signature algorithm not supported");
        }
    }

    private void addAttachments(SOAPMessage msg, HashMap attachments) throws MessagingException, FileNotFoundException, RegistryException {
        Iterator it = attachments.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String id = (String)entry.getKey();
            DataHandler dh = (DataHandler)entry.getValue();
            this.addAttachment(msg, id, dh, dh.getContentType());
        }
    }

    public void addAttachment(SOAPMessage msg, String id, DataHandler dh, String mimeType) throws FileNotFoundException, MessagingException, RegistryException {
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart bp2 = new MimeBodyPart();
        bp2.setDataHandler(dh);
        bp2.addHeader("Content-Type", mimeType);
        bp2.addHeader("Content-ID", "payload2");
        mp.addBodyPart((BodyPart)bp2);
        String payloadSigFilePath = "payloadSig.xml";
        com.sun.ebxml.registry.security.SecurityUtil secUtil = com.sun.ebxml.registry.security.SecurityUtil.getInstance();
        secUtil.signPayload(mp, id, new FileOutputStream(payloadSigFilePath), this.privateKey, (X509Certificate)this.certChain[0], this.signingAlgo);
        mp.removeBodyPart(0);
        MimeBodyPart bp1 = new MimeBodyPart();
        File payloadSigFile = new File(payloadSigFilePath);
        FileDataSource payloadSigFileDs = new FileDataSource(payloadSigFile);
        DataHandler payloadSigFileDh = new DataHandler((DataSource)payloadSigFileDs);
        bp1.setDataHandler(payloadSigFileDh);
        bp1.addHeader("Content-Type", "text/plain");
        bp1.addHeader("Content-ID", "payload1");
        mp.addBodyPart((BodyPart)bp1);
        mp.addBodyPart((BodyPart)bp2);
        ContentType mpContentType = new ContentType(mp.getContentType());
        String boundary = mpContentType.getParameter("boundary");
        ContentType apContentType = new ContentType("multipart/related");
        apContentType.setParameter("boundary", boundary);
        AttachmentPart ap = msg.createAttachmentPart((Object)mp, apContentType.toString());
        ap.setContentId(id);
        msg.addAttachmentPart(ap);
        this.log.trace((Object)("adding attachment: contentId=" + id));
    }

    SOAPMessage send(SOAPMessage msg) throws SOAPException {
        SOAPConnectionFactory scf = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = scf.createConnection();
        this.dumpMessage("Request=", msg);
        long t1 = System.currentTimeMillis();
        SOAPMessage reply = null;
        reply = connection.call(msg, (Object)this.endpoint);
        long t2 = System.currentTimeMillis();
        double secs = ((double)t2 - (double)t1) / 1000.0;
        this.log.debug((Object)("Call elapsed time in seconds: " + secs));
        return reply;
    }

    Reader processResponseBody(SOAPMessage response, String lookFor) throws JAXRException, SOAPException, TransformerConfigurationException, TransformerException {
        this.dumpMessage("Response=", response);
        SOAPPart replyPart = response.getSOAPPart();
        Source replySource = replyPart.getContent();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer xFormer = tFactory.newTransformer();
        DOMResult domResult = new DOMResult();
        xFormer.transform(replySource, domResult);
        Node node = domResult.getNode();
        while (node != null && !lookFor.equalsIgnoreCase(node.getLocalName())) {
            node = SoapMessenger.nextNode(node);
        }
        if (node == null) {
            throw new JAXRException("Could not find element '" + lookFor + "' in response");
        }
        return this.domNode2StringReader(node);
    }

    private static Node nextNode(Node node) {
        Node sib;
        Node child = node.getFirstChild();
        if (child != null) {
            return child;
        }
        while ((sib = node.getNextSibling()) == null) {
            if ((node = node.getParentNode()) != null) continue;
            return null;
        }
        return sib;
    }

    StringReader domNode2StringReader(Node node) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        StringWriter writer = null;
        Transformer serializer = tfactory.newTransformer();
        Properties oprops = new Properties();
        oprops.put("method", "xml");
        oprops.put("indent", "yes");
        serializer.setOutputProperties(oprops);
        writer = new StringWriter();
        serializer.transform(new DOMSource(node), new StreamResult(writer));
        String outString = writer.toString();
        StringReader reader = new StringReader(outString);
        return reader;
    }

    private HashMap processResponseAttachments(SOAPMessage response) throws JAXRException, SOAPException, MessagingException {
        if (response.countAttachments() == 0) {
            return null;
        }
        HashMap<String, DataHandler> attachMap = new HashMap<String, DataHandler>();
        Iterator it = response.getAttachments();
        while (it.hasNext()) {
            AttachmentPart ap = (AttachmentPart)it.next();
            String contentId = ap.getContentId();
            Object obj = ap.getContent();
            if (!(obj instanceof MimeMultipart)) {
                throw new JAXRException("Expected javax.mail.internet.MimeMultipart got " + obj.getClass().getName());
            }
            MimeMultipart mp = (MimeMultipart)obj;
            if (mp.getCount() != 2) {
                throw new JAXRException("Found " + mp.getCount() + " BodyParts. A Multipart for a RepositoryItem must have exactly 2 BodyParts. First is the signature, second is the repository item.");
            }
            BodyPart bp2 = mp.getBodyPart(1);
            DataHandler dh = bp2.getDataHandler();
            attachMap.put(contentId, dh);
        }
        return attachMap;
    }
}

