/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.InternationalStringImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectRef;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.RegistryObject;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.rim.Classification;
import org.oasis.ebxml.registry.bindings.rim.ClassificationType;
import org.oasis.ebxml.registry.bindings.rim.ObjectRef;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;

public class ClassificationImpl
extends RegistryObjectImpl
implements javax.xml.registry.infomodel.Classification {
    private RegistryObjectRef conceptRef = null;
    private RegistryObjectRef schemeRef = null;
    private String value = null;
    private RegistryObjectRef classifiedObjectRef = null;

    public ClassificationImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        super(lcm);
    }

    public ClassificationImpl(LifeCycleManagerImpl lcm, ClassificationType ebClass, RegistryObject classifiedObject) throws JAXRException {
        super(lcm, ebClass);
        Object cnodeObj;
        Object schemeObj = ebClass.getClassificationScheme();
        if (schemeObj != null) {
            this.schemeRef = new RegistryObjectRef(lcm, schemeObj);
        }
        if (classifiedObject != null) {
            this.classifiedObjectRef = new RegistryObjectRef(lcm, classifiedObject);
        }
        if ((cnodeObj = ebClass.getClassificationNode()) != null) {
            this.conceptRef = new RegistryObjectRef(lcm, cnodeObj);
        }
        this.value = ebClass.getNodeRepresentation();
        this.setModified(false);
    }

    public String toXML() throws JAXRException {
        Classification ebObj = this.toBindingObject();
        StringWriter sw = new StringWriter();
        try {
            ((RegistryObjectType)ebObj).marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (ValidationException x) {
            throw new JAXRException((Throwable)x);
        }
        return sw.toString();
    }

    public Concept getConcept() throws JAXRException {
        Concept concept = null;
        if (this.conceptRef != null) {
            concept = (Concept)this.conceptRef.getRegistryObject("ClassificationNode");
        }
        return concept;
    }

    public void setConcept(Concept concept) throws JAXRException {
        ClassificationScheme scheme = concept.getClassificationScheme();
        if (scheme == null) {
            throw new InvalidRequestException("Error: Classification.setConcept must not be called using a concept that has no ClassificationScheme ancestor.");
        }
        this.conceptRef = new RegistryObjectRef(this.lcm, (RegistryObject)concept);
        this.setModified(true);
    }

    public ClassificationScheme getClassificationScheme() throws JAXRException {
        ClassificationScheme scheme = null;
        if (this.schemeRef == null) {
            Concept concept = this.getConcept();
            if (concept != null) {
                scheme = concept.getClassificationScheme();
            }
        } else {
            scheme = (ClassificationScheme)this.schemeRef.getRegistryObject("ClassificationScheme");
        }
        return scheme;
    }

    public void setClassificationScheme(ClassificationScheme scheme) throws JAXRException {
        this.schemeRef = new RegistryObjectRef(this.lcm, (RegistryObject)scheme);
        this.setModified(true);
    }

    public InternationalString getName() throws JAXRException {
        Concept concept;
        InternationalString name = super.getName();
        if (name.getLocalizedStrings().size() == 0 && !this.isExternal() && (concept = this.getConcept()) != null) {
            name = (InternationalStringImpl)((InternationalStringImpl)concept.getName()).clone();
        }
        return name;
    }

    public String getValue() throws JAXRException {
        String val = null;
        if (this.isExternal()) {
            val = this.value;
        } else {
            Concept concept = this.getConcept();
            if (concept != null) {
                val = concept.getValue();
            }
        }
        return val;
    }

    public void setValue(String par1) throws JAXRException {
        this.value = par1;
        this.setModified(true);
    }

    public RegistryObject getClassifiedObject() throws JAXRException {
        RegistryObject classifiedObject = null;
        if (this.classifiedObjectRef != null) {
            classifiedObject = this.classifiedObjectRef.getRegistryObject("RegistryObject");
        }
        return classifiedObject;
    }

    public void setClassifiedObject(RegistryObject ro) throws JAXRException {
        if (ro == null) {
            throw new JAXRException("Classified Object must not be null");
        }
        this.classifiedObjectRef = new RegistryObjectRef(this.lcm, ro);
        this.setModified(true);
        Collection classifications = ro.getClassifications();
        if (!classifications.contains(this)) {
            ro.addClassification((javax.xml.registry.infomodel.Classification)this);
        }
    }

    public boolean isExternal() throws JAXRException {
        boolean external = false;
        if (this.conceptRef == null) {
            external = true;
        }
        return external;
    }

    public Classification toBindingObject() throws JAXRException {
        Classification ebClassification = new Classification();
        this.setBindingObject(ebClassification);
        return ebClassification;
    }

    protected void setBindingObject(ClassificationType ebClassification) throws JAXRException {
        super.setBindingObject(ebClassification);
        if (this.schemeRef != null) {
            ObjectRef ebSchemeRef = new ObjectRef();
            ebSchemeRef.setId(this.schemeRef.getId());
            ebClassification.setClassificationScheme(ebSchemeRef);
        }
        ObjectRef ebClassifiedObjectRef = new ObjectRef();
        ebClassifiedObjectRef.setId(this.classifiedObjectRef.getId());
        ebClassification.setClassifiedObject(ebClassifiedObjectRef);
        if (this.conceptRef != null) {
            ObjectRef ebClassificationNodeRef = new ObjectRef();
            ebClassificationNodeRef.setId(this.conceptRef.getId());
            ebClassification.setClassificationNode(ebClassificationNodeRef);
        }
        if (this.value != null) {
            ebClassification.setNodeRepresentation(this.value);
        }
    }

    public HashSet getRegistryObjectRefs() {
        HashSet<RegistryObjectRef> refs = new HashSet<RegistryObjectRef>();
        if (this.conceptRef != null) {
            refs.add(this.conceptRef);
        }
        if (this.schemeRef != null) {
            refs.add(this.schemeRef);
        }
        if (this.classifiedObjectRef != null) {
            refs.add(this.classifiedObjectRef);
        }
        return refs;
    }
}

