/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.util;

import com.sun.xml.registry.ebxml.infomodel.ConceptImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;

public class QueryUtil {
    private static final QueryUtil INSTANCE = new QueryUtil();
    HashSet unsupportedObjectTypes = new HashSet();

    private QueryUtil() {
        this.unsupportedObjectTypes.add("ObjectType");
        this.unsupportedObjectTypes.add("Registry");
        this.unsupportedObjectTypes.add("Federation");
        this.unsupportedObjectTypes.add("Subscription");
    }

    public static QueryUtil getInstance() {
        return INSTANCE;
    }

    public String classificationsToPred(Collection classifications, String term) throws JAXRException {
        if (classifications == null || classifications.size() == 0) {
            return null;
        }
        Iterator i = classifications.iterator();
        Classification cl = (Classification)i.next();
        String sub1 = " IN (SELECT classifiedObject FROM Classification WHERE classificationNode IN ( SELECT id FROM ClassificationNode WHERE path LIKE '";
        ConceptImpl concept = (ConceptImpl)cl.getConcept();
        String path = "";
        if (concept != null) {
            path = concept.getPath();
        }
        StringBuffer result = new StringBuffer("(" + term + sub1 + path + "%'");
        while (i.hasNext()) {
            ConceptImpl con1 = (ConceptImpl)cl.getConcept();
            String path1 = "";
            if (con1 != null) {
                path1 = con1.getPath();
            }
            cl = (Classification)i.next();
            result.append("))) AND (" + term + sub1 + path1 + "%'");
        }
        return result.append(")))").toString();
    }

    public String externalIdentifiersToPred(Collection extIds, String term) throws JAXRException {
        if (extIds == null || extIds.size() == 0) {
            return null;
        }
        StringBuffer pred = new StringBuffer();
        boolean first = true;
        Iterator iter = extIds.iterator();
        while (iter.hasNext()) {
            ExternalIdentifier extId = (ExternalIdentifier)iter.next();
            if (!first) {
                pred.append("AND ");
            } else {
                first = false;
            }
            pred.append("(" + term + " IN (SELECT extId.registryObject FROM ExternalIdentifier extId WHERE (extId.value LIKE '" + extId.getValue() + "') AND (extId.identificationScheme = '" + extId.getIdentificationScheme().getKey().getId() + "' )))");
        }
        return pred.toString();
    }

    public String externalLinksToPred(Collection extLinks, String term) throws JAXRException {
        if (extLinks == null || extLinks.size() == 0) {
            return null;
        }
        StringBuffer pred = new StringBuffer();
        boolean first = true;
        Iterator iter = extLinks.iterator();
        while (iter.hasNext()) {
            ExternalLink extLink = (ExternalLink)iter.next();
            if (!first) {
                pred.append("AND ");
            } else {
                first = false;
            }
            pred.append("(" + term + " IN (SELECT ass.targetObject FROM Association ass WHERE ass.associationType = 'ExternallyLinks' AND ass.sourceObject IN (SELECT id from ExternalLink extLink WHERE extLink.externalURI LIKE '" + extLink.getExternalURI() + "')))");
        }
        return pred.toString();
    }

    public HashSet getUnsupportedObjectTypes() {
        return this.unsupportedObjectTypes;
    }
}

