/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.util;

import com.sun.xml.registry.ebxml.util.UUID;
import java.security.SecureRandom;

public class UUIDFactory {
    private final SecureRandom secRand = new SecureRandom();
    private final byte[] secRandBuf16 = new byte[16];
    private final byte[] secRandBuf8 = new byte[8];
    private static UUIDFactory instance = null;
    static /* synthetic */ Class class$com$sun$xml$registry$ebxml$util$UUIDFactory;

    protected UUIDFactory() {
    }

    public UUID newUUID() {
        this.secRand.nextBytes(this.secRandBuf16);
        this.secRandBuf16[6] = (byte)(this.secRandBuf16[6] & 0xF);
        this.secRandBuf16[6] = (byte)(this.secRandBuf16[6] | 0x40);
        this.secRandBuf16[8] = (byte)(this.secRandBuf16[8] & 0x3F);
        this.secRandBuf16[8] = (byte)(this.secRandBuf16[8] | 0x80);
        this.secRandBuf16[10] = (byte)(this.secRandBuf16[10] | 0x80);
        long mostSig = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSig = mostSig << 8 | (long)(this.secRandBuf16[i] & 0xFF);
        }
        long leastSig = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSig = leastSig << 8 | (long)(this.secRandBuf16[i] & 0xFF);
        }
        return new UUID(mostSig, leastSig);
    }

    public boolean isValidUUID(String uuid) {
        boolean isValid = true;
        int len = uuid.length();
        String hexDigits = "0123456789abcdef";
        for (int i = 0; i < len; ++i) {
            char c = uuid.charAt(i);
            if (i == 8 || i == 13 || i == 18 || i == 23) {
                if (c == '-') continue;
                isValid = false;
                break;
            }
            if (hexDigits.indexOf(c) != -1) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    public static void main(String[] args) {
        UUIDFactory uf = UUIDFactory.getInstance();
        UUID id = uf.newUUID();
        System.out.println("new UUID : " + id.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUIDFactory getInstance() {
        if (instance == null) {
            Class clazz = class$com$sun$xml$registry$ebxml$util$UUIDFactory == null ? (class$com$sun$xml$registry$ebxml$util$UUIDFactory = UUIDFactory.class$("com.sun.xml.registry.ebxml.util.UUIDFactory")) : class$com$sun$xml$registry$ebxml$util$UUIDFactory;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new UUIDFactory();
                }
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

