/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.MethodInfo;
import javassist.compiler.CompileError;
import javassist.compiler.Javac;

public final class CtConstructor
extends CtBehavior {
    protected CtConstructor next = null;

    protected CtConstructor(MethodInfo minfo, CtClass declaring) {
        super(declaring, minfo);
    }

    public CtConstructor(CtClass[] parameters, CtClass declaring) {
        this((MethodInfo)null, declaring);
        ConstPool cp = declaring.getClassFile2().getConstPool();
        String desc = Descriptor.ofConstructor(parameters);
        this.methodInfo = new MethodInfo(cp, "<init>", desc);
        this.setModifiers(1);
    }

    public CtConstructor(CtConstructor src, CtClass declaring, ClassMap map) throws CannotCompileException {
        this((MethodInfo)null, declaring);
        MethodInfo srcInfo = src.methodInfo;
        CtClass srcClass = src.getDeclaringClass();
        ConstPool cp = declaring.getClassFile2().getConstPool();
        if (map == null) {
            map = new ClassMap();
        }
        map.put(srcClass.getName(), declaring.getName());
        try {
            String srcSuperName;
            boolean patch = false;
            CtClass srcSuper = srcClass.getSuperclass();
            String destSuperName = declaring.getSuperclass().getName();
            if (srcSuper != null && !(srcSuperName = srcSuper.getName()).equals(destSuperName)) {
                if (srcSuperName.equals("java.lang.Object")) {
                    patch = true;
                } else {
                    map.put(srcSuperName, destSuperName);
                }
            }
            this.methodInfo = new MethodInfo(cp, srcInfo.getName(), srcInfo, map);
            if (patch) {
                this.methodInfo.setSuperclass(destSuperName);
            }
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        catch (BadBytecode e) {
            throw new CannotCompileException(e);
        }
    }

    static CtConstructor append(CtConstructor list, CtConstructor tail) {
        tail.next = null;
        if (list == null) {
            return tail;
        }
        CtConstructor lst = list;
        while (lst.next != null) {
            lst = lst.next;
        }
        lst.next = tail;
        return list;
    }

    static int count(CtConstructor m) {
        int n = 0;
        while (m != null) {
            ++n;
            m = m.next;
        }
        return n;
    }

    public boolean isConstructor() {
        return this.methodInfo.isConstructor();
    }

    public boolean isClassInitializer() {
        return this.methodInfo.isStaticInitializer();
    }

    public String getName() {
        if (this.methodInfo.isStaticInitializer()) {
            return "<clinit>";
        }
        return this.declaringClass.getName();
    }

    public boolean isEmpty() {
        CodeAttribute ca = this.getMethodInfo2().getCodeAttribute();
        if (ca == null) {
            return false;
        }
        ConstPool cp = ca.getConstPool();
        CodeIterator it = ca.iterator();
        try {
            int desc;
            int pos;
            return it.byteAt(it.next()) == 42 && it.byteAt(pos = it.next()) == 183 && (desc = cp.isConstructor("java.lang.Object", it.u16bitAt(pos + 1))) != 0 && cp.getUtf8Info(desc).equals("()V") && it.byteAt(it.next()) == 177 && !it.hasNext();
        }
        catch (BadBytecode e) {
            return false;
        }
    }

    public void setBody(String src) throws CannotCompileException {
        if (src == null) {
            src = this.isClassInitializer() ? ";" : "super();";
        }
        super.setBody(src);
    }

    public void setBody(CtConstructor src, ClassMap map) throws CannotCompileException {
        CtConstructor.setBody0(src.declaringClass, src.methodInfo, this.declaringClass, this.methodInfo, map);
    }

    public void insertBeforeBody(String src) throws CannotCompileException {
        this.declaringClass.checkModify();
        if (this.isClassInitializer()) {
            throw new CannotCompileException("class initializer");
        }
        CodeAttribute ca = this.methodInfo.getCodeAttribute();
        CodeIterator iterator = ca.iterator();
        Bytecode b = new Bytecode(this.methodInfo.getConstPool(), ca.getMaxStack(), ca.getMaxLocals());
        b.setStackDepth(ca.getMaxStack());
        Javac jv = new Javac(b, this.declaringClass);
        try {
            jv.recordParams(this.getParameterTypes(), false);
            jv.compileStmnt(src);
            ca.setMaxStack(b.getMaxStack());
            ca.setMaxLocals(b.getMaxLocals());
            iterator.skipConstructor();
            int pos = iterator.insertEx(b.get());
            iterator.insert(b.getExceptionTable(), pos);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        catch (CompileError e) {
            throw new CannotCompileException(e);
        }
        catch (BadBytecode e) {
            throw new CannotCompileException(e);
        }
    }

    int getStartPosOfBody(CodeAttribute ca) throws CannotCompileException {
        CodeIterator ci = ca.iterator();
        try {
            ci.skipConstructor();
            return ci.next();
        }
        catch (BadBytecode e) {
            throw new CannotCompileException(e);
        }
    }
}

