/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.jboss.security.SecurityDomain;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public class BaseCertLoginModule
extends AbstractServerLoginModule {
    private Principal identity;
    private X509Certificate credential;
    private SecurityDomain domain = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        String sd = (String)options.get("securityDomain");
        if (sd == null) {
            sd = "java:/jaas/other";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("securityDomain=" + sd));
        }
        try {
            Object tempDomain = new InitialContext().lookup(sd);
            if (tempDomain instanceof SecurityDomain) {
                this.domain = (SecurityDomain)tempDomain;
                if (this.log.isDebugEnabled()) {
                    if (this.domain != null) {
                        this.log.debug((Object)("found domain: " + this.domain.getClass().getName()));
                    } else {
                        this.log.debug((Object)("the domain " + sd + " is null!"));
                    }
                }
            } else {
                this.log.error((Object)("The domain " + sd + " is not a SecurityDomain. All authentication using this module will fail!"));
            }
        }
        catch (NamingException e) {
            this.log.error((Object)("Unable to find the securityDomain named: " + sd), (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"exit: initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"enter: login()");
        }
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    this.log.debug((Object)"Failed to create principal", (Throwable)e);
                    throw new LoginException("Failed to create principal: " + e.getMessage());
                }
            }
            Object password = this.sharedState.get("javax.security.auth.login.password");
            if (password instanceof X509Certificate) {
                this.credential = (X509Certificate)password;
            } else if (password != null) {
                this.log.debug((Object)"javax.security.auth.login.password is not X509Certificate");
                this.loginOk = false;
                return false;
            }
            return true;
        }
        this.loginOk = false;
        Object[] info = this.getAliasAndCert();
        String alias = (String)info[0];
        this.credential = (X509Certificate)info[1];
        if (alias == null && this.credential == null) {
            this.identity = this.unauthenticatedIdentity;
            this.log.trace((Object)("Authenticating as unauthenticatedIdentity=" + this.identity));
        }
        if (this.identity == null) {
            try {
                this.identity = this.createIdentity(alias);
            }
            catch (Exception e) {
                this.log.debug((Object)("Failed to create identity for alias:" + alias), (Throwable)e);
            }
            if (!this.validateCredential(alias, this.credential)) {
                this.log.debug((Object)("Bad credential for alias=" + alias));
                throw new FailedLoginException("Supplied Credential did not match existing credential for " + alias);
            }
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", alias);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        this.log.trace((Object)("User '" + this.identity + "' authenticated, loginOk=" + this.loginOk));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"exit: login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        boolean ok = super.commit();
        if (ok) {
            this.subject.getPublicCredentials().add(this.credential);
        }
        return ok;
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Object getCredentials() {
        return this.credential;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return username;
    }

    protected Object[] getAliasAndCert() throws LoginException {
        X509Certificate cert;
        String alias;
        Object[] info;
        block10: {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"enter: getAliasAndCert()");
            }
            info = new Object[]{null, null};
            if (this.callbackHandler == null) {
                throw new LoginException("Error: no CallbackHandler available to collect authentication information");
            }
            NameCallback nc = new NameCallback("Alias: ");
            ObjectCallback oc = new ObjectCallback("Certificate: ");
            Callback[] callbacks = new Callback[]{nc, oc};
            alias = null;
            cert = null;
            try {
                this.callbackHandler.handle(callbacks);
                alias = nc.getName();
                Object tmpCert = oc.getCredential();
                if (tmpCert == null) break block10;
                if (tmpCert instanceof X509Certificate) {
                    cert = (X509Certificate)tmpCert;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("found cert " + cert.getSerialNumber().toString(16) + ":" + cert.getSubjectDN().getName()));
                    }
                    break block10;
                }
                if (tmpCert instanceof X509Certificate[]) {
                    X509Certificate[] certChain = (X509Certificate[])tmpCert;
                    if (certChain.length > 0) {
                        cert = certChain[0];
                    }
                    break block10;
                }
                String msg = "Don't know how to obtain X509Certificate from: " + tmpCert.getClass();
                this.log.warn((Object)msg);
                throw new LoginException(msg);
            }
            catch (IOException e) {
                this.log.debug((Object)"Failed to invoke callback", (Throwable)e);
                throw new LoginException("Failed to invoke callback: " + e.toString());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException("CallbackHandler does not support: " + uce.getCallback());
            }
        }
        info[0] = alias;
        info[1] = cert;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"exit: getAliasAndCert()");
        }
        return info;
    }

    protected boolean validateCredential(String alias, X509Certificate cert) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"enter: validateCredentail(String, X509Certificate)");
        }
        boolean isValid = false;
        if (this.domain != null && cert != null) {
            KeyStore store = this.domain.getTrustStore();
            if (store == null) {
                store = this.domain.getKeyStore();
            }
            if (store != null) {
                X509Certificate storeCert = null;
                try {
                    storeCert = (X509Certificate)store.getCertificate(alias);
                    if (this.log.isDebugEnabled()) {
                        StringBuffer buf = new StringBuffer("\n\tSupplied Credential: ");
                        buf.append(cert.getSerialNumber().toString(16));
                        buf.append("\n\t\t");
                        buf.append(cert.getSubjectDN().getName());
                        buf.append("\n\n\tExisting Credential: ");
                        if (storeCert != null) {
                            buf.append(storeCert.getSerialNumber().toString(16));
                            buf.append("\n\t\t");
                            buf.append(storeCert.getSubjectDN().getName());
                            buf.append("\n");
                        } else {
                            ArrayList<String> aliases = new ArrayList<String>();
                            Enumeration<String> en = store.aliases();
                            while (en.hasMoreElements()) {
                                aliases.add(en.nextElement());
                            }
                            buf.append("No match for alias: " + alias + ", we have aliases " + aliases);
                        }
                        this.log.debug((Object)buf.toString());
                    }
                }
                catch (KeyStoreException e) {
                    this.log.warn((Object)("failed to find the certificate for " + alias), (Throwable)e);
                }
                if (cert.equals(storeCert)) {
                    isValid = true;
                }
            } else {
                this.log.warn((Object)"KeyStore is null!");
            }
        } else {
            this.log.warn((Object)"Domain or Credential is null. Unable to validate the certificate.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("The supplied certificate " + (isValid ? "matched" : "DID NOT match") + " the certificate in the keystore."));
            this.log.debug((Object)"exit: validateCredentail(String, X509Certificate)");
        }
        return isValid;
    }
}

