/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jacc;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Iterator;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.jboss.logging.Logger;
import org.jboss.security.jacc.ContextPolicy;

public class DelegatingPolicy
extends Policy {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$jacc$DelegatingPolicy == null ? (class$org$jboss$security$jacc$DelegatingPolicy = DelegatingPolicy.class$("org.jboss.security.jacc.DelegatingPolicy")) : class$org$jboss$security$jacc$DelegatingPolicy));
    private static DelegatingPolicy instance;
    private Policy delegate;
    private HashMap contextPolicies = new HashMap();
    private boolean trace;
    private PolicyProxy policyProxy = new PolicyProxy(this);
    static /* synthetic */ Class class$org$jboss$security$jacc$DelegatingPolicy;

    public static synchronized DelegatingPolicy getInstance() {
        if (instance == null) {
            instance = new DelegatingPolicy();
        }
        return instance;
    }

    public DelegatingPolicy() {
        this(null);
    }

    public DelegatingPolicy(Policy delegate) {
        if (delegate == null) {
            delegate = Policy.getPolicy();
        }
        this.delegate = delegate;
        this.trace = log.isTraceEnabled();
        if (instance == null) {
            instance = this;
        }
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        return super.getPermissions(domain);
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        boolean isJaccPermission;
        boolean bl = isJaccPermission = permission instanceof EJBMethodPermission || permission instanceof EJBRoleRefPermission || permission instanceof WebResourcePermission || permission instanceof WebRoleRefPermission || permission instanceof WebUserDataPermission;
        if (this.trace) {
            log.trace((Object)("implies, domain=" + domain + ", permission=" + permission + ", isJaccPermission=" + isJaccPermission));
        }
        boolean implied = false;
        if (!isJaccPermission) {
            implied = this.delegate.implies(domain, permission);
        } else {
            String contextID = PolicyContext.getContextID();
            ContextPolicy contextPolicy = (ContextPolicy)this.contextPolicies.get(contextID);
            if (contextPolicy != null) {
                implied = contextPolicy.implies(domain, permission);
            } else if (this.trace) {
                log.trace((Object)("No PolicyContext found for contextID=" + contextID));
            }
        }
        if (this.trace) {
            log.trace((Object)("implied=" + implied));
        }
        return implied;
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        ContextPolicy policy;
        PermissionCollection pc = null;
        String contextID = PolicyContext.getContextID();
        pc = contextID == null ? this.delegate.getPermissions(cs) : ((policy = (ContextPolicy)this.contextPolicies.get(contextID)) != null ? policy.getPermissions() : this.delegate.getPermissions(cs));
        return pc;
    }

    public void refresh() {
    }

    public Policy getPolicyProxy() {
        return this.policyProxy;
    }

    public String listContextPolicies() {
        HashMap copy = new HashMap(this.contextPolicies);
        StringBuffer tmp = new StringBuffer("<ContextPolicies>");
        Iterator iter = copy.keySet().iterator();
        while (iter.hasNext()) {
            String contextID = (String)iter.next();
            ContextPolicy cp = (ContextPolicy)this.contextPolicies.get(contextID);
            tmp.append(cp);
            tmp.append('\n');
        }
        tmp.append("</ContextPolicies>");
        return tmp.toString();
    }

    synchronized ContextPolicy getContextPolicy(String contextID) throws PolicyContextException {
        ContextPolicy policy = (ContextPolicy)this.contextPolicies.get(contextID);
        if (policy == null) {
            throw new PolicyContextException("No ContextPolicy exists for contextID=" + contextID);
        }
        return policy;
    }

    synchronized void initPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        ContextPolicy policy = (ContextPolicy)this.contextPolicies.get(contextID);
        if (policy == null) {
            policy = new ContextPolicy(contextID);
            this.contextPolicies.put(contextID, policy);
        }
        if (remove) {
            policy.clear();
        }
    }

    void addToExcludedPolicy(String contextID, Permission permission) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToExcludedPolicy(permission);
    }

    void addToExcludedPolicy(String contextID, PermissionCollection permissions) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToExcludedPolicy(permissions);
    }

    void addToRole(String contextID, String roleName, Permission permission) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToRole(roleName, permission);
    }

    void addToRole(String contextID, String roleName, PermissionCollection permissions) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToRole(roleName, permissions);
    }

    void addToUncheckedPolicy(String contextID, Permission permission) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToUncheckedPolicy(permission);
    }

    void addToUncheckedPolicy(String contextID, PermissionCollection permissions) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.addToUncheckedPolicy(permissions);
    }

    void linkConfiguration(String contextID, PolicyConfiguration link) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        ContextPolicy linkPolicy = this.getContextPolicy(link.getContextID());
        policy.linkConfiguration(linkPolicy);
    }

    public void commit(String contextID) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String contextID) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.delete();
        HashMap hashMap = this.contextPolicies;
        synchronized (hashMap) {
            this.contextPolicies.remove(contextID);
        }
    }

    void removeExcludedPolicy(String contextID) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.removeExcludedPolicy();
    }

    void removeRole(String contextID, String roleName) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.removeRole(roleName);
    }

    void removeUncheckedPolicy(String contextID) throws PolicyContextException {
        ContextPolicy policy = this.getContextPolicy(contextID);
        policy.removeUncheckedPolicy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PolicyProxy
    extends Policy {
        private Policy delegate;

        PolicyProxy(Policy delegate) {
            this.delegate = delegate;
        }

        public void refresh() {
            this.delegate.refresh();
        }

        public PermissionCollection getPermissions(CodeSource codesource) {
            return this.delegate.getPermissions(codesource);
        }

        public boolean implies(ProtectionDomain domain, Permission permission) {
            return this.delegate.implies(domain, permission);
        }

        public PermissionCollection getPermissions(ProtectionDomain domain) {
            return this.delegate.getPermissions(domain);
        }
    }
}

