/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jboss.logging.Logger;

public class FilePassword {
    private File passwordFile;
    static /* synthetic */ Class class$org$jboss$security$plugins$FilePassword;

    public FilePassword(String file) {
        this.passwordFile = new File(file);
    }

    public char[] toCharArray() throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.passwordFile, "rws");
        try {
            char[] password = FilePassword.decode(raf);
            return password;
        }
        catch (Exception e) {
            Logger log = Logger.getLogger((Class)(class$org$jboss$security$plugins$FilePassword == null ? (class$org$jboss$security$plugins$FilePassword = FilePassword.class$("org.jboss.security.plugins.FilePassword")) : class$org$jboss$security$plugins$FilePassword));
            log.error((Object)("Failed to decode password file: " + this.passwordFile), (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    static char[] decode(RandomAccessFile passwordFile) throws Exception {
        int b;
        byte[] salt = new byte[8];
        passwordFile.readFully(salt);
        int count = passwordFile.readInt();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = passwordFile.read()) >= 0) {
            baos.write(b);
        }
        passwordFile.close();
        byte[] secret = baos.toByteArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec keySpec = new PBEKeySpec("78aac249a60a13d5e882927928043ebb".toCharArray());
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        SecretKey cipherKey = factory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance("PBEwithMD5andDES");
        cipher.init(2, (Key)cipherKey, cipherSpec);
        byte[] decode = cipher.doFinal(secret);
        return new String(decode, "UTF-8").toCharArray();
    }

    static void encode(RandomAccessFile passwordFile, byte[] salt, int count, byte[] secret) throws Exception {
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec keySpec = new PBEKeySpec("78aac249a60a13d5e882927928043ebb".toCharArray());
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        SecretKey cipherKey = factory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance("PBEwithMD5andDES");
        cipher.init(1, (Key)cipherKey, cipherSpec);
        byte[] encode = cipher.doFinal(secret);
        passwordFile.write(salt);
        passwordFile.writeInt(count);
        passwordFile.write(encode);
        passwordFile.close();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("Write a password in opaque form to a file for use with the FilePassword accessorUsage: FilePassword salt count password password-file  salt  : an 8 char sequence for PBEKeySpec  count : iteration count for PBEKeySpec  password : the clear text password to write  password-file : the path to the file to write the password to");
        }
        byte[] salt = args[0].substring(0, 8).getBytes();
        int count = Integer.parseInt(args[1]);
        byte[] passwordBytes = args[2].getBytes("UTF-8");
        RandomAccessFile passwordFile = new RandomAccessFile(args[3], "rws");
        FilePassword.encode(passwordFile, salt, count, passwordBytes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

