/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityDomain;
import org.jboss.security.SecurityProxyFactory;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.security.plugins.SecurityDomainContext;
import org.jboss.security.plugins.SubjectActions;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

public class JaasSecurityManagerService
extends ServiceMBeanSupport
implements JaasSecurityManagerServiceMBean {
    private static final String SECURITY_MGR_PATH = "java:/jaas";
    private static final String DEFAULT_CACHE_POLICY_PATH = "java:/timedCacheFactory";
    private static Logger log;
    private static String securityMgrClassName;
    private static Class securityMgrClass;
    private static String callbackHandlerClassName;
    private static Class callbackHandlerClass;
    private static String cacheJndiName;
    private static int defaultCacheTimeout;
    private static int defaultCacheResolution;
    private static String securityProxyFactoryClassName;
    private static Class securityProxyFactoryClass;
    private static Hashtable securityDomainCtxMap;
    private static NameParser parser;
    private static MBeanServer server;
    private static String defaultUnauthenticatedPrincipal;
    static /* synthetic */ Class class$org$jboss$security$auth$callback$SecurityAssociationHandler;
    static /* synthetic */ Class class$org$jboss$security$SubjectSecurityProxyFactory;
    static /* synthetic */ Class class$org$jboss$security$plugins$JaasSecurityManagerService;
    static /* synthetic */ Class class$org$jboss$security$AuthenticationManager;
    static /* synthetic */ Class class$org$jboss$security$plugins$JaasSecurityManagerService$SecurityDomainObjectFactory;
    static /* synthetic */ Class class$org$jboss$security$plugins$JaasSecurityManagerService$DefaultCacheObjectFactory;
    static /* synthetic */ Class class$java$security$Principal;
    static /* synthetic */ Class class$org$jboss$security$propertyeditor$PrincipalEditor;
    static /* synthetic */ Class class$org$jboss$security$SecurityDomain;
    static /* synthetic */ Class class$org$jboss$security$propertyeditor$SecurityDomainEditor;
    static /* synthetic */ Class class$org$jboss$util$CachePolicy;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$security$auth$callback$CallbackHandler;
    static /* synthetic */ Class class$javax$naming$Context;

    public String getSecurityManagerClassName() {
        return securityMgrClassName;
    }

    public void setSecurityManagerClassName(String className) throws ClassNotFoundException, ClassCastException {
        ClassLoader loader;
        securityMgrClassName = className;
        if (!(class$org$jboss$security$AuthenticationManager == null ? (class$org$jboss$security$AuthenticationManager = JaasSecurityManagerService.class$("org.jboss.security.AuthenticationManager")) : class$org$jboss$security$AuthenticationManager).isAssignableFrom(securityMgrClass = (loader = Thread.currentThread().getContextClassLoader()).loadClass(securityMgrClassName))) {
            throw new ClassCastException(securityMgrClass + " does not implement " + (class$org$jboss$security$AuthenticationManager == null ? (class$org$jboss$security$AuthenticationManager = JaasSecurityManagerService.class$("org.jboss.security.AuthenticationManager")) : class$org$jboss$security$AuthenticationManager));
        }
    }

    public String getSecurityProxyFactoryClassName() {
        return securityProxyFactoryClassName;
    }

    public void setSecurityProxyFactoryClassName(String className) throws ClassNotFoundException {
        securityProxyFactoryClassName = className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        securityProxyFactoryClass = loader.loadClass(securityProxyFactoryClassName);
    }

    public String getCallbackHandlerClassName() {
        return callbackHandlerClassName;
    }

    public void setCallbackHandlerClassName(String className) throws ClassNotFoundException {
        callbackHandlerClassName = className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        callbackHandlerClass = loader.loadClass(callbackHandlerClassName);
    }

    public String getAuthenticationCacheJndiName() {
        return cacheJndiName;
    }

    public void setAuthenticationCacheJndiName(String jndiName) {
        cacheJndiName = jndiName;
    }

    public int getDefaultCacheTimeout() {
        return defaultCacheTimeout;
    }

    public void setDefaultCacheTimeout(int timeoutInSecs) {
        defaultCacheTimeout = timeoutInSecs;
    }

    public int getDefaultCacheResolution() {
        return defaultCacheResolution;
    }

    public void setDefaultCacheResolution(int resInSecs) {
        defaultCacheResolution = resInSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheTimeout(String securityDomain, int timeoutInSecs, int resInSecs) {
        CachePolicy cache = JaasSecurityManagerService.getCachePolicy(securityDomain);
        if (cache != null && cache instanceof TimedCachePolicy) {
            TimedCachePolicy tcp;
            TimedCachePolicy timedCachePolicy = tcp = (TimedCachePolicy)cache;
            synchronized (timedCachePolicy) {
                tcp.setDefaultLifetime(timeoutInSecs);
                tcp.setResolution(resInSecs);
            }
        } else {
            log.warn((Object)("Failed to find cache policy for securityDomain='" + securityDomain + "'"));
        }
    }

    public void flushAuthenticationCache(String securityDomain) {
        CachePolicy cache = JaasSecurityManagerService.getCachePolicy(securityDomain);
        if (cache != null) {
            cache.flush();
        } else {
            log.warn((Object)("Failed to find cache policy for securityDomain='" + securityDomain + "'"));
        }
    }

    public void flushAuthenticationCache(String securityDomain, Principal user) {
        CachePolicy cache = JaasSecurityManagerService.getCachePolicy(securityDomain);
        if (cache != null) {
            cache.remove((Object)user);
        } else {
            log.warn((Object)("Failed to find cache policy for securityDomain='" + securityDomain + "'"));
        }
    }

    public List getAuthenticationCachePrincipals(String securityDomain) {
        CachePolicy cache = JaasSecurityManagerService.getCachePolicy(securityDomain);
        List validPrincipals = null;
        if (cache instanceof TimedCachePolicy) {
            TimedCachePolicy tcache = (TimedCachePolicy)cache;
            validPrincipals = tcache.getValidKeys();
        }
        return validPrincipals;
    }

    public boolean isValid(String securityDomain, Principal principal, Object credential) {
        boolean isValid = false;
        try {
            SecurityDomainContext sdc = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            isValid = sdc.getSecurityManager().isValid(principal, credential);
        }
        catch (NamingException e) {
            log.debug((Object)("isValid(" + securityDomain + ") failed"), (Throwable)e);
        }
        return isValid;
    }

    public Principal getPrincipal(String securityDomain, Principal principal) {
        Principal realmPrincipal = null;
        try {
            SecurityDomainContext sdc = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            realmPrincipal = sdc.getRealmMapping().getPrincipal(principal);
        }
        catch (NamingException e) {
            log.debug((Object)("getPrincipal(" + securityDomain + ") failed"), (Throwable)e);
        }
        return realmPrincipal;
    }

    public boolean doesUserHaveRole(String securityDomain, Principal principal, Object credential, Set roles) {
        boolean doesUserHaveRole = false;
        try {
            SecurityDomainContext sdc = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            sdc.getSecurityManager().isValid(principal, credential);
            doesUserHaveRole = sdc.getRealmMapping().doesUserHaveRole(principal, roles);
        }
        catch (NamingException e) {
            log.debug((Object)("doesUserHaveRole(" + securityDomain + ") failed"), (Throwable)e);
        }
        return doesUserHaveRole;
    }

    public Set getUserRoles(String securityDomain, Principal principal, Object credential) {
        Set userRoles = null;
        try {
            SecurityDomainContext sdc = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            sdc.getSecurityManager().isValid(principal, credential);
            userRoles = sdc.getRealmMapping().getUserRoles(principal);
        }
        catch (NamingException e) {
            log.debug((Object)("getUserRoles(" + securityDomain + ") failed"), (Throwable)e);
        }
        return userRoles;
    }

    protected void startService() throws Exception {
        InitialContext ctx = new InitialContext();
        parser = ctx.getNameParser("");
        StringRefAddr refAddr = new StringRefAddr("nns", "JSM");
        String factoryName = (class$org$jboss$security$plugins$JaasSecurityManagerService$SecurityDomainObjectFactory == null ? (class$org$jboss$security$plugins$JaasSecurityManagerService$SecurityDomainObjectFactory = JaasSecurityManagerService.class$("org.jboss.security.plugins.JaasSecurityManagerService$SecurityDomainObjectFactory")) : class$org$jboss$security$plugins$JaasSecurityManagerService$SecurityDomainObjectFactory).getName();
        Reference ref = new Reference("javax.naming.Context", refAddr, factoryName, null);
        ctx.rebind(SECURITY_MGR_PATH, (Object)ref);
        log.debug((Object)"securityMgrCtxPath=java:/jaas");
        refAddr = new StringRefAddr("nns", "JSMCachePolicy");
        factoryName = (class$org$jboss$security$plugins$JaasSecurityManagerService$DefaultCacheObjectFactory == null ? (class$org$jboss$security$plugins$JaasSecurityManagerService$DefaultCacheObjectFactory = JaasSecurityManagerService.class$("org.jboss.security.plugins.JaasSecurityManagerService$DefaultCacheObjectFactory")) : class$org$jboss$security$plugins$JaasSecurityManagerService$DefaultCacheObjectFactory).getName();
        ref = new Reference("javax.naming.Context", refAddr, factoryName, null);
        ctx.rebind(DEFAULT_CACHE_POLICY_PATH, (Object)ref);
        log.debug((Object)("cachePolicyCtxPath=" + cacheJndiName));
        SecurityProxyFactory proxyFactory = (SecurityProxyFactory)securityProxyFactoryClass.newInstance();
        ctx.bind("java:/SecurityProxyFactory", (Object)proxyFactory);
        log.debug((Object)("SecurityProxyFactory=" + proxyFactory));
        PropertyEditorManager.registerEditor(class$java$security$Principal == null ? (class$java$security$Principal = JaasSecurityManagerService.class$("java.security.Principal")) : class$java$security$Principal, class$org$jboss$security$propertyeditor$PrincipalEditor == null ? (class$org$jboss$security$propertyeditor$PrincipalEditor = JaasSecurityManagerService.class$("org.jboss.security.propertyeditor.PrincipalEditor")) : class$org$jboss$security$propertyeditor$PrincipalEditor);
        PropertyEditorManager.registerEditor(class$org$jboss$security$SecurityDomain == null ? (class$org$jboss$security$SecurityDomain = JaasSecurityManagerService.class$("org.jboss.security.SecurityDomain")) : class$org$jboss$security$SecurityDomain, class$org$jboss$security$propertyeditor$SecurityDomainEditor == null ? (class$org$jboss$security$propertyeditor$SecurityDomainEditor = JaasSecurityManagerService.class$("org.jboss.security.propertyeditor.SecurityDomainEditor")) : class$org$jboss$security$propertyeditor$SecurityDomainEditor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        InitialContext ic = new InitialContext();
        try {
            ic.unbind(SECURITY_MGR_PATH);
        }
        catch (CommunicationException communicationException) {
        }
        finally {
            ic.close();
        }
    }

    public void registerSecurityDomain(String securityDomain, SecurityDomain instance) {
        log.debug((Object)("Added " + securityDomain + ", " + instance + " to map"));
        CachePolicy authCache = JaasSecurityManagerService.lookupCachePolicy(securityDomain);
        SecurityDomainContext sdc = new SecurityDomainContext(instance, authCache);
        securityDomainCtxMap.put(securityDomain, sdc);
        JaasSecurityManagerService.setSecurityDomainCache(instance, authCache);
    }

    private static CachePolicy getCachePolicy(String securityDomain) {
        if (securityDomain.startsWith(SECURITY_MGR_PATH)) {
            securityDomain = securityDomain.substring(SECURITY_MGR_PATH.length() + 1);
        }
        CachePolicy cache = null;
        try {
            SecurityDomainContext sdc = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            if (sdc != null) {
                cache = sdc.getAuthenticationCache();
            }
        }
        catch (NamingException e) {
            log.debug((Object)("getCachePolicy(" + securityDomain + ") failure"), (Throwable)e);
        }
        return cache;
    }

    private static CachePolicy lookupCachePolicy(String securityDomain) {
        CachePolicy authCache = null;
        String domainCachePath = cacheJndiName + '/' + securityDomain;
        try {
            InitialContext iniCtx = new InitialContext();
            authCache = (CachePolicy)iniCtx.lookup(domainCachePath);
        }
        catch (Exception e) {
            try {
                InitialContext iniCtx = new InitialContext();
                authCache = (CachePolicy)iniCtx.lookup(cacheJndiName);
            }
            catch (Exception e2) {
                log.warn((Object)("Failed to locate auth CachePolicy at: " + cacheJndiName + " for securityDomain=" + securityDomain));
            }
        }
        return authCache;
    }

    private static void setSecurityDomainCache(AuthenticationManager securityMgr, CachePolicy cachePolicy) {
        try {
            Class[] setCachePolicyTypes = new Class[]{class$org$jboss$util$CachePolicy == null ? (class$org$jboss$util$CachePolicy = JaasSecurityManagerService.class$("org.jboss.util.CachePolicy")) : class$org$jboss$util$CachePolicy};
            Method m = securityMgrClass.getMethod("setCachePolicy", setCachePolicyTypes);
            Object[] setCachePolicyArgs = new Object[]{cachePolicy};
            m.invoke((Object)securityMgr, setCachePolicyArgs);
            log.debug((Object)("setCachePolicy, c=" + setCachePolicyArgs[0]));
        }
        catch (Exception e2) {
            log.debug((Object)"setCachePolicy failed", (Throwable)e2);
        }
    }

    private static SecurityDomainContext lookupSecurityDomain(String securityDomain) throws NamingException {
        SecurityDomainContext securityDomainCtx = (SecurityDomainContext)securityDomainCtxMap.get(securityDomain);
        if (securityDomainCtx == null) {
            securityDomainCtx = JaasSecurityManagerService.newSecurityDomainCtx(securityDomain);
            securityDomainCtxMap.put(securityDomain, securityDomainCtx);
            log.debug((Object)("Added " + securityDomain + ", " + securityDomainCtx + " to map"));
        }
        return securityDomainCtx;
    }

    private static SecurityDomainContext newSecurityDomainCtx(String securityDomain) throws NamingException {
        SecurityDomainContext sdc = null;
        try {
            Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JaasSecurityManagerService.class$("java.lang.String")) : class$java$lang$String, class$javax$security$auth$callback$CallbackHandler == null ? (class$javax$security$auth$callback$CallbackHandler = JaasSecurityManagerService.class$("javax.security.auth.callback.CallbackHandler")) : class$javax$security$auth$callback$CallbackHandler};
            Constructor ctor = securityMgrClass.getConstructor(parameterTypes);
            CallbackHandler handler = (CallbackHandler)callbackHandlerClass.newInstance();
            Object[] args = new Object[]{securityDomain, handler};
            AuthenticationManager securityMgr = (AuthenticationManager)ctor.newInstance(args);
            log.debug((Object)("Created securityMgr=" + securityMgr));
            CachePolicy cachePolicy = JaasSecurityManagerService.lookupCachePolicy(securityDomain);
            sdc = new SecurityDomainContext(securityMgr, cachePolicy);
            JaasSecurityManagerService.setSecurityDomainCache(securityMgr, cachePolicy);
        }
        catch (Exception e2) {
            log.error((Object)"Failed to create sec mgr", (Throwable)e2);
            throw new NamingException("Failed to create sec mgr:" + e2.getMessage());
        }
        return sdc;
    }

    public String getDefaultUnauthenticatedPrincipal() {
        return defaultUnauthenticatedPrincipal;
    }

    public void setDefaultUnauthenticatedPrincipal(String principal) {
        defaultUnauthenticatedPrincipal = principal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        securityMgrClassName = "org.jboss.security.plugins.JaasSecurityManager";
        callbackHandlerClassName = "org.jboss.security.auth.callback.SecurityAssociationHandler";
        callbackHandlerClass = class$org$jboss$security$auth$callback$SecurityAssociationHandler == null ? (class$org$jboss$security$auth$callback$SecurityAssociationHandler = JaasSecurityManagerService.class$("org.jboss.security.auth.callback.SecurityAssociationHandler")) : class$org$jboss$security$auth$callback$SecurityAssociationHandler;
        cacheJndiName = DEFAULT_CACHE_POLICY_PATH;
        defaultCacheTimeout = 1800;
        defaultCacheResolution = 60;
        securityProxyFactoryClassName = "org.jboss.security.SubjectSecurityProxyFactory";
        securityProxyFactoryClass = class$org$jboss$security$SubjectSecurityProxyFactory == null ? (class$org$jboss$security$SubjectSecurityProxyFactory = JaasSecurityManagerService.class$("org.jboss.security.SubjectSecurityProxyFactory")) : class$org$jboss$security$SubjectSecurityProxyFactory;
        securityDomainCtxMap = new Hashtable();
        defaultUnauthenticatedPrincipal = "Unauthenticated Principal";
        SecurityAssociation.setServer();
        log = Logger.getLogger((Class)(class$org$jboss$security$plugins$JaasSecurityManagerService == null ? (class$org$jboss$security$plugins$JaasSecurityManagerService = JaasSecurityManagerService.class$("org.jboss.security.plugins.JaasSecurityManagerService")) : class$org$jboss$security$plugins$JaasSecurityManagerService));
    }

    public static class DefaultCacheObjectFactory
    implements InvocationHandler,
    ObjectFactory {
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class[] interfaces = new Class[]{class$javax$naming$Context == null ? (class$javax$naming$Context = JaasSecurityManagerService.class$("javax.naming.Context")) : class$javax$naming$Context};
            Context ctx = (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this);
            return ctx;
        }

        public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
            TimedCachePolicy cachePolicy = new TimedCachePolicy(defaultCacheTimeout, true, defaultCacheResolution);
            cachePolicy.create();
            cachePolicy.start();
            return cachePolicy;
        }
    }

    static class DomainEnumeration
    implements NamingEnumeration {
        Enumeration domains;
        Hashtable ctxMap;

        DomainEnumeration(Enumeration domains, Hashtable ctxMap) {
            this.domains = domains;
            this.ctxMap = ctxMap;
        }

        public void close() {
        }

        public boolean hasMoreElements() {
            return this.domains.hasMoreElements();
        }

        public boolean hasMore() {
            return this.domains.hasMoreElements();
        }

        public Object next() {
            String name = (String)this.domains.nextElement();
            Object value = this.ctxMap.get(name);
            String className = value.getClass().getName();
            NameClassPair pair = new NameClassPair(name, className);
            return pair;
        }

        public Object nextElement() {
            return this.domains.nextElement();
        }
    }

    public static class SecurityDomainObjectFactory
    implements InvocationHandler,
    ObjectFactory {
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            ClassLoader loader = SubjectActions.getContextClassLoader();
            Class[] interfaces = new Class[]{class$javax$naming$Context == null ? (class$javax$naming$Context = JaasSecurityManagerService.class$("javax.naming.Context")) : class$javax$naming$Context};
            Context ctx = (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this);
            return ctx;
        }

        public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                return "java:/jaas Context proxy";
            }
            if (methodName.equals("list")) {
                return new DomainEnumeration(securityDomainCtxMap.keys(), securityDomainCtxMap);
            }
            if (!methodName.equals("lookup")) {
                throw new OperationNotSupportedException("Only lookup is supported, op=" + method);
            }
            String securityDomain = null;
            Name name = null;
            name = args[0] instanceof String ? parser.parse((String)args[0]) : (Name)args[0];
            securityDomain = name.get(0);
            SecurityDomainContext securityDomainCtx = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            Object binding = securityDomainCtx.getSecurityManager();
            if (name.size() == 2) {
                String request = name.get(1);
                binding = securityDomainCtx.lookup(request);
            }
            return binding;
        }
    }
}

