/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.jboss.aop.AnnotationIntroductionDef;
import org.jboss.aop.Aspect;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Bind;
import org.jboss.aop.CFlowDef;
import org.jboss.aop.CFlowStackDef;
import org.jboss.aop.DynamicCFlowDef;
import org.jboss.aop.InterceptorDef;
import org.jboss.aop.PointcutDef;
import org.jboss.aop.Prepare;
import org.jboss.aop.TypeDef;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.AspectFactoryDelegator;
import org.jboss.aop.advice.DynamicCFlowDefinition;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopedInterceptorFactory;
import org.jboss.aop.annotation.AnnotationProxy;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.pointcut.CFlow;
import org.jboss.aop.pointcut.CFlowStack;
import org.jboss.aop.pointcut.DynamicCFlow;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.TypedefExpression;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.pointcut.ast.TypeExpressionParser;

public class AspectAnnotationLoader {
    static /* synthetic */ Class class$org$jboss$aop$advice$AspectFactory;
    static /* synthetic */ Class class$org$jboss$aop$advice$Interceptor;
    static /* synthetic */ Class class$org$jboss$aop$PointcutDef;
    static /* synthetic */ Class class$org$jboss$aop$Mixin;
    static /* synthetic */ Class class$org$jboss$aop$Introduction;
    static /* synthetic */ Class class$org$jboss$aop$TypeDef;
    static /* synthetic */ Class class$org$jboss$aop$CFlowStackDef;
    static /* synthetic */ Class class$org$jboss$aop$Prepare;
    static /* synthetic */ Class class$org$jboss$aop$AnnotationIntroductionDef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployInputStreamIterator(Iterator it) throws Exception {
        while (it.hasNext()) {
            AnnotationsAttribute visible;
            InputStream stream = (InputStream)it.next();
            DataInputStream dstream = new DataInputStream(stream);
            ClassFile cf = null;
            try {
                cf = new ClassFile(dstream);
            }
            finally {
                dstream.close();
                stream.close();
            }
            if (AspectManager.verbose) {
                System.out.println("[debug] Looking for aspects in: " + cf.getName());
            }
            if ((visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations")) == null) continue;
            AspectDefinition def = this.deployAspect(visible, cf);
            if (def == null) {
                def = this.deployInterceptor(visible, cf);
            }
            if (def == null) {
                this.deployDynamicCFlow(visible, cf);
            }
            if (def == null) continue;
            this.deployPointcuts(cf);
            this.deployMixins(cf);
            this.deployIntroductions(cf);
            this.deployTypedefs(cf);
            this.deployCFlowStackDefs(cf);
            this.deployPrepares(cf);
            this.deployAnnotationIntroductions(cf);
        }
    }

    private AspectDefinition deployAspect(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Aspect.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Found @Aspect in: " + cf.getName());
            }
            Aspect aspect = (Aspect)AnnotationProxy.createProxy(info, Aspect.class);
            Scope scope = aspect.scope();
            AspectDefinition def = new AspectDefinition(cf.getName(), scope, new GenericAspectFactory(cf.getName(), null));
            AspectManager.instance().addAspectDefinition(def);
            this.deployAspectMethodBindings(cf, def);
            return def;
        }
        return null;
    }

    private AspectDefinition deployInterceptor(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(InterceptorDef.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Found @InterceptorDef in: " + cf.getName());
            }
            Aspect aspect = (Aspect)AnnotationProxy.createProxy(info, Aspect.class);
            Scope scope = aspect.scope();
            String[] interfaces = cf.getInterfaces();
            boolean isFactory = false;
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].equals((class$org$jboss$aop$advice$AspectFactory == null ? AspectAnnotationLoader.class$("org.jboss.aop.advice.AspectFactory") : class$org$jboss$aop$advice$AspectFactory).getName())) {
                    isFactory = true;
                    break;
                }
                if (interfaces[i].equals((class$org$jboss$aop$advice$Interceptor == null ? AspectAnnotationLoader.class$("org.jboss.aop.advice.Interceptor") : class$org$jboss$aop$advice$Interceptor).getName())) break;
            }
            AspectFactory aspectFactory = isFactory ? new AspectFactoryDelegator(cf.getName(), null) : new GenericAspectFactory(cf.getName(), null);
            AspectDefinition def = new AspectDefinition(cf.getName(), scope, aspectFactory);
            AspectManager.instance().addAspectDefinition(def);
            ScopedInterceptorFactory factory = new ScopedInterceptorFactory(def);
            AspectManager.instance().addInterceptorFactory(factory.getName(), factory);
            this.deployInterceptorBindings(visible, cf, factory);
            return def;
        }
        return null;
    }

    private void deployDynamicCFlow(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(DynamicCFlowDef.class.getName());
        if (info != null) {
            if (AspectManager.verbose) {
                System.out.println("[debug] Found @InterceptorDef in: " + cf.getName());
            }
            DynamicCFlowDef dynCFlow = (DynamicCFlowDef)AnnotationProxy.createProxy(info, DynamicCFlowDef.class);
            String name = cf.getName();
            String clazz = cf.getName();
            String[] interfaces = cf.getInterfaces();
            boolean foundDCFlow = false;
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].equals((class$org$jboss$aop$pointcut$DynamicCFlow == null ? AspectAnnotationLoader.class$("org.jboss.aop.pointcut.DynamicCFlow") : class$org$jboss$aop$pointcut$DynamicCFlow).getName())) continue;
                foundDCFlow = true;
                break;
            }
            if (!foundDCFlow) {
                throw new RuntimeException("@DynamicCFlow annotated class: " + clazz + " must implement " + DynamicCFlow.class.getName());
            }
            AspectManager.instance().addDynamicCFlow(name, new DynamicCFlowDefinition(null, clazz, name));
        }
    }

    private void deployAspectMethodBindings(ClassFile cf, AspectDefinition def) throws Exception {
        Iterator methods = cf.getMethods().iterator();
        while (methods.hasNext()) {
            Annotation binfo;
            MethodInfo minfo = (MethodInfo)methods.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Bind == null ? AspectAnnotationLoader.class$("org.jboss.aop.Bind") : class$org$jboss$aop$Bind).getName())) == null) continue;
            Bind binding = (Bind)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$Bind == null ? AspectAnnotationLoader.class$("org.jboss.aop.Bind") : class$org$jboss$aop$Bind);
            String pointcutString = binding.pointcut();
            String cflow = binding.cflow();
            if (cflow == null || cflow.trim().equals("")) {
                cflow = null;
            }
            ASTCFlowExpression cflowExpression = null;
            if (cflow != null) {
                cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
            }
            AdviceFactory factory = new AdviceFactory(def, minfo.getName());
            AspectManager.instance().addInterceptorFactory(factory.getName(), factory);
            InterceptorFactory[] fact = new InterceptorFactory[]{factory};
            String name = cf.getName() + "." + minfo.getName() + " " + minfo.hashCode();
            PointcutExpression pointcut = new PointcutExpression(name, pointcutString);
            AspectManager.instance().addPointcut(pointcut);
            AdviceBinding abinding = new AdviceBinding(name, pointcut, cflowExpression, cflow, fact);
            AspectManager.instance().addBinding(abinding);
        }
    }

    private void deployInterceptorBindings(AnnotationsAttribute visible, ClassFile cf, InterceptorFactory factory) throws Exception {
        Annotation binfo = visible.getAnnotation(Bind.class.getName());
        Bind bind = (Bind)AnnotationProxy.createProxy(binfo, Bind.class);
        String pointcutString = bind.pointcut();
        String cflow = bind.cflow();
        if (cflow == null || cflow.trim().equals("")) {
            cflow = null;
        }
        ASTCFlowExpression cflowExpression = null;
        if (cflow != null) {
            cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
        }
        String name = cf.getName();
        InterceptorFactory[] inters = new InterceptorFactory[]{factory};
        PointcutExpression p = null;
        p = new PointcutExpression(name, pointcutString);
        AspectManager.instance().addPointcut(p);
        AdviceBinding binding = new AdviceBinding(name, p, cflowExpression, cflow, inters);
        AspectManager.instance().addBinding(binding);
    }

    private void deployPointcuts(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$PointcutDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.PointcutDef") : class$org$jboss$aop$PointcutDef).getName())) == null) continue;
            PointcutDef pdef = (PointcutDef)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$PointcutDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.PointcutDef") : class$org$jboss$aop$PointcutDef);
            PointcutExpression pointcut = new PointcutExpression(cf.getName() + "." + finfo.getName(), pdef.value());
            AspectManager.instance().addPointcut(pointcut);
        }
    }

    private void deployMixins(ClassFile cf) throws Exception {
        Iterator methods = cf.getMethods().iterator();
        while (methods.hasNext()) {
            Annotation binfo;
            MethodInfo minfo = (MethodInfo)methods.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Mixin == null ? AspectAnnotationLoader.class$("org.jboss.aop.Mixin") : class$org$jboss$aop$Mixin).getName())) == null) continue;
            MemberValue mv = binfo.getMemberValue("target");
            String target = mv != null ? ((ClassMemberValue)mv).getValue() : "java.lang.Class";
            mv = binfo.getMemberValue("typeExpression");
            String typeExpression = mv != null ? ((StringMemberValue)mv).getValue() : "";
            mv = binfo.getMemberValue("interfaces");
            MemberValue[] values = ((ArrayMemberValue)mv).getValue();
            String[] interfaces = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                interfaces[i] = ((ClassMemberValue)values[i]).getValue();
            }
            mv = binfo.getMemberValue("isTransient");
            boolean isTransient = mv != null ? ((BooleanMemberValue)mv).getValue() : true;
            String name = cf.getName() + "." + minfo.getName();
            InterfaceIntroduction intro = this.createIntroduction(name, target, typeExpression, null);
            String construction = name + "(this)";
            String classname = this.getReturnType(minfo);
            intro.getMixins().add(new InterfaceIntroduction.Mixin(classname, interfaces, construction, isTransient));
            AspectManager.instance().addInterfaceIntroduction(intro);
        }
    }

    private void deployIntroductions(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Introduction == null ? AspectAnnotationLoader.class$("org.jboss.aop.Introduction") : class$org$jboss$aop$Introduction).getName())) == null) continue;
            MemberValue mv = binfo.getMemberValue("target");
            String target = mv != null ? ((ClassMemberValue)mv).getValue() : "java.lang.Class";
            mv = binfo.getMemberValue("typeExpression");
            String typeExpression = mv != null ? ((StringMemberValue)mv).getValue() : "";
            mv = binfo.getMemberValue("interfaces");
            MemberValue[] values = ((ArrayMemberValue)mv).getValue();
            String[] interfaces = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                interfaces[i] = ((ClassMemberValue)values[i]).getValue();
            }
            String name = cf.getName() + "." + finfo.getName();
            InterfaceIntroduction interfaceIntro = this.createIntroduction(name, target, typeExpression, interfaces);
            AspectManager.instance().addInterfaceIntroduction(interfaceIntro);
        }
    }

    private void deployTypedefs(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$TypeDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.TypeDef") : class$org$jboss$aop$TypeDef).getName())) == null) continue;
            TypeDef typeDefinition = (TypeDef)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$TypeDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.TypeDef") : class$org$jboss$aop$TypeDef);
            String name = cf.getName() + "." + finfo.getName();
            String expr = typeDefinition.value();
            TypedefExpression typedef = new TypedefExpression(name, expr);
            AspectManager.instance().addTypedef(typedef);
        }
    }

    private void deployCFlowStackDefs(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$CFlowStackDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.CFlowStackDef") : class$org$jboss$aop$CFlowStackDef).getName())) == null) continue;
            CFlowStackDef stackDef = (CFlowStackDef)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$CFlowStackDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.CFlowStackDef") : class$org$jboss$aop$CFlowStackDef);
            String name = cf.getName() + "." + finfo.getName();
            CFlowDef[] cflows = stackDef.cflows();
            CFlowStack stack = new CFlowStack(name);
            for (int i = 0; i < cflows.length; ++i) {
                CFlowDef cflow = cflows[i];
                boolean not = !cflow.called();
                stack.addCFlow(new CFlow(cflow.expr(), not));
            }
            AspectManager.instance().addCFlowStack(stack);
        }
    }

    private void deployPrepares(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$Prepare == null ? AspectAnnotationLoader.class$("org.jboss.aop.Prepare") : class$org$jboss$aop$Prepare).getName())) == null) continue;
            Prepare prepare = (Prepare)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$Prepare == null ? AspectAnnotationLoader.class$("org.jboss.aop.Prepare") : class$org$jboss$aop$Prepare);
            String name = cf.getName() + "." + finfo.getName();
            String expr = prepare.value();
            PointcutExpression p = new PointcutExpression(name, expr);
            AspectManager.instance().addPointcut(p);
        }
    }

    private void deployAnnotationIntroductions(ClassFile cf) throws Exception {
        Iterator fields = cf.getFields().iterator();
        while (fields.hasNext()) {
            Annotation binfo;
            FieldInfo finfo = (FieldInfo)fields.next();
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation((class$org$jboss$aop$AnnotationIntroductionDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.AnnotationIntroductionDef") : class$org$jboss$aop$AnnotationIntroductionDef).getName())) == null) continue;
            AnnotationIntroductionDef intro = (AnnotationIntroductionDef)AnnotationProxy.createProxy(binfo, class$org$jboss$aop$AnnotationIntroductionDef == null ? AspectAnnotationLoader.class$("org.jboss.aop.AnnotationIntroductionDef") : class$org$jboss$aop$AnnotationIntroductionDef);
            String expr = intro.expr();
            boolean invisible = intro.invisible();
            String annotation = intro.annotation();
            annotation = annotation.replace('\'', '\"');
            AnnotationIntroduction annIntro = AnnotationIntroduction.createComplexAnnotationIntroduction(expr, annotation, invisible);
            AspectManager.instance().addAnnotationIntroduction(annIntro);
        }
    }

    private InterfaceIntroduction createIntroduction(String name, String target, String typeExpression, String[] interfaces) throws Exception {
        if (typeExpression != null && typeExpression.trim().equals("")) {
            typeExpression = null;
        }
        if (typeExpression != null && target != null && target.equals("java.lang.Class")) {
            target = null;
        }
        if (target == null && typeExpression == null) {
            throw new RuntimeException("No target nor a typeExpression attribute is defined for this @Mixin");
        }
        if (target == null && typeExpression == null) {
            throw new RuntimeException("You cannot define both a target and typeExpression attribute in the same @Mixin");
        }
        InterfaceIntroduction intro = null;
        if (target != null) {
            intro = new InterfaceIntroduction(name, target, interfaces);
        } else {
            ASTStart start = new TypeExpressionParser(new StringReader(typeExpression)).Start();
            intro = new InterfaceIntroduction(name, start, interfaces);
        }
        return intro;
    }

    private String[] makeClassnameArray(Class[] classes) {
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = classes[i].getName();
        }
        return names;
    }

    private String getReturnType(MethodInfo minfo) {
        String descriptor = minfo.getDescriptor();
        int paramsEnd = descriptor.indexOf(";)");
        String classname = descriptor.substring(paramsEnd + 3, descriptor.length() - 1);
        classname = classname.replace('/', '.');
        return classname;
    }
}

