/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.AspectFactoryDelegator;
import org.jboss.aop.advice.DynamicCFlowDefinition;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopeUtil;
import org.jboss.aop.advice.ScopedInterceptorFactory;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.pointcut.CFlow;
import org.jboss.aop.pointcut.CFlowStack;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.TypedefExpression;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.pointcut.ast.TypeExpressionParser;
import org.jboss.aop.util.XmlHelper;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AspectXmlLoader {
    static ThreadLocal counter = new ThreadLocal();
    static ThreadLocal defaultBaseName = new ThreadLocal();

    private static String getName(Element element, String errorHeader) {
        String name = element.getAttribute("name");
        if (name != null && !name.equals("")) {
            return name;
        }
        return AspectXmlLoader.getName(errorHeader);
    }

    private static String getName(String errorHeader) {
        Long count = (Long)counter.get();
        if (count == null) {
            throw new RuntimeException(errorHeader + ": must have a name");
        }
        counter.set(new Long(count + 1L));
        String baseName = (String)defaultBaseName.get();
        baseName = baseName + count.toString();
        return baseName;
    }

    public static void undeployInterceptor(Element element) throws Exception {
        String factory;
        String clazz;
        String name = element.getAttribute("name");
        if (name != null && name.trim().equals("")) {
            name = null;
        }
        if ((clazz = element.getAttribute("class")) != null && clazz.trim().equals("")) {
            clazz = null;
        }
        if ((factory = element.getAttribute("factory")) != null && factory.trim().equals("")) {
            factory = null;
        }
        if (name == null) {
            name = clazz == null ? factory : clazz;
        }
        AspectManager.instance().removeAspectDefinition(name);
        String factoryName = name + ".invoke";
        AspectManager.instance().removeInterceptorFactory(factoryName);
    }

    public static InterceptorFactory deployInterceptor(Element element) throws Exception {
        String s;
        String factory1;
        String clazz;
        String name = element.getAttribute("name");
        if (name != null && name.trim().equals("")) {
            name = null;
        }
        if ((clazz = element.getAttribute("class")) != null && clazz.trim().equals("")) {
            clazz = null;
        }
        if ((factory1 = element.getAttribute("factory")) != null && factory1.trim().equals("")) {
            factory1 = null;
        }
        if (clazz == null && factory1 == null) {
            throw new RuntimeException("Interceptor " + name + " must have a class or factory associated with it.");
        }
        if (clazz != null && factory1 != null) {
            throw new RuntimeException("Interceptor " + name + " cannot have both the class and factory attribute set.");
        }
        if (name == null) {
            String string = name = clazz == null ? factory1 : clazz;
        }
        if ((s = element.getAttribute("scope")) != null && s.trim().equals("")) {
            s = null;
        }
        Scope scope = null;
        if (s != null && (scope = ScopeUtil.parse(s)) == null) {
            throw new RuntimeException("Illegal scope attribute value: " + s);
        }
        AspectDefinition def = (AspectDefinition)AspectManager.instance().getAspectDefinitions().get(name);
        if (def != null) {
            if (scope == null) {
                scope = Scope.PER_VM;
            }
            if (scope != def.getScope()) {
                throw new RuntimeException("multiple definitions of <interceptor> " + name + " with different scopes is illegal");
            }
        } else {
            AspectFactory aspectFactory = clazz != null ? new GenericAspectFactory(clazz, element) : new AspectFactoryDelegator(factory1, element);
            def = new AspectDefinition(name, scope, aspectFactory);
            AspectManager.instance().addAspectDefinition(def);
        }
        ScopedInterceptorFactory factory = new ScopedInterceptorFactory(def);
        AspectManager.instance().addInterceptorFactory(factory.getName(), factory);
        return factory;
    }

    public static void undeployAdvice(Element element) throws Exception {
        String name = element.getAttribute("name");
        String aspect = element.getAttribute("aspect");
        String factory = aspect + "." + name;
        AspectManager.instance().removeInterceptorFactory(factory);
    }

    public static InterceptorFactory deployAdvice(Element element) throws Exception {
        String name = element.getAttribute("name");
        String aspect = element.getAttribute("aspect");
        AspectDefinition def = AspectManager.instance().getAspectDefinition(aspect);
        if (def == null) {
            throw new RuntimeException("advice " + name + " cannot find aspect " + aspect);
        }
        AdviceFactory factory = new AdviceFactory(def, name);
        AspectManager.instance().addInterceptorFactory(factory.getName(), factory);
        return factory;
    }

    public static void deployBinding(Element element) throws Exception {
        String name = AspectXmlLoader.getName(element, "binding");
        String pointcut = element.getAttribute("pointcut");
        if (pointcut == null || pointcut.trim().equals("")) {
            throw new RuntimeException("Binding must have a pointcut element associated with it.");
        }
        String cflow = element.getAttribute("cflow");
        if (cflow != null && cflow.trim().equals("")) {
            cflow = null;
        }
        ASTCFlowExpression cflowExpression = null;
        if (cflow != null) {
            try {
                cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
            }
            catch (ParseException e) {
                throw new RuntimeException(cflow, e);
            }
        }
        ArrayList interceptors = AspectXmlLoader.loadInterceptors(element);
        InterceptorFactory[] inters = interceptors.toArray(new InterceptorFactory[interceptors.size()]);
        PointcutExpression p = null;
        try {
            p = new PointcutExpression(AspectXmlLoader.getName("binding pointcut "), pointcut);
        }
        catch (ParseException ex) {
            throw new RuntimeException("<bind> pointcut expression failed: " + pointcut, ex);
        }
        AspectManager.instance().addPointcut(p);
        AdviceBinding binding = new AdviceBinding(name, p, cflowExpression, cflow, inters);
        AspectManager.instance().addBinding(binding);
    }

    public static void undeployBinding(Element element) throws Exception {
        String binding = AspectXmlLoader.getName(element, "binding");
        AspectManager.instance().removeBinding(binding);
        AspectXmlLoader.unloadInterceptors(element);
        String pointcut = AspectXmlLoader.getName("pointcut");
        AspectManager.instance().removePointcut(pointcut);
    }

    private static ArrayList loadInterceptors(Element element) throws Exception {
        ArrayList<InterceptorFactory> interceptors = new ArrayList<InterceptorFactory>();
        NodeList children2 = element.getChildNodes();
        for (int j = 0; j < children2.getLength(); ++j) {
            InterceptorFactory factory;
            if (children2.item(j).getNodeType() != 1) continue;
            Element interceptorElement = (Element)children2.item(j);
            String tag2 = interceptorElement.getTagName();
            if (tag2.equals("interceptor")) {
                factory = AspectXmlLoader.deployInterceptor(interceptorElement);
                interceptors.add(factory);
                continue;
            }
            if (tag2.equals("interceptor-ref")) {
                String iname = interceptorElement.getAttribute("name");
                if (iname == null) {
                    throw new RuntimeException("interceptor-ref has null name attribute");
                }
                InterceptorFactory factory2 = AspectManager.instance().getInterceptorFactory(iname);
                if (factory2 == null) {
                    throw new RuntimeException("unable to resolve interceptor-ref: " + iname);
                }
                interceptors.add(factory2);
                continue;
            }
            if (tag2.equals("stack-ref")) {
                String name = interceptorElement.getAttribute("name");
                AdviceStack stack = AspectManager.instance().getAdviceStack(name);
                if (stack == null) {
                    throw new Exception("there is no <stack> defined for name: " + name);
                }
                interceptors.addAll(stack.getInterceptorFactories());
                continue;
            }
            if (!tag2.equals("advice")) continue;
            factory = AspectXmlLoader.deployAdvice(interceptorElement);
            interceptors.add(factory);
        }
        return interceptors;
    }

    private static void unloadInterceptors(Element element) throws Exception {
        NodeList children2 = element.getChildNodes();
        for (int j = 0; j < children2.getLength(); ++j) {
            if (children2.item(j).getNodeType() != 1) continue;
            Element interceptorElement = (Element)children2.item(j);
            String tag2 = interceptorElement.getTagName();
            if (tag2.equals("interceptor")) {
                AspectXmlLoader.undeployInterceptor(interceptorElement);
            }
            if (!tag2.equals("advice")) continue;
            AspectXmlLoader.undeployAdvice(interceptorElement);
        }
    }

    public static void undeployAspect(Element pointcut) throws Exception {
        String name;
        String clazz = pointcut.getAttribute("class");
        if (clazz == null || clazz.trim().equals("")) {
            clazz = null;
        }
        if ((name = pointcut.getAttribute("name")) == null || name.trim().equals("")) {
            name = clazz;
        }
        if (name == null) {
            return;
        }
        AspectManager.instance().removeAspectDefinition(name);
    }

    public static AspectDefinition deployAspect(Element element, String type) throws Exception {
        String s;
        String factory;
        String clazz;
        String name = element.getAttribute("name");
        if (name != null && name.trim().equals("")) {
            name = null;
        }
        if ((clazz = element.getAttribute("class")) != null && clazz.trim().equals("")) {
            clazz = null;
        }
        if ((factory = element.getAttribute("factory")) != null && factory.trim().equals("")) {
            factory = null;
        }
        if (clazz == null && factory == null) {
            throw new RuntimeException(type + " " + name + " must have a class or factory associated with it.");
        }
        if (clazz != null && factory != null) {
            throw new RuntimeException(type + " " + name + " cannot have both the class and factory attribute set.");
        }
        if (name == null) {
            String string = name = clazz == null ? factory : clazz;
        }
        if ((s = element.getAttribute("scope")) != null && s.trim().equals("")) {
            s = null;
        }
        Scope scope = null;
        if (s != null && (scope = ScopeUtil.parse(s)) == null) {
            throw new RuntimeException("Illegal scope attribute value: " + s);
        }
        AspectFactory aspectFactory = clazz != null ? new GenericAspectFactory(clazz, element) : new AspectFactoryDelegator(factory, element);
        AspectDefinition def = new AspectDefinition(name, scope, aspectFactory);
        AspectManager.instance().addAspectDefinition(def);
        return def;
    }

    public static void undeployCFlowStack(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        AspectManager.instance().removeCFlowStack(name);
    }

    public static void deployCFlowStack(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        if (name != null && name.trim().equals("")) {
            name = null;
        }
        if (name == null) {
            throw new RuntimeException("name required for a cflow-stack");
        }
        CFlowStack stack = new CFlowStack(name);
        NodeList children2 = pointcut.getChildNodes();
        for (int j = 0; j < children2.getLength(); ++j) {
            if (children2.item(j).getNodeType() != 1) continue;
            Element cflowElement = (Element)children2.item(j);
            String tag2 = cflowElement.getTagName();
            String expr = cflowElement.getAttribute("expr");
            if (expr != null && expr.trim().equals("")) {
                throw new RuntimeException(tag2 + " requires an expr attribute to be defined");
            }
            if (tag2.equals("called")) {
                stack.addCFlow(new CFlow(expr, false));
            }
            if (!tag2.equals("not-called")) continue;
            stack.addCFlow(new CFlow(expr, true));
        }
        AspectManager.instance().addCFlowStack(stack);
    }

    public static void undeployInterceptorStack(Element element) throws Exception {
        String name = element.getAttribute("name");
        AspectXmlLoader.unloadInterceptors(element);
        AspectManager.instance().removeInterceptorStack(name);
    }

    public static void deployInterceptorStack(Element element) throws Exception {
        ArrayList interceptors = AspectXmlLoader.loadInterceptors(element);
        String name = element.getAttribute("name");
        AdviceStack stack = new AdviceStack(name, interceptors);
        AspectManager.instance().addAdviceStack(stack);
    }

    private static ClassMetaDataBinding loadMetaData(Element element) throws Exception {
        String classExpr = element.getAttribute("class");
        String tag = element.getAttribute("tag");
        String name = AspectXmlLoader.getName(element, "metadata: " + tag + " " + classExpr);
        ClassMetaDataLoader loader = AspectManager.instance().findClassMetaDataLoader(tag);
        return loader.importMetaData(element, name, tag, classExpr);
    }

    public static void undeployMetaDataLoader(Element element) throws Exception {
        String tag = element.getAttribute("tag");
        AspectManager.instance().removeClassMetaDataLoader(tag);
    }

    public static void deployMetaDataLoader(Element element) throws Exception {
        String tag = element.getAttribute("tag");
        String classname = element.getAttribute("class");
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname);
        ClassMetaDataLoader loader = (ClassMetaDataLoader)clazz.newInstance();
        if (loader instanceof XmlLoadable) {
            ((XmlLoadable)loader).importXml(element);
        }
        AspectManager.instance().addClassMetaDataLoader(tag, loader);
    }

    public static void deployClassMetaData(Element element) throws Exception {
        ClassMetaDataBinding data = AspectXmlLoader.loadMetaData(element);
        AspectManager.instance().addClassMetaData(data);
    }

    public static void undeployClassMetaData(Element element) throws Exception {
        String classExpr = element.getAttribute("class");
        String tag = element.getAttribute("tag");
        String name = AspectXmlLoader.getName(element, "metadata: " + tag + " " + classExpr);
        AspectManager.instance().removeClassMetaData(name);
    }

    public static void undeployPointcut(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        AspectManager.instance().removePointcut(name);
    }

    public static void undeployPluggablePointcut(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        AspectManager.instance().removePointcut(name);
    }

    public static void deployPluggablePointcut(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("pluggable pointcut declaration must have a name associated with it");
        }
        String clazz = pointcut.getAttribute("class");
        if (clazz != null && clazz.trim().equals("")) {
            throw new RuntimeException("pluggable pointcut declaration must have an expr associated with it");
        }
        Pointcut p = null;
        Class<?> pClass = null;
        try {
            pClass = Thread.currentThread().getContextClassLoader().loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("pluggable pointcut class not found: " + clazz);
        }
        p = (Pointcut)pClass.newInstance();
        if (p instanceof XmlLoadable) {
            ((XmlLoadable)p).importXml(pointcut);
        }
        AspectManager.instance().addPointcut(p);
    }

    public static void undeployDynamicCFlow(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        AspectManager.instance().removeDynamicCFlow(name);
    }

    public static void deployDynamicCFlow(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("dynamic cflow declaration must have a name associated with it");
        }
        String clazz = pointcut.getAttribute("class");
        if (clazz != null && clazz.trim().equals("")) {
            throw new RuntimeException("dynamic cflow declaration must have an expr associated with it");
        }
        AspectManager.instance().addDynamicCFlow(name, new DynamicCFlowDefinition(pointcut, clazz, name));
    }

    public static void deployPointcut(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("pointcut declaration must have a name associated with it");
        }
        String expr = pointcut.getAttribute("expr");
        if (expr == null || expr.trim().equals("")) {
            throw new RuntimeException("pointcut declaration must have an expr associated with it");
        }
        PointcutExpression p = null;
        try {
            p = new PointcutExpression(name, expr);
        }
        catch (ParseException ex) {
            throw new RuntimeException("<pointcut name='" + name + "' expr='" + expr + "'/> failed", ex);
        }
        AspectManager.instance().addPointcut(p);
    }

    public static void undeployPrepare(Element pointcut) throws Exception {
        String name = AspectXmlLoader.getName(pointcut, "prepare");
        AspectManager.instance().removePointcut(name);
    }

    public static void deployPrepare(Element pointcut) throws Exception {
        String name = AspectXmlLoader.getName(pointcut, "prepare");
        String expr = pointcut.getAttribute("expr");
        if (expr != null && expr.trim().equals("")) {
            throw new RuntimeException("pointcut declaration must have an expr associated with it");
        }
        PointcutExpression p = null;
        try {
            p = new PointcutExpression(name, expr);
        }
        catch (ParseException ex) {
            throw new RuntimeException("<prepare> failed: " + expr, ex);
        }
        AspectManager.instance().addPointcut(p);
    }

    public static void deployAnnotationIntroduction(Element pointcut) throws Exception {
        AspectManager.instance().addAnnotationIntroduction(AspectXmlLoader.loadAnnotationIntroduction(pointcut));
    }

    public static void undeployAnnotationIntroduction(Element pointcut) throws Exception {
        AspectManager.instance().removeAnnotationIntroduction(AspectXmlLoader.loadAnnotationIntroduction(pointcut));
    }

    public static AnnotationIntroduction loadAnnotationIntroduction(Element pointcut) throws Exception {
        String expr = pointcut.getAttribute("expr");
        if (expr != null && expr.trim().equals("")) {
            throw new RuntimeException("annotation introduction must have an expr attribute");
        }
        String invisible = pointcut.getAttribute("invisible");
        if (invisible != null && expr.trim().equals("")) {
            throw new RuntimeException("annotation introduction must have an invisible attribute");
        }
        boolean isInvisble = new Boolean(invisible);
        String annotation = XmlHelper.getElementContent(pointcut);
        return AnnotationIntroduction.createComplexAnnotationIntroduction(expr, annotation, isInvisble);
    }

    public static void undeployIntroductionPointcut(Element pointcut) throws Exception {
        String name = AspectXmlLoader.getName(pointcut, "introduction-pointcut");
        AspectManager.instance().removeInterfaceIntroduction(name);
    }

    public static void deployIntroductionPointcut(Element pointcut) throws Exception {
        String ast;
        String name = AspectXmlLoader.getName(pointcut, "introduction");
        String classExpr = pointcut.getAttribute("class");
        if (classExpr != null && classExpr.trim().equals("")) {
            classExpr = null;
        }
        if ((ast = pointcut.getAttribute("expr")) != null && ast.trim().equals("")) {
            ast = null;
        }
        if (classExpr == null && ast == null) {
            throw new RuntimeException("A class nor a expr attribute is defined for this <introduction>");
        }
        if (classExpr != null && ast != null) {
            throw new RuntimeException("You cannot define both a class and expr attribute in the same <introduction>");
        }
        String intfs = XmlHelper.getOptionalChildContent(pointcut, "interfaces");
        String[] ifaces = null;
        if (intfs != null) {
            StringTokenizer tokenizer = new StringTokenizer(intfs, ",");
            ArrayList<String> interfaces = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String intf = tokenizer.nextToken().trim();
                if (intf.equals("")) continue;
                interfaces.add(intf);
            }
            ifaces = interfaces.toArray(new String[interfaces.size()]);
        }
        InterfaceIntroduction pcut = null;
        if (classExpr != null) {
            pcut = new InterfaceIntroduction(name, classExpr, ifaces);
        } else {
            ASTStart start = new TypeExpressionParser(new StringReader(ast)).Start();
            pcut = new InterfaceIntroduction(name, start, ifaces);
        }
        Iterator it = XmlHelper.getChildrenByTagName(pointcut, "mixin");
        while (it.hasNext()) {
            Element mixin = (Element)it.next();
            if (mixin == null) continue;
            String construction = XmlHelper.getOptionalChildContent(mixin, "construction");
            String classname = XmlHelper.getUniqueChildContent(mixin, "class");
            String isTransientString = mixin.getAttribute("transient");
            boolean isTransient = true;
            isTransient = isTransientString == null || isTransientString.trim().equals("") ? true : new Boolean(isTransientString);
            intfs = XmlHelper.getUniqueChildContent(mixin, "interfaces");
            StringTokenizer tokenizer = new StringTokenizer(intfs, ",");
            ArrayList<String> interfaces = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String intf = tokenizer.nextToken().trim();
                if (intf.equals("")) continue;
                interfaces.add(intf);
            }
            ifaces = interfaces.toArray(new String[interfaces.size()]);
            pcut.getMixins().add(new InterfaceIntroduction.Mixin(classname, ifaces, construction, isTransient));
        }
        AspectManager.instance().addInterfaceIntroduction(pcut);
    }

    public static void deployTypedef(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("typedef declaration must have a name associated with it");
        }
        String expr = pointcut.getAttribute("expr");
        if (expr == null || expr.trim().equals("")) {
            throw new RuntimeException("typedef declaration must have an expr associated with it");
        }
        try {
            TypedefExpression typedef = new TypedefExpression(name, expr);
            AspectManager.instance().addTypedef(typedef);
        }
        catch (ParseException ex) {
            throw new RuntimeException("<typedef name='" + name + "' expr='" + expr + "'/> failed", ex);
        }
    }

    public static void undeployTypedef(Element pointcut) throws Exception {
        String name = pointcut.getAttribute("name");
        AspectManager.instance().removeTypedef(name);
    }

    private static void setupDefaultName(URL url) throws Exception {
        if (url == null) {
            return;
        }
        counter.set(new Long(0L));
        defaultBaseName.set(url.toString());
    }

    public static void deployXML(Document doc, URL url) throws Exception {
        AspectXmlLoader.setupDefaultName(url);
        NodeList children = doc.getDocumentElement().getChildNodes();
        try {
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                Element element = (Element)children.item(i);
                String tag = element.getTagName();
                if (AspectManager.verbose) {
                    System.out.println("[deploy] <" + tag + "> " + url.toString());
                }
                if (tag.equals("interceptor")) {
                    AspectXmlLoader.deployInterceptor(element);
                    continue;
                }
                if (tag.equals("introduction")) {
                    AspectXmlLoader.deployIntroductionPointcut(element);
                    continue;
                }
                if (tag.equals("metadata-loader")) {
                    AspectXmlLoader.deployMetaDataLoader(element);
                    continue;
                }
                if (tag.equals("metadata")) {
                    AspectXmlLoader.deployClassMetaData(element);
                    continue;
                }
                if (tag.equals("stack")) {
                    AspectXmlLoader.deployInterceptorStack(element);
                    continue;
                }
                if (tag.equals("aspect")) {
                    AspectXmlLoader.deployAspect(element, "Aspect");
                    continue;
                }
                if (tag.equals("pointcut")) {
                    AspectXmlLoader.deployPointcut(element);
                    continue;
                }
                if (tag.equals("pluggable-pointcut")) {
                    AspectXmlLoader.deployPluggablePointcut(element);
                    continue;
                }
                if (tag.equals("bind")) {
                    AspectXmlLoader.deployBinding(element);
                    continue;
                }
                if (tag.equals("prepare")) {
                    AspectXmlLoader.deployPrepare(element);
                    continue;
                }
                if (tag.equals("cflow-stack")) {
                    AspectXmlLoader.deployCFlowStack(element);
                    continue;
                }
                if (tag.equals("dynamic-cflow")) {
                    AspectXmlLoader.deployDynamicCFlow(element);
                    continue;
                }
                if (tag.equals("annotation-introduction")) {
                    AspectXmlLoader.deployAnnotationIntroduction(element);
                    continue;
                }
                if (tag.equals("typedef")) {
                    AspectXmlLoader.deployTypedef(element);
                    continue;
                }
                throw new IllegalArgumentException("Unknown AOP tag: " + tag);
            }
        }
        catch (Exception e) {
            System.err.println("[error] " + e.getMessage() + " " + url);
            if (AspectManager.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    public static void undeployXML(Document doc, URL url) throws Exception {
        AspectXmlLoader.setupDefaultName(url);
        NodeList children = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element element = (Element)children.item(i);
            String tag = element.getTagName();
            if (AspectManager.verbose) {
                System.out.println("[undeploy] <" + tag + "> " + url.toString());
            }
            if (tag.equals("interceptor")) {
                AspectXmlLoader.undeployInterceptor(element);
                continue;
            }
            if (tag.equals("introduction")) {
                AspectXmlLoader.undeployIntroductionPointcut(element);
                continue;
            }
            if (tag.equals("metadata-loader")) {
                AspectXmlLoader.undeployMetaDataLoader(element);
                continue;
            }
            if (tag.equals("metadata")) {
                AspectXmlLoader.undeployClassMetaData(element);
                continue;
            }
            if (tag.equals("stack")) {
                AspectXmlLoader.undeployInterceptorStack(element);
                continue;
            }
            if (tag.equals("aspect")) {
                AspectXmlLoader.undeployAspect(element);
                continue;
            }
            if (tag.equals("pointcut")) {
                AspectXmlLoader.undeployPointcut(element);
                continue;
            }
            if (tag.equals("bind")) {
                AspectXmlLoader.undeployBinding(element);
                continue;
            }
            if (tag.equals("prepare")) {
                AspectXmlLoader.undeployPrepare(element);
                continue;
            }
            if (tag.equals("cflow-stack")) {
                AspectXmlLoader.undeployCFlowStack(element);
                continue;
            }
            if (tag.equals("pluggable-pointcut")) {
                AspectXmlLoader.undeployPluggablePointcut(element);
                continue;
            }
            if (tag.equals("dynamic-cflow")) {
                AspectXmlLoader.undeployDynamicCFlow(element);
                continue;
            }
            if (tag.equals("typedef")) {
                AspectXmlLoader.undeployTypedef(element);
                continue;
            }
            if (!tag.equals("annotation-introduction")) continue;
            AspectXmlLoader.undeployAnnotationIntroduction(element);
        }
    }

    public static void deployXML(URL url) throws Exception {
        AspectXmlLoader.deployXML(AspectXmlLoader.loadURL(url), url);
    }

    public static void undeployXML(URL url) throws Exception {
        AspectXmlLoader.undeployXML(AspectXmlLoader.loadURL(url), url);
    }

    private static Document loadURL(URL configURL) throws Exception {
        InputStream is;
        InputStream inputStream = is = configURL != null ? configURL.openStream() : null;
        if (is == null) {
            throw new IOException("Failed to obtain InputStream from url: " + configURL);
        }
        DocumentBuilderFactory docBuilderFactory = null;
        docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(false);
        InputSource source = new InputSource(is);
        URL url = AspectXmlLoader.class.getResource("/jboss-aop_1_0.dtd");
        source.setSystemId(url.toString());
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        docBuilder.setEntityResolver(new Resolver());
        Document doc = docBuilder.parse(source);
        return doc;
    }

    private static class LocalErrorHandler
    implements ErrorHandler {
        private LocalErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
        }

        public void error(SAXParseException exception) throws SAXException {
        }

        public void fatalError(SAXParseException exception) throws SAXException {
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.endsWith("jboss-aop_1_0.dtd")) {
                try {
                    URL url = (class$org$jboss$aop$AspectXmlLoader == null ? (class$org$jboss$aop$AspectXmlLoader = AspectXmlLoader.class$("org.jboss.aop.AspectXmlLoader")) : class$org$jboss$aop$AspectXmlLoader).getResource("/jboss-aop_1_0.dtd");
                    InputStream is = url.openStream();
                    return new InputSource(is);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
    }
}

