/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.CallerConstructorInfo;
import org.jboss.aop.CallerMethodInfo;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.CFlowInterceptor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aop.instrument.ConstructorExecutionTransformer;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.util.ConstructorComparator;
import org.jboss.aop.util.FieldComparator;
import org.jboss.aop.util.MethodHashing;

public class ClassAdvisor
extends Advisor {
    public static final String NOT_TRANSFORMABLE_SUFFIX = "$aop";
    protected Class clazz = null;
    private TLongObjectHashMap methodInterceptors = new TLongObjectHashMap();
    private TLongObjectHashMap advisedMethods = new TLongObjectHashMap();
    private TLongObjectHashMap unadvisedMethods = new TLongObjectHashMap();
    protected TLongObjectHashMap methodCalledByMethodBindings = new TLongObjectHashMap();
    protected HashMap backrefMethodCalledByMethodBindings = new HashMap();
    protected TLongObjectHashMap methodCalledByMethodInterceptors = new TLongObjectHashMap();
    protected TLongObjectHashMap conCalledByMethodBindings = new TLongObjectHashMap();
    protected HashMap backrefConCalledByMethodBindings = new HashMap();
    protected TLongObjectHashMap conCalledByMethodInterceptors = new TLongObjectHashMap();
    protected HashMap[] methodCalledByConBindings;
    protected HashMap[] methodCalledByConInterceptors;
    protected HashMap backrefMethodCalledByConstructorBindings = new HashMap();
    protected HashMap[] conCalledByConBindings;
    protected HashMap[] conCalledByConInterceptors;
    protected HashMap backrefConCalledByConstructorBindings = new HashMap();
    private Interceptor[][] fieldReadInterceptors;
    private Interceptor[][] fieldWriteInterceptors;
    private Field[] advisedFields;
    private HashMap staticFieldAspects = new HashMap();
    private Interceptor[][] constructorInterceptors;
    private Constructor[] constructors;
    protected boolean initialized = false;

    public Object getFieldAspect(FieldJoinpoint joinpoint, AspectDefinition def) {
        Object aspect = this.staticFieldAspects.get(joinpoint);
        if (aspect == null) {
            aspect = def.getFactory().createPerJoinpoint(this, joinpoint);
            this.staticFieldAspects.put(joinpoint, aspect);
        }
        return aspect;
    }

    public Object resolveAnnotation(Class annotation) {
        Object value = super.resolveAnnotation(annotation);
        if (this.clazz == null) {
            return null;
        }
        if (value == null) {
            value = AnnotationElement.getAnyAnnotation(this.clazz, annotation);
        }
        return value;
    }

    public boolean hasAnnotation(String annotation) {
        if (super.hasAnnotation(annotation)) {
            return true;
        }
        if (this.clazz == null) {
            return false;
        }
        try {
            return AnnotationElement.isAnyAnnotationPresent(this.clazz, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class getClazz() {
        return this.clazz;
    }

    public Field[] getAdvisedFields() {
        return this.advisedFields;
    }

    public TLongObjectHashMap getAdvisedMethods() {
        return this.advisedMethods;
    }

    public TLongObjectHashMap getUnadvisedMethods() {
        return this.unadvisedMethods;
    }

    public Class getAdvisedClass() {
        return this.clazz;
    }

    public ClassAdvisor(String classname) {
        super(classname);
    }

    public Constructor[] getConstructors() {
        return this.constructors;
    }

    public TLongObjectHashMap getMethodCalledByMethodInterceptors() {
        return this.methodCalledByMethodInterceptors;
    }

    public HashMap[] getMethodCalledByConInterceptors() {
        return this.methodCalledByConInterceptors;
    }

    public HashMap[] getConCalledByConInterceptors() {
        return this.conCalledByConInterceptors;
    }

    public TLongObjectHashMap getConCalledByMethodInterceptors() {
        return this.conCalledByMethodInterceptors;
    }

    public TLongObjectHashMap getMethodCalledByMethodBindings() {
        return this.methodCalledByMethodBindings;
    }

    public Interceptor[][] getConstructorInterceptors() {
        return this.constructorInterceptors;
    }

    public Interceptor[][] getFieldReadInterceptors() {
        return this.fieldReadInterceptors;
    }

    public Interceptor[][] getFieldWriteInterceptors() {
        return this.fieldWriteInterceptors;
    }

    public TLongObjectHashMap getMethodInterceptors() {
        return this.methodInterceptors;
    }

    public synchronized void attachClass(Class clazz) {
        try {
            if (this.initialized) {
                return;
            }
            AspectManager.instance().attachMetaData(this, clazz);
            this.interfaceIntroductions.clear();
            this.rebindClassMetaData();
            AspectManager.instance().applyInterfaceIntroductions(this, clazz);
            this.clazz = clazz;
            this.createFieldTable();
            this.createMethodTables();
            this.createConstructorTables();
            this.populateMixinMethods();
            this.rebindClassMetaData();
            this.createInterceptorChains();
            this.initialized = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getMethod(Class clazz, Method method) throws NoSuchMethodException {
        if (clazz == null || clazz.equals(Object.class)) {
            throw new NoSuchMethodException(method.getName());
        }
        try {
            String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
            return clazz.getMethod(wrappedName, method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return ClassAdvisor.getMethod(clazz.getSuperclass(), method);
        }
    }

    public int getConstructorIndex(Constructor constructor) {
        for (int i = 0; i < this.constructors.length; ++i) {
            if (!constructor.equals(this.constructors[i])) continue;
            return i;
        }
        return -1;
    }

    public int getFieldIndex(Field field) {
        for (int i = 0; i < this.advisedFields.length; ++i) {
            if (!field.equals(this.advisedFields[i])) continue;
            return i;
        }
        return -1;
    }

    protected void populateMixinMethods() throws Exception {
        ArrayList pointcuts = this.getInterfaceIntroductions();
        Iterator it = pointcuts.iterator();
        while (it.hasNext()) {
            InterfaceIntroduction pointcut = (InterfaceIntroduction)it.next();
            ArrayList mixins = pointcut.getMixins();
            for (int i = 0; i < mixins.size(); ++i) {
                InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mixins.get(i);
                Class<?> mixinClass = Thread.currentThread().getContextClassLoader().loadClass(mixin.getClassName());
                String[] interfaces = mixin.getInterfaces();
                for (int j = 0; j < interfaces.length; ++j) {
                    Class<?> intf = Thread.currentThread().getContextClassLoader().loadClass(interfaces[j]);
                    Method[] methods = intf.getMethods();
                    for (int k = 0; k < methods.length; ++k) {
                        Method method = ClassAdvisor.getMethod(this.clazz, methods[k]);
                        long hash = MethodHashing.methodHash(method);
                        this.unadvisedMethods.put(hash, (Object)method);
                    }
                }
            }
        }
    }

    public synchronized void removeAdviceBinding(AdviceBinding binding) {
        this.removeCallerPointcut(binding);
        super.removeAdviceBinding(binding);
    }

    protected void createInterceptorChain(InterceptorFactory[] factories, ArrayList newinterceptors, Joinpoint joinpoint) {
        for (int i = 0; i < factories.length; ++i) {
            if (!factories[i].isDeployed()) continue;
            newinterceptors.add(factories[i].create(this, joinpoint));
        }
    }

    protected void resolveMethodPointcut(TLongObjectHashMap newMethodInterceptors, AdviceBinding binding) {
        long[] keys = this.advisedMethods.keys();
        for (int i = 0; i < keys.length; ++i) {
            Method method = (Method)this.advisedMethods.get(keys[i]);
            if (!binding.getPointcut().matchesExecution((Advisor)this, method)) continue;
            this.adviceBindings.add(binding);
            if (AspectManager.verbose) {
                System.err.println("method matched binding " + binding.getPointcut().getExpr() + " " + method.toString());
            }
            binding.addAdvisor(this);
            MethodInfo info = (MethodInfo)newMethodInterceptors.get(keys[i]);
            ArrayList curr = info.interceptorChain;
            if (binding.getCFlow() != null) {
                ArrayList cflowChain = new ArrayList();
                this.createInterceptorChain(binding.getInterceptorFactories(), cflowChain, new MethodJoinpoint(method));
                Interceptor[] cflowInterceptors = cflowChain.toArray(new Interceptor[cflowChain.size()]);
                curr.add(new CFlowInterceptor(binding.getCFlowString(), binding.getCFlow(), cflowInterceptors));
                continue;
            }
            this.createInterceptorChain(binding.getInterceptorFactories(), curr, new MethodJoinpoint(method));
        }
    }

    protected void resolveFieldPointcut(ArrayList newFieldInterceptors, AdviceBinding binding, boolean write) {
        for (int i = 0; i < this.advisedFields.length; ++i) {
            Field field = this.advisedFields[i];
            if ((write || !binding.getPointcut().matchesGet(this, field)) && (!write || !binding.getPointcut().matchesSet(this, field))) continue;
            if (AspectManager.verbose) {
                System.err.println("field matched binding " + binding.getName());
            }
            this.adviceBindings.add(binding);
            binding.addAdvisor(this);
            ArrayList curr = (ArrayList)newFieldInterceptors.get(i);
            if (binding.getCFlow() != null) {
                ArrayList cflowChain = new ArrayList();
                this.createInterceptorChain(binding.getInterceptorFactories(), cflowChain, new FieldJoinpoint(field));
                Interceptor[] cflowInterceptors = cflowChain.toArray(new Interceptor[cflowChain.size()]);
                curr.add(new CFlowInterceptor(binding.getCFlowString(), binding.getCFlow(), cflowInterceptors));
                continue;
            }
            this.createInterceptorChain(binding.getInterceptorFactories(), curr, new FieldJoinpoint(field));
        }
    }

    protected void resolveConstructorPointcut(ArrayList newConstructorInterceptors, AdviceBinding binding) {
        for (int i = 0; i < this.constructors.length; ++i) {
            Constructor constructor = this.constructors[i];
            if (!binding.getPointcut().matchesExecution(this, constructor)) continue;
            if (AspectManager.verbose) {
                System.err.println(constructor + " matched binding " + binding.getName() + " " + binding.getPointcut().getExpr());
            }
            this.adviceBindings.add(binding);
            binding.addAdvisor(this);
            ArrayList curr = (ArrayList)newConstructorInterceptors.get(i);
            if (binding.getCFlow() != null) {
                ArrayList cflowChain = new ArrayList();
                this.createInterceptorChain(binding.getInterceptorFactories(), cflowChain, new ConstructorJoinpoint(constructor));
                Interceptor[] cflowInterceptors = cflowChain.toArray(new Interceptor[cflowChain.size()]);
                curr.add(new CFlowInterceptor(binding.getCFlowString(), binding.getCFlow(), cflowInterceptors));
                continue;
            }
            this.createInterceptorChain(binding.getInterceptorFactories(), curr, new ConstructorJoinpoint(constructor));
        }
    }

    protected TLongObjectHashMap initializeMethodChain() {
        TLongObjectHashMap newInterceptors = new TLongObjectHashMap();
        long[] keys = this.advisedMethods.keys();
        for (int i = 0; i < keys.length; ++i) {
            Method umethod;
            Method amethod;
            MethodInfo info = new MethodInfo();
            info.advisedMethod = amethod = (Method)this.advisedMethods.get(keys[i]);
            info.unadvisedMethod = umethod = (Method)this.unadvisedMethods.get(keys[i]);
            info.hash = keys[i];
            info.advisor = this;
            newInterceptors.put(keys[i], (Object)info);
            try {
                Field infoField = this.clazz.getDeclaredField(MethodExecutionTransformer.getMethodInfoFieldName(amethod.getName(), keys[i]));
                infoField.setAccessible(true);
                infoField.set(null, info);
                continue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return newInterceptors;
    }

    protected ArrayList initializeFieldChain() {
        ArrayList chain = new ArrayList(this.advisedFields.length);
        for (int i = 0; i < this.advisedFields.length; ++i) {
            ArrayList list = new ArrayList();
            chain.add(list);
        }
        return chain;
    }

    protected ArrayList initializeConstructorChain() {
        ArrayList chain = new ArrayList(this.constructors.length);
        for (int i = 0; i < this.constructors.length; ++i) {
            ArrayList list = new ArrayList();
            chain.add(list);
        }
        return chain;
    }

    protected void finalizeMethodChain(TLongObjectHashMap newMethodInterceptors) {
        long[] keys = newMethodInterceptors.keys();
        for (int i = 0; i < keys.length; ++i) {
            MethodInfo info = (MethodInfo)newMethodInterceptors.get(keys[i]);
            ArrayList list = info.interceptorChain;
            info.interceptors = list.toArray(new Interceptor[list.size()]);
        }
    }

    protected void finalizeFieldChain(ArrayList newFieldInterceptors) {
        for (int i = 0; i < newFieldInterceptors.size(); ++i) {
            ArrayList list = (ArrayList)newFieldInterceptors.get(i);
            Interceptor[] chain = list.toArray(new Interceptor[list.size()]);
            newFieldInterceptors.set(i, chain);
        }
    }

    protected void finalizeConstructorChain(ArrayList newFieldInterceptors) {
        for (int i = 0; i < newFieldInterceptors.size(); ++i) {
            ArrayList list = (ArrayList)newFieldInterceptors.get(i);
            Interceptor[] chain = list.toArray(new Interceptor[list.size()]);
            newFieldInterceptors.set(i, chain);
        }
    }

    protected void createInterceptorChains() throws Exception {
        TLongObjectHashMap newMethodInterceptors = this.initializeMethodChain();
        ArrayList newFieldReadInterceptors = this.initializeFieldChain();
        ArrayList newFieldWriteInterceptors = this.initializeFieldChain();
        ArrayList newConstructorInterceptors = this.initializeConstructorChain();
        Iterator it = AspectManager.instance().bindings.values().iterator();
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (AspectManager.verbose) {
                System.out.println("iterate binding " + binding.getName());
            }
            this.resolveMethodPointcut(newMethodInterceptors, binding);
            this.resolveFieldPointcut(newFieldReadInterceptors, binding, false);
            this.resolveFieldPointcut(newFieldWriteInterceptors, binding, true);
            this.resolveConstructorPointcut(newConstructorInterceptors, binding);
        }
        this.finalizeMethodChain(newMethodInterceptors);
        this.finalizeFieldChain(newFieldReadInterceptors);
        this.finalizeFieldChain(newFieldWriteInterceptors);
        this.finalizeConstructorChain(newConstructorInterceptors);
        this.methodInterceptors = newMethodInterceptors;
        this.fieldReadInterceptors = (Interceptor[][])newFieldReadInterceptors.toArray((T[])new Interceptor[0][0]);
        this.fieldWriteInterceptors = (Interceptor[][])newFieldWriteInterceptors.toArray((T[])new Interceptor[0][0]);
        this.constructorInterceptors = (Interceptor[][])newConstructorInterceptors.toArray((T[])new Interceptor[0][0]);
        this.doesHaveAspects = this.adviceBindings.size() > 0;
    }

    protected CallerMethodInfo initializeCallerInterceptorsMap(long callingMethodHash, String calledClass, long calledMethodHash, Method calledMethod) throws Exception {
        TLongObjectHashMap calledMethodsMap;
        HashMap<String, TLongObjectHashMap> calledClassesMap = (HashMap<String, TLongObjectHashMap>)this.methodCalledByMethodInterceptors.get(callingMethodHash);
        if (calledClassesMap == null) {
            calledClassesMap = new HashMap<String, TLongObjectHashMap>();
            this.methodCalledByMethodInterceptors.put(callingMethodHash, calledClassesMap);
        }
        if ((calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass)) == null) {
            calledMethodsMap = new TLongObjectHashMap();
            calledClassesMap.put(calledClass, calledMethodsMap);
        }
        calledMethod.setAccessible(true);
        CallerMethodInfo info = new CallerMethodInfo(calledMethod, null);
        calledMethodsMap.put(calledMethodHash, (Object)info);
        return info;
    }

    protected CallerConstructorInfo initializeConCalledByMethodInterceptorsMap(long callingMethodHash, String calledClass, long calledConHash, Constructor calledCon) throws Exception {
        TLongObjectHashMap calledMethodsMap;
        HashMap<String, TLongObjectHashMap> calledClassesMap = (HashMap<String, TLongObjectHashMap>)this.conCalledByMethodInterceptors.get(callingMethodHash);
        if (calledClassesMap == null) {
            calledClassesMap = new HashMap<String, TLongObjectHashMap>();
            this.conCalledByMethodInterceptors.put(callingMethodHash, calledClassesMap);
        }
        if ((calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass)) == null) {
            calledMethodsMap = new TLongObjectHashMap();
            calledClassesMap.put(calledClass, calledMethodsMap);
        }
        CallerConstructorInfo info = null;
        info = this.createCallerConstructorInfo(calledClass, calledCon);
        calledMethodsMap.put(calledConHash, (Object)info);
        return info;
    }

    private CallerConstructorInfo createCallerConstructorInfo(String calledClass, Constructor calledCon) {
        CallerConstructorInfo info;
        calledCon.setAccessible(true);
        try {
            int index = calledClass.lastIndexOf(46);
            String baseClassName = calledClass.substring(index + 1);
            Method wrapper = calledCon.getDeclaringClass().getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(baseClassName), calledCon.getParameterTypes());
            info = new CallerConstructorInfo(calledCon, wrapper, null);
        }
        catch (NoSuchMethodException e) {
            info = new CallerConstructorInfo(calledCon, null);
        }
        return info;
    }

    protected CallerMethodInfo initializeConstructorCallerInterceptorsMap(int callingIndex, String calledClass, long calledMethodHash, Method calledMethod) throws Exception {
        TLongObjectHashMap calledMethodsMap;
        HashMap<String, TLongObjectHashMap> calledClassesMap = this.methodCalledByConInterceptors[callingIndex];
        if (calledClassesMap == null) {
            this.methodCalledByConInterceptors[callingIndex] = calledClassesMap = new HashMap<String, TLongObjectHashMap>();
        }
        if ((calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass)) == null) {
            calledMethodsMap = new TLongObjectHashMap();
            calledClassesMap.put(calledClass, calledMethodsMap);
        }
        calledMethod.setAccessible(true);
        CallerMethodInfo info = new CallerMethodInfo(calledMethod, null);
        calledMethodsMap.put(calledMethodHash, (Object)info);
        return info;
    }

    protected CallerConstructorInfo initializeConCalledByConInterceptorsMap(int callingIndex, String calledClass, long calledConHash, Constructor calledCon) throws Exception {
        TLongObjectHashMap calledMethodsMap;
        HashMap<String, TLongObjectHashMap> calledClassesMap = this.conCalledByConInterceptors[callingIndex];
        if (calledClassesMap == null) {
            this.conCalledByConInterceptors[callingIndex] = calledClassesMap = new HashMap<String, TLongObjectHashMap>();
        }
        if ((calledMethodsMap = (TLongObjectHashMap)calledClassesMap.get(calledClass)) == null) {
            calledMethodsMap = new TLongObjectHashMap();
            calledClassesMap.put(calledClass, calledMethodsMap);
        }
        CallerConstructorInfo info = this.createCallerConstructorInfo(calledClass, calledCon);
        calledMethodsMap.put(calledConHash, (Object)info);
        return info;
    }

    protected void rebuildCallerInterceptors() throws Exception {
        long[] calledKeys;
        TLongObjectHashMap calledMethods;
        String cname;
        Map.Entry entry;
        Iterator classesIterator;
        ArrayList bindings;
        int j;
        long[] calledKeys2;
        String cname2;
        Map.Entry entry2;
        Iterator classesIterator2;
        HashMap calledClasses;
        int i;
        long[] callingKeys = this.methodCalledByMethodInterceptors.keys();
        for (i = 0; i < callingKeys.length; ++i) {
            long callingHash = callingKeys[i];
            calledClasses = (HashMap)this.methodCalledByMethodInterceptors.get(callingHash);
            classesIterator2 = calledClasses.entrySet().iterator();
            while (classesIterator2.hasNext()) {
                entry2 = classesIterator2.next();
                cname2 = (String)entry2.getKey();
                TLongObjectHashMap calledMethods2 = (TLongObjectHashMap)entry2.getValue();
                calledKeys2 = calledMethods2.keys();
                for (j = 0; j < calledKeys2.length; ++j) {
                    long calledHash = calledKeys2[j];
                    bindings = this.getCallerBindings(callingHash, cname2, calledHash);
                    Method calling = MethodHashing.findMethodByHash(this.clazz, callingHash);
                    this.bindCallerInterceptorChain(bindings, callingHash, cname2, calledHash, calling);
                }
            }
        }
        for (i = 0; i < this.methodCalledByConInterceptors.length; ++i) {
            HashMap calledClasses2 = this.methodCalledByConInterceptors[i];
            if (calledClasses2 == null) continue;
            classesIterator = calledClasses2.entrySet().iterator();
            while (classesIterator.hasNext()) {
                entry = classesIterator.next();
                cname = (String)entry.getKey();
                calledMethods = (TLongObjectHashMap)entry.getValue();
                calledKeys = calledMethods.keys();
                for (int j2 = 0; j2 < calledKeys.length; ++j2) {
                    long calledHash = calledKeys[j2];
                    ArrayList bindings2 = this.getConstructorCallerBindings(i, cname, calledHash);
                    this.bindConstructorCallerInterceptorChain(bindings2, i, cname, calledHash);
                }
            }
        }
        callingKeys = this.conCalledByMethodInterceptors.keys();
        for (i = 0; i < callingKeys.length; ++i) {
            long callingHash = callingKeys[i];
            calledClasses = (HashMap)this.conCalledByMethodInterceptors.get(callingHash);
            classesIterator2 = calledClasses.entrySet().iterator();
            while (classesIterator2.hasNext()) {
                entry2 = classesIterator2.next();
                cname2 = (String)entry2.getKey();
                TLongObjectHashMap calledMethods3 = (TLongObjectHashMap)entry2.getValue();
                calledKeys2 = calledMethods3.keys();
                for (j = 0; j < calledKeys2.length; ++j) {
                    long calledHash = calledKeys2[j];
                    bindings = this.getConCalledByMethodBindings(callingHash, cname2, calledHash);
                    this.bindConCalledByMethodInterceptorChain(bindings, callingHash, cname2, calledHash);
                }
            }
        }
        for (i = 0; i < this.conCalledByConInterceptors.length; ++i) {
            HashMap calledClasses3 = this.conCalledByConInterceptors[i];
            if (calledClasses3 == null) continue;
            classesIterator = calledClasses3.entrySet().iterator();
            while (classesIterator.hasNext()) {
                entry = classesIterator.next();
                cname = (String)entry.getKey();
                calledMethods = (TLongObjectHashMap)entry.getValue();
                calledKeys = calledMethods.keys();
                for (int j3 = 0; j3 < calledKeys.length; ++j3) {
                    long calledHash = calledKeys[j3];
                    ArrayList bindings3 = this.getConCalledByConBindings(i, cname, calledHash);
                    this.bindConCalledByConInterceptorChain(bindings3, i, cname, calledHash);
                }
            }
        }
    }

    private ArrayList getCallerBindings(long callingHash, String cname, long calledHash) {
        HashMap calledClasses = (HashMap)this.methodCalledByMethodBindings.get(callingHash);
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(cname);
        return (ArrayList)calledMethods.get(calledHash);
    }

    private ArrayList getConCalledByMethodBindings(long callingHash, String cname, long calledHash) {
        HashMap calledClasses = (HashMap)this.conCalledByMethodBindings.get(callingHash);
        TLongObjectHashMap calledCons = (TLongObjectHashMap)calledClasses.get(cname);
        return (ArrayList)calledCons.get(calledHash);
    }

    private ArrayList getConstructorCallerBindings(int callingIndex, String cname, long calledHash) {
        HashMap calledClasses = this.methodCalledByConBindings[callingIndex];
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(cname);
        return (ArrayList)calledMethods.get(calledHash);
    }

    private ArrayList getConCalledByConBindings(int callingIndex, String cname, long calledHash) {
        HashMap calledClasses = this.conCalledByConBindings[callingIndex];
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(cname);
        return (ArrayList)calledMethods.get(calledHash);
    }

    private void bindCallerInterceptorChain(ArrayList bindings, long callingHash, String cname, long calledHash, Method calling) {
        ArrayList<CFlowInterceptor> interceptors = new ArrayList<CFlowInterceptor>();
        Iterator it = bindings.iterator();
        CallerMethodInfo info = this.getCallerMethodInfo(callingHash, cname, calledHash);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (binding.getCFlow() != null) {
                ArrayList cflowChain = new ArrayList();
                this.createInterceptorChain(binding.getInterceptorFactories(), cflowChain, new MethodCalledByMethodJoinpoint(calling, info.method));
                Interceptor[] cflowInterceptors = cflowChain.toArray(new Interceptor[cflowChain.size()]);
                interceptors.add(new CFlowInterceptor(binding.getCFlowString(), binding.getCFlow(), cflowInterceptors));
                continue;
            }
            this.createInterceptorChain(binding.getInterceptorFactories(), interceptors, new MethodCalledByMethodJoinpoint(calling, info.method));
        }
        Interceptor[] chain = interceptors.toArray(new Interceptor[interceptors.size()]);
        info.interceptors = chain.length == 0 ? null : chain;
    }

    private void bindConCalledByMethodInterceptorChain(ArrayList bindings, long callingHash, String cname, long calledHash) throws Exception {
        ArrayList<CFlowInterceptor> interceptors = new ArrayList<CFlowInterceptor>();
        Iterator it = bindings.iterator();
        CallerConstructorInfo info = this.getConCalledByMethod(callingHash, cname, calledHash);
        Method calling = MethodHashing.findMethodByHash(this.clazz, callingHash);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (binding.getCFlow() != null) {
                ArrayList cflowChain = new ArrayList();
                this.createInterceptorChain(binding.getInterceptorFactories(), cflowChain, new ConstructorCalledByMethodJoinpoint(calling, info.constructor));
                Interceptor[] cflowInterceptors = cflowChain.toArray(new Interceptor[cflowChain.size()]);
                interceptors.add(new CFlowInterceptor(binding.getCFlowString(), binding.getCFlow(), cflowInterceptors));
                continue;
            }
            this.createInterceptorChain(binding.getInterceptorFactories(), interceptors, new ConstructorCalledByMethodJoinpoint(calling, info.constructor));
        }
        Interceptor[] chain = interceptors.toArray(new Interceptor[interceptors.size()]);
        info.interceptors = chain.length == 0 ? null : chain;
    }

    private void bindConCalledByConInterceptorChain(ArrayList bindings, int callingIndex, String cname, long calledHash) {
        ArrayList<CFlowInterceptor> interceptors = new ArrayList<CFlowInterceptor>();
        Iterator it = bindings.iterator();
        CallerConstructorInfo info = this.getConCalledByCon(callingIndex, cname, calledHash);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (binding.getCFlow() != null) {
                ArrayList cflowChain = new ArrayList();
                this.createInterceptorChain(binding.getInterceptorFactories(), cflowChain, new ConstructorCalledByConstructorJoinpoint(this.constructors[callingIndex], info.constructor));
                Interceptor[] cflowInterceptors = cflowChain.toArray(new Interceptor[cflowChain.size()]);
                interceptors.add(new CFlowInterceptor(binding.getCFlowString(), binding.getCFlow(), cflowInterceptors));
                continue;
            }
            this.createInterceptorChain(binding.getInterceptorFactories(), interceptors, new ConstructorCalledByConstructorJoinpoint(this.constructors[callingIndex], info.constructor));
        }
        Interceptor[] chain = interceptors.toArray(new Interceptor[interceptors.size()]);
        info.interceptors = chain.length == 0 ? null : chain;
    }

    private void bindConstructorCallerInterceptorChain(ArrayList bindings, int callingIndex, String cname, long calledHash) {
        ArrayList<CFlowInterceptor> interceptors = new ArrayList<CFlowInterceptor>();
        Iterator it = bindings.iterator();
        CallerMethodInfo info = this.getConstructorCallerMethodInfo(callingIndex, cname, calledHash);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (binding.getCFlow() != null) {
                ArrayList cflowChain = new ArrayList();
                this.createInterceptorChain(binding.getInterceptorFactories(), cflowChain, new MethodCalledByConstructorJoinpoint(this.constructors[callingIndex], info.method));
                Interceptor[] cflowInterceptors = cflowChain.toArray(new Interceptor[cflowChain.size()]);
                interceptors.add(new CFlowInterceptor(binding.getCFlowString(), binding.getCFlow(), cflowInterceptors));
                continue;
            }
            this.createInterceptorChain(binding.getInterceptorFactories(), interceptors, new MethodCalledByConstructorJoinpoint(this.constructors[callingIndex], info.method));
        }
        Interceptor[] chain = interceptors.toArray(new Interceptor[interceptors.size()]);
        info.interceptors = chain.length == 0 ? null : chain;
    }

    protected void rebuildInterceptors() {
        if (this.initialized) {
            try {
                this.adviceBindings.clear();
                this.createInterceptorChains();
                this.rebuildCallerInterceptors();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void bindClassMetaData(ClassMetaDataBinding data) {
        try {
            Constructor[] cons;
            ClassMetaDataLoader loader = data.getLoader();
            Object[] objs = this.advisedMethods.getValues();
            Method[] methods = new Method[objs.length];
            Field[] fields = this.advisedFields;
            if (fields == null) {
                fields = new Field[]{};
            }
            if ((cons = this.constructors) == null) {
                cons = new Constructor[]{};
            }
            for (int i = 0; i < objs.length; ++i) {
                methods[i] = (Method)objs[i];
            }
            loader.bind(this, data, methods, fields, cons);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void rebindClassMetaData() {
        this.defaultMetaData.clear();
        this.methodMetaData.clear();
        this.fieldMetaData.clear();
        this.constructorMetaData.clear();
        this.classMetaData.clear();
        for (int i = 0; i < this.classMetaDataBindings.size(); ++i) {
            ClassMetaDataBinding data = (ClassMetaDataBinding)this.classMetaDataBindings.get(i);
            this.bindClassMetaData(data);
        }
    }

    public synchronized void addClassMetaData(ClassMetaDataBinding data) {
        this.classMetaDataBindings.add(data);
        if (this.clazz == null) {
            return;
        }
        this.bindClassMetaData(data);
        this.adviceBindings.clear();
        this.doesHaveAspects = false;
        this.rebuildInterceptors();
    }

    public synchronized void removeClassMetaData(ClassMetaDataBinding data) {
        if (this.classMetaDataBindings.remove(data)) {
            if (this.clazz == null) {
                return;
            }
            this.rebindClassMetaData();
            this.adviceBindings.clear();
            this.doesHaveAspects = false;
            this.rebuildInterceptors();
        }
    }

    public void initializeEmptyCallerChain(long callingMethodHash, String calledClass, long calledMethodHash) throws Exception {
        ArrayList bindings;
        TLongObjectHashMap classMap;
        HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.methodCalledByMethodBindings.get(callingMethodHash);
        if (callingMethod == null) {
            callingMethod = new HashMap<String, TLongObjectHashMap>();
            this.methodCalledByMethodBindings.put(callingMethodHash, callingMethod);
        }
        if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingMethod.put(calledClass, classMap);
        }
        if ((bindings = (ArrayList)classMap.get(calledMethodHash)) == null) {
            bindings = new ArrayList();
            classMap.put(calledMethodHash, bindings);
        }
    }

    public void initializeConCalledByMethodEmptyChain(long callingMethodHash, String calledClass, long calledConHash) throws Exception {
        ArrayList bindings;
        TLongObjectHashMap classMap;
        HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.conCalledByMethodBindings.get(callingMethodHash);
        if (callingMethod == null) {
            callingMethod = new HashMap<String, TLongObjectHashMap>();
            this.conCalledByMethodBindings.put(callingMethodHash, callingMethod);
        }
        if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingMethod.put(calledClass, classMap);
        }
        if ((bindings = (ArrayList)classMap.get(calledConHash)) == null) {
            bindings = new ArrayList();
            classMap.put(calledConHash, bindings);
        }
    }

    public void initializeEmptyConstructorCallerChain(int callingIndex, String calledClass, long calledMethodHash) throws Exception {
        ArrayList bindings;
        TLongObjectHashMap classMap;
        HashMap<String, TLongObjectHashMap> callingCon = this.methodCalledByConBindings[callingIndex];
        if (callingCon == null) {
            this.methodCalledByConBindings[callingIndex] = callingCon = new HashMap<String, TLongObjectHashMap>();
        }
        if ((classMap = (TLongObjectHashMap)callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        if ((bindings = (ArrayList)classMap.get(calledMethodHash)) == null) {
            bindings = new ArrayList();
            classMap.put(calledMethodHash, bindings);
        }
    }

    public void initializeConCalledByConEmptyChain(int callingIndex, String calledClass, long calledConHash) throws Exception {
        ArrayList bindings;
        TLongObjectHashMap classMap;
        HashMap<String, TLongObjectHashMap> callingCon = this.conCalledByConBindings[callingIndex];
        if (callingCon == null) {
            this.conCalledByConBindings[callingIndex] = callingCon = new HashMap<String, TLongObjectHashMap>();
        }
        if ((classMap = (TLongObjectHashMap)callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        if ((bindings = (ArrayList)classMap.get(calledConHash)) == null) {
            bindings = new ArrayList();
            classMap.put(calledConHash, bindings);
        }
    }

    public void addMethodCalledByMethodPointcut(long callingMethodHash, String calledClass, long calledMethodHash, AdviceBinding binding) throws Exception {
        ArrayList<ArrayList<ArrayList<AdviceBinding>>> backrefs;
        TLongObjectHashMap classMap;
        if (AspectManager.verbose) {
            System.err.println("method call matched binding " + binding.getPointcut().getExpr());
        }
        this.adviceBindings.add(binding);
        binding.addAdvisor(this);
        HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.methodCalledByMethodBindings.get(callingMethodHash);
        if (callingMethod == null) {
            callingMethod = new HashMap<String, TLongObjectHashMap>();
            this.methodCalledByMethodBindings.put(callingMethodHash, callingMethod);
        }
        if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingMethod.put(calledClass, classMap);
        }
        ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledMethodHash);
        boolean createdBindings = false;
        if (bindings == null) {
            bindings = new ArrayList<AdviceBinding>();
            classMap.put(calledMethodHash, bindings);
            createdBindings = true;
        }
        if (!bindings.contains(binding)) {
            bindings.add(binding);
        }
        if ((backrefs = (ArrayList<ArrayList<ArrayList<AdviceBinding>>>)this.backrefMethodCalledByMethodBindings.get(binding.getName())) == null) {
            backrefs = new ArrayList<ArrayList<ArrayList<AdviceBinding>>>();
            this.backrefMethodCalledByMethodBindings.put(binding.getName(), backrefs);
            backrefs.add(bindings);
        } else if (createdBindings) {
            backrefs.add(bindings);
        }
    }

    public void addConstructorCalledByMethodPointcut(long callingMethodHash, String calledClass, long calledMethodHash, AdviceBinding binding) throws Exception {
        ArrayList<ArrayList<ArrayList<AdviceBinding>>> backrefs;
        TLongObjectHashMap classMap;
        if (AspectManager.verbose) {
            System.err.println("method call matched binding " + binding.getPointcut().getExpr());
        }
        this.adviceBindings.add(binding);
        binding.addAdvisor(this);
        HashMap<String, TLongObjectHashMap> callingMethod = (HashMap<String, TLongObjectHashMap>)this.conCalledByMethodBindings.get(callingMethodHash);
        if (callingMethod == null) {
            callingMethod = new HashMap<String, TLongObjectHashMap>();
            this.conCalledByMethodBindings.put(callingMethodHash, callingMethod);
        }
        if ((classMap = (TLongObjectHashMap)callingMethod.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingMethod.put(calledClass, classMap);
        }
        ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledMethodHash);
        boolean createdBindings = false;
        if (bindings == null) {
            bindings = new ArrayList<AdviceBinding>();
            classMap.put(calledMethodHash, bindings);
            createdBindings = true;
        }
        if (!bindings.contains(binding)) {
            bindings.add(binding);
        }
        if ((backrefs = (ArrayList<ArrayList<ArrayList<AdviceBinding>>>)this.backrefConCalledByMethodBindings.get(binding.getName())) == null) {
            backrefs = new ArrayList<ArrayList<ArrayList<AdviceBinding>>>();
            this.backrefConCalledByMethodBindings.put(binding.getName(), backrefs);
            backrefs.add(bindings);
        } else if (createdBindings) {
            backrefs.add(bindings);
        }
    }

    public void addConstructorCallerPointcut(int callingIndex, String calledClass, long calledMethodHash, AdviceBinding binding) throws Exception {
        ArrayList<ArrayList<ArrayList<AdviceBinding>>> backrefs;
        TLongObjectHashMap classMap;
        if (AspectManager.verbose) {
            System.err.println("constructor call matched binding " + binding.getPointcut().getExpr());
        }
        this.adviceBindings.add(binding);
        binding.addAdvisor(this);
        HashMap<String, TLongObjectHashMap> callingCon = this.methodCalledByConBindings[callingIndex];
        if (callingCon == null) {
            this.methodCalledByConBindings[callingIndex] = callingCon = new HashMap<String, TLongObjectHashMap>();
        }
        if ((classMap = (TLongObjectHashMap)callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledMethodHash);
        boolean createdBindings = false;
        if (bindings == null) {
            bindings = new ArrayList<AdviceBinding>();
            classMap.put(calledMethodHash, bindings);
            createdBindings = true;
        }
        if (!bindings.contains(binding)) {
            bindings.add(binding);
        }
        if ((backrefs = (ArrayList<ArrayList<ArrayList<AdviceBinding>>>)this.backrefMethodCalledByConstructorBindings.get(binding.getName())) == null) {
            backrefs = new ArrayList<ArrayList<ArrayList<AdviceBinding>>>();
            this.backrefMethodCalledByConstructorBindings.put(binding.getName(), backrefs);
            backrefs.add(bindings);
        } else if (createdBindings) {
            backrefs.add(bindings);
        }
    }

    public void addConstructorCalledByConPointcut(int callingIndex, String calledClass, long calledConHash, AdviceBinding binding) throws Exception {
        ArrayList<ArrayList<ArrayList<AdviceBinding>>> backrefs;
        TLongObjectHashMap classMap;
        if (AspectManager.verbose) {
            System.err.println("constructor call matched binding " + binding.getPointcut().getExpr());
        }
        this.adviceBindings.add(binding);
        binding.addAdvisor(this);
        HashMap<String, TLongObjectHashMap> callingCon = this.conCalledByConBindings[callingIndex];
        if (callingCon == null) {
            this.conCalledByConBindings[callingIndex] = callingCon = new HashMap<String, TLongObjectHashMap>();
        }
        if ((classMap = (TLongObjectHashMap)callingCon.get(calledClass)) == null) {
            classMap = new TLongObjectHashMap();
            callingCon.put(calledClass, classMap);
        }
        ArrayList<AdviceBinding> bindings = (ArrayList<AdviceBinding>)classMap.get(calledConHash);
        boolean createdBindings = false;
        if (bindings == null) {
            bindings = new ArrayList<AdviceBinding>();
            classMap.put(calledConHash, bindings);
            createdBindings = true;
        }
        if (!bindings.contains(binding)) {
            bindings.add(binding);
        }
        if ((backrefs = (ArrayList<ArrayList<ArrayList<AdviceBinding>>>)this.backrefConCalledByConstructorBindings.get(binding.getName())) == null) {
            backrefs = new ArrayList<ArrayList<ArrayList<AdviceBinding>>>();
            this.backrefConCalledByConstructorBindings.put(binding.getName(), backrefs);
            backrefs.add(bindings);
        } else if (createdBindings) {
            backrefs.add(bindings);
        }
    }

    public void removeCallerPointcut(AdviceBinding binding) {
        ArrayList backrefs = (ArrayList)this.backrefMethodCalledByMethodBindings.get(binding.getName());
        if (backrefs == null) {
            return;
        }
        for (int i = 0; i < backrefs.size(); ++i) {
            ArrayList ref = (ArrayList)backrefs.get(i);
            ref.remove(binding);
        }
    }

    public static String notAdvisedMethodName(String className, String methodName) {
        return className.replace('.', '$') + "$" + methodName + NOT_TRANSFORMABLE_SUFFIX;
    }

    public static boolean isWithoutAdvisement(String name) {
        return name.endsWith(NOT_TRANSFORMABLE_SUFFIX);
    }

    public static boolean isAdvisable(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isFinal(modifiers) && !ClassAdvisor.isWithoutAdvisement(field.getName()) && !field.getName().startsWith("_") && field.getName().indexOf(36) == -1;
    }

    public static boolean isAdvisable(Method method) {
        int modifiers = method.getModifiers();
        return !ClassAdvisor.isWithoutAdvisement(method.getName()) && !Modifier.isAbstract(modifiers) && !Modifier.isNative(modifiers) && !method.getName().startsWith("_");
    }

    private void populateFieldTable(ArrayList fields, Class superclass) throws Exception {
        if (superclass == null) {
            return;
        }
        if (superclass.equals(Object.class)) {
            return;
        }
        this.populateFieldTable(fields, superclass.getSuperclass());
        ArrayList<Field> temp = new ArrayList<Field>();
        Field[] declaredFields = superclass.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!ClassAdvisor.isAdvisable(declaredFields[i])) continue;
            declaredFields[i].setAccessible(true);
            temp.add(declaredFields[i]);
        }
        Collections.sort(temp, FieldComparator.INSTANCE);
        fields.addAll(temp);
    }

    private void createFieldTable() throws Exception {
        ArrayList fields = new ArrayList();
        this.populateFieldTable(fields, this.clazz);
        this.advisedFields = fields.toArray(new Field[fields.size()]);
    }

    private void addDeclaredMethods(Class superclass) throws Exception {
        Method[] declaredMethods = superclass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            if (!ClassAdvisor.isAdvisable(declaredMethods[i])) continue;
            long hash = MethodHashing.methodHash(declaredMethods[i]);
            this.advisedMethods.put(hash, (Object)declaredMethods[i]);
            try {
                Method m = declaredMethods[i];
                Method un = superclass.getDeclaredMethod(ClassAdvisor.notAdvisedMethodName(superclass.getName(), m.getName()), m.getParameterTypes());
                un.setAccessible(true);
                this.unadvisedMethods.put(hash, (Object)un);
                continue;
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
    }

    private void populateMethodTables(Class superclass) throws Exception {
        if (superclass == null) {
            return;
        }
        if (superclass.equals(Object.class)) {
            return;
        }
        this.populateMethodTables(superclass.getSuperclass());
        ClassAdvisor superAdvisor = AspectManager.instance().getAdvisorIfAdvised(superclass);
        if (superAdvisor != null) {
            TLongObjectHashMap superHash = superAdvisor.getUnadvisedMethods();
            long[] keys = superHash.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.unadvisedMethods.put(keys[i], superHash.get(keys[i]));
            }
        }
        this.addDeclaredMethods(superclass);
    }

    private void createMethodTables() throws Exception {
        this.populateMethodTables(this.clazz.getSuperclass());
        this.addDeclaredMethods(this.clazz);
    }

    private void createConstructorTables() throws Exception {
        this.constructors = this.clazz.getDeclaredConstructors();
        this.methodCalledByConBindings = new HashMap[this.constructors.length];
        this.methodCalledByConInterceptors = new HashMap[this.constructors.length];
        this.conCalledByConBindings = new HashMap[this.constructors.length];
        this.conCalledByConInterceptors = new HashMap[this.constructors.length];
        for (int i = 0; i < this.constructors.length; ++i) {
            this.constructors[i].setAccessible(true);
        }
        Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
    }

    public CallerMethodInfo resolveCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash) {
        try {
            Method callingMethod = MethodHashing.findMethodByHash(this.clazz, callingMethodHash);
            if (callingMethod == null) {
                throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
            }
            Class<?> called = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
            Method calledMethod = MethodHashing.findMethodByHash(called, calledMethodHash);
            if (calledMethod == null) {
                throw new RuntimeException("Unable to figure out calledmethod of a caller pointcut");
            }
            Iterator it = AspectManager.instance().bindings.values().iterator();
            boolean matched = false;
            while (it.hasNext()) {
                AdviceBinding binding = (AdviceBinding)it.next();
                if (!binding.getPointcut().matchesCall(this, (AccessibleObject)callingMethod, called, calledMethod)) continue;
                this.addMethodCalledByMethodPointcut(callingMethodHash, calledClass, calledMethodHash, binding);
                matched = true;
            }
            if (!matched) {
                this.initializeEmptyCallerChain(callingMethodHash, calledClass, calledMethodHash);
            }
            CallerMethodInfo info = this.initializeCallerInterceptorsMap(callingMethodHash, calledClass, calledMethodHash, calledMethod);
            ArrayList bindings = this.getCallerBindings(callingMethodHash, calledClass, calledMethodHash);
            this.bindCallerInterceptorChain(bindings, callingMethodHash, calledClass, calledMethodHash, callingMethod);
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public CallerConstructorInfo resolveCallerConstructorInfo(long callingMethodHash, String calledClass, long calledConHash) {
        try {
            Method callingMethod = MethodHashing.findMethodByHash(this.clazz, callingMethodHash);
            if (callingMethod == null) {
                throw new RuntimeException("Unable to figure out calling method of a constructor caller pointcut");
            }
            Class<?> called = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
            Constructor calledCon = MethodHashing.findConstructorByHash(called, calledConHash);
            if (calledCon == null) {
                throw new RuntimeException("Unable to figure out calledcon of a constructor caller pointcut");
            }
            Iterator it = AspectManager.instance().bindings.values().iterator();
            boolean matched = false;
            while (it.hasNext()) {
                AdviceBinding binding = (AdviceBinding)it.next();
                if (!binding.getPointcut().matchesCall(this, (AccessibleObject)callingMethod, called, calledCon)) continue;
                this.addConstructorCalledByMethodPointcut(callingMethodHash, calledClass, calledConHash, binding);
                matched = true;
            }
            if (!matched) {
                this.initializeConCalledByMethodEmptyChain(callingMethodHash, calledClass, calledConHash);
            }
            CallerConstructorInfo info = this.initializeConCalledByMethodInterceptorsMap(callingMethodHash, calledClass, calledConHash, calledCon);
            ArrayList bindings = this.getConCalledByMethodBindings(callingMethodHash, calledClass, calledConHash);
            this.bindConCalledByMethodInterceptorChain(bindings, callingMethodHash, calledClass, calledConHash);
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public CallerMethodInfo resolveConstructorCallerMethodInfo(int callingIndex, String calledClass, long calledMethodHash) {
        try {
            Constructor callingConstructor = this.constructors[callingIndex];
            if (callingConstructor == null) {
                throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
            }
            Class<?> called = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
            Method calledMethod = MethodHashing.findMethodByHash(called, calledMethodHash);
            if (calledMethod == null) {
                throw new RuntimeException("Unable to figure out calledmethod of a caller pointcut");
            }
            Iterator it = AspectManager.instance().bindings.values().iterator();
            boolean matched = false;
            while (it.hasNext()) {
                AdviceBinding binding = (AdviceBinding)it.next();
                if (!binding.getPointcut().matchesCall(this, (AccessibleObject)callingConstructor, called, calledMethod)) continue;
                this.addConstructorCallerPointcut(callingIndex, calledClass, calledMethodHash, binding);
                matched = true;
            }
            if (!matched) {
                this.initializeEmptyConstructorCallerChain(callingIndex, calledClass, calledMethodHash);
            }
            CallerMethodInfo info = this.initializeConstructorCallerInterceptorsMap(callingIndex, calledClass, calledMethodHash, calledMethod);
            ArrayList bindings = this.getConstructorCallerBindings(callingIndex, calledClass, calledMethodHash);
            this.bindConstructorCallerInterceptorChain(bindings, callingIndex, calledClass, calledMethodHash);
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public CallerConstructorInfo resolveConstructorCallerConstructorInfo(int callingIndex, String calledClass, long calledConHash) {
        try {
            Constructor callingConstructor = this.constructors[callingIndex];
            if (callingConstructor == null) {
                throw new RuntimeException("Unable to figure out calling method of a caller pointcut");
            }
            Class<?> called = Thread.currentThread().getContextClassLoader().loadClass(calledClass);
            Constructor calledCon = MethodHashing.findConstructorByHash(called, calledConHash);
            if (calledCon == null) {
                throw new RuntimeException("Unable to figure out calledcon of a caller pointcut");
            }
            Iterator it = AspectManager.instance().bindings.values().iterator();
            boolean matched = false;
            while (it.hasNext()) {
                AdviceBinding binding = (AdviceBinding)it.next();
                if (!binding.getPointcut().matchesCall(this, (AccessibleObject)callingConstructor, called, calledCon)) continue;
                this.addConstructorCalledByConPointcut(callingIndex, calledClass, calledConHash, binding);
                matched = true;
            }
            if (!matched) {
                this.initializeConCalledByConEmptyChain(callingIndex, calledClass, calledConHash);
            }
            CallerConstructorInfo info = this.initializeConCalledByConInterceptorsMap(callingIndex, calledClass, calledConHash, calledCon);
            ArrayList bindings = this.getConCalledByConBindings(callingIndex, calledClass, calledConHash);
            this.bindConCalledByConInterceptorChain(bindings, callingIndex, calledClass, calledConHash);
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public Object invokeWithoutAdvisement(Object target, long methodHash, Object[] arguments) throws Throwable {
        try {
            Method method = (Method)this.unadvisedMethods.get(methodHash);
            return method.invoke(target, arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Object invokeNewWithoutAdvisement(Object[] arguments, Constructor constructor) throws Throwable {
        try {
            return constructor.newInstance(arguments);
        }
        catch (InstantiationException in) {
            throw new RuntimeException("failed to call constructor", in);
        }
        catch (IllegalAccessException ill) {
            throw new RuntimeException("illegal access", ill);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    public Object invokeMethod(long methodHash, Object[] arguments) throws Throwable {
        return this.invokeMethod(null, methodHash, arguments);
    }

    public Object invokeMethod(Object target, long methodHash, Object[] arguments) throws Throwable {
        InstanceAdvisor advisor = null;
        if (target != null) {
            InstanceAdvised advised = (InstanceAdvised)target;
            advisor = advised._getInstanceAdvisor();
        }
        MethodInfo info = (MethodInfo)this.methodInterceptors.get(methodHash);
        return this.invokeMethod((ClassInstanceAdvisor)advisor, target, methodHash, arguments, info);
    }

    public Object invokeMethod(InstanceAdvisor instanceAdvisor, Object target, long methodHash, Object[] arguments) throws Throwable {
        MethodInfo info = (MethodInfo)this.methodInterceptors.get(methodHash);
        if (info == null) {
            System.out.println("info is null for hash: " + methodHash + " of " + this.clazz.getName());
        }
        return this.invokeMethod((ClassInstanceAdvisor)instanceAdvisor, target, methodHash, arguments, info);
    }

    public Object invokeMethod(ClassInstanceAdvisor instanceAdvisor, Object target, long methodHash, Object[] arguments, MethodInfo info) throws Throwable {
        Interceptor[] aspects = info.interceptors;
        if (instanceAdvisor != null && (instanceAdvisor.appendedInterceptors != null || instanceAdvisor.insertedInterceptors != null)) {
            aspects = instanceAdvisor.getInterceptors(aspects);
        }
        MethodInvocation invocation = new MethodInvocation(info, aspects);
        invocation.setArguments(arguments);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeCaller(long callingMethodHash, Object target, Object[] args, CallerMethodInfo info) throws Throwable {
        MethodCalledByMethodInvocation invocation = new MethodCalledByMethodInvocation(info.interceptors, info.method, args, this.clazz, callingMethodHash);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeConCalledByMethod(long callingMethodHash, Object[] args, CallerConstructorInfo info) throws Throwable {
        ConstructorCalledByMethodInvocation invocation = new ConstructorCalledByMethodInvocation(info.interceptors, info, callingMethodHash, this.clazz, args);
        return invocation.invokeNext();
    }

    public Object invokeConstructorCaller(int callingIndex, Object target, Object[] args, CallerMethodInfo info) throws Throwable {
        MethodCalledByConstructorInvocation invocation = new MethodCalledByConstructorInvocation(info.method, args, this.constructors[callingIndex], info.interceptors);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeConCalledByCon(int callingIndex, Object[] args, CallerConstructorInfo info) throws Throwable {
        ConstructorCalledByConstructorInvocation invocation = new ConstructorCalledByConstructorInvocation(this.constructors[callingIndex], info, args);
        return invocation.invokeNext();
    }

    private CallerMethodInfo getCallerMethodInfo(long callingMethodHash, String calledClass, long calledMethodHash) {
        HashMap calledClasses = (HashMap)this.methodCalledByMethodInterceptors.get(callingMethodHash);
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
        CallerMethodInfo info = (CallerMethodInfo)calledMethods.get(calledMethodHash);
        return info;
    }

    private CallerConstructorInfo getConCalledByMethod(long callingMethodHash, String calledClass, long calledConHash) {
        HashMap calledClasses = (HashMap)this.conCalledByMethodInterceptors.get(callingMethodHash);
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
        CallerConstructorInfo info = (CallerConstructorInfo)calledMethods.get(calledConHash);
        return info;
    }

    private CallerMethodInfo getConstructorCallerMethodInfo(int callingIndex, String calledClass, long calledMethodHash) {
        HashMap calledClasses = this.methodCalledByConInterceptors[callingIndex];
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
        CallerMethodInfo info = (CallerMethodInfo)calledMethods.get(calledMethodHash);
        return info;
    }

    private CallerConstructorInfo getConCalledByCon(int callingIndex, String calledClass, long calledConHash) {
        HashMap calledClasses = this.conCalledByConInterceptors[callingIndex];
        TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClasses.get(calledClass);
        CallerConstructorInfo info = (CallerConstructorInfo)calledMethods.get(calledConHash);
        return info;
    }

    public InvocationResponse dynamicInvoke(Object target, Invocation invocation) throws Throwable {
        if (invocation instanceof MethodInvocation) {
            InstanceAdvised advised = (InstanceAdvised)target;
            Interceptor[] aspects = null;
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            long hash = methodInvocation.getMethodHash();
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
            aspects = info.interceptors;
            if (advised != null) {
                aspects = advised._getInstanceAdvisor().getInterceptors(aspects);
            }
            MethodInvocation nextInvocation = new MethodInvocation(info, aspects);
            nextInvocation.setTargetObject(target);
            nextInvocation.setArguments(methodInvocation.getArguments());
            nextInvocation.setAdvisor(this);
            InvocationResponse response = new InvocationResponse(nextInvocation.invokeNext());
            response.setContextInfo(nextInvocation.getResponseContextInfo());
            return response;
        }
        throw new RuntimeException("dynamic field invocations not supported yet!");
    }

    public Object invokeNew(Object[] args, int idx) throws Throwable {
        Interceptor[] cInterceptors = this.constructorInterceptors[idx];
        ConstructorInvocation invocation = new ConstructorInvocation(cInterceptors);
        invocation.setAdvisor(this);
        invocation.setArguments(args);
        invocation.setConstructor(this.constructors[idx]);
        return invocation.invokeNext();
    }

    public Object invokeRead(Object target, int index) throws Throwable {
        InstanceAdvised advised;
        ClassInstanceAdvisor advisor;
        Interceptor[] aspects = this.fieldReadInterceptors[index];
        if (target != null && (advisor = (ClassInstanceAdvisor)(advised = (InstanceAdvised)target)._getInstanceAdvisor()) != null && (advisor.appendedInterceptors != null || advisor.insertedInterceptors != null)) {
            aspects = advisor.getInterceptors(aspects);
        }
        FieldReadInvocation invocation = new FieldReadInvocation(this.advisedFields[index], index, aspects);
        invocation.setAdvisor(this);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invokeWrite(Object target, int index, Object value) throws Throwable {
        InstanceAdvised advised;
        ClassInstanceAdvisor advisor;
        Interceptor[] aspects = this.fieldWriteInterceptors[index];
        if (target != null && (advisor = (ClassInstanceAdvisor)(advised = (InstanceAdvised)target)._getInstanceAdvisor()) != null && (advisor.appendedInterceptors != null || advisor.insertedInterceptors != null)) {
            aspects = advised._getInstanceAdvisor().getInterceptors(aspects);
        }
        FieldWriteInvocation invocation = new FieldWriteInvocation(this.advisedFields[index], index, value, aspects);
        invocation.setAdvisor(this);
        invocation.setTargetObject(target);
        return invocation.invokeNext();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof FieldWriteInvocation) {
            FieldWriteInvocation fieldInvocation = (FieldWriteInvocation)invocation;
            Object target = fieldInvocation.getTargetObject();
            Object val = fieldInvocation.getValue();
            Field field = fieldInvocation.getField();
            field.set(target, val);
            return null;
        }
        if (invocation instanceof FieldReadInvocation) {
            FieldReadInvocation fieldInvocation = (FieldReadInvocation)invocation;
            Object target = fieldInvocation.getTargetObject();
            Field field = fieldInvocation.getField();
            return field.get(target);
        }
        if (invocation instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            return this.invokeWithoutAdvisement(methodInvocation.getTargetObject(), methodInvocation.getMethodHash(), methodInvocation.getArguments());
        }
        if (invocation instanceof ConstructorInvocation) {
            ConstructorInvocation cInvocation = (ConstructorInvocation)invocation;
            Object[] arguments = cInvocation.getArguments();
            Constructor constructor = cInvocation.getConstructor();
            return this.invokeNewWithoutAdvisement(arguments, constructor);
        }
        throw new IllegalStateException("Unknown Invocation type: " + invocation.getClass().getName());
    }
}

