/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.GenericInterceptorFactory;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;

public class AdviceBinding {
    private static volatile long counter = 0L;
    protected String name;
    protected Pointcut pointcut;
    protected ASTCFlowExpression cflow;
    protected String cflowString;
    protected HashSet advisors = new HashSet();
    protected InterceptorFactory[] interceptorFactories;

    public AdviceBinding(String name, Pointcut p, ASTCFlowExpression cflow, String cflowString, InterceptorFactory[] factories) throws ParseException {
        this.name = name;
        this.interceptorFactories = factories;
        this.cflow = cflow;
        this.pointcut = p;
        this.cflowString = cflowString;
    }

    public AdviceBinding(String pointcutExpression, String cflow) throws ParseException {
        this(Long.toString(System.currentTimeMillis()) + ":" + Long.toString(counter++), pointcutExpression, cflow);
    }

    public AdviceBinding(String name, String pointcutExpression, String cflow) throws ParseException {
        this.name = name;
        this.pointcut = new PointcutExpression(Long.toString(System.currentTimeMillis()) + ":" + Long.toString(counter++), pointcutExpression);
        if (cflow != null) {
            this.cflowString = cflow;
            this.cflow = new PointcutExpressionParser(new StringReader(this.cflowString)).CFlowExpression();
        }
        this.interceptorFactories = new InterceptorFactory[0];
    }

    public void addInterceptor(Class clazz) {
        List<InterceptorFactory> list = Arrays.asList(this.interceptorFactories);
        list = new ArrayList<InterceptorFactory>(list);
        list.add(new GenericInterceptorFactory(clazz));
        this.interceptorFactories = list.toArray(new InterceptorFactory[list.size()]);
    }

    public String getName() {
        return this.name;
    }

    public InterceptorFactory[] getInterceptorFactories() {
        return this.interceptorFactories;
    }

    public void addAdvisor(Advisor advisor) {
        if (AspectManager.verbose) {
            System.out.println("[debug] added advisor: " + advisor.getName() + " from binding: " + this.name);
        }
        this.advisors.add(advisor.getName());
    }

    public boolean hasAdvisors() {
        return this.advisors.size() > 0;
    }

    public void clearAdvisors() {
        Iterator it = this.advisors.iterator();
        while (it.hasNext()) {
            String advisorName = (String)it.next();
            Advisor advisor = AspectManager.instance().getAdvisor(advisorName);
            if (advisor == null) continue;
            advisor.removeAdviceBinding(this);
        }
        this.advisors.clear();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdviceBinding)) {
            return false;
        }
        return ((AdviceBinding)obj).getName().equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public ASTCFlowExpression getCFlow() {
        return this.cflow;
    }

    public String getCFlowString() {
        return this.cflowString;
    }
}

