/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation.compiler;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import org.jboss.aop.annotation.compiler.AnnotationDocletTag;
import org.jboss.aop.annotation.compiler.AnnotationDocletTagFactory;
import org.jboss.aop.annotation.compiler.AnnotationInfoCreator;

public class ByteCodeAnnotationCompiler {
    ClassPool pool;

    public void usage() {
        System.err.println("Usage: annotationc <files>+");
    }

    public void compile(String[] args) throws Exception {
        int i;
        if (args.length == 0) {
            this.usage();
            System.exit(1);
            return;
        }
        JavaDocBuilder builder = new JavaDocBuilder((DocletTagFactory)new AnnotationDocletTagFactory());
        this.pool = new ClassPool();
        this.pool.appendSystemPath();
        this.pool.appendClassPath((ClassPath)new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-bytecode") || args[i].equals("-o") || args[i].equals("-xml")) continue;
            File f = new File(args[i]).getCanonicalFile();
            builder.addSource((Reader)new FileReader(f));
        }
        for (i = 0; i < builder.getSources().length; ++i) {
            JavaSource src = builder.getSources()[i];
            for (int j = 0; j < src.getClasses().length; ++j) {
                JavaClass clazz = src.getClasses()[j];
                this.compileClass(clazz);
            }
        }
    }

    private CtMethod getJavassistMethod(JavaMethod method, CtClass clazz) throws Exception {
        int i;
        CtMethod[] methods = clazz.getDeclaredMethods();
        ArrayList<CtMethod> possible = new ArrayList<CtMethod>();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(method.getName()) || methods[i].getParameterTypes().length != method.getParameters().length) continue;
            possible.add(methods[i]);
        }
        if (possible.size() == 0) {
            throw new RuntimeException("cannot resolve method" + method.toString());
        }
        if (possible.size() == 1) {
            return (CtMethod)possible.get(0);
        }
        for (i = 0; i < possible.size(); ++i) {
            CtMethod ctMethod = (CtMethod)possible.get(i);
            CtClass[] params = ctMethod.getParameterTypes();
            boolean bad = false;
            for (int k = 0; k < params.length; ++k) {
                if (params[k].getName().equals(method.getParameters()[k].getType().toString())) continue;
                bad = true;
                break;
            }
            if (bad) continue;
            return ctMethod;
        }
        throw new RuntimeException("cannot resolve method" + method.toString());
    }

    private CtConstructor getJavassistConstructor(JavaMethod method, CtClass clazz) throws Exception {
        int i;
        CtConstructor[] cons = clazz.getDeclaredConstructors();
        ArrayList<CtConstructor> possible = new ArrayList<CtConstructor>();
        for (i = 0; i < cons.length; ++i) {
            if (cons[i].getParameterTypes().length != method.getParameters().length) continue;
            possible.add(cons[i]);
        }
        if (possible.size() == 0) {
            throw new RuntimeException("cannot resolve constructor" + method.toString());
        }
        if (possible.size() == 1) {
            return (CtConstructor)possible.get(0);
        }
        for (i = 0; i < possible.size(); ++i) {
            CtConstructor ctCon = (CtConstructor)possible.get(i);
            CtClass[] params = ctCon.getParameterTypes();
            boolean bad = false;
            for (int k = 0; k < params.length; ++k) {
                if (params[k].getName().equals(method.getParameters()[k].getType().toString())) continue;
                bad = true;
                break;
            }
            if (bad) continue;
            return ctCon;
        }
        throw new RuntimeException("cannot resolve constructor" + method.toString());
    }

    private void compileClass(JavaClass clazz) throws Exception {
        AnnotationDocletTag tag;
        int i;
        CtClass ctClass = this.pool.get(clazz.getFullyQualifiedName());
        boolean modified = false;
        for (i = 0; i < clazz.getTags().length; ++i) {
            AnnotationDocletTag tag2 = (AnnotationDocletTag)clazz.getTags()[i];
            if (tag2.getAnnotation() == null) continue;
            modified = true;
            Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.pool, ctClass.getClassFile().getConstPool(), tag2.getAnnotation());
            AnnotationsAttribute visible = this.getVisibleAnnotationsAttribute(ctClass);
            visible.addAnnotation(info);
        }
        for (i = 0; i < clazz.getMethods().length; ++i) {
            JavaMethod method = clazz.getMethods()[i];
            for (int j = 0; j < method.getTags().length; ++j) {
                tag = (AnnotationDocletTag)method.getTags()[j];
                if (tag.getAnnotation() == null) continue;
                modified = true;
                if (method.isConstructor()) {
                    this.compileConstructor(method, tag, ctClass);
                    continue;
                }
                this.compileMethod(method, tag, ctClass);
            }
        }
        for (i = 0; i < clazz.getFields().length; ++i) {
            JavaField field = clazz.getFields()[i];
            for (int j = 0; j < field.getTags().length; ++j) {
                tag = (AnnotationDocletTag)field.getTags()[j];
                if (tag.getAnnotation() == null) continue;
                modified = true;
                this.compileField(field, tag, ctClass);
            }
        }
        if (modified) {
            String classFile = ctClass.getName().replace('.', '/') + ".class";
            URL url = Thread.currentThread().getContextClassLoader().getResource(classFile);
            if (!url.getProtocol().equals("file")) {
                throw new RuntimeException(".class file must not be in a jar: " + url.toString());
            }
            byte[] byteCode = ctClass.toBytecode();
            File fp = new File(url.getFile());
            FileOutputStream os = new FileOutputStream(new File(url.getFile()));
            os.write(byteCode);
            os.close();
            System.out.println("[compiled] " + fp);
        }
    }

    private AnnotationsAttribute getVisibleAnnotationsAttribute(CtClass ctClass) {
        AnnotationsAttribute visible = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            ClassFile cf = ctClass.getClassFile();
            visible = new AnnotationsAttribute(cf.getConstPool(), "RuntimeVisibleAnnotations");
            cf.addAttribute((AttributeInfo)visible);
        }
        return visible;
    }

    private void compileMethod(JavaMethod method, AnnotationDocletTag tag, CtClass clazz) throws Exception {
        CtMethod ctMethod = this.getJavassistMethod(method, clazz);
        MethodInfo minfo = ctMethod.getMethodInfo();
        Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.pool, minfo.getConstPool(), tag.getAnnotation());
        AnnotationsAttribute visible = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            visible = new AnnotationsAttribute(minfo.getConstPool(), "RuntimeVisibleAnnotations");
            minfo.addAttribute((AttributeInfo)visible);
        }
        visible.addAnnotation(info);
    }

    private void compileField(JavaField field, AnnotationDocletTag tag, CtClass clazz) throws Exception {
        CtField ctField = clazz.getDeclaredField(field.getName());
        FieldInfo minfo = ctField.getFieldInfo();
        Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.pool, minfo.getConstPool(), tag.getAnnotation());
        AnnotationsAttribute visible = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            visible = new AnnotationsAttribute(minfo.getConstPool(), "RuntimeVisibleAnnotations");
            minfo.addAttribute((AttributeInfo)visible);
        }
        visible.addAnnotation(info);
    }

    private void compileConstructor(JavaMethod method, AnnotationDocletTag tag, CtClass clazz) throws Exception {
        CtConstructor ctMethod = this.getJavassistConstructor(method, clazz);
        MethodInfo minfo = ctMethod.getMethodInfo();
        Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.pool, minfo.getConstPool(), tag.getAnnotation());
        AnnotationsAttribute visible = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            visible = new AnnotationsAttribute(minfo.getConstPool(), "RuntimeVisibleAnnotations");
            minfo.addAttribute((AttributeInfo)visible);
        }
        visible.addAnnotation(info);
    }
}

