/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.pointcut.ConstructorMatcher;
import org.jboss.aop.pointcut.FieldMatcher;
import org.jboss.aop.pointcut.MethodMatcher;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTAllParameter;
import org.jboss.aop.pointcut.ast.ASTAnd;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTBoolean;
import org.jboss.aop.pointcut.ast.ASTClass;
import org.jboss.aop.pointcut.ast.ASTComposite;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTNot;
import org.jboss.aop.pointcut.ast.ASTOr;
import org.jboss.aop.pointcut.ast.ASTParameter;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTSub;
import org.jboss.aop.pointcut.ast.Node;
import org.jboss.aop.pointcut.ast.SimpleNode;
import org.jboss.aop.pointcut.ast.TypeExpressionParserVisitor;

public class AnnotationMatcher
implements TypeExpressionParserVisitor {
    private ClassAdvisor advisor;
    private Object javassist;

    public AnnotationMatcher(ClassAdvisor advisor, Object javassist) {
        this.advisor = advisor;
        this.javassist = javassist;
    }

    public Object visit(ASTStart node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTBoolean node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTComposite node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTNot node, Object data) {
        Boolean bool = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        boolean val = bool;
        return val ? Boolean.FALSE : Boolean.TRUE;
    }

    public Object visit(ASTSub node, Object data) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            data = node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTAnd node, Object left) {
        Node andChild = node.jjtGetChild(0);
        boolean val = (Boolean)left;
        return new Boolean(val && (Boolean)andChild.jjtAccept(this, (Object)Boolean.FALSE) != false);
    }

    public Object visit(ASTOr node, Object left) {
        Node orChild = node.jjtGetChild(0);
        boolean val = (Boolean)left;
        return new Boolean(val || (Boolean)orChild.jjtAccept(this, (Object)Boolean.FALSE) != false);
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public CtClass getDeclaringClass() {
        if (this.javassist instanceof CtClass) {
            return (CtClass)this.javassist;
        }
        if (this.javassist instanceof CtMethod) {
            return ((CtMethod)this.javassist).getDeclaringClass();
        }
        if (this.javassist instanceof CtField) {
            return ((CtField)this.javassist).getDeclaringClass();
        }
        if (this.javassist instanceof CtConstructor) {
            return ((CtConstructor)this.javassist).getDeclaringClass();
        }
        throw new RuntimeException("Unknown!");
    }

    public Object visit(ASTHas node, Object data) {
        Node n = node.jjtGetChild(0);
        CtClass clazz = this.getDeclaringClass();
        if (n instanceof ASTMethod) {
            return new Boolean(Util.has(clazz, (ASTMethod)n, this.advisor));
        }
        return new Boolean(Util.has(clazz, (ASTConstructor)n, this.advisor));
    }

    public Object visit(ASTHasField node, Object data) {
        CtClass clazz = this.getDeclaringClass();
        ASTField f = (ASTField)node.jjtGetChild(0);
        return new Boolean(Util.has(clazz, f, this.advisor));
    }

    public Object visit(ASTClass node, Object data) {
        if (!(this.javassist instanceof CtClass)) {
            return Boolean.FALSE;
        }
        CtClass clazz = (CtClass)this.javassist;
        return new Boolean(Util.matchesClassExpr(node.getClazz(), clazz, (Advisor)this.advisor));
    }

    public Object visit(ASTMethod node, Object data) {
        if (!(this.javassist instanceof CtMethod)) {
            return Boolean.FALSE;
        }
        MethodMatcher methodMatcher = null;
        try {
            methodMatcher = new MethodMatcher((Advisor)this.advisor, (CtMethod)this.javassist, null);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return methodMatcher.matches(node);
    }

    public Object visit(ASTConstructor node, Object data) {
        if (!(this.javassist instanceof CtConstructor)) {
            return Boolean.FALSE;
        }
        ConstructorMatcher conMatcher = null;
        try {
            conMatcher = new ConstructorMatcher(this.advisor, (CtConstructor)this.javassist, null);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return conMatcher.matches(node);
    }

    public Object visit(ASTField node, Object data) {
        if (!(this.javassist instanceof CtField)) {
            return Boolean.FALSE;
        }
        FieldMatcher fieldMatcher = null;
        try {
            fieldMatcher = new FieldMatcher(this.advisor, (CtField)this.javassist, null);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return node.jjtAccept(fieldMatcher, null);
    }

    public Object visit(ASTAttribute node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTParameter node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTAllParameter node, Object data) {
        return Boolean.FALSE;
    }
}

