/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.MethodCall;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.MethodMatcher;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.WithinMatcher;
import org.jboss.aop.pointcut.ast.ASTCall;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTWithin;
import org.jboss.aop.pointcut.ast.ASTWithincode;
import org.jboss.aop.pointcut.ast.Node;

public class MethodCallMatcher
extends MatcherHelper {
    MethodCall call;
    ClassAdvisor advisor;

    public MethodCallMatcher(ClassAdvisor advisor, MethodCall call, ASTStart start) throws NotFoundException {
        super(start);
        this.advisor = advisor;
        this.call = call;
    }

    public Object visit(ASTCall node, Object data) {
        try {
            if (!(node.getBehavior() instanceof ASTMethod)) {
                return Boolean.FALSE;
            }
            ASTMethod astMethod = (ASTMethod)node.getBehavior();
            if (astMethod.getClazz().isSimple()) {
                if (!astMethod.getClazz().matches(this.call.getClassName())) {
                    return Boolean.FALSE;
                }
                if (!astMethod.getMethodIdentifier().isAnnotation() && !astMethod.getMethodIdentifier().matches(this.call.getMethodName())) {
                    return Boolean.FALSE;
                }
            }
            CtMethod calledMethod = this.call.getMethod();
            ClassAdvisor calledAdvisor = AspectManager.instance().getTempClassAdvisor(calledMethod.getDeclaringClass());
            MethodMatcher methodMatcher = new MethodMatcher((Advisor)calledAdvisor, calledMethod, null);
            return methodMatcher.matches(astMethod);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object visit(ASTHas node, Object data) {
        try {
            Node n = node.jjtGetChild(0);
            CtMethod method = this.call.getMethod();
            if (n instanceof ASTMethod) {
                return new Boolean(Util.has(method.getDeclaringClass(), (ASTMethod)n, this.advisor));
            }
            return new Boolean(Util.has(method.getDeclaringClass(), (ASTConstructor)n, this.advisor));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Object visit(ASTHasField node, Object data) {
        ASTField f = (ASTField)node.jjtGetChild(0);
        CtMethod method = null;
        try {
            method = this.call.getMethod();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return new Boolean(Util.has(method.getDeclaringClass(), f, this.advisor));
    }

    public Object visit(ASTWithin node, Object data) {
        WithinMatcher within = null;
        try {
            within = new WithinMatcher(this.advisor, this.call.where(), null);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return node.jjtAccept(within, null);
    }

    public Object visit(ASTWithincode node, Object data) {
        WithinMatcher within = null;
        try {
            within = new WithinMatcher(this.advisor, this.call.where(), null);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return node.jjtAccept(within, null);
    }

    protected Boolean resolvePointcut(Pointcut p) {
        try {
            return new Boolean(p.matchesCall(this.advisor, this.call));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

