/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.pointcut.CallMatcher;
import org.jboss.aop.pointcut.ConstructorCallMatcher;
import org.jboss.aop.pointcut.ExecutionConstructorMatcher;
import org.jboss.aop.pointcut.ExecutionMethodMatcher;
import org.jboss.aop.pointcut.FieldGetMatcher;
import org.jboss.aop.pointcut.FieldSetMatcher;
import org.jboss.aop.pointcut.MethodCallMatcher;
import org.jboss.aop.pointcut.NewExprMatcher;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.SoftClassMatcher;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;

public class PointcutExpression
implements Pointcut {
    protected String name;
    protected String expr;
    protected ASTStart ast;

    public PointcutExpression(String name, String expr) throws ParseException {
        this.name = name;
        this.expr = expr;
        this.ast = new PointcutExpressionParser(new StringReader(expr)).Start();
    }

    public String getName() {
        return this.name;
    }

    public String getExpr() {
        return this.expr;
    }

    public boolean softMatch(Advisor advisor) {
        SoftClassMatcher matcher = new SoftClassMatcher(advisor, advisor.getName(), this.ast);
        return matcher.matches();
    }

    public boolean matchesCall(ClassAdvisor callingAdvisor, MethodCall methodCall) throws NotFoundException {
        MethodCallMatcher matcher = new MethodCallMatcher(callingAdvisor, methodCall, this.ast);
        return matcher.matches();
    }

    public boolean matchesCall(ClassAdvisor callingAdvisor, NewExpr methodCall) throws NotFoundException {
        NewExprMatcher matcher = new NewExprMatcher(callingAdvisor, methodCall, this.ast);
        return matcher.matches();
    }

    public boolean matchesExecution(Advisor advisor, Method m) {
        ExecutionMethodMatcher matcher = new ExecutionMethodMatcher(advisor, m, this.ast);
        return matcher.matches();
    }

    public boolean matchesExecution(ClassAdvisor advisor, Constructor c) {
        ExecutionConstructorMatcher matcher = new ExecutionConstructorMatcher(advisor, c, this.ast);
        return matcher.matches();
    }

    public boolean matchesGet(ClassAdvisor advisor, Field f) {
        FieldGetMatcher matcher = new FieldGetMatcher(advisor, f, this.ast);
        return matcher.matches();
    }

    public boolean matchesSet(ClassAdvisor advisor, Field f) {
        FieldSetMatcher matcher = new FieldSetMatcher(advisor, f, this.ast);
        return matcher.matches();
    }

    public boolean matchesExecution(Advisor advisor, CtMethod m) throws NotFoundException {
        ExecutionMethodMatcher matcher = new ExecutionMethodMatcher(advisor, m, this.ast);
        return matcher.matches();
    }

    public boolean matchesExecution(ClassAdvisor advisor, CtConstructor c) throws NotFoundException {
        ExecutionConstructorMatcher matcher = new ExecutionConstructorMatcher(advisor, c, this.ast);
        return matcher.matches();
    }

    public boolean matchesGet(ClassAdvisor advisor, CtField f) throws NotFoundException {
        FieldGetMatcher matcher = new FieldGetMatcher(advisor, f, this.ast);
        return matcher.matches();
    }

    public boolean matchesSet(ClassAdvisor advisor, CtField f) throws NotFoundException {
        FieldSetMatcher matcher = new FieldSetMatcher(advisor, f, this.ast);
        return matcher.matches();
    }

    public boolean matchesCall(ClassAdvisor advisor, AccessibleObject within, Class calledClass, Method calledMethod) {
        CallMatcher matcher = new CallMatcher(advisor, within, calledClass, calledMethod, this.ast);
        return matcher.matches();
    }

    public boolean matchesCall(ClassAdvisor advisor, AccessibleObject within, Class calledClass, Constructor calledCon) {
        ConstructorCallMatcher matcher = new ConstructorCallMatcher(advisor, within, calledClass, calledCon, this.ast);
        return matcher.matches();
    }
}

