/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.pointcut.ConstructorMatcher;
import org.jboss.aop.pointcut.FieldGetMatcher;
import org.jboss.aop.pointcut.MethodMatcher;
import org.jboss.aop.pointcut.Typedef;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTException;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ClassExpression;

public class Util {
    public static boolean matchesClassExpr(ClassExpression classExpr, CtClass clazz, Advisor advisor) {
        try {
            if (classExpr.isAnnotation()) {
                String sub = classExpr.getOriginal().substring(1);
                if (advisor != null && advisor.getClassMetaData().hasTag(sub)) {
                    return true;
                }
                return advisor.hasAnnotation(clazz, sub);
            }
            if (classExpr.isInstanceOf()) {
                return Util.subtypeOf(clazz, classExpr);
            }
            if (classExpr.isTypedef()) {
                return Util.matchesTypedef(clazz, classExpr, advisor);
            }
            return classExpr.matches(clazz.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean matchesClassExpr(ClassExpression classExpr, Class clazz, Advisor advisor) {
        try {
            if (classExpr.isAnnotation()) {
                String sub = classExpr.getOriginal().substring(1);
                if (advisor != null && advisor.getClassMetaData().hasTag(sub)) {
                    return true;
                }
                return advisor.hasAnnotation(sub);
            }
            if (classExpr.isInstanceOf()) {
                return Util.subtypeOf(clazz, classExpr);
            }
            if (classExpr.isTypedef()) {
                return Util.matchesTypedef(clazz, classExpr, advisor);
            }
            return classExpr.matches(clazz.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean subtypeOf(CtClass clazz, ClassExpression instanceOf) throws NotFoundException {
        if (clazz == null) {
            return false;
        }
        if (instanceOf.matches(clazz.getName())) {
            return true;
        }
        CtClass[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!Util.subtypeOf(interfaces[i], instanceOf)) continue;
            return true;
        }
        if (clazz.isInterface()) {
            return false;
        }
        return Util.subtypeOf(clazz.getSuperclass(), instanceOf);
    }

    public static boolean subtypeOf(Class clazz, ClassExpression instanceOf) {
        if (clazz == null) {
            return false;
        }
        if (instanceOf.matches(clazz.getName())) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!Util.subtypeOf(interfaces[i], instanceOf)) continue;
            return true;
        }
        if (clazz.isInterface()) {
            return false;
        }
        return Util.subtypeOf(clazz.getSuperclass(), instanceOf);
    }

    public static boolean has(CtClass target, ASTMethod method, ClassAdvisor advisor) {
        try {
            CtMethod[] methods = target.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                MethodMatcher matcher = new MethodMatcher((Advisor)advisor, methods[i], null);
                if (!matcher.matches(method).booleanValue()) continue;
                return true;
            }
            CtClass superClass = target.getSuperclass();
            if (superClass != null) {
                return Util.has(superClass, method, advisor);
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static boolean has(CtClass target, ASTField field, ClassAdvisor advisor) {
        try {
            CtField[] fields = target.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                FieldGetMatcher matcher = new FieldGetMatcher(advisor, fields[i], null);
                if (!((Boolean)field.jjtAccept(matcher, null)).booleanValue()) continue;
                return true;
            }
            CtClass superClass = target.getSuperclass();
            if (superClass != null) {
                return Util.has(superClass, field, advisor);
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static boolean has(CtClass target, ASTConstructor con, ClassAdvisor advisor) {
        try {
            CtConstructor[] cons = target.getDeclaredConstructors();
            for (int i = 0; i < cons.length; ++i) {
                ConstructorMatcher matcher = new ConstructorMatcher(advisor, cons[i], null);
                if (!matcher.matches(con).booleanValue()) continue;
                return true;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static boolean has(Class target, ASTMethod method, ClassAdvisor advisor) {
        Method[] methods = target.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodMatcher matcher = new MethodMatcher((Advisor)advisor, methods[i], null);
            if (!matcher.matches(method).booleanValue()) continue;
            return true;
        }
        Class superClass = target.getSuperclass();
        if (superClass != null) {
            return Util.has(superClass, method, advisor);
        }
        return false;
    }

    public static boolean has(Class target, ASTField field, ClassAdvisor advisor) {
        Field[] fields = target.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            FieldGetMatcher matcher = new FieldGetMatcher(advisor, fields[i], null);
            if (!((Boolean)field.jjtAccept(matcher, null)).booleanValue()) continue;
            return true;
        }
        Class superClass = target.getSuperclass();
        if (superClass != null) {
            return Util.has(superClass, field, advisor);
        }
        return false;
    }

    public static boolean has(Class target, ASTConstructor con, ClassAdvisor advisor) {
        Constructor<?>[] cons = target.getDeclaredConstructors();
        for (int i = 0; i < cons.length; ++i) {
            ConstructorMatcher matcher = new ConstructorMatcher(advisor, cons[i], null);
            if (!matcher.matches(con).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesTypedef(CtClass clazz, ClassExpression classExpr, Advisor advisor) {
        String original = classExpr.getOriginal();
        String typedefName = original.substring("$typedef{".length(), original.lastIndexOf("}"));
        Typedef typedef = AspectManager.instance().getTypedef(typedefName);
        return typedef.matches(advisor, clazz);
    }

    public static boolean matchesTypedef(Class clazz, ClassExpression classExpr, Advisor advisor) {
        String original = classExpr.getOriginal();
        String typedefName = original.substring("$typedef{".length(), original.lastIndexOf("}"));
        Typedef typedef = AspectManager.instance().getTypedef(typedefName);
        return typedef.matches(advisor, clazz);
    }

    public static boolean matchModifiers(ASTAttribute need, int have) {
        if (Modifier.isAbstract(need.attribute) && need.not) {
            return !Modifier.isAbstract(have);
        }
        if (Modifier.isAbstract(need.attribute) && !need.not) {
            return Modifier.isAbstract(have);
        }
        if (Modifier.isFinal(need.attribute) && need.not) {
            return !Modifier.isFinal(have);
        }
        if (Modifier.isFinal(need.attribute) && !need.not) {
            return Modifier.isFinal(have);
        }
        if (Modifier.isInterface(need.attribute) && need.not) {
            return !Modifier.isInterface(have);
        }
        if (Modifier.isInterface(need.attribute) && !need.not) {
            return Modifier.isInterface(have);
        }
        if (Modifier.isNative(need.attribute) && need.not) {
            return !Modifier.isNative(have);
        }
        if (Modifier.isNative(need.attribute) && !need.not) {
            return Modifier.isNative(have);
        }
        if (Modifier.isPrivate(need.attribute) && need.not) {
            return !Modifier.isPrivate(have);
        }
        if (Modifier.isPrivate(need.attribute) && !need.not) {
            return Modifier.isPrivate(have);
        }
        if (Modifier.isProtected(need.attribute) && need.not) {
            return !Modifier.isProtected(have);
        }
        if (Modifier.isProtected(need.attribute) && !need.not) {
            return Modifier.isProtected(have);
        }
        if (Modifier.isPublic(need.attribute) && need.not) {
            return !Modifier.isPublic(have);
        }
        if (Modifier.isPublic(need.attribute) && !need.not) {
            return Modifier.isPublic(have);
        }
        if (Modifier.isStatic(need.attribute) && need.not) {
            return !Modifier.isStatic(have);
        }
        if (Modifier.isStatic(need.attribute) && !need.not) {
            return Modifier.isStatic(have);
        }
        if (Modifier.isStrict(need.attribute) && need.not) {
            return !Modifier.isStrict(have);
        }
        if (Modifier.isStrict(need.attribute) && !need.not) {
            return Modifier.isStrict(have);
        }
        if (Modifier.isSynchronized(need.attribute) && need.not) {
            return !Modifier.isSynchronized(have);
        }
        if (Modifier.isSynchronized(need.attribute) && !need.not) {
            return Modifier.isSynchronized(have);
        }
        if (Modifier.isTransient(need.attribute) && need.not) {
            return !Modifier.isTransient(have);
        }
        if (Modifier.isTransient(need.attribute) && !need.not) {
            return Modifier.isTransient(have);
        }
        if (Modifier.isVolatile(need.attribute) && need.not) {
            return !Modifier.isVolatile(have);
        }
        if (Modifier.isVolatile(need.attribute) && !need.not) {
            return Modifier.isVolatile(have);
        }
        return true;
    }

    public static boolean matchExceptions(ArrayList nodeExceptions, CtClass[] foundExceptions) {
        if (nodeExceptions.size() > foundExceptions.length) {
            return false;
        }
        Iterator it = nodeExceptions.iterator();
        while (it.hasNext()) {
            boolean found = false;
            ASTException ex = (ASTException)it.next();
            for (int i = 0; i < foundExceptions.length; ++i) {
                if (!ex.getType().matches(foundExceptions[i].getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean matchExceptions(ArrayList nodeExceptions, Class[] foundExceptions) {
        if (nodeExceptions.size() > foundExceptions.length) {
            return false;
        }
        Iterator it = nodeExceptions.iterator();
        while (it.hasNext()) {
            boolean found = false;
            ASTException ex = (ASTException)it.next();
            for (int i = 0; i < foundExceptions.length; ++i) {
                if (!ex.getType().matches(foundExceptions[i].getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

