/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.RealmBase;
import org.jboss.logging.Logger;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.web.tomcat.security.JBossGenericPrincipal;
import org.jboss.web.tomcat.security.SecurityAssociationActions;
import org.jboss.web.tomcat.security.SecurityAssociationValve;

public class JBossSecurityMgrRealm
extends RealmBase
implements Realm {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$web$tomcat$security$JBossSecurityMgrRealm == null ? (class$org$jboss$web$tomcat$security$JBossSecurityMgrRealm = JBossSecurityMgrRealm.class$("org.jboss.web.tomcat.security.JBossSecurityMgrRealm")) : class$org$jboss$web$tomcat$security$JBossSecurityMgrRealm));
    private CertificatePrincipal certMapping = new SubjectDNMapping();
    private ConcurrentReaderHashMap userPrincipalMap = new ConcurrentReaderHashMap();
    private boolean trace;
    static /* synthetic */ Class class$org$jboss$web$tomcat$security$JBossSecurityMgrRealm;

    public void setCertificatePrincipal(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cpClass = loader.loadClass(className);
            this.certMapping = (CertificatePrincipal)cpClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Failed to load CertificatePrincipal: " + className), (Throwable)e);
            this.certMapping = new SubjectDNMapping();
        }
    }

    private Context getSecurityContext() {
        Context securityCtx = null;
        try {
            InitialContext iniCtx = new InitialContext();
            securityCtx = (Context)iniCtx.lookup("java:comp/env/security");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return securityCtx;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        this.trace = log.isTraceEnabled();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        super.stop();
    }

    public Principal authenticate(X509Certificate[] certs) {
        Principal principal = null;
        Context securityCtx = this.getSecurityContext();
        if (securityCtx == null) {
            if (this.trace) {
                log.trace((Object)"No security context for authenticate(X509Certificate[])");
            }
            return null;
        }
        try {
            SubjectSecurityManager securityMgr = (SubjectSecurityManager)securityCtx.lookup("securityMgr");
            principal = this.certMapping.toPrinicipal(certs);
            if (securityMgr.isValid(principal, (Object)certs)) {
                if (this.trace) {
                    log.trace((Object)("User: " + principal + " is authenticated"));
                }
                SecurityAssociationActions.setPrincipalInfo(principal, certs);
                RealmMapping realmMapping = (RealmMapping)securityCtx.lookup("realmMapping");
                Principal oldPrincipal = principal;
                principal = realmMapping.getPrincipal(oldPrincipal);
                if (this.trace) {
                    log.trace((Object)("Mapped from input principal: " + oldPrincipal + "to: " + principal));
                }
                if (!((Object)principal).equals(oldPrincipal)) {
                    this.userPrincipalMap.put((Object)principal, (Object)oldPrincipal);
                }
                principal = this.getCachingPrincpal(realmMapping, oldPrincipal, principal, certs);
            } else {
                if (this.trace) {
                    log.trace((Object)("User: " + principal + " is NOT authenticated"));
                }
                principal = null;
            }
        }
        catch (NamingException e) {
            log.error((Object)"Error during authenticate", (Throwable)e);
        }
        return principal;
    }

    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        return super.authenticate(username, digest, nonce, nc, cnonce, qop, realm, md5a2);
    }

    public Principal authenticate(String username, String credentials) {
        if (this.trace) {
            log.trace((Object)("Begin authenticate, username=" + username));
        }
        Object principal = null;
        Context securityCtx = this.getSecurityContext();
        if (securityCtx == null) {
            if (this.trace) {
                log.trace((Object)"No security context for authenticate(String, String)");
            }
            return null;
        }
        Principal caller = (Principal)SecurityAssociationValve.userPrincipal.get();
        if (caller == null && username == null && credentials == null) {
            return null;
        }
        try {
            SubjectSecurityManager securityMgr = (SubjectSecurityManager)securityCtx.lookup("securityMgr");
            principal = new SimplePrincipal(username);
            char[] passwordChars = null;
            if (credentials != null) {
                passwordChars = credentials.toCharArray();
            }
            if (securityMgr.isValid((Principal)principal, (Object)passwordChars)) {
                log.trace((Object)("User: " + username + " is authenticated"));
                SecurityAssociationActions.setPrincipalInfo((Principal)principal, passwordChars);
                RealmMapping realmMapping = (RealmMapping)securityCtx.lookup("realmMapping");
                SimplePrincipal oldPrincipal = principal;
                principal = realmMapping.getPrincipal((Principal)oldPrincipal);
                if (this.trace) {
                    log.trace((Object)("Mapped from input principal: " + oldPrincipal + "to: " + principal));
                }
                if (!principal.equals(oldPrincipal)) {
                    this.userPrincipalMap.put(principal, (Object)oldPrincipal);
                }
                principal = this.getCachingPrincpal(realmMapping, (Principal)oldPrincipal, (Principal)principal, credentials);
            } else {
                principal = null;
                if (this.trace) {
                    log.trace((Object)("User: " + username + " is NOT authenticated"));
                }
            }
        }
        catch (NamingException e) {
            principal = null;
            log.error((Object)"Error during authenticate", (Throwable)e);
        }
        if (this.trace) {
            log.trace((Object)("End authenticate, principal=" + principal));
        }
        return principal;
    }

    public Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, new String(credentials));
    }

    protected String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getPassword(String username) {
        String password = null;
        return password;
    }

    protected Principal getPrincipal(String username) {
        return new SimplePrincipal(username);
    }

    protected Principal getCachingPrincpal(RealmMapping realmMapping, Principal authPrincipal, Principal callerPrincipal, Object credential) {
        Set userRoles = realmMapping.getUserRoles(authPrincipal);
        ArrayList<String> roles = new ArrayList<String>();
        if (userRoles != null) {
            Iterator iterator = userRoles.iterator();
            while (iterator.hasNext()) {
                Principal role = (Principal)iterator.next();
                roles.add(role.getName());
            }
        }
        Subject subject = SecurityAssociationActions.getSubject();
        JBossGenericPrincipal gp = new JBossGenericPrincipal(this, subject, authPrincipal, callerPrincipal, credential, roles);
        return gp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

