/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Wrapper;
import org.apache.catalina.deploy.SecurityConstraint;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.security.JBossGenericPrincipal;
import org.jboss.web.tomcat.security.JBossSecurityMgrRealm;
import org.jboss.web.tomcat.security.JaccContextValve;

public class JaccAuthorizationRealm
extends JBossSecurityMgrRealm {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$web$tomcat$security$JaccAuthorizationRealm == null ? (class$org$jboss$web$tomcat$security$JaccAuthorizationRealm = JaccAuthorizationRealm.class$("org.jboss.web.tomcat.security.JaccAuthorizationRealm")) : class$org$jboss$web$tomcat$security$JaccAuthorizationRealm));
    private static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
    private static ThreadLocal activeRequest = new ThreadLocal();
    private boolean trace;
    private Policy policy = Policy.getPolicy();
    static /* synthetic */ Class class$org$jboss$web$tomcat$security$JaccAuthorizationRealm;

    public JaccAuthorizationRealm() {
        this.trace = log.isTraceEnabled();
    }

    public boolean hasResourcePermission(HttpRequest request, HttpResponse response, SecurityConstraint[] securityConstraints, Context context) throws IOException {
        Wrapper servlet = request.getWrapper();
        if (servlet != null) {
            activeRequest.set(servlet.getName());
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request.getRequest();
        WebResourcePermission perm = new WebResourcePermission(httpRequest);
        boolean allowed = this.checkSecurityAssociation((Permission)perm);
        if (this.trace) {
            log.trace((Object)("hasResourcePermission, perm=" + perm + ", allowed=" + allowed));
        }
        if (!allowed) {
            HttpServletResponse httpResponse = (HttpServletResponse)response.getResponse();
            httpResponse.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return allowed;
    }

    public boolean hasRole(Principal principal, String name) {
        String servletName = (String)activeRequest.get();
        WebRoleRefPermission perm = new WebRoleRefPermission(servletName, name);
        Principal[] principals = new Principal[]{principal};
        if (principal instanceof JBossGenericPrincipal) {
            JBossGenericPrincipal jgp = (JBossGenericPrincipal)((Object)principal);
            Set<Principal> principalsSet = jgp.getSubject().getPrincipals();
            principals = new Principal[principalsSet.size()];
            principalsSet.toArray(principals);
        }
        boolean allowed = this.checkSecurityAssociation((Permission)perm, principals);
        if (this.trace) {
            log.trace((Object)("hasRole, perm=" + perm + ", allowed=" + allowed));
        }
        return allowed;
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        boolean ok;
        block4: {
            HttpServletRequest httpRequest = (HttpServletRequest)request.getRequest();
            WebUserDataPermission perm = new WebUserDataPermission(httpRequest);
            if (this.trace) {
                log.trace((Object)("hasUserDataPermission, p=" + perm));
            }
            ok = false;
            try {
                ok = this.checkSecurityAssociation((Permission)perm, null);
            }
            catch (Exception e) {
                if (!this.trace) break block4;
                log.trace((Object)"Failed to checkSecurityAssociation", (Throwable)e);
            }
        }
        if (!ok) {
            ok = super.hasUserDataPermission(request, response, constraints);
        }
        return ok;
    }

    private boolean checkSecurityAssociation(Permission perm) {
        Subject caller;
        block4: {
            caller = null;
            try {
                caller = (Subject)PolicyContext.getContext((String)SUBJECT_CONTEXT_KEY);
            }
            catch (PolicyContextException e) {
                if (!this.trace) break block4;
                log.trace((Object)"Failed to get subject from PolicyContext", (Throwable)e);
            }
        }
        if (caller == null) {
            if (this.trace) {
                log.trace((Object)"Denied, no active subject found in PolicyContext");
            }
            return false;
        }
        Set<Principal> principalsSet = caller.getPrincipals();
        Principal[] principals = new Principal[principalsSet.size()];
        principalsSet.toArray(principals);
        return this.checkSecurityAssociation(perm, principals);
    }

    private boolean checkSecurityAssociation(Permission perm, Principal[] principals) {
        CodeSource webCS = (CodeSource)JaccContextValve.activeCS.get();
        ProtectionDomain pd = new ProtectionDomain(webCS, null, null, principals);
        boolean allowed = this.policy.implies(pd, perm);
        if (this.trace) {
            String msg = (allowed ? "Allowed: " : "Denied: ") + perm;
            log.trace((Object)msg);
        }
        return allowed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

