/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.statistics;

import javax.management.j2ee.statistics.TimeStatistic;
import org.jboss.management.j2ee.statistics.StatisticImpl;

public class TimeStatisticImpl
extends StatisticImpl
implements TimeStatistic {
    protected long count;
    protected long minTime;
    protected long maxTime;
    protected long totalTime;
    protected double requestRate;
    private long start = System.currentTimeMillis();

    public TimeStatisticImpl(String name, String units, String description) {
        super(name, units, description);
    }

    public long getCount() {
        return this.count;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public double getRequestRate() {
        return this.requestRate;
    }

    public String toString() {
        return "[ Count: " + this.getCount() + ", Min. Time: " + this.getMinTime() + ", Max. Time: " + this.getMaxTime() + ", Total Time: " + this.getTotalTime() + ", Request Rate: " + this.getRequestRate() + ", " + super.toString() + " ]";
    }

    public void add(long pTime) {
        ++this.count;
        if (pTime == 0L) {
            this.minTime = 1L;
        }
        if (this.minTime == 0L) {
            this.minTime = pTime;
        }
        this.minTime = pTime < this.minTime ? pTime : this.minTime;
        this.maxTime = pTime > this.maxTime ? pTime : this.maxTime;
        this.totalTime += pTime;
        this.requestRate = (System.currentTimeMillis() - this.start) / this.count;
    }

    public void reset() {
        this.count = 0L;
        this.minTime = 0L;
        this.maxTime = 0L;
        this.totalTime = 0L;
        this.requestRate = 0.0;
        super.reset();
    }

    public void set(long count, long minTime, long maxTime, long totalTime) {
        this.count = count;
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.totalTime = totalTime;
        this.requestRate = count == 0L ? Double.NaN : (double)(totalTime / count);
    }
}

