/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.Wrapper;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteRequestFacade;
import org.apache.tomcat.util.buf.MessageBytes;
import org.jboss.web.tomcat.security.JBossGenericPrincipal;

public class CustomPrincipalValve
extends ValveBase {
    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request.getRequest();
        Principal user = httpRequest.getUserPrincipal();
        Object wrappedRequest = request;
        if (user instanceof JBossGenericPrincipal) {
            CoyoteRequest coyteRequest = (CoyoteRequest)request;
            JBossGenericPrincipal guser = (JBossGenericPrincipal)((Object)user);
            Principal realUser = guser.getCallerPrincipal();
            wrappedRequest = new UserPrinicpalRequest(coyteRequest, realUser);
        }
        context.invokeNext(wrappedRequest, response);
    }

    static class UserPrinicipalServletRequest
    extends CoyoteRequestFacade {
        private Principal userPrincipal;

        UserPrinicipalServletRequest(CoyoteRequest request, Principal userPrincipal) {
            super(request);
            this.userPrincipal = userPrincipal;
        }

        public Principal getUserPrincipal() {
            return this.userPrincipal;
        }
    }

    static class UserPrinicpalRequest
    implements HttpRequest,
    HttpServletRequest {
        private CoyoteRequest delegate;
        private UserPrinicipalServletRequest httpRequest;
        private Principal userPrincipal;

        UserPrinicpalRequest(CoyoteRequest delegate, Principal userPrincipal) {
            this.delegate = delegate;
            this.userPrincipal = userPrincipal;
            this.httpRequest = new UserPrinicipalServletRequest(delegate, userPrincipal);
        }

        public String getAuthType() {
            return this.delegate.getAuthType();
        }

        public Cookie[] getCookies() {
            return this.delegate.getCookies();
        }

        public long getDateHeader(String name) {
            return this.delegate.getDateHeader(name);
        }

        public String getHeader(String name) {
            return this.delegate.getHeader(name);
        }

        public Enumeration getHeaders(String name) {
            return this.delegate.getHeaders(name);
        }

        public Enumeration getHeaderNames() {
            return this.delegate.getHeaderNames();
        }

        public int getIntHeader(String name) {
            return this.delegate.getIntHeader(name);
        }

        public String getMethod() {
            return this.delegate.getMethod();
        }

        public String getPathInfo() {
            return this.delegate.getPathInfo();
        }

        public String getPathTranslated() {
            return this.delegate.getPathTranslated();
        }

        public String getContextPath() {
            return this.delegate.getContextPath();
        }

        public String getQueryString() {
            return this.delegate.getQueryString();
        }

        public String getRemoteUser() {
            return this.delegate.getRemoteUser();
        }

        public boolean isUserInRole(String role) {
            return this.delegate.isUserInRole(role);
        }

        public Principal getUserPrincipal() {
            return this.userPrincipal;
        }

        public String getRequestedSessionId() {
            return this.delegate.getRequestedSessionId();
        }

        public String getRequestURI() {
            return this.delegate.getRequestURI();
        }

        public StringBuffer getRequestURL() {
            return this.delegate.getRequestURL();
        }

        public String getServletPath() {
            return this.delegate.getServletPath();
        }

        public HttpSession getSession(boolean create) {
            return this.delegate.getSession(create);
        }

        public HttpSession getSession() {
            return this.delegate.getSession();
        }

        public boolean isRequestedSessionIdValid() {
            return this.delegate.isRequestedSessionIdValid();
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.delegate.isRequestedSessionIdFromCookie();
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.delegate.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.delegate.isRequestedSessionIdFromUrl();
        }

        public Object getAttribute(String name) {
            return this.delegate.getAttribute(name);
        }

        public Enumeration getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        public String getCharacterEncoding() {
            return this.delegate.getCharacterEncoding();
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
            this.delegate.setCharacterEncoding(env);
        }

        public int getContentLength() {
            return this.delegate.getContentLength();
        }

        public String getContentType() {
            return this.delegate.getContentType();
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        public String getParameter(String name) {
            return this.delegate.getParameter(name);
        }

        public Enumeration getParameterNames() {
            return this.delegate.getParameterNames();
        }

        public String[] getParameterValues(String name) {
            return this.delegate.getParameterValues(name);
        }

        public Map getParameterMap() {
            return this.delegate.getParameterMap();
        }

        public String getProtocol() {
            return this.delegate.getProtocol();
        }

        public String getScheme() {
            return this.delegate.getScheme();
        }

        public String getServerName() {
            return this.delegate.getServerName();
        }

        public int getServerPort() {
            return this.delegate.getServerPort();
        }

        public BufferedReader getReader() throws IOException {
            return this.delegate.getReader();
        }

        public String getRemoteAddr() {
            return this.delegate.getRemoteAddr();
        }

        public String getRemoteHost() {
            return this.delegate.getRemoteHost();
        }

        public void setAttribute(String name, Object o) {
            this.delegate.setAttribute(name, o);
        }

        public void removeAttribute(String name) {
            this.delegate.removeAttribute(name);
        }

        public Locale getLocale() {
            return this.delegate.getLocale();
        }

        public Enumeration getLocales() {
            return this.delegate.getLocales();
        }

        public boolean isSecure() {
            return this.delegate.isSecure();
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return this.delegate.getRequestDispatcher(path);
        }

        public String getRealPath(String path) {
            return this.delegate.getRealPath(path);
        }

        public int getRemotePort() {
            return this.delegate.getRemotePort();
        }

        public String getLocalName() {
            return this.delegate.getLocalName();
        }

        public String getLocalAddr() {
            return this.delegate.getLocalAddr();
        }

        public int getLocalPort() {
            return this.delegate.getLocalPort();
        }

        public void addCookie(Cookie cookie) {
            this.delegate.addCookie(cookie);
        }

        public void addHeader(String name, String value) {
            this.delegate.addHeader(name, value);
        }

        public void addLocale(Locale locale) {
            this.delegate.addLocale(locale);
        }

        public void addParameter(String name, String[] values) {
            this.delegate.addParameter(name, values);
        }

        public void clearCookies() {
            this.delegate.clearCookies();
        }

        public void clearHeaders() {
            this.delegate.clearHeaders();
        }

        public void clearLocales() {
            this.delegate.clearLocales();
        }

        public void clearParameters() {
            this.delegate.clearParameters();
        }

        public void setAuthType(String type) {
            this.delegate.setAuthType(type);
        }

        public MessageBytes getContextPathMB() {
            return this.delegate.getContextPathMB();
        }

        public void setContextPath(String path) {
            this.delegate.setContextPath(path);
        }

        public void setMethod(String method) {
            this.delegate.setMethod(method);
        }

        public void setQueryString(String query) {
            this.delegate.setQueryString(query);
        }

        public MessageBytes getPathInfoMB() {
            return this.delegate.getPathInfoMB();
        }

        public void setPathInfo(String path) {
            this.delegate.setPathInfo(path);
        }

        public MessageBytes getRequestPathMB() {
            return this.delegate.getRequestPathMB();
        }

        public void setRequestedSessionCookie(boolean flag) {
            this.delegate.setRequestedSessionCookie(flag);
        }

        public void setRequestedSessionId(String id) {
            this.delegate.setRequestedSessionId(id);
        }

        public void setRequestedSessionURL(boolean flag) {
            this.delegate.setRequestedSessionURL(flag);
        }

        public void setRequestURI(String uri) {
            this.delegate.setRequestURI(uri);
        }

        public void setDecodedRequestURI(String uri) {
            this.delegate.setDecodedRequestURI(uri);
        }

        public String getDecodedRequestURI() {
            return this.delegate.getDecodedRequestURI();
        }

        public MessageBytes getDecodedRequestURIMB() {
            return this.delegate.getDecodedRequestURIMB();
        }

        public MessageBytes getServletPathMB() {
            return this.delegate.getServletPathMB();
        }

        public void setServletPath(String path) {
            this.delegate.setServletPath(path);
        }

        public void setUserPrincipal(Principal principal) {
            this.delegate.setUserPrincipal(principal);
        }

        public String getAuthorization() {
            return this.delegate.getAuthorization();
        }

        public void setAuthorization(String authorization) {
            this.delegate.setAuthorization(authorization);
        }

        public Connector getConnector() {
            return this.delegate.getConnector();
        }

        public void setConnector(Connector connector) {
            this.delegate.setConnector(connector);
        }

        public Context getContext() {
            return this.delegate.getContext();
        }

        public void setContext(Context context) {
            this.delegate.setContext(context);
        }

        public FilterChain getFilterChain() {
            return this.delegate.getFilterChain();
        }

        public void setFilterChain(FilterChain filterChain) {
            this.delegate.setFilterChain(filterChain);
        }

        public Host getHost() {
            return this.delegate.getHost();
        }

        public void setHost(Host host) {
            this.delegate.setHost(host);
        }

        public String getInfo() {
            return this.delegate.getInfo();
        }

        public ServletRequest getRequest() {
            return this.httpRequest;
        }

        public Response getResponse() {
            return this.delegate.getResponse();
        }

        public void setResponse(Response response) {
            this.delegate.setResponse(response);
        }

        public Socket getSocket() {
            return this.delegate.getSocket();
        }

        public void setSocket(Socket socket) {
            this.delegate.setSocket(socket);
        }

        public InputStream getStream() {
            return this.delegate.getStream();
        }

        public void setStream(InputStream stream) {
            this.delegate.setStream(stream);
        }

        public ValveContext getValveContext() {
            return this.delegate.getValveContext();
        }

        public void setValveContext(ValveContext valveContext) {
            this.delegate.setValveContext(valveContext);
        }

        public Wrapper getWrapper() {
            return this.delegate.getWrapper();
        }

        public void setWrapper(Wrapper wrapper) {
            this.delegate.setWrapper(wrapper);
        }

        public ServletInputStream createInputStream() throws IOException {
            return this.delegate.createInputStream();
        }

        public void finishRequest() throws IOException {
            this.delegate.finishRequest();
        }

        public Object getNote(String name) {
            return this.delegate.getNote(name);
        }

        public Iterator getNoteNames() {
            return this.delegate.getNoteNames();
        }

        public void recycle() {
            this.delegate.recycle();
        }

        public void removeNote(String name) {
            this.delegate.removeNote(name);
        }

        public void setContentLength(int length) {
            this.delegate.setContentLength(length);
        }

        public void setContentType(String type) {
            this.delegate.setContentType(type);
        }

        public void setNote(String name, Object value) {
            this.delegate.setNote(name, value);
        }

        public void setProtocol(String protocol) {
            this.delegate.setProtocol(protocol);
        }

        public void setRemoteAddr(String remote) {
            this.delegate.setRemoteAddr(remote);
        }

        public void setScheme(String scheme) {
            this.delegate.setScheme(scheme);
        }

        public void setSecure(boolean secure) {
            this.delegate.setSecure(secure);
        }

        public void setServerName(String name) {
            this.delegate.setServerName(name);
        }

        public void setServerPort(int port) {
            this.delegate.setServerPort(port);
        }
    }
}

