/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.net.ServerSocketFactory;
import org.jboss.security.SecurityDomain;
import org.jboss.security.ssl.DomainServerSocketFactory;

public class SSLServerSocketFactory
implements ServerSocketFactory {
    private DomainServerSocketFactory socketFactory;

    public SSLServerSocketFactory() {
    }

    public SSLServerSocketFactory(SecurityDomain securityDomain) throws IOException {
        this.socketFactory = new DomainServerSocketFactory(securityDomain);
    }

    public void setSecurityDomainName(String jndiName) throws NamingException, IOException {
        InitialContext iniCtx = new InitialContext();
        SecurityDomain securityDomain = (SecurityDomain)iniCtx.lookup(jndiName);
        this.socketFactory = new DomainServerSocketFactory(securityDomain);
    }

    public ServerSocket createSocket(int port) throws IOException {
        return this.createSocket(port, 50, null);
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        return this.createSocket(port, backlog, null);
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return this.socketFactory.createServerSocket(port, backlog, ifAddress);
    }
}

