/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.Principal;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.ValveContext;
import org.apache.catalina.Wrapper;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.metadata.WebMetaData;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.web.tomcat.security.JBossGenericPrincipal;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

public class SecurityAssociationValve
extends ValveBase {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$web$tomcat$security$SecurityAssociationValve == null ? (class$org$jboss$web$tomcat$security$SecurityAssociationValve = SecurityAssociationValve.class$("org.jboss.web.tomcat.security.SecurityAssociationValve")) : class$org$jboss$web$tomcat$security$SecurityAssociationValve));
    public static ThreadLocal userPrincipal = new ThreadLocal();
    private WebMetaData metaData;
    private String subjectAttributeName = null;
    private JaasSecurityManagerServiceMBean secMgrService;
    private boolean trace;
    static /* synthetic */ Class class$org$jboss$web$tomcat$security$SecurityAssociationValve;

    public SecurityAssociationValve(WebMetaData metaData, JaasSecurityManagerServiceMBean secMgrService) {
        this.metaData = metaData;
        this.secMgrService = secMgrService;
        this.trace = log.isTraceEnabled();
    }

    public void setSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeName = subjectAttributeName;
        if (subjectAttributeName != null && subjectAttributeName.length() == 0) {
            this.subjectAttributeName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        Session session = null;
        HttpServletRequest httpRequest = (HttpServletRequest)request.getRequest();
        Principal caller = httpRequest.getUserPrincipal();
        JBossGenericPrincipal principal = null;
        HttpSession hsession = httpRequest.getSession(false);
        try {
            String runAsRole = null;
            try {
                Context securityCtx;
                Wrapper servlet = request.getWrapper();
                if (servlet != null) {
                    runAsRole = servlet.getRunAs();
                    if (this.trace) {
                        log.trace((Object)(servlet.getName() + ", runAs: " + runAsRole));
                    }
                    RunAsIdentity identity = null;
                    if (runAsRole != null) {
                        identity = new RunAsIdentity(runAsRole, null);
                    }
                    SecurityAssociationActions.pushRunAsIdentity(identity);
                }
                userPrincipal.set(caller);
                Manager manager = this.container.getManager();
                if (manager != null && hsession != null) {
                    try {
                        session = manager.findSession(hsession.getId());
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                if (caller == null || !(caller instanceof JBossGenericPrincipal)) {
                    if (session != null) {
                        principal = (JBossGenericPrincipal)((Object)session.getPrincipal());
                    }
                } else {
                    principal = (JBossGenericPrincipal)((Object)caller);
                }
                if (principal != null) {
                    if (this.trace) {
                        log.trace((Object)"Restoring principal info from cache");
                    }
                    SecurityAssociationActions.setPrincipalInfo(principal.getAuthPrincipal(), principal.getCredentials(), principal.getSubject());
                }
                if (this.subjectAttributeName != null && (securityCtx = this.getSecurityContext()) != null) {
                    AuthenticationManager securityMgr = (AuthenticationManager)securityCtx.lookup("securityMgr");
                    Subject subject = securityMgr.getActiveSubject();
                    request.getRequest().setAttribute(this.subjectAttributeName, (Object)subject);
                }
            }
            catch (Throwable e) {
                log.debug((Object)"Failed to determine servlet", e);
            }
            context.invokeNext(request, response);
            SecurityAssociationActions.popRunAsIdentity();
            if (this.secMgrService != null && session != null && !session.isValid() && this.metaData.isFlushOnSessionInvalidation() && principal != null) {
                String securityDomain = this.metaData.getSecurityDomain();
                if (this.trace) {
                    log.trace((Object)("Session is invalid, security domain: " + securityDomain + ", user=" + (Object)((Object)principal)));
                }
                try {
                    Principal authPrincipal = principal.getAuthPrincipal();
                    this.secMgrService.flushAuthenticationCache(securityDomain, authPrincipal);
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to flush auth cache", (Throwable)e);
                }
            }
        }
        finally {
            SecurityAssociationActions.clear();
            userPrincipal.set(null);
        }
    }

    private Context getSecurityContext() {
        Context securityCtx = null;
        try {
            InitialContext iniCtx = new InitialContext();
            securityCtx = (Context)iniCtx.lookup("java:comp/env/security");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return securityCtx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

