/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.tc5.session.AbstractJBossManager;

abstract class ClusteredSession
extends StandardSession {
    private static final long serialVersionUID = -758573655613558722L;
    protected static Logger log = Logger.getLogger((Class)(class$org$jboss$web$tomcat$tc5$session$ClusteredSession == null ? (class$org$jboss$web$tomcat$tc5$session$ClusteredSession = ClusteredSession.class$("org.jboss.web.tomcat.tc5.session.ClusteredSession")) : class$org$jboss$web$tomcat$tc5$session$ClusteredSession));
    protected static final String info = "ClusteredSession/1.0";
    protected int invalidationPolicy;
    protected static StringManager sm = StringManager.getManager((String)"org.jboss.web.tomcat.session");
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$session$ClusteredSession;

    public ClusteredSession(AbstractJBossManager manager) {
        super((Manager)manager);
        this.invalidationPolicy = ((AbstractJBossManager)this.manager).getInvalidateSessionPolicy();
    }

    public abstract void initAfterLoad(AbstractJBossManager var1);

    public void setManager(Manager manager) {
        super.setManager(manager);
        this.manager = manager;
    }

    public abstract void processSessionRepl();

    public abstract void removeMyself();

    public abstract void removeMyselfLocal();

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttribute.ise"));
        }
        return this.getAttributeInternal(name);
    }

    public Enumeration getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
        }
        return new Enumerator(this.getAttributesInternal().keySet(), true);
    }

    public void setAttribute(String name, Object value) {
        Context context;
        Object[] listeners;
        Object unbound;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.setAttribute.ise"));
        }
        if (this.manager != null && this.manager.getDistributable() && !(value instanceof Serializable)) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.iae"));
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            try {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            catch (Throwable t) {
                this.log(sm.getString("standardSession.bindingEvent"), t);
            }
        }
        if ((unbound = this.setInternalAttribute(name, value)) != null && unbound instanceof HttpSessionBindingListener) {
            try {
                ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent(this.getSession(), name));
            }
            catch (Throwable t) {
                this.log(sm.getString("standardSession.bindingEvent"), t);
            }
        }
        if ((listeners = (context = (Context)this.manager.getContainer()).getApplicationEventListeners()) == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
            try {
                if (unbound != null) {
                    this.fireContainerEvent(context, "beforeSessionAttributeReplaced", listener);
                    if (event == null) {
                        event = new HttpSessionBindingEvent(this.getSession(), name, unbound);
                    }
                    listener.attributeReplaced(event);
                    this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    continue;
                }
                this.fireContainerEvent(context, "beforeSessionAttributeAdded", listener);
                if (event == null) {
                    event = new HttpSessionBindingEvent(this.getSession(), name, value);
                }
                listener.attributeAdded(event);
                this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                continue;
            }
            catch (Throwable t) {
                try {
                    if (unbound != null) {
                        this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    } else {
                        this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.log(sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(boolean notify) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("The session has expired with id: " + this.id));
        }
        if (this.expiring) {
            return;
        }
        ClusteredSession clusteredSession = this;
        synchronized (clusteredSession) {
            if (this.manager == null) {
                return;
            }
            this.expiring = true;
            Context context = (Context)this.manager.getContainer();
            Object[] listeners = context.getApplicationLifecycleListeners();
            if (notify && listeners != null) {
                HttpSessionEvent event = new HttpSessionEvent(this.getSession());
                for (int i = 0; i < listeners.length; ++i) {
                    int j = listeners.length - 1 - i;
                    if (!(listeners[j] instanceof HttpSessionListener)) continue;
                    HttpSessionListener listener = (HttpSessionListener)listeners[j];
                    try {
                        this.fireContainerEvent(context, "beforeSessionDestroyed", listener);
                        listener.sessionDestroyed(event);
                        this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                        continue;
                    }
                    catch (Throwable t) {
                        try {
                            this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.log(sm.getString("standardSession.sessionEvent"), t);
                    }
                }
            }
            this.accessCount = 0;
            this.setValid(false);
            if (notify) {
                this.fireSessionEvent("destroySession", null);
            }
            this.expiring = false;
            if (this.manager != null) {
                ((AbstractJBossManager)this.manager).removeLocal((Session)this);
            }
        }
    }

    public void passivate() {
    }

    public void activate() {
    }

    protected String[] keys() {
        return this.getAttributesInternal().keySet().toArray(EMPTY_ARRAY);
    }

    protected void removeAttributeInternal(String name, boolean notify) {
        Context context;
        Object[] listeners;
        Object value = this.removeJBossInternalAttribute(name);
        if (!notify || value == null) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if ((listeners = (context = (Context)this.manager.getContainer()).getApplicationEventListeners()) == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
            try {
                this.fireContainerEvent(context, "beforeSessionAttributeRemoved", listener);
                if (event == null) {
                    event = new HttpSessionBindingEvent(this.getSession(), name, value);
                }
                listener.attributeRemoved(event);
                this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                continue;
            }
            catch (Throwable t) {
                try {
                    this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.log(sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    protected Object getAttributeInternal(String name) {
        return this.getJBossInternalAttribute(name);
    }

    protected Map getAttributesInternal() {
        return this.getJBossInternalAttributes();
    }

    protected Object setInternalAttribute(String name, Object value) {
        return this.setJBossInternalAttribute(name, value);
    }

    protected abstract Object getJBossInternalAttribute(String var1);

    protected abstract Object removeJBossInternalAttribute(String var1);

    protected abstract Map getJBossInternalAttributes();

    protected abstract Object setJBossInternalAttribute(String var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeObject(ObjectOutputStream out) throws IOException {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            out.defaultWriteObject();
        }
    }

    protected void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

