/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.jboss.metadata.WebMetaData;
import org.jboss.web.tomcat.tc5.session.AttributeBasedClusteredSession;
import org.jboss.web.tomcat.tc5.session.ClusteredSession;
import org.jboss.web.tomcat.tc5.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.tc5.session.JBossCacheService;
import org.jboss.web.tomcat.tc5.session.JBossManager;
import org.jboss.web.tomcat.tc5.session.SessionBasedClusteredSession;

public class JBossCacheManager
extends JBossManager {
    private static final String info_ = "JBossCacheManager/1.0";
    private InitialContext initialContext_;
    private JBossCacheService proxy_;
    protected boolean useJK_ = false;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$JvmRouteFilter;

    public void init(String name, WebMetaData webMetaData, boolean useJK, boolean useLocalCache) throws ClusteringNotSupportedException {
        super.init(name, webMetaData, useJK, useLocalCache);
        this.useJK_ = useJK;
        try {
            this.proxy_ = new JBossCacheService();
        }
        catch (Throwable t) {
            String str = "JBossCacheService to Tomcat clustering not found";
            this.log_.error((Object)str);
            throw new ClusteringNotSupportedException(str);
        }
    }

    public JBossCacheService getCacheService() {
        return this.proxy_;
    }

    public void start() throws LifecycleException {
        super.start();
        if (this.useJK_) {
            boolean hasFilterCreated = false;
            Context context = (Context)this.container_;
            context.getServletContext().setAttribute("AbstractJBossManager", (Object)this);
            String filterName = "JvmRouteFilter";
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("start(): we are using mod_jk(2) for load-balancing. Will add " + filterName));
            }
            FilterDef def = new FilterDef();
            def.setFilterName(filterName);
            def.setDescription("Filter to re-package the session id with jvmroute if failing-over under mod_jk(2)");
            def.setFilterClass((class$org$jboss$web$tomcat$tc5$JvmRouteFilter == null ? (class$org$jboss$web$tomcat$tc5$JvmRouteFilter = JBossCacheManager.class$("org.jboss.web.tomcat.tc5.JvmRouteFilter")) : class$org$jboss$web$tomcat$tc5$JvmRouteFilter).getName());
            FilterDef[] defs = context.findFilterDefs();
            for (int i = 0; i < defs.length; ++i) {
                FilterDef d = defs[i];
                if (!d.getFilterName().equals(filterName)) continue;
                hasFilterCreated = true;
                break;
            }
            if (!hasFilterCreated) {
                context.addFilterDef(def);
            }
            FilterMap map = new FilterMap();
            map.setFilterName(filterName);
            map.setURLPattern("/*");
            context.addFilterMap(map);
        }
        ClassLoader tcl = super.getContainer().getLoader().getClassLoader();
        this.proxy_.start(tcl, this);
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)"start(): JBossCacheService started");
        }
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.proxy_.stop();
    }

    public Session createSession() {
        ClusteredSession session = null;
        if (this.replicationGranularity_ == 1) {
            session = new AttributeBasedClusteredSession(this);
        } else if (this.replicationGranularity_ == 0) {
            session = new SessionBasedClusteredSession(this);
        }
        session.setNew(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval_);
        String sessionId = this.getNextId();
        if (this.useJK_) {
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("createSession(): useJK is true. Will append JvmRoute: " + this.getJvmRoute()));
            }
            sessionId = sessionId + "." + this.getJvmRoute();
        }
        session.setValid(true);
        session.setId(sessionId);
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Creating an ClusteredSession with id: " + session.getId()));
        }
        ++this.createdCounter_;
        return session;
    }

    public boolean storeSession(Session baseSession) {
        if (!(baseSession instanceof ClusteredSession)) {
            throw new IllegalArgumentException("You can only add ClusteredSessions to this Manager");
        }
        ClusteredSession session = (ClusteredSession)baseSession;
        if (session == null) {
            return false;
        }
        if (session.isValid()) {
            this.sessions_.put(this.getRealId(session.getId()), session);
            String id = session.getId();
            long beginPassivate = System.currentTimeMillis();
            session.passivate();
            long endPassivate = System.currentTimeMillis();
            this.stats_.updatePassivationStats(id, endPassivate - beginPassivate);
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("check to see if needs to store and replicate session with id " + id));
            }
            long beginReplication = System.currentTimeMillis();
            this.processSessionRepl(session);
            long endReplication = System.currentTimeMillis();
            this.stats_.updateReplicationStats(id, endReplication - beginReplication);
            return true;
        }
        return false;
    }

    public void add(Session session) {
        if (session == null) {
            return;
        }
        if (!session.isValid()) {
            this.log_.error((Object)("Cannot add session with id=" + session.getId() + " because it is invalid"));
            return;
        }
        if (this.maxActive_ != -1 && this.activeCounter_ >= this.maxActive_) {
            ++this.rejectedCounter_;
            throw new IllegalStateException("JBossCacheManager.add(): number of active sessions exceeds the maximum limit: " + this.maxActive_ + " when trying to add session id " + session.getId());
        }
        if (this.storeSession((Session)((ClusteredSession)session))) {
            ++this.activeCounter_;
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)("Session with id=" + session.getId() + " added. Current active sessions " + this.activeCounter_));
            }
        }
    }

    public Session createEmptySession() {
        throw new RuntimeException("JBossManager.createEmptySession(). Method not implemented");
    }

    public Session findSession(String id) {
        String realId = this.getRealId(id);
        Session session = (Session)this.sessions_.get(realId);
        if (session != null) {
            return session;
        }
        return this.loadSession(realId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] findSessions() {
        ClusteredSession[] sess = new ClusteredSession[]{};
        Map map = this.sessions_;
        synchronized (map) {
            sess = this.sessions_.values().toArray(sess);
        }
        return sess;
    }

    public void remove(Session session) {
        String id = session.getId();
        if (id == null) {
            return;
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Removing session from store with id: " + id));
        }
        ((ClusteredSession)session).removeMyself();
        this.sessions_.remove(this.getRealId(session.getId()));
        --this.activeCounter_;
    }

    public void removeLocal(Session session) {
        String id = session.getId();
        if (id == null) {
            return;
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Removing session from local store with id: " + id));
        }
        ((ClusteredSession)session).removeMyselfLocal();
        this.sessions_.remove(this.getRealId(session.getId()));
        ++this.expiredCounter_;
        --this.activeCounter_;
    }

    protected Session loadSession(String realId) {
        ClusteredSession session = null;
        if (realId == null) {
            return null;
        }
        session = (ClusteredSession)((Object)this.proxy_.getSession(realId));
        if (session != null) {
            session.initAfterLoad(this);
            this.sessions_.put(this.getRealId(session.getId()), session);
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("loadSession(): id= " + realId + ", session=" + (Object)((Object)session)));
        }
        return session;
    }

    protected void processSessionRepl(ClusteredSession session) {
        UserTransaction tx = this.getNewTransaction();
        try {
            tx.begin();
            session.processSessionRepl();
            tx.commit();
        }
        catch (Exception ex) {
            this.log_.error((Object)("processSessionRepl: failed with exception: " + ex));
            try {
                tx.rollback();
            }
            catch (Exception exn) {
                exn.printStackTrace();
            }
            throw new RuntimeException("JBossCacheManager.processSessionRepl(): failed to replicate session.", ex);
        }
    }

    private UserTransaction getNewTransaction() {
        try {
            UserTransaction t = (UserTransaction)this.getInitialContext().lookup("UserTransaction");
            return t;
        }
        catch (NamingException n) {
            this.initialContext_ = null;
            throw new RuntimeException("JBossCacheManager.getNewTransaction(): failed to look up UserTransaction. ", n);
        }
    }

    private InitialContext getInitialContext() throws NamingException {
        if (this.initialContext_ == null) {
            this.initialContext_ = new InitialContext();
        }
        return this.initialContext_;
    }

    private String getRealId(String id) {
        if (!this.useJK_) {
            return id;
        }
        int index = id.indexOf(".");
        if (index > 0) {
            return id.substring(0, id.indexOf("."));
        }
        return id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

