/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.invocation.MarshalledValue;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.web.tomcat.tc5.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.tc5.session.JBossCacheManager;
import org.jgroups.View;

public class JBossCacheService
implements TreeCacheListener {
    private TreeCacheMBean proxy_;
    private ObjectName cacheServiceName_;
    private static Logger log_ = Logger.getLogger((Class)(class$org$jboss$web$tomcat$tc5$session$JBossCacheService == null ? (class$org$jboss$web$tomcat$tc5$session$JBossCacheService = JBossCacheService.class$("org.jboss.web.tomcat.tc5.session.JBossCacheService")) : class$org$jboss$web$tomcat$tc5$session$JBossCacheService));
    public static final String SESSION = "JSESSION";
    public static final String ATTRIBUTE = "ATTRIBUTE";
    public static final String KEY = "ATRR_KEY";
    private static final int RETRY = 3;
    private ClassLoader tcl_;
    private JBossCacheManager manager_;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$session$JBossCacheService;
    static /* synthetic */ Class class$org$jboss$cache$TreeCacheMBean;

    public JBossCacheService() throws ClusteringNotSupportedException {
        try {
            this.cacheServiceName_ = new ObjectName("jboss.cache:service=TomcatClusteringCache");
            this.proxy_ = (TreeCacheMBean)MBeanProxyExt.create((Class)(class$org$jboss$cache$TreeCacheMBean == null ? (class$org$jboss$cache$TreeCacheMBean = JBossCacheService.class$("org.jboss.cache.TreeCacheMBean")) : class$org$jboss$cache$TreeCacheMBean), (ObjectName)this.cacheServiceName_);
            if (this.proxy_ == null) {
                throw new RuntimeException("JBossCacheService: locate null TomcatCacheMbean");
            }
        }
        catch (Throwable e) {
            String str = this.cacheServiceName_ + " service to Tomcat clustering not found";
            log_.error((Object)str);
            throw new ClusteringNotSupportedException(str);
        }
    }

    public void start(ClassLoader tcl, JBossCacheManager manager) {
        this.tcl_ = tcl;
        this.manager_ = manager;
        this.proxy_.addTreeCacheListener((TreeCacheListener)this);
    }

    public void stop() {
        this.proxy_.removeTreeCacheListener((TreeCacheListener)this);
    }

    public Object getSession(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getSessionFqn(realId);
        return this.getUnMarshalledValue(this._get(fqn, realId));
    }

    public Object putSession(String id, Object session) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getSessionFqn(realId);
        return this._put(fqn, realId, this.getMarshalledValue(session));
    }

    public Object removeSession(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getSessionFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove session from distributed store. Fqn: " + fqn));
        }
        return this.getUnMarshalledValue(this._remove(fqn, realId));
    }

    public void removeSessionLocal(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getSessionFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove session from my own distributed store only. Fqn: " + fqn));
        }
        this._evict(fqn);
    }

    public boolean exists(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getSessionFqn(realId);
        return this.proxy_.exists(fqn);
    }

    public Object getAttribute(String id, String key) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        return this.getUnMarshalledValue(this._get(fqn, key));
    }

    public Object putAttribute(String id, String key, Object value) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        return this._put(fqn, key, this.getMarshalledValue(value));
    }

    public void putAttribute(String id, Map map) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        Set set = map.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this._put(fqn, key, this.getMarshalledValue(map.get(key)));
        }
    }

    public void removeAttributes(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        this._remove(fqn);
    }

    public Object removeAttribute(String id, String key) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove attribute from distributed store. Fqn: " + fqn + " key: " + key));
        }
        return this.getUnMarshalledValue(this._remove(fqn, key));
    }

    public void removeAttributeLocal(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove attributes from my own distributed store only. Fqn: " + fqn));
        }
        this._evict(fqn);
    }

    public Set getAttributeKeys(String id) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("JBossCacheService: id is either null or empty");
        }
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            return this.proxy_.getKeys(fqn);
        }
        catch (CacheException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map getAttributes(String id) {
        if (id == null || id.length() == 0) {
            return new HashMap();
        }
        Set set = this.getAttributeKeys(id);
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = this.getAttribute(id, key);
            map.put(key, value);
        }
        return map;
    }

    protected Object _get(Fqn fqn, String id) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.proxy_.get(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache get ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache get after retry ... ", ex);
    }

    protected Object _put(Fqn fqn, String id, Object value) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.proxy_.put(fqn, (Object)id, value);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache put ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache put after retry ... ", ex);
    }

    protected Object _remove(Fqn fqn, String id) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.proxy_.remove(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache remove ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache remove after retry ... ", ex);
    }

    protected void _remove(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.proxy_.remove(fqn);
                return;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache remove ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache remove after retry ... ", ex);
    }

    protected void _evict(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.proxy_.evict(fqn);
                return;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache evict ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache evict after retry ... ", ex);
    }

    private String stripJvmRoute(String id) {
        int index = id.indexOf(".");
        if (index > 0) {
            return id.substring(0, index);
        }
        return id;
    }

    private Fqn getSessionFqn(String id) {
        Object[] objs = new Object[]{SESSION, id};
        return new Fqn(objs);
    }

    private Fqn getAttributeFqn(String id) {
        Object[] objs = new Object[]{SESSION, id, ATTRIBUTE};
        return new Fqn(objs);
    }

    private Object getMarshalledValue(Object value) {
        try {
            return new MarshalledValue(value);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUnMarshalledValue(Object mv) {
        if (mv == null) {
            return null;
        }
        ClassLoader prevTCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.tcl_);
        try {
            Object object = ((MarshalledValue)mv).get();
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
            Object var4_6 = null;
            return var4_6;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Object var4_7 = null;
            return var4_7;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevTCL);
        }
    }

    public void nodeCreated(Fqn fqn) {
    }

    public void nodeRemoved(Fqn fqn) {
        this.nodeDirty(fqn);
    }

    public void nodeLoaded(Fqn fqn) {
    }

    public void nodeModified(Fqn fqn) {
        this.nodeDirty(fqn);
    }

    protected void nodeDirty(Fqn fqn) {
    }

    public void nodeVisited(Fqn fqn) {
    }

    public void cacheStarted(TreeCache cache) {
    }

    public void cacheStopped(TreeCache cache) {
    }

    public void viewChange(View new_view) {
    }

    public void nodeEvicted(Fqn fqn) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

