/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.sso;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.ValveContext;
import org.apache.catalina.authenticator.SingleSignOn;
import org.jboss.web.tomcat.tc5.sso.SSOClusterManager;
import org.jboss.web.tomcat.tc5.sso.SingleSignOnEntry;
import org.jboss.web.tomcat.tc5.sso.TreeCacheSSOClusterManager;

public class ClusteredSingleSignOn
extends SingleSignOn {
    private String clusterManagerClass = (class$org$jboss$web$tomcat$tc5$sso$TreeCacheSSOClusterManager == null ? (class$org$jboss$web$tomcat$tc5$sso$TreeCacheSSOClusterManager = ClusteredSingleSignOn.class$("org.jboss.web.tomcat.tc5.sso.TreeCacheSSOClusterManager")) : class$org$jboss$web$tomcat$tc5$sso$TreeCacheSSOClusterManager).getName();
    private SSOClusterManager ssoClusterManager = null;
    private String treeCacheName = "jboss.cache:service=TomcatClusteringCache";
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$sso$ClusteredSingleSignOn;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$sso$TreeCacheSSOClusterManager;

    public SSOClusterManager getClusterManager() {
        return this.ssoClusterManager;
    }

    public void setClusterManager(SSOClusterManager clusterManager) {
        if (this.started && clusterManager != this.ssoClusterManager) {
            throw new IllegalStateException("already started -- cannot set a new SSOClusterManager");
        }
        this.ssoClusterManager = clusterManager;
        if (clusterManager != null) {
            this.clusterManagerClass = clusterManager.getClass().getName();
        }
    }

    public String getClusterManagerClass() {
        return this.clusterManagerClass;
    }

    public void setClusterManagerClass(String managerClass) {
        if (!this.started) {
            this.clusterManagerClass = managerClass;
        } else if (this.ssoClusterManager == null) {
            try {
                this.createClusterManager(managerClass);
            }
            catch (LifecycleException e) {
                this.log("Exception creating SSOClusterManager " + managerClass, e);
            }
        } else {
            this.log("Cannot set clusterManagerClass to " + managerClass + "; already started using " + this.clusterManagerClass);
        }
    }

    public String getTreeCacheName() {
        return this.treeCacheName;
    }

    public void setTreeCacheName(String cacheName) throws Exception {
        this.treeCacheName = cacheName;
        if (this.ssoClusterManager != null && this.ssoClusterManager instanceof TreeCacheSSOClusterManager) {
            ((TreeCacheSSOClusterManager)this.ssoClusterManager).setCacheName(cacheName);
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.createClusterManager(this.getClusterManagerClass());
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.start();
        }
        if (this.debug >= 1) {
            this.log("Started");
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.stop();
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.debug >= 1) {
            this.log("Stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (this.debug >= 1) {
            this.log("Process session destroyed on " + session);
        }
        String ssoId = null;
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            ssoId = (String)this.reverse.get(session);
        }
        if (ssoId == null) {
            return;
        }
        if (session.getMaxInactiveInterval() > 0 && System.currentTimeMillis() - session.getLastAccessedTime() >= (long)(session.getMaxInactiveInterval() * 1000)) {
            this.removeSession(ssoId, session);
        } else {
            this.logout(ssoId);
        }
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        SingleSignOnEntry entry;
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            context.invokeNext(request, response);
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        if (this.debug >= 1) {
            this.log("Process request for '" + hreq.getRequestURI() + "'");
        }
        if (hreq.getUserPrincipal() != null) {
            if (this.debug >= 1) {
                this.log(" Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            context.invokeNext(request, response);
            return;
        }
        if (this.debug >= 1) {
            this.log(" Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (this.debug >= 1) {
                this.log(" SSO cookie is not present");
            }
            context.invokeNext(request, response);
            return;
        }
        if (this.debug >= 1) {
            this.log(" Checking for cached principal for " + cookie.getValue());
        }
        if ((entry = this.getSingleSignOnEntry(cookie.getValue())) != null) {
            Principal ssoPrinc = entry.getPrincipal();
            if (this.debug >= 1) {
                this.log(" Found cached principal '" + (ssoPrinc == null ? "NULL" : ssoPrinc.getName()) + "' with auth type '" + entry.getAuthType() + "'");
            }
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            if (!this.getRequireReauthentication() && ssoPrinc != null) {
                ((HttpRequest)request).setAuthType(entry.getAuthType());
                ((HttpRequest)request).setUserPrincipal(ssoPrinc);
            }
        } else {
            if (this.debug >= 1) {
                this.log(" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            hres.addCookie(cookie);
        }
        context.invokeNext(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associate(String ssoId, Session session) {
        if (this.debug >= 1) {
            this.log("Associate sso id " + ssoId + " with session " + session);
        }
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        boolean added = false;
        if (sso != null) {
            added = sso.addSession(this, session);
        }
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.put(session, ssoId);
        }
        if (added && this.ssoClusterManager != null) {
            this.ssoClusterManager.addSession(ssoId, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.remove(session);
        }
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso == null) {
            return;
        }
        boolean removed = sso.removeSession(session);
        if (removed && this.ssoClusterManager != null) {
            this.ssoClusterManager.removeSession(ssoId, session);
        }
        if (sso.getSessionCount() == 0) {
            HashMap hashMap2 = this.cache;
            synchronized (hashMap2) {
                sso = (SingleSignOnEntry)this.cache.remove(ssoId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId) {
        if (this.debug >= 1) {
            this.log("Deregistering sso id '" + ssoId + "'");
        }
        SingleSignOnEntry sso = null;
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            sso = (SingleSignOnEntry)this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        Session[] sessions = sso.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (this.debug >= 2) {
                this.log(" Invalidating session " + sessions[i]);
            }
            HashMap hashMap2 = this.reverse;
            synchronized (hashMap2) {
                this.reverse.remove(sessions[i]);
            }
            sessions[i].expire();
        }
    }

    protected void logout(String ssoId) {
        this.deregister(ssoId);
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.logout(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry getSingleSignOnEntry(String ssoId) {
        SingleSignOnEntry sso = this.localLookup(ssoId);
        if (sso == null && this.ssoClusterManager != null && (sso = this.ssoClusterManager.lookup(ssoId)) != null) {
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                this.cache.put(ssoId, sso);
            }
        }
        return sso;
    }

    protected boolean reauthenticate(String ssoId, Realm realm, HttpRequest request) {
        Principal reauthPrincipal;
        String username;
        if (ssoId == null || realm == null) {
            return false;
        }
        boolean reauthenticated = false;
        SingleSignOnEntry entry = this.getSingleSignOnEntry(ssoId);
        if (entry != null && entry.getCanReauthenticate() && (username = entry.getUsername()) != null && (reauthPrincipal = realm.authenticate(username, entry.getPassword())) != null) {
            reauthenticated = true;
            request.setAuthType(entry.getAuthType());
            request.setUserPrincipal(reauthPrincipal);
        }
        return reauthenticated;
    }

    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        this.registerLocal(ssoId, principal, authType, username, password);
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.register(ssoId, authType, username, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry;
        if (this.debug >= 1) {
            this.log("Removing session " + session.toString() + " from sso id " + ssoId);
        }
        if ((entry = this.getSingleSignOnEntry(ssoId)) == null) {
            return;
        }
        boolean removed = entry.removeSession(session);
        if (removed && this.ssoClusterManager != null) {
            this.ssoClusterManager.removeSession(ssoId, session);
        }
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.remove(session);
        }
        if (entry.getSessionCount() == 0) {
            this.deregister(ssoId);
        }
    }

    protected void update(String ssoId, Principal principal, String authType, String username, String password) {
        boolean needToBroadcast = this.updateLocal(ssoId, principal, authType, username, password);
        if (needToBroadcast && this.ssoClusterManager != null) {
            this.ssoClusterManager.updateCredentials(ssoId, authType, username, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SingleSignOnEntry localLookup(String ssoId) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            return (SingleSignOnEntry)this.cache.get(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerLocal(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.debug >= 1) {
            this.log("Registering sso id '" + ssoId + "' for user '" + principal.getName() + "' with auth type '" + authType + "'");
        }
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(ssoId, new SingleSignOnEntry(principal, authType, username, password));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateLocal(String ssoId, Principal principal, String authType, String username, String password) {
        boolean shouldBroadcast = false;
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso != null) {
            if (!sso.getCanReauthenticate()) {
                if (this.debug >= 1) {
                    this.log("Update sso id " + ssoId + " to auth type " + authType);
                }
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    shouldBroadcast = sso.updateCredentials(principal, authType, username, password);
                }
            }
            if (sso.getPrincipal() == null && principal != null) {
                if (this.debug >= 1) {
                    this.log("Update sso id " + ssoId + " with principal " + principal.getName());
                }
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    sso.setPrincipal(principal);
                }
            }
        }
        return shouldBroadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remoteUpdate(String ssoId, String authType, String username, String password) {
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso != null && !sso.getCanReauthenticate()) {
            if (this.debug >= 1) {
                this.log("Update sso id " + ssoId + " to auth type " + authType);
            }
            SingleSignOnEntry singleSignOnEntry = sso;
            synchronized (singleSignOnEntry) {
                Principal p = sso.getPrincipal();
                sso.updateCredentials(p, authType, username, password);
            }
        }
    }

    private void createClusterManager(String className) throws LifecycleException {
        if (this.ssoClusterManager != null) {
            return;
        }
        if (className != null) {
            SSOClusterManager mgr = null;
            try {
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = tcl.loadClass(className);
                mgr = (SSOClusterManager)clazz.newInstance();
                mgr.setSingleSignOnValve(this);
                if (mgr instanceof TreeCacheSSOClusterManager) {
                    ((TreeCacheSSOClusterManager)mgr).setCacheName(this.getTreeCacheName());
                }
                this.ssoClusterManager = mgr;
                this.clusterManagerClass = className;
            }
            catch (Throwable t) {
                throw new LifecycleException("Cannot create SSOClusterManager using " + className, t);
            }
            if (this.started) {
                this.ssoClusterManager.start();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        info = (class$org$jboss$web$tomcat$tc5$sso$ClusteredSingleSignOn == null ? (class$org$jboss$web$tomcat$tc5$sso$ClusteredSingleSignOn = ClusteredSingleSignOn.class$("org.jboss.web.tomcat.tc5.sso.ClusteredSingleSignOn")) : class$org$jboss$web$tomcat$tc5$sso$ClusteredSingleSignOn).getName();
    }
}

