/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.BaseCertLoginModule;

public class DatabaseCertLoginModule
extends BaseCertLoginModule {
    private String dsJndiName;
    private String rolesQuery = "select Role, RoleGroup from Roles where PrincipalID=?";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        Object tmp;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get("dsJndiName");
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/DefaultDS";
        }
        if ((tmp = options.get("rolesQuery")) != null) {
            this.rolesQuery = tmp.toString();
        }
        this.log.trace((Object)("DatabaseServerLoginModule, dsJndiName=" + this.dsJndiName));
        this.log.trace((Object)("rolesQuery=" + this.rolesQuery));
    }

    /*
     * Loose catch block
     */
    protected Group[] getRoleSets() throws LoginException {
        HashMap<String, Group> setsMap;
        block28: {
            Statement ps;
            Connection conn;
            block27: {
                ResultSet rs;
                block24: {
                    Group[] groupArray;
                    block25: {
                        Group[] roleSets;
                        String username = this.getUsername();
                        conn = null;
                        setsMap = new HashMap<String, Group>();
                        ps = null;
                        InitialContext ctx = new InitialContext();
                        DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
                        conn = ds.getConnection();
                        ps = conn.prepareStatement(this.rolesQuery);
                        try {
                            ps.setString(1, username);
                        }
                        catch (ArrayIndexOutOfBoundsException ignore) {
                            // empty catch block
                        }
                        rs = ps.executeQuery();
                        if (rs.next()) break block24;
                        if (this.getUnauthenticatedIdentity() == null) {
                            throw new FailedLoginException("No matching username found in Roles");
                        }
                        groupArray = roleSets = new Group[]{new SimpleGroup("Roles")};
                        Object var12_15 = null;
                        if (ps == null) break block25;
                        try {
                            ps.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    return groupArray;
                }
                do {
                    Group group;
                    String name = rs.getString(1);
                    String groupName = rs.getString(2);
                    if (groupName == null || groupName.length() == 0) {
                        groupName = "Roles";
                    }
                    if ((group = (Group)setsMap.get(groupName)) == null) {
                        group = new SimpleGroup(groupName);
                        setsMap.put(groupName, group);
                    }
                    group.addMember((Principal)new SimplePrincipal(name));
                } while (rs.next());
                rs.close();
                Object var12_16 = null;
                if (ps == null) break block27;
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
            break block28;
            {
                catch (NamingException ex) {
                    throw new LoginException(ex.toString(true));
                }
                catch (SQLException ex) {
                    this.log.error((Object)"SQL failure", (Throwable)ex);
                    throw new LoginException(ex.toString());
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }
}

