/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class DatabaseServerLoginModule
extends UsernamePasswordLoginModule {
    protected String dsJndiName;
    protected String principalsQuery = "select Password from Principals where PrincipalID=?";
    protected String rolesQuery = "select Role, RoleGroup from Roles where PrincipalID=?";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        Object tmp;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get("dsJndiName");
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/DefaultDS";
        }
        if ((tmp = options.get("principalsQuery")) != null) {
            this.principalsQuery = tmp.toString();
        }
        if ((tmp = options.get("rolesQuery")) != null) {
            this.rolesQuery = tmp.toString();
        }
        this.log.trace((Object)("DatabaseServerLoginModule, dsJndiName=" + this.dsJndiName));
        this.log.trace((Object)("principalsQuery=" + this.principalsQuery));
        this.log.trace((Object)("rolesQuery=" + this.rolesQuery));
    }

    /*
     * Loose catch block
     */
    protected String getUsersPassword() throws LoginException {
        String password;
        block22: {
            SQLException e22;
            ResultSet rs;
            Statement ps;
            Connection conn;
            block20: {
                String username = this.getUsername();
                password = null;
                conn = null;
                ps = null;
                rs = null;
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
                conn = ds.getConnection();
                ps = conn.prepareStatement(this.principalsQuery);
                ps.setString(1, username);
                rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new FailedLoginException("No matching username found in Principals");
                }
                password = rs.getString(1);
                password = this.convertRawPassword(password);
                Object var9_10 = null;
                if (rs == null) break block20;
                try {
                    rs.close();
                }
                catch (SQLException e22) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e22) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
            break block22;
            {
                catch (NamingException ex) {
                    throw new LoginException(ex.toString(true));
                }
                catch (SQLException ex) {
                    this.log.error((Object)"Query failed", (Throwable)ex);
                    throw new LoginException(ex.toString());
                }
            }
            catch (Throwable throwable) {
                SQLException e22;
                Object var9_11 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e22) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e22) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return password;
    }

    /*
     * Loose catch block
     */
    protected Group[] getRoleSets() throws LoginException {
        HashMap<String, Group> setsMap;
        block39: {
            SQLException e222;
            ResultSet rs;
            Statement ps;
            Connection conn;
            block37: {
                block33: {
                    SQLException e222;
                    Group[] groupArray;
                    block34: {
                        Group[] roleSets;
                        String username = this.getUsername();
                        conn = null;
                        setsMap = new HashMap<String, Group>();
                        ps = null;
                        rs = null;
                        InitialContext ctx = new InitialContext();
                        DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
                        conn = ds.getConnection();
                        ps = conn.prepareStatement(this.rolesQuery);
                        try {
                            ps.setString(1, username);
                        }
                        catch (ArrayIndexOutOfBoundsException ignore) {
                            // empty catch block
                        }
                        rs = ps.executeQuery();
                        if (rs.next()) break block33;
                        if (this.getUnauthenticatedIdentity() == null) {
                            throw new FailedLoginException("No matching username found in Roles");
                        }
                        groupArray = roleSets = new Group[]{new SimpleGroup("Roles")};
                        Object var13_15 = null;
                        if (rs == null) break block34;
                        try {
                            rs.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    return groupArray;
                }
                do {
                    Group group;
                    String name = rs.getString(1);
                    String groupName = rs.getString(2);
                    if (groupName == null || groupName.length() == 0) {
                        groupName = "Roles";
                    }
                    if ((group = (Group)setsMap.get(groupName)) == null) {
                        group = new SimpleGroup(groupName);
                        setsMap.put(groupName, group);
                    }
                    try {
                        Principal p = super.createIdentity(name);
                        this.log.trace((Object)("Assign user to role " + name));
                        group.addMember(p);
                    }
                    catch (Exception e3) {
                        this.log.debug((Object)("Failed to create principal: " + name), (Throwable)e3);
                    }
                } while (rs.next());
                Object var13_16 = null;
                if (rs == null) break block37;
                try {
                    rs.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
            break block39;
            {
                catch (NamingException ex) {
                    throw new LoginException(ex.toString(true));
                }
                catch (SQLException ex) {
                    this.log.error((Object)"SQL failure", (Throwable)ex);
                    throw new LoginException(ex.toString());
                }
            }
            catch (Throwable throwable) {
                SQLException e222;
                Object var13_17 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }

    protected String convertRawPassword(String rawPassword) {
        return rawPassword;
    }
}

