/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.naming.InitialContext;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;
import org.jboss.security.ssl.Context;

public class DomainServerSocketFactory
extends SSLServerSocketFactory {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$ssl$DomainServerSocketFactory == null ? (class$org$jboss$security$ssl$DomainServerSocketFactory = DomainServerSocketFactory.class$("org.jboss.security.ssl.DomainServerSocketFactory")) : class$org$jboss$security$ssl$DomainServerSocketFactory));
    private transient SecurityDomain securityDomain;
    private transient InetAddress bindAddress;
    private transient SSLContext sslCtx = null;
    private boolean wantsClientAuth = true;
    private boolean needsClientAuth = false;
    static /* synthetic */ Class class$org$jboss$security$ssl$DomainServerSocketFactory;

    public DomainServerSocketFactory() {
    }

    public DomainServerSocketFactory(SecurityDomain securityDomain) throws IOException {
        if (securityDomain == null) {
            throw new IOException("The securityDomain may not be null");
        }
        this.securityDomain = securityDomain;
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = InetAddress.getByName(host);
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public boolean isWantsClientAuth() {
        return this.wantsClientAuth;
    }

    public void setWantsClientAuth(boolean wantsClientAuth) {
        this.wantsClientAuth = wantsClientAuth;
    }

    public boolean isNeedsClientAuth() {
        return this.needsClientAuth;
    }

    public void setNeedsClientAuth(boolean needsClientAuth) {
        this.needsClientAuth = needsClientAuth;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createServerSocket(port, 50, this.bindAddress);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.createServerSocket(port, backlog, this.bindAddress);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        this.initSSLContext();
        SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
        SSLServerSocket socket = (SSLServerSocket)factory.createServerSocket(port, backlog, ifAddress);
        String[] supportedProtocols = socket.getSupportedProtocols();
        log.debug((Object)("Supported protocols: " + Arrays.asList(supportedProtocols)));
        String[] protocols = supportedProtocols;
        socket.setEnabledProtocols(protocols);
        socket.setNeedClientAuth(this.needsClientAuth);
        socket.setWantClientAuth(this.wantsClientAuth);
        return socket;
    }

    public static ServerSocketFactory getDefault() {
        DomainServerSocketFactory ssf = null;
        try {
            InitialContext iniCtx = new InitialContext();
            SecurityDomain sd = (SecurityDomain)iniCtx.lookup("java:/jaas/other");
            ssf = new DomainServerSocketFactory(sd);
        }
        catch (Exception e) {
            log.error((Object)"Failed to create default ServerSocketFactory", (Throwable)e);
        }
        return ssf;
    }

    public String[] getDefaultCipherSuites() {
        String[] cipherSuites = new String[]{};
        try {
            this.initSSLContext();
            SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
            cipherSuites = factory.getDefaultCipherSuites();
        }
        catch (IOException e) {
            log.error((Object)"Failed to get default SSLServerSocketFactory", (Throwable)e);
        }
        return cipherSuites;
    }

    public String[] getSupportedCipherSuites() {
        String[] cipherSuites = new String[]{};
        try {
            this.initSSLContext();
            SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
            cipherSuites = factory.getSupportedCipherSuites();
        }
        catch (IOException e) {
            log.error((Object)"Failed to get default SSLServerSocketFactory", (Throwable)e);
        }
        return cipherSuites;
    }

    private void initSSLContext() throws IOException {
        if (this.sslCtx != null) {
            return;
        }
        this.sslCtx = Context.forDomain(this.securityDomain);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

