/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.cookie;

import at.tugraz.genome.crypt.DesEncrypter;
import at.tugraz.genome.crypt.SecurityFactory;
import at.tugraz.genome.usermanagement.UserManagementConstants;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnectionManager;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieManager {
    private static Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$cookie$CookieManager == null ? (class$at$tugraz$genome$usermanagement$cookie$CookieManager = CookieManager.class$("at.tugraz.genome.usermanagement.cookie.CookieManager")) : class$at$tugraz$genome$usermanagement$cookie$CookieManager));
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$cookie$CookieManager;

    public static void createCookie(HttpServletRequest request, HttpServletResponse response, UserVO vo, String username, String appliactionName, String authID) {
        logger_.info((Object)"createCookie");
        Cookie[] cookies = request.getCookies();
        boolean cookiesallowed = false;
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i].getName().equalsIgnoreCase("JSESSIONID")) {
                    cookiesallowed = true;
                }
                ++i;
            }
        }
        vo.setCookieInUse(cookiesallowed);
        request.getSession().setAttribute(UserManagementConstants.USER, (Object)vo);
        DesEncrypter des = SecurityFactory.getInstance().getCookieEncrypter(appliactionName);
        username = des.encrypt(username);
        authID = des.encrypt(authID);
        String cookievalue = username + ":" + authID + ":" + (System.currentTimeMillis() / 1000L + (long)ConfigLoader.getInstance(appliactionName).getCookieMaxAge()) + SecurityFactory.getInstance().getActualVersion(appliactionName);
        Cookie cookie = new Cookie(UserManagementConstants.COOKIENAME, cookievalue);
        cookie.setComment("This cookie is used for the usermanagementsystem of genome.tugraz.at");
        cookie.setMaxAge(ConfigLoader.getInstance(appliactionName).getCookieMaxAge());
        cookie.setPath("/");
        if (ConfigLoader.getInstance(appliactionName).getCookieDomain() != null) {
            cookie.setDomain(ConfigLoader.getInstance(appliactionName).getCookieDomain());
        }
        response.addCookie(cookie);
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String application) {
        block5: {
            Cookie[] cookies = request.getCookies();
            Cookie delcookie = null;
            String username = "";
            if (cookies != null) {
                int i = 0;
                while (i < cookies.length) {
                    if (cookies[i].getName().equalsIgnoreCase(UserManagementConstants.COOKIENAME)) {
                        delcookie = (Cookie)cookies[i].clone();
                        int point = cookies[i].getValue().indexOf(":");
                        int secondPoint = cookies[i].getValue().substring(point + 1).indexOf(":") + point + 1;
                        DesEncrypter des = SecurityFactory.getInstance().getCookieEncrypter(application);
                        String userNameInTheCookie = cookies[i].getValue().substring(0, point);
                        String authTokenInTheCookie = cookies[i].getValue().substring(point + 1, secondPoint);
                        String cookieusername = des.decrypt(userNameInTheCookie);
                        String authToken = des.decrypt(authTokenInTheCookie);
                        username = cookieusername;
                        delcookie.setPath("/");
                        delcookie.setMaxAge(0);
                        delcookie.setValue("-1");
                        response.addCookie(delcookie);
                    }
                    ++i;
                }
            }
            if (username == null || username.length() <= 0) break block5;
            try {
                ServerConnectionManager.getInstance().getConnection(SecurityFactory.getInstance().getApplicationName()).logoutUser(username, SecurityFactory.getInstance().getApplicationName());
            }
            catch (UserSecurityException usx) {}
        }
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response) {
        block6: {
            Cookie[] cookies = request.getCookies();
            Cookie delcookie = null;
            String username = "";
            if (cookies != null) {
                int i = 0;
                while (i < cookies.length) {
                    if (cookies[i].getName().equalsIgnoreCase(UserManagementConstants.COOKIENAME)) {
                        delcookie = (Cookie)cookies[i].clone();
                        int point = cookies[i].getValue().indexOf(":");
                        int secondPoint = cookies[i].getValue().substring(point + 1).indexOf(":") + point + 1;
                        DesEncrypter des = SecurityFactory.getInstance().getCookieEncrypter();
                        if (des == null) {
                            des = SecurityFactory.getInstance().getNewestCookieEncrypter(SecurityFactory.getInstance().getApplicationName());
                        }
                        String userNameInTheCookie = cookies[i].getValue().substring(0, point);
                        String authTokenInTheCookie = cookies[i].getValue().substring(point + 1, secondPoint);
                        String cookieusername = des.decrypt(userNameInTheCookie);
                        String authToken = des.decrypt(authTokenInTheCookie);
                        username = cookieusername;
                        delcookie.setPath("/");
                        delcookie.setMaxAge(0);
                        delcookie.setValue("-1");
                        response.addCookie(delcookie);
                    }
                    ++i;
                }
            }
            if (username == null || username.length() <= 0) break block6;
            try {
                ServerConnectionManager.getInstance().getConnection(SecurityFactory.getInstance().getApplicationName()).logoutUser(username, SecurityFactory.getInstance().getApplicationName());
            }
            catch (UserSecurityException usx) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

