/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.saml;

import at.tugraz.genome.usermanagement.saml.SamlAuthenticationException;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import saml.client.sp.IDPServerException;
import saml.client.sp.IdpServer;

public class SamlAuthentication {
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$saml$SamlAuthentication == null ? (class$at$tugraz$genome$usermanagement$saml$SamlAuthentication = SamlAuthentication.class$("at.tugraz.genome.usermanagement.saml.SamlAuthentication")) : class$at$tugraz$genome$usermanagement$saml$SamlAuthentication));
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$saml$SamlAuthentication;

    public static String checkSamlUrl(String appName, String returnUrl) throws SamlAuthenticationException {
        String url = null;
        ConfigLoader config_ = ConfigLoader.getInstance(appName);
        String acceptSaml = config_.getProperties().getProperty("accept_saml");
        logger_.info((Object)("acceptSaml: " + acceptSaml));
        if (acceptSaml != null && (acceptSaml.trim().equalsIgnoreCase("yes") || acceptSaml.trim().equalsIgnoreCase("true"))) {
            if (!SamlAuthentication.checkServerConnection()) {
                throw new SamlAuthenticationException("The SAML Server is not running; log in normally");
            }
            url = IdpServer.createSSORedirectUrl(returnUrl);
            logger_.info((Object)("Got the url: " + url));
        }
        return url;
    }

    public static String getAasUsernameFromSaml(String alias) throws SamlAuthenticationException {
        try {
            if (!SamlAuthentication.checkServerConnection()) {
                throw new SamlAuthenticationException("The SAML Server is not running;");
            }
            return IdpServer.getFederationUserName(alias, IdpServer.getApplicationId());
        }
        catch (IOException iox) {
            throw new SamlAuthenticationException("The SAML config file could not be read");
        }
    }

    public static String getSamlApplicationName() throws SamlAuthenticationException {
        return IdpServer.getApplicationId();
    }

    public static boolean setAasUsernameInSaml(String aasUsername, String samlAlias) throws SamlAuthenticationException {
        try {
            if (!SamlAuthentication.checkServerConnection()) {
                throw new SamlAuthenticationException("The SAML Server is not running;");
            }
            return IdpServer.setFederationUserName(aasUsername, samlAlias, IdpServer.getApplicationId());
        }
        catch (IOException iox) {
            throw new SamlAuthenticationException("The SAML config file could not be read");
        }
        catch (IDPServerException idx) {
            throw new SamlAuthenticationException(idx);
        }
    }

    public static boolean checkServerConnection() throws SamlAuthenticationException {
        try {
            return IdpServer.checkServerConnection();
        }
        catch (IOException iox) {
            throw new SamlAuthenticationException("The SAML config file could not be read");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

