/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.serverconnection.http;

import at.tugraz.genome.crypt.SecurityFactory;
import at.tugraz.genome.usermanagement.server.MessageBean;
import at.tugraz.genome.usermanagement.server.acl.VO.AclVO;
import at.tugraz.genome.usermanagement.server.authentication.AuthenticationToken;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVOToAdd;
import at.tugraz.genome.usermanagement.serverconnection.AbstractServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.exception.ProtocolException;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import com.opensymphony.module.propertyset.ejb.types.VO.DateEntityVO;
import com.oreilly.servlet.HttpMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.util.FilterDoubleEntries;
import server.Management.util.MessageFromServer;
import server.Management.util.ServerConstants;

public class ServerConnectionHTTP
extends AbstractServerConnection
implements ServerConnection {
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$serverconnection$http$ServerConnectionHTTP == null ? (class$at$tugraz$genome$usermanagement$serverconnection$http$ServerConnectionHTTP = ServerConnectionHTTP.class$("at.tugraz.genome.usermanagement.serverconnection.http.ServerConnectionHTTP")) : class$at$tugraz$genome$usermanagement$serverconnection$http$ServerConnectionHTTP));
    private Properties prop = new Properties();
    private UserVOToAdd objecttoSend_;
    private DateEntityVO dummy = new DateEntityVO();
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$serverconnection$http$ServerConnectionHTTP;

    public ServerConnectionHTTP(ConfigLoader config) {
        super(config);
        AbstractServerConnection.PORT = this.config_.getProperties().getProperty("http_port");
        AbstractServerConnection.SERVERNAME = this.config_.getProperties().getProperty("http_url");
        AbstractServerConnection.PROTOCOL = this.config_.getProperties().getProperty("protocol").toLowerCase();
        AbstractServerConnection.URL = AbstractServerConnection.PROTOCOL + "://" + AbstractServerConnection.SERVERNAME + ":" + AbstractServerConnection.PORT + "/UsermanagementWeb/servlet/";
        String proxy = this.config_.getProperties().getProperty("proxy");
        if (proxy == null) {
            proxy = "";
        }
        this.checkConfig();
        if (proxy.equalsIgnoreCase("ON")) {
            String javaversion = System.getProperty("java.version");
            if (javaversion.startsWith("1.4")) {
                Properties systemSettings = System.getProperties();
                ((Hashtable)systemSettings).put("http.proxyHost", this.config_.getProperties().getProperty("proxy_host"));
                ((Hashtable)systemSettings).put("http.proxyPort", this.config_.getProperties().getProperty("proxy_port"));
                System.setProperties(systemSettings);
            } else if (javaversion.startsWith("1.4")) {
                Properties systemSettings = System.getProperties();
                ((Hashtable)systemSettings).put("http.proxyHost", this.config_.getProperties().getProperty("proxy_host"));
                ((Hashtable)systemSettings).put("http.proxyPort", this.config_.getProperties().getProperty("proxy_port"));
                System.setProperties(systemSettings);
            } else {
                Properties systemSettings = System.getProperties();
                ((Hashtable)systemSettings).put("proxySet", "true");
                ((Hashtable)systemSettings).put("proxyHost", this.config_.getProperties().getProperty("proxy_host"));
                ((Hashtable)systemSettings).put("proxyPort", this.config_.getProperties().getProperty("proxy_port"));
                System.setProperties(systemSettings);
            }
        }
    }

    public ExtendedUserVO getUserVOExtended(String name, String authenticationID, String realm, String applicationpassword) throws UserSecurityException {
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(applicationpassword);
        try {
            ExtendedUserVO vo = ServerConnectionHTTP.executeGetUserVOExtended(name, authenticationID, realm, encryptedPassword);
            if (vo == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(applicationpassword);
                vo = ServerConnectionHTTP.executeGetUserVOExtended(name, authenticationID, realm, encryptedPassword);
            }
            if (vo != null) {
                vo.setNameOfCurrentAplication(realm);
            }
            return vo;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static ExtendedUserVO executeGetUserVOExtended(String name, String authenticationID, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String nameURLenc = URLEncoder.encode(name, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String url = AbstractServerConnection.URL + "getUserVOExtended" + "?" + "username=" + nameURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        ExtendedUserVO vo = (ExtendedUserVO)input.readObject();
        input.close();
        return vo;
    }

    public UserVO getUserVO(String name, String authenticationID, String realm, String applicationpassword) throws UserSecurityException {
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(applicationpassword);
        try {
            UserVO vo = ServerConnectionHTTP.executeGetUserVO(name, authenticationID, realm, encryptedPassword);
            if (vo == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(applicationpassword);
                vo = ServerConnectionHTTP.executeGetUserVO(name, authenticationID, realm, encryptedPassword);
            }
            return vo;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static UserVO executeGetUserVO(String name, String authenticationID, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String nameURLenc = URLEncoder.encode(name, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String url = AbstractServerConnection.URL + "getUserVO" + "?" + "username=" + nameURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        UserVO vo = (UserVO)input.readObject();
        input.close();
        return vo;
    }

    public boolean hasUserAccessLevel(String username, String authenticationID, String realm, String resource, String accessLevel, String applicationpassword) throws RemoteException, UserSecurityException {
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(applicationpassword);
        try {
            Integer result = ServerConnectionHTTP.executeHasUserAccessLevel(username, authenticationID, realm, resource, accessLevel, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(applicationpassword);
                result = ServerConnectionHTTP.executeHasUserAccessLevel(username, authenticationID, realm, resource, accessLevel, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Integer executeHasUserAccessLevel(String username, String authenticationID, String applicationname, String resource, String accessLevel, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String resourceURLenc = URLEncoder.encode(resource, "UTF-8");
        String accessLevelURLenc = URLEncoder.encode(accessLevel, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String url = AbstractServerConnection.URL + "hasUserAccessLevel";
        url = url + "?" + "username=" + usernameURLenc + "&" + "application=" + applicationnameURLenc + "&" + "resource=" + resourceURLenc + "&" + "accessLevel=" + accessLevelURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public AuthenticationToken authenticateUser(String realm, String username, String password, String applicationpassword, String ipAddress) throws UserSecurityException {
        URLConnection servletConnection = null;
        if (username == null || realm == null || password == null || applicationpassword == null || ipAddress == null) {
            throw new UserSecurityException("data given to method is null");
        }
        AuthenticationToken result = null;
        try {
            String encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(password);
            String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
            String url = AbstractServerConnection.URL + "authentication" + "?username=" + username + "&application=" + realm + "&password=" + encryptedURLPswd + "&ipAddress=" + ipAddress + "&" + AbstractServerConnection.COOKIE_MAX_AGE + String.valueOf(ConfigLoader.getInstance(realm).getCookieMaxAge());
            servletConnection = ServerConnectionHTTP.getServletConnection(url);
            ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
            result = (AuthenticationToken)input.readObject();
            logger_.debug((Object)("got new IdentificationID: " + result.getAuthenticationID()));
            input.close();
            if (result.isError()) {
                logger_.error((Object)result.getErrorMessage());
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            logger_.error((Object)"error at login attempt");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger_.error((Object)"error at login attempt");
        }
        if (result != null) {
            return new AuthenticationToken(result.getErrorMessage());
        }
        return new AuthenticationToken("connection not established");
    }

    public AuthenticationToken authenticateSamlUser(String realm, String username, String applicationpassword, String ipAddress, String samlAlias, String samlRealm) throws UserSecurityException {
        URLConnection servletConnection = null;
        if (username == null || realm == null || applicationpassword == null || ipAddress == null || samlAlias == null || samlRealm == null) {
            throw new UserSecurityException("data given to method is null");
        }
        AuthenticationToken result = null;
        try {
            String encryptedAlias = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(samlAlias);
            String encryptedURLAlias = URLEncoder.encode(encryptedAlias, "UTF-8");
            String url = AbstractServerConnection.URL + "samlAuthentication" + "?username=" + username + "&application=" + realm + "&ipAddress=" + ipAddress + "&" + AbstractServerConnection.COOKIE_MAX_AGE + String.valueOf(ConfigLoader.getInstance(realm).getCookieMaxAge() + "&samlAlias=" + encryptedURLAlias + "&samlRealm=" + samlRealm);
            servletConnection = ServerConnectionHTTP.getServletConnection(url);
            ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
            result = (AuthenticationToken)input.readObject();
            logger_.debug((Object)("got new IdentificationID: " + result.getAuthenticationID()));
            input.close();
            if (result.isError()) {
                logger_.error((Object)result.getErrorMessage());
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            logger_.error((Object)"error at login attempt");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger_.error((Object)"error at login attempt");
        }
        if (result != null) {
            return new AuthenticationToken(result.getErrorMessage());
        }
        return new AuthenticationToken("connection not established");
    }

    private static URLConnection getServletConnection(String serverName) {
        URL url = null;
        URLConnection servletConnection = null;
        try {
            url = new URL(serverName);
            servletConnection = url.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setRequestProperty("Content-type", "application/octet-stream");
        }
        catch (IOException ioe) {
            logger_.debug((Object)ioe.getMessage());
            logger_.error((Object)("IOException " + ioe));
        }
        catch (Exception e) {
            logger_.error((Object)("Error in getServletConnection:  " + e.getMessage()));
        }
        return servletConnection;
    }

    public MessageBean changePassword(String username, String adminusername, String authenticationID, String newpassword, String oldpassword, String periodeOfChanging, String realm, String applicationpassword) throws UserSecurityException {
        MessageBean result = null;
        if (newpassword != null && newpassword.length() < 8) {
            return new MessageBean("password must execced 8 characters, cannot create new user");
        }
        if (!newpassword.matches("(.)*([0-9])+(.)*")) {
            return new MessageBean("password must contain at least one number (0-9), cannot create new user");
        }
        if (!newpassword.matches("(.)*(\\p{Punct})+(.)*")) {
            return new MessageBean("password must contain at least special character (!@#$%^&*()), cannot create new user");
        }
        if (adminusername == null) {
            adminusername = "";
        }
        if (oldpassword == null) {
            oldpassword = "";
        }
        if (periodeOfChanging == null) {
            periodeOfChanging = ServerConstants.PERIODE_WEEKLY;
        }
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(applicationpassword);
        String encryptedOldPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(oldpassword);
        String encryptedNewPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(newpassword);
        try {
            result = ServerConnectionHTTP.executeChangePassword(username, encryptedNewPassword, encryptedOldPassword, periodeOfChanging, adminusername, authenticationID, realm, enryptedPassword);
            if (result.getMessage().equalsIgnoreCase("The key version for the encryption is wrong")) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(applicationpassword);
                encryptedOldPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(oldpassword);
                encryptedNewPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(newpassword);
                result = ServerConnectionHTTP.executeChangePassword(username, encryptedNewPassword, encryptedOldPassword, periodeOfChanging, adminusername, authenticationID, realm, enryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static MessageBean executeChangePassword(String username, String encryptedNewpassword, String encryptedOldpassword, String periodeOfChanging, String adminusername, String authenticationID, String realm, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        MessageBean result = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String encryptedURLOldPswd = URLEncoder.encode(encryptedOldpassword, "UTF-8");
        String encryptedURLNewPswd = URLEncoder.encode(encryptedNewpassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String periodeOfChangingURLenc = URLEncoder.encode(periodeOfChanging, "UTF-8");
        String adminusernameURLenc = URLEncoder.encode(adminusername, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String realmURLenc = URLEncoder.encode(realm, "UTF-8");
        String url = AbstractServerConnection.URL + "changePassword" + "?" + "username=" + usernameURLenc + "&" + "password=" + encryptedURLNewPswd + "&" + "oldpassword=" + encryptedURLOldPswd + "&" + "period=" + periodeOfChangingURLenc + "&" + "admin=" + adminusernameURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "application=" + realmURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(realm);
        logger_.debug((Object)("will change password from user : " + username));
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        result = (MessageBean)input.readObject();
        input.close();
        return result;
    }

    public Vector getExtendedUsersOfApplication(String realm, String applicationpassword, boolean withGroupMembers, boolean includeGloballyDisabledUsers) throws UserSecurityException {
        Object servletConnection = null;
        Object choice = null;
        String withGroupUsers = "";
        String includeGloballyDisabledUsersString = null;
        withGroupUsers = withGroupMembers ? "yes" : "no";
        includeGloballyDisabledUsersString = includeGloballyDisabledUsers ? "yes" : "no";
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(applicationpassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetExtendedUsersOfApplication(realm, encryptedPassword, withGroupUsers, includeGloballyDisabledUsersString);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(applicationpassword);
                result = ServerConnectionHTTP.executeGetExtendedUsersOfApplication(realm, encryptedPassword, withGroupUsers, includeGloballyDisabledUsersString);
            }
            if (result != null) {
                Iterator iter = ((AbstractList)result).iterator();
                while (iter.hasNext()) {
                    ExtendedUserVO vo = (ExtendedUserVO)iter.next();
                    if (vo == null) continue;
                    vo.setNameOfCurrentAplication(realm);
                }
            }
            return FilterDoubleEntries.filterUsers(result);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetExtendedUsersOfApplication(String applicationname, String encryptedPassword, String withGroupUsers, String includeGloballyDisabledUsers) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String withGroupUsersURLenc = URLEncoder.encode(withGroupUsers, "UTF-8");
        String includeGloballyDisabledUsersURLenc = URLEncoder.encode(includeGloballyDisabledUsers, "UTF-8");
        String url = AbstractServerConnection.URL + "getAllExtendedUsersOffApplication" + "?" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + "groupUsers=" + withGroupUsersURLenc + "&" + "includeGloballyDisabledUsers=" + includeGloballyDisabledUsersURLenc + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public Vector getExtendedUsersOfApplication(String realm, String applicationpassword, boolean withGroupMembers) throws UserSecurityException {
        return this.getExtendedUsersOfApplication(realm, applicationpassword, withGroupMembers, true);
    }

    public MessageBean addUser(ExtendedUserVO userVO, String realm, String templateUser, String newPasswordOfUser, String periodeOfChanging, String authenticationID, String adminUsername, String applicationPassword, boolean addToApplication) throws UserSecurityException {
        if (userVO == null || realm == null || newPasswordOfUser == null) {
            throw new UserSecurityException("data null");
        }
        if (realm.length() == 0) {
            throw new UserSecurityException("no relam given");
        }
        if (newPasswordOfUser.length() == 0) {
            throw new UserSecurityException("no password for user given");
        }
        if (userVO.getName().length() == 0) {
            return new MessageBean("user name has zero length, cannot create new user");
        }
        if (newPasswordOfUser != null && newPasswordOfUser.length() < 8) {
            return new MessageBean("password must execced 8 characters, cannot create new user");
        }
        if (!newPasswordOfUser.matches("(.)*([0-9])+(.)*")) {
            return new MessageBean("password must contain at least one number (0-9), cannot create new user");
        }
        if (!newPasswordOfUser.matches("(.)*(\\p{Punct})+(.)*")) {
            return new MessageBean("password must contain at least special character (!@#$%^&*()), cannot create new user");
        }
        MessageFromServer message = this.existsUser(userVO.getName(), userVO.getFullname(), userVO.getEmail(), authenticationID, adminUsername, realm, applicationPassword);
        if (message.isError()) {
            throw new UserSecurityException(message.getMessage());
        }
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(applicationPassword);
        String encryptedNewPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(newPasswordOfUser);
        this.objecttoSend_ = new UserVOToAdd(userVO, realm);
        this.objecttoSend_.setPassword(encryptedNewPassword);
        this.objecttoSend_.setTemplateUser(templateUser);
        this.objecttoSend_.setAdminUsername(adminUsername);
        this.objecttoSend_.setAuthenticationID(authenticationID);
        this.objecttoSend_.setEnableInApplication(addToApplication);
        this.objecttoSend_.setPeriode(periodeOfChanging);
        try {
            MessageBean result = ServerConnectionHTTP.executeAddUser(this.objecttoSend_, enryptedPassword, realm);
            if (result.getMessage().equalsIgnoreCase("The key version for the encryption is wrong")) {
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(applicationPassword);
                encryptedNewPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(newPasswordOfUser);
                this.objecttoSend_.setPassword(encryptedNewPassword);
                result = ServerConnectionHTTP.executeAddUser(this.objecttoSend_, enryptedPassword, realm);
            }
            return new MessageBean();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static MessageBean executeAddUser(UserVOToAdd objecttoSend_, String enryptedPassword, String application) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        objecttoSend_.setApplicationPassword(enryptedPassword);
        objecttoSend_.setVersion(SecurityFactory.getInstance().getActualVersion(application));
        URL servletURL = new URL(AbstractServerConnection.URL + "addUser");
        HttpMessage msg = new HttpMessage(servletURL);
        ObjectInputStream input = new ObjectInputStream(msg.sendPostMessage((Serializable)objecttoSend_));
        MessageBean result = (MessageBean)input.readObject();
        input.close();
        return result;
    }

    public void editUser(ExtendedUserVO userVO, String authenticationID, String adminUsername, String realm, String applicationpassword) throws UserSecurityException {
        if (userVO == null) {
            return;
        }
        this.objecttoSend_ = new UserVOToAdd(userVO, "");
        this.objecttoSend_.setAdminUsername(adminUsername);
        this.objecttoSend_.setRealm(realm);
        this.objecttoSend_.setAuthenticationID(authenticationID);
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(applicationpassword);
        try {
            MessageBean result = ServerConnectionHTTP.executeEditUser(this.objecttoSend_, enryptedPassword, realm);
            if (result.getMessage().equalsIgnoreCase("The key version for the encryption is wrong")) {
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(applicationpassword);
                result = ServerConnectionHTTP.executeEditUser(this.objecttoSend_, enryptedPassword, realm);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static MessageBean executeEditUser(UserVOToAdd objecttoSend_, String enryptedPassword, String application) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        objecttoSend_.setApplicationPassword(enryptedPassword);
        objecttoSend_.setVersion(SecurityFactory.getInstance().getActualVersion(application));
        URL servletURL = new URL(AbstractServerConnection.URL + "editUser");
        HttpMessage msg = new HttpMessage(servletURL);
        ObjectInputStream input = new ObjectInputStream(msg.sendPostMessage((Serializable)objecttoSend_));
        MessageBean result = (MessageBean)input.readObject();
        input.close();
        return result;
    }

    public void editUser(ExtendedUserVO userVO, String authenticationID, String applicationname, String applicationpassword) throws UserSecurityException {
        this.editUser(userVO, authenticationID, null, applicationname, applicationpassword);
    }

    public ExtendedUserVO getUserByIDExtended(Long id, String adminUsername, String authenticationID, String applicationname, String applicationpassword) throws UserSecurityException {
        if (id == null || adminUsername == null || authenticationID == null || applicationname == null || applicationpassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(applicationname).encrypt(applicationpassword);
        try {
            ExtendedUserVO vo = ServerConnectionHTTP.executeGetUserByIDExtended(id.toString(), adminUsername, authenticationID, applicationname, encryptedPassword);
            if (vo == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(applicationname).encrypt(applicationpassword);
                vo = ServerConnectionHTTP.executeGetUserByIDExtended(id.toString(), adminUsername, authenticationID, applicationname, encryptedPassword);
            }
            if (vo != null) {
                vo.setNameOfCurrentAplication(applicationname);
            }
            return vo;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static ExtendedUserVO executeGetUserByIDExtended(String userid, String adminUsername, String authenticationID, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String useridURLenc = URLEncoder.encode(userid, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String url = AbstractServerConnection.URL + "getUserByIDExtended" + "?" + "userID=" + useridURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        ExtendedUserVO vo = (ExtendedUserVO)input.readObject();
        input.close();
        return vo;
    }

    public UserVO getUserByID(Long id, String applicationname, String applicationpassword) throws UserSecurityException {
        if (id == null) {
            return null;
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(applicationname).encrypt(applicationpassword);
        try {
            UserVO vo = ServerConnectionHTTP.executeGetUserByID(id.toString(), applicationname, encryptedPassword);
            if (vo == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(applicationname).encrypt(applicationpassword);
                vo = ServerConnectionHTTP.executeGetUserByID(id.toString(), applicationname, encryptedPassword);
            }
            return vo;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static UserVO executeGetUserByID(String userid, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String useridURLenc = URLEncoder.encode(userid, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String url = AbstractServerConnection.URL + "getUserByID" + "?" + "userID=" + useridURLenc + "&" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        UserVO vo = (UserVO)input.readObject();
        input.close();
        return vo;
    }

    public Vector getUsersOfApplication(String realm, String applicationpassword, boolean withGroupMembers, boolean includeGloballyDisabledUsers) throws UserSecurityException {
        Object choice = null;
        String withGroupUsers = "";
        String includeGloballyDisabledUsersString = "";
        withGroupUsers = withGroupMembers ? "yes" : "no";
        includeGloballyDisabledUsersString = includeGloballyDisabledUsers ? "yes" : "no";
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(realm).encrypt(applicationpassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetUsersOfApplication(realm, encryptedPassword, withGroupUsers, includeGloballyDisabledUsersString);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(applicationpassword);
                result = ServerConnectionHTTP.executeGetUsersOfApplication(realm, encryptedPassword, withGroupUsers, includeGloballyDisabledUsersString);
            }
            return FilterDoubleEntries.filterUsers(result);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetUsersOfApplication(String applicationname, String encryptedPassword, String withGroupUsers, String includeGloballyDisabledUsers) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String withGroupUsersURLenc = URLEncoder.encode(withGroupUsers, "UTF-8");
        String includeGloballyDisabledUsersURLenc = URLEncoder.encode(includeGloballyDisabledUsers, "UTF-8");
        String url = AbstractServerConnection.URL + "getAllUsersOffApplication" + "?" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + "groupUsers=" + withGroupUsersURLenc + "&" + "includeGloballyDisabledUsers=" + includeGloballyDisabledUsersURLenc + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public Vector getUsersOfApplication(String realm, String applicationpassword, boolean withGroupMembers) throws UserSecurityException {
        return this.getUsersOfApplication(realm, applicationpassword, withGroupMembers, true);
    }

    public MessageFromServer existsUser(String username, String fullname, String email, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(application);
        try {
            MessageFromServer result = ServerConnectionHTTP.executeExistsUser(username, fullname, email, authenticationID, adminUsername, application, encryptedPassword);
            if (result.getMessage().startsWith("The key version for the encryption is wrong")) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeExistsUser(username, fullname, email, authenticationID, adminUsername, application, encryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger_.error((Object)"ERROR, serverconnection");
        return null;
    }

    private static MessageFromServer executeExistsUser(String username, String fullname, String email, String authenticationID, String adminUsername, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        MessageFromServer result = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String emailURLenc = URLEncoder.encode(email, "UTF-8");
        String fullnameURLenc = URLEncoder.encode(fullname, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/existsUser" + "?" + "username=" + usernameURLenc + "&" + "email=" + emailURLenc + "&" + "fullname=" + fullnameURLenc + "&" + "application=" + applicationURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        result = (MessageFromServer)input.readObject();
        input.close();
        return result;
    }

    public boolean enableUserInApplication(String username, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Integer result = ServerConnectionHTTP.executeEnableUserInApplication(username, authenticationID, adminUsername, application, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeEnableUserInApplication(username, authenticationID, adminUsername, application, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger_.error((Object)"ERROR, serverconnection");
        return false;
    }

    private static Integer executeEnableUserInApplication(String username, String authenticationID, String adminUsername, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/enableUserInApplication" + "?" + "username=" + usernameURLenc + "&" + "application=" + applicationnameURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public boolean disableUserInApplication(String username, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Integer result = ServerConnectionHTTP.executeDisableUserInApplication(username, authenticationID, adminUsername, application, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeDisableUserInApplication(username, authenticationID, adminUsername, application, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger_.error((Object)"ERROR, serverconnection");
        return false;
    }

    private static Integer executeDisableUserInApplication(String username, String authenticationID, String adminUsername, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/disableUserInApplication" + "?" + "username=" + usernameURLenc + "&" + "application=" + applicationnameURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public boolean copyAcl(String sourceUser, String destinationUser, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Integer result = ServerConnectionHTTP.executeCopyAcl(sourceUser, destinationUser, authenticationID, adminUsername, application, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeCopyAcl(sourceUser, destinationUser, authenticationID, adminUsername, application, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger_.error((Object)"ERROR, serverconnection");
        return false;
    }

    private static Integer executeCopyAcl(String sourceUser, String destinationUser, String authenticationID, String adminUsername, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String destinationUserURLenc = URLEncoder.encode(destinationUser, "UTF-8");
        String sourceUserURLenc = URLEncoder.encode(sourceUser, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/copyAcl" + "?" + "destination=" + destinationUserURLenc + "&" + "source=" + sourceUserURLenc + "&" + "application=" + applicationnameURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public ExtendedUserVO getUserByIDExtended(Long id, String applicationname, String applicationpassword) throws UserSecurityException {
        if (id == null || applicationname == null || applicationpassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(applicationname).encrypt(applicationpassword);
        try {
            ExtendedUserVO vo = ServerConnectionHTTP.executeGetUserByIDExtended(id.toString(), applicationname, encryptedPassword);
            if (vo == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(applicationname).encrypt(applicationpassword);
                vo = ServerConnectionHTTP.executeGetUserByIDExtended(id.toString(), applicationname, encryptedPassword);
            }
            if (vo != null) {
                vo.setNameOfCurrentAplication(applicationname);
            }
            return vo;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static ExtendedUserVO executeGetUserByIDExtended(String id, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String idURLenc = URLEncoder.encode(id, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String url = AbstractServerConnection.URL + "getUserByIDExtendedWithoutAdmin" + "?" + "userID=" + idURLenc + "&" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        ExtendedUserVO vo = (ExtendedUserVO)input.readObject();
        input.close();
        return vo;
    }

    public Long getUserIDFromName(String username, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Long id = ServerConnectionHTTP.executeGetUserIDFromName(username, application, encryptedPassword);
            if (id == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                id = ServerConnectionHTTP.executeGetUserIDFromName(username, application, encryptedPassword);
            }
            return id;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Long executeGetUserIDFromName(String username, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String url = AbstractServerConnection.URL + "getUserIDFromName" + "?" + "username=" + usernameURLenc + "&" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Long id = (Long)input.readObject();
        input.close();
        return id;
    }

    public Vector getGroupsEnabledInApplication(String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector list = ServerConnectionHTTP.executeGetGroupsEnabledInApplication(application, encryptedPassword);
            if (list == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                list = ServerConnectionHTTP.executeGetGroupsEnabledInApplication(application, encryptedPassword);
            }
            if (list != null) {
                Iterator iter = ((AbstractList)list).iterator();
                while (iter.hasNext()) {
                    SmallGroupVO vo = (SmallGroupVO)iter.next();
                    vo.setNameOfCurrentAplication(application);
                }
            }
            return FilterDoubleEntries.filterGroups(list);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetGroupsEnabledInApplication(String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/getAllGroupsEnabledInApplication" + "?" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public boolean addUserToGroup(String username, String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null || authenticationID == null || adminUsername == null || groupname == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Integer result = ServerConnectionHTTP.executeAddUserToGroup(username, groupname, authenticationID, adminUsername, application, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeAddUserToGroup(username, groupname, authenticationID, adminUsername, application, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Integer executeAddUserToGroup(String username, String groupname, String authenticationID, String adminUsername, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String groupnameURLenc = URLEncoder.encode(groupname, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/addUserToGroup" + "?" + "groupname=" + groupnameURLenc + "&" + "username=" + usernameURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public boolean removeUserFromGroup(String username, String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Integer result = ServerConnectionHTTP.executeRemoveUserFromGroup(username, groupname, authenticationID, adminUsername, application, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeRemoveUserFromGroup(username, groupname, authenticationID, adminUsername, application, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Integer executeRemoveUserFromGroup(String username, String groupname, String authenticationID, String adminUsername, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String groupnameURLenc = URLEncoder.encode(groupname, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/removeUserFromGroup" + "?" + "groupname=" + groupnameURLenc + "&" + "username=" + usernameURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public Vector getUserVORegEx(String regExpression, String application, String applicationPassword) throws UserSecurityException {
        if (regExpression == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetUserVORegEx(regExpression, application, encryptedPassword);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeGetUserVORegEx(regExpression, application, encryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetUserVORegEx(String regExpression, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String regExpressionURLenc = URLEncoder.encode(regExpression, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/getUserVORegEx" + "?" + "regex=" + regExpressionURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public Vector getUserVOExtendedRegEx(String regExpression, String application, String applicationPassword) throws UserSecurityException {
        if (regExpression == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetUserVOExtendedRegEx(regExpression, application, encryptedPassword);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeGetUserVOExtendedRegEx(regExpression, application, encryptedPassword);
            }
            if (result != null) {
                Iterator iter = ((AbstractList)result).iterator();
                while (iter.hasNext()) {
                    ExtendedUserVO vo = (ExtendedUserVO)iter.next();
                    vo.setNameOfCurrentAplication(application);
                }
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetUserVOExtendedRegEx(String regExpression, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String regExpressionURLenc = URLEncoder.encode(regExpression, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/getUserVOExtendedRegExp" + "?" + "regex=" + regExpressionURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public boolean createGroup(String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || application == null || applicationPassword == null || authenticationID == null || applicationPassword == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Integer result = ServerConnectionHTTP.executeCreateGroup(groupname, authenticationID, adminUsername, application, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeCreateGroup(groupname, authenticationID, adminUsername, application, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Integer executeCreateGroup(String groupname, String authenticationID, String adminUsername, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String groupnameURLenc = URLEncoder.encode(groupname, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/createGroup" + "?" + "groupname=" + groupnameURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public boolean deleteGroup(String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || adminUsername == null || authenticationID == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Integer result = ServerConnectionHTTP.executeDeleteGroup(groupname, authenticationID, adminUsername, application, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeDeleteGroup(groupname, authenticationID, adminUsername, application, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Integer executeDeleteGroup(String groupname, String authenticationID, String adminUsername, String applicationname, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String groupnameURLenc = URLEncoder.encode(groupname, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
        String url = AbstractServerConnection.URL + "admin/deleteGroup" + "?" + "groupname=" + groupnameURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "application=" + applicationnameURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(applicationname);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public Vector getAclsOfUser(String username, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetAclsOfUser(username, application, encryptedPassword);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeGetAclsOfUser(username, application, encryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetAclsOfUser(String username, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/getAclsOfUser" + "?" + "username=" + usernameURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public Vector getAclsOfGroup(String groupname, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetAclsOfGroup(groupname, application, encryptedPassword);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeGetAclsOfGroup(groupname, application, encryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetAclsOfGroup(String groupname, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String groupnameURLenc = URLEncoder.encode(groupname, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/getAclsOfGroup" + "?" + "groupname=" + groupnameURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public boolean setAclsOfUser(String username, Long id, String accessLevel, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null || id == null || accessLevel == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Integer result = ServerConnectionHTTP.executeSetAclsOfUser(username, id, accessLevel, authenticationID, adminUsername, application, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeSetAclsOfUser(username, id, accessLevel, authenticationID, adminUsername, application, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Integer executeSetAclsOfUser(String username, Long id, String accessLevel, String authenticationID, String adminUsername, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String idURLenc = URLEncoder.encode(id.toString(), "UTF-8");
        String accessLevelURLenc = URLEncoder.encode(accessLevel, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/setAclsOfUser" + "?" + "username=" + usernameURLenc + "&" + "aclId=" + idURLenc + "&" + "accessLevel=" + accessLevelURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public boolean setAclsOfGroup(String groupname, Long id, String accessLevel, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Integer result = ServerConnectionHTTP.executeSetAclsOfGroup(groupname, id, accessLevel, authenticationID, adminUsername, application, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeSetAclsOfGroup(groupname, id, accessLevel, authenticationID, adminUsername, application, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Integer executeSetAclsOfGroup(String groupname, Long id, String accessLevel, String authenticationID, String adminUsername, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String groupnameURLenc = URLEncoder.encode(groupname, "UTF-8");
        String idURLenc = URLEncoder.encode(id.toString(), "UTF-8");
        String accessLevelURLenc = URLEncoder.encode(accessLevel, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/setAclsOfGroup" + "?" + "groupname=" + groupnameURLenc + "&" + "aclId=" + idURLenc + "&" + "accessLevel=" + accessLevelURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public Vector getAllResourcesOfApplication(String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetAllResourcesOfApplication(application, encryptedPassword);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeGetAllResourcesOfApplication(application, encryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetAllResourcesOfApplication(String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/getAllResourcesOfApplication" + "?" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public AclVO getAclOfResourceByUser(String username, String resourceKey, String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            AclVO vo = ServerConnectionHTTP.executeGetAclOfResourceByUser(username, resourceKey, application, encryptedPassword);
            if (vo == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                vo = ServerConnectionHTTP.executeGetAclOfResourceByUser(username, resourceKey, application, encryptedPassword);
            }
            return vo;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static AclVO executeGetAclOfResourceByUser(String username, String resourceKey, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String resourceKeyURLenc = URLEncoder.encode(resourceKey, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/getAclOfResourceByUser" + "?" + "username=" + usernameURLenc + "&" + "resourceKey=" + resourceKeyURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        AclVO vo = (AclVO)input.readObject();
        input.close();
        return vo;
    }

    public AclVO getAclOfResourceByGroup(String groupname, String resourceKey, String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            AclVO vo = ServerConnectionHTTP.executeGetAclOfResourceByGroup(groupname, resourceKey, application, encryptedPassword);
            if (vo == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                vo = ServerConnectionHTTP.executeGetAclOfResourceByGroup(groupname, resourceKey, application, encryptedPassword);
            }
            return vo;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static AclVO executeGetAclOfResourceByGroup(String groupname, String resourceKey, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String groupnameURLenc = URLEncoder.encode(groupname, "UTF-8");
        String resourceKeyURLenc = URLEncoder.encode(resourceKey, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/getAclOfResourceByGroup" + "?" + "groupname=" + groupnameURLenc + "&" + "resourceKey=" + resourceKeyURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        AclVO vo = (AclVO)input.readObject();
        input.close();
        return vo;
    }

    public boolean createAcl(String username, String groupname, String resourceKey, String accessLevel, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null || adminUsername == null || authenticationID == null || resourceKey == null || accessLevel == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (username == null) {
            username = "";
        }
        if (groupname == null) {
            groupname = "";
        }
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            MessageBean message = ServerConnectionHTTP.executeCreateAcl(username, groupname, resourceKey, accessLevel, authenticationID, adminUsername, application, enryptedPassword);
            if (message.getMessage().equalsIgnoreCase("The key version for the encryption is wrong")) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                message = ServerConnectionHTTP.executeCreateAcl(username, groupname, resourceKey, accessLevel, authenticationID, adminUsername, application, enryptedPassword);
            }
            if (message.isError()) {
                throw new UserSecurityException(message.getMessage());
            }
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static MessageBean executeCreateAcl(String username, String groupname, String resourceKey, String accessLevel, String authenticationID, String adminUsername, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        MessageBean result = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String groupnameURLenc = URLEncoder.encode(groupname, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String accessLevelURLenc = URLEncoder.encode(accessLevel, "UTF-8");
        String resourceKeyURLenc = URLEncoder.encode(resourceKey, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = "";
        if (adminUsername != null) {
            adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        }
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/createAcl" + "?" + "groupname=" + groupnameURLenc + "&" + "username=" + usernameURLenc + "&" + "accessLevel=" + accessLevelURLenc + "&" + "resourceKey=" + resourceKeyURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        result = (MessageBean)input.readObject();
        input.close();
        return result;
    }

    public boolean deleteAcl(Long id, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Integer result = ServerConnectionHTTP.executeDeleteAcl(id.toString(), authenticationID, adminUsername, application, enryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeDeleteAcl(id.toString(), authenticationID, adminUsername, application, enryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Integer executeDeleteAcl(String aclId, String authenticationID, String adminUsername, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String aclIdURLenc = URLEncoder.encode(aclId, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String adminUsernameURLenc = URLEncoder.encode(adminUsername, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/deleteAcl" + "?" + "aclId=" + aclIdURLenc + "&" + "admin=" + adminUsernameURLenc + "&" + "application=" + applicationURLenc + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public Vector getAccessrightsByUser(Long id, String application, String applicationPassword) throws UserSecurityException {
        if (id == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetAccessrightsByUser(id, application, encryptedPassword);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeGetAccessrightsByUser(id, application, encryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetAccessrightsByUser(Long userid, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String useridURLenc = URLEncoder.encode(userid.toString(), "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/getInformationAboutUserForResource" + "?" + "userID=" + useridURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public Vector getAccessrightsByUser(String username, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetAccessrightsByUser(username, application, encryptedPassword);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeGetAccessrightsByUser(username, application, encryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetAccessrightsByUser(String username, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "rights/getInformationAboutUserForResource" + "?" + "username=" + usernameURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public boolean checkLogin(String username, String id, String application) throws UserSecurityException {
        if (username == null || application == null || id == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(ConfigLoader.getInstance(application).getProperties().getProperty("applicationPassword"));
        try {
            Integer result = ServerConnectionHTTP.executeCheckLogin(username, id, application, encryptedPassword);
            if (result == 2) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(ConfigLoader.getInstance(application).getProperties().getProperty("applicationPassword"));
                result = ServerConnectionHTTP.executeCheckLogin(username, id, application, encryptedPassword);
            }
            if (result == 1) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Integer executeCheckLogin(String username, String authenticationID, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String usernameURLenc = URLEncoder.encode(username, "UTF-8");
        String authenticationIDURLenc = URLEncoder.encode(authenticationID, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "/isUserAllowedInApplication" + "?" + "username=" + username + "&" + "Authentication_Id=" + authenticationIDURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Integer result = (Integer)input.readObject();
        input.close();
        return result;
    }

    public Vector getAllInstitutes(String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetAllInstitutes(application, encryptedPassword);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeGetAllInstitutes(application, encryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetAllInstitutes(String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "/institut/getAllInstitutes" + "?" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public Vector getAllUsersFromInstitut(Long institutId, String adminusername, String application, String applicationPassword) throws UserSecurityException {
        if (adminusername == null || institutId == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetAllUsersFromInstitut(institutId.toString(), adminusername, application, encryptedPassword);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeGetAllUsersFromInstitut(institutId.toString(), adminusername, application, encryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetAllUsersFromInstitut(String instituteId, String adminusername, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String instituteIdURLenc = URLEncoder.encode(instituteId, "UTF-8");
        String adminusernameURLenc = URLEncoder.encode(adminusername, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "/institut/getAllUsersFromInstitut" + "?" + "institutId=" + instituteIdURLenc + "&" + "admin=" + adminusernameURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public Vector getAllUsersWithProperty(String propertyKey, String adminusername, String application, String applicationPassword) throws UserSecurityException {
        if (adminusername == null || propertyKey == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getCookieEncrypter(application).encrypt(applicationPassword);
        try {
            Vector result = ServerConnectionHTTP.executeGetAllUsersWithProperty(propertyKey, adminusername, application, encryptedPassword);
            if (result == null) {
                logger_.info((Object)"Changing to a new Cookie key");
                encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(applicationPassword);
                result = ServerConnectionHTTP.executeGetAllUsersWithProperty(propertyKey, adminusername, application, encryptedPassword);
            }
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Vector executeGetAllUsersWithProperty(String propertyKey, String adminusername, String application, String encryptedPassword) throws UnsupportedEncodingException, IOException, ClassNotFoundException, ProtocolException {
        URLConnection servletConnection = null;
        String encryptedURLPswd = URLEncoder.encode(encryptedPassword, "UTF-8");
        String propertyKeyURLenc = URLEncoder.encode(propertyKey, "UTF-8");
        String adminusernameURLenc = URLEncoder.encode(adminusername, "UTF-8");
        String applicationURLenc = URLEncoder.encode(application, "UTF-8");
        String url = AbstractServerConnection.URL + "/admin/getUsersWithPropertyKey" + "?" + "propertyKey=" + propertyKeyURLenc + "&" + "admin=" + adminusernameURLenc + "&" + "application=" + applicationURLenc + "&" + "appPasswd=" + encryptedURLPswd + "&" + AbstractServerConnection.VERSION_OF_KEY + SecurityFactory.getInstance().getActualVersion(application);
        AbstractServerConnection.checkUrl(url);
        servletConnection = ServerConnectionHTTP.getServletConnection(url);
        ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
        Vector result = (Vector)input.readObject();
        input.close();
        return result;
    }

    public String getCookieKey(String applicationname) throws UserSecurityException {
        URLConnection servletConnection = null;
        String cookieKey = "";
        try {
            String url = AbstractServerConnection.URL + "cookie/getCookieKey" + "?application=" + applicationname;
            servletConnection = ServerConnectionHTTP.getServletConnection(url);
            ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
            cookieKey = (String)input.readObject();
            logger_.debug((Object)("encrypted Cookie Key: " + cookieKey));
            input.close();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            logger_.error((Object)"error at login attempt");
        }
        return cookieKey;
    }

    public boolean logoutUser(String username, String applicationname) throws UserSecurityException {
        if (username == null || applicationname == null) {
            throw new UserSecurityException("unsufficient data");
        }
        URLConnection servletConnection = null;
        try {
            String usernameURLenc = URLEncoder.encode(username, "UTF-8");
            String applicationnameURLenc = URLEncoder.encode(applicationname, "UTF-8");
            String url = AbstractServerConnection.URL + "logoutUser" + "?application=" + applicationnameURLenc + "&username=" + usernameURLenc;
            servletConnection = ServerConnectionHTTP.getServletConnection(url);
            ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
            Boolean result = (Boolean)input.readObject();
            logger_.info((Object)("Logged out successfully: " + result));
            input.close();
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            logger_.error((Object)"error at login attempt");
        }
        return false;
    }

    public String refreshAuthenticationId(String username, String authenticationId, String realm) throws UserSecurityException {
        URLConnection servletConnection = null;
        if (username == null || authenticationId == null || realm == null) {
            throw new UserSecurityException("unsufficient data");
        }
        try {
            String usernameURLenc = URLEncoder.encode(username, "UTF-8");
            String authenticationIdURLenc = URLEncoder.encode(authenticationId, "UTF-8");
            String maxAgeURLEnc = URLEncoder.encode(String.valueOf(ConfigLoader.getInstance(realm).getCookieMaxAge()), "UTF-8");
            String url = AbstractServerConnection.URL + "refreshAuthenticationId" + "?username=" + usernameURLenc + "&" + "Authentication_Id=" + authenticationIdURLenc + "&" + AbstractServerConnection.COOKIE_MAX_AGE + maxAgeURLEnc;
            servletConnection = ServerConnectionHTTP.getServletConnection(url);
            ObjectInputStream input = new ObjectInputStream(servletConnection.getInputStream());
            String authId = (String)input.readObject();
            if (authId.equalsIgnoreCase("false")) {
                throw new UserSecurityException("The refresh of the authentication ID did not work");
            }
            return authId;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            logger_.error((Object)"error at login attempt");
        }
        throw new UserSecurityException("The refresh of the authentication ID did not work");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

