/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.serverconnection.util;

import at.tugraz.genome.usermanagement.UserManagementConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigLoader {
    private static Hashtable instanceHash = new Hashtable();
    private Properties serverProperties_ = null;
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$serverconnection$util$ConfigLoader == null ? (class$at$tugraz$genome$usermanagement$serverconnection$util$ConfigLoader = ConfigLoader.class$("at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader")) : class$at$tugraz$genome$usermanagement$serverconnection$util$ConfigLoader));
    private String path;
    private int cookieAge = 3600;
    private String cookieDomain = null;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$serverconnection$util$ConfigLoader;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$serverconnection$ServerConnection;

    private ConfigLoader(String applicationName) {
        logger_.info((Object)("Usermangement Version " + UserManagementConstants.VERSION));
        logger_.info((Object)("ConfigLoader " + applicationName));
        this.serverProperties_ = new Properties();
        String appFile = applicationName + ".properties";
        logger_.info((Object)("Loading File :" + appFile));
        try {
            this.path = new String();
            try {
                this.path = (class$at$tugraz$genome$usermanagement$serverconnection$ServerConnection == null ? (class$at$tugraz$genome$usermanagement$serverconnection$ServerConnection = ConfigLoader.class$("at.tugraz.genome.usermanagement.serverconnection.ServerConnection")) : class$at$tugraz$genome$usermanagement$serverconnection$ServerConnection).getResource("ServerConnection.class").getPath();
                logger_.info((Object)("ResourcePath: " + this.path));
                if (this.path == null) {
                    logger_.error((Object)"no path found for config file");
                    this.path = "";
                } else {
                    int sign = this.path.indexOf("!");
                    if (sign != -1) {
                        logger_.info((Object)"found lib");
                        this.path = this.path.substring(0, sign);
                        int slash = this.path.lastIndexOf("/");
                        if (slash != -1) {
                            this.path = this.path.substring(0, slash);
                        }
                        if ((slash = this.path.lastIndexOf("/")) != -1) {
                            this.path = this.path.substring(0, slash);
                        }
                        this.path = this.path.replaceFirst("file:", "");
                        this.path = this.path.concat(File.separator + appFile);
                        logger_.info((Object)this.path);
                    } else {
                        logger_.info((Object)("path " + this.path + "---------check buggy Zeller Code "));
                        this.path = this.path.replaceAll("at.tugraz.genome.usermanagement.serverconnection.ServerConnection.class", "");
                        this.path = this.path.replaceAll("classes/", "");
                        this.path = this.path.concat(appFile);
                        this.path = this.path.replaceFirst("file:", "");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger_.error((Object)("ERROR in configfile loader" + e.toString()));
            }
            logger_.info((Object)("will load Usermanagement-Client connection setup from file: " + this.path.trim()));
            FileInputStream in = new FileInputStream(this.path.trim());
            this.serverProperties_.load(in);
            in.close();
            logger_.info((Object)" ...done");
        }
        catch (IOException ex) {
            logger_.info((Object)("ex:" + ex));
            logger_.info((Object)("File " + this.path + " not found"));
            logger_.info((Object)"=======> new try at <=========");
            logger_.info((Object)"JBoss server.config.url");
            this.path = System.getProperty("jboss.server.config.url");
            this.path = this.path.replaceAll("file:", "");
            logger_.info((Object)("load configfile for config ejb server from : " + this.path + appFile));
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.path + appFile);
                this.serverProperties_.load(in);
                in.close();
                logger_.info((Object)("load configfile for config ejb server from : " + this.path + appFile + "...done"));
            }
            catch (Exception ex1) {
                logger_.info((Object)("Could not find ConfigFile " + this.path + appFile));
            }
        }
        if (this.serverProperties_ != null) {
            logger_.info((Object)("Usermanagement Serverconnection: will use Protocol: " + this.serverProperties_.getProperty("protocol")));
            if (this.serverProperties_.getProperty("protocol").equalsIgnoreCase("EJB")) {
                logger_.info((Object)("with port: " + this.serverProperties_.getProperty("java.naming.provider.url")));
            } else if (this.serverProperties_.getProperty("protocol").equalsIgnoreCase("HTTP")) {
                logger_.info((Object)("with port: " + this.serverProperties_.getProperty("http_port") + " at " + this.serverProperties_.getProperty("http_url")));
            } else if (this.serverProperties_.getProperty("protocol").equalsIgnoreCase("HTTPS")) {
                logger_.info((Object)("with port: " + this.serverProperties_.getProperty("https_port") + " at " + this.serverProperties_.getProperty("https_url")));
            }
            String age = this.getProperties().getProperty("CookieMaxAgeInSeconds");
            if (age == null || age.length() == 0) {
                logger_.info((Object)"no coockie age set! will use expire after 60 Minutes (3600 seconds)");
                logger_.info((Object)"Usage (e.g.5 Minutes): CookieMaxAgeInSeconds=300 or CookieMaxAgeInSeconds=Never");
            } else {
                try {
                    this.cookieAge = age.equalsIgnoreCase("NEVER") ? -1 : Integer.parseInt(age);
                }
                catch (Exception e) {
                    logger_.info((Object)"invalid coockie age set! will use expire after 60 Minutes");
                }
            }
            String cookieDomain__ = this.getProperties().getProperty("COOKIEDOMAIN");
            if (cookieDomain__ == null || cookieDomain__.length() == 0) {
                logger_.info((Object)"no coockie domain set in properties file usage: COOKIEDOMAIN=genome.tugraz.at");
            } else {
                this.cookieDomain = cookieDomain__;
            }
        }
    }

    public static ConfigLoader getInstance(String applicationName) {
        ConfigLoader loader = (ConfigLoader)instanceHash.get(applicationName);
        if (loader == null) {
            loader = new ConfigLoader(applicationName);
            instanceHash.put(applicationName, loader);
        }
        return loader;
    }

    public int getCookieMaxAge() {
        return this.cookieAge;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public Properties getProperties() {
        return this.serverProperties_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

