/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.taglib;

import at.tugraz.genome.usermanagement.UserManagementConstants;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnectionManager;
import at.tugraz.genome.usermanagement.serverconnection.cache.PermissionCache;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import java.io.IOException;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckButtonPermissionTag
extends TagSupport {
    private String userName = null;
    private String resourceKey;
    private String accessLevel;
    private String trueValue;
    private String falseValue;
    private String applicationname;
    private String key = null;
    private String authenticationID;
    private ServerConnection serverConnection = null;
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$taglib$CheckButtonPermissionTag == null ? (class$at$tugraz$genome$usermanagement$taglib$CheckButtonPermissionTag = CheckButtonPermissionTag.class$("at.tugraz.genome.usermanagement.taglib.CheckButtonPermissionTag")) : class$at$tugraz$genome$usermanagement$taglib$CheckButtonPermissionTag));
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$taglib$CheckButtonPermissionTag;

    public void setResourceName(String name) {
        this.applicationname = name;
    }

    public String getResourceName() {
        return this.applicationname;
    }

    public String getFalseValue() {
        return this.falseValue;
    }

    public void setFalseValue(String falseValue) {
        this.falseValue = falseValue;
    }

    public String getTrueValue() {
        return this.trueValue;
    }

    public void setTrueValue(String trueValue) {
        this.trueValue = trueValue;
    }

    public void setAccessLevel(String level) {
        this.accessLevel = level;
    }

    public String getAccessLevel() {
        return this.accessLevel;
    }

    public void setResourceKey(String key) {
        this.resourceKey = key;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public int doEndTag() throws JspException {
        HttpSession session = this.pageContext.getSession();
        if (this.trueValue == null) {
            this.trueValue = "true";
        }
        if (this.falseValue == null) {
            this.falseValue = "false";
        }
        if (this.trueValue.length() == 0) {
            this.trueValue = "";
        }
        if (this.falseValue.length() == 0) {
            this.falseValue = "";
        }
        try {
            this.userName = ((UserVO)session.getAttribute(UserManagementConstants.USER)).getName();
        }
        catch (Exception ex) {
            this.userName = (String)session.getAttribute(UserManagementConstants.USER);
        }
        if (this.userName == null) {
            this.setResult(this.falseValue);
            return 6;
        }
        if (this.applicationname == null) {
            this.applicationname = (String)session.getAttribute(UserManagementConstants.APPLICATIONNAME);
        }
        if (this.applicationname == null) {
            logger_.error((Object)"no applicationame defined");
            this.setResult(this.falseValue);
            return 6;
        }
        this.key = ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword");
        if (this.key == null) {
            logger_.error((Object)"no applicationkey defined");
            this.setResult(this.falseValue);
            return 6;
        }
        if (this.getResourceKey() == null) {
            logger_.error((Object)"no Resourcekey defined");
            this.setResult(this.falseValue);
            return 6;
        }
        this.authenticationID = (String)session.getAttribute("Authentication_Id");
        if (this.authenticationID == null) {
            logger_.error((Object)"no authenticationID in session stored");
            this.setResult(this.falseValue);
            return 6;
        }
        this.serverConnection = ServerConnectionManager.getInstance().getConnection(this.applicationname);
        if (this.serverConnection == null) {
            logger_.error((Object)"no connection to UserManagement server");
            this.setResult(this.falseValue);
            return 6;
        }
        try {
            if (PermissionCache.hasPermission(this.userName, this.authenticationID, this.applicationname, this.resourceKey, this.accessLevel, this.key)) {
                logger_.debug((Object)("access granted to resource: " + this.resourceKey + ", with level: " + this.accessLevel + " for user " + this.userName));
                this.setResult(this.trueValue);
                return 6;
            }
            logger_.debug((Object)("access denied to resource: " + this.resourceKey + ", with level: " + this.accessLevel + " for user " + this.userName));
            this.setResult(this.falseValue);
            return 6;
        }
        catch (Exception ex) {
            logger_.error((Object)ex.toString());
            this.setResult(this.falseValue);
            return 6;
        }
    }

    private void setResult(String value) {
        try {
            this.pageContext.getOut().println(value);
        }
        catch (IOException ex1) {}
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

