/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.server.user.VO;

import at.tugraz.genome.usermanagement.server.institut.VO.InstitutVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import com.opensymphony.module.propertyset.ejb.types.VO.DataEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.DateEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.DecimalEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.NumberEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.PropertySetVO;
import com.opensymphony.module.propertyset.ejb.types.VO.StringEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.exception.PropertyException;
import com.opensymphony.util.DateHandler;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class ExtendedUserVO
extends UserVO
implements Serializable {
    private List groups;
    private PropertySetVO propertySet;
    private HashMap activeMap_;
    private boolean hasToChangePassword;
    private boolean applictationAuthenticationEnabled;
    private boolean ldapAuthenticationEnabled;
    private String currentApplication_;
    private InstitutVO mainInstitute;
    private Vector additionalInstitutes;
    private String lastLoginRealm;
    private Long lastLoginDate;
    private String homeDirectory;
    private String loginShell;
    private String changePeriode;
    private String timeToChangePWD;
    private String windowsDomain;
    private String logonScript;
    private String profilePath;
    private String windowsHomeDir;
    private String workstation;
    private String userSID;
    private String groupSID;
    private String dirDrive;
    private Long uid;
    private Long sambaGroupId;
    private String sambaGroup;
    private boolean isLogged;
    private boolean loggedOutSuccessfully;
    private static final String PROPERTY_FULLNAME = "fullName";
    private static final String PROPERTY_EMAIL = "email";
    private static final String ACCOUNT_START_DATE = "startdate";
    private static final String ACCOUNT_EXPIRE_DATE = "expiredate";
    private static final String DISABLED_REALM_LIST = "disabledRealmList";

    public ExtendedUserVO() {
        this.activeMap_ = new HashMap();
        this.propertySet = new PropertySetVO();
    }

    public ExtendedUserVO(Long id, String name) {
        super(id, name, "");
        this.name_ = name;
        this.activeMap_ = new HashMap();
        this.propertySet = new PropertySetVO();
    }

    public ExtendedUserVO(String name) {
        super(name);
        this.name_ = name;
        this.activeMap_ = new HashMap();
        this.propertySet = new PropertySetVO();
    }

    public List getGroups() {
        return this.groups;
    }

    public PropertySetVO getProperties() {
        return this.propertySet;
    }

    public void setGroups(List groupList) {
        this.groups = groupList;
    }

    public String getEmail() {
        try {
            return this.propertySet.getString(PROPERTY_EMAIL);
        }
        catch (PropertyException ex) {
            return "not available";
        }
    }

    public void setEmail(String email) {
        if (email == null) {
            email = "not available";
        }
        this.propertySet.setString(PROPERTY_EMAIL, email);
    }

    public void setExpireDate(Long expireDate) {
        if (expireDate == null) {
            expireDate = new Long(1L);
        }
        this.propertySet.setDate(ACCOUNT_EXPIRE_DATE, expireDate);
    }

    public Long getExpireDate() {
        try {
            return this.propertySet.getDate(ACCOUNT_EXPIRE_DATE);
        }
        catch (Exception ex) {
            return new Long(1L);
        }
    }

    public String getFullname() {
        return this.propertySet.getFullname();
    }

    public void setFullname(String fullname) {
        if (fullname == null) {
            fullname = "not available";
        }
        this.propertySet.setString(PROPERTY_FULLNAME, fullname);
        this.fullUserName_ = fullname;
    }

    public Long getStartDate() {
        try {
            return this.propertySet.getDate(ACCOUNT_START_DATE);
        }
        catch (PropertyException ex) {
            return new Long(0L);
        }
    }

    public void setStartDate(Long startDate) {
        if (startDate == null) {
            startDate = new Long(0L);
        }
        this.propertySet.setDate(ACCOUNT_START_DATE, startDate);
    }

    public String getAccountExpireDate() {
        try {
            return new Date(this.propertySet.getDate(ACCOUNT_EXPIRE_DATE)).toString();
        }
        catch (Exception ex) {
            return "not available";
        }
    }

    public String getAccountStartDate() {
        try {
            return new Date(this.propertySet.getDate(ACCOUNT_START_DATE)).toString();
        }
        catch (Exception ex) {
            return "not available";
        }
    }

    public String toString() {
        String returnString = "id: " + this.id_ + " name: " + this.name_ + " fullUserName: " + this.fullUserName_ + " hasToChangePswd: " + this.hasToChangePassword + " applictationAuthenticationEnabled: " + this.applictationAuthenticationEnabled + " ldapAuthenticationEnabled: " + this.ldapAuthenticationEnabled + "\n";
        returnString = returnString + "changePeriod: " + this.changePeriode + " timeToChangePswd: " + this.timeToChangePWD + " currentApplication: " + this.currentApplication_ + " lastLoginDate: " + this.lastLoginDate + " lastLoginRealm: " + this.lastLoginRealm + "\n";
        if (this.mainInstitute != null) {
            returnString = returnString + "institut: " + this.mainInstitute.getName() + " ";
        }
        returnString = returnString + "homeDirectory: " + this.homeDirectory + " loginShell: " + this.loginShell + " windowsDomain: " + this.windowsDomain + " logonScript: " + this.logonScript + " profilePath: " + this.profilePath + "\n";
        returnString = returnString + "windowsHomeDir: " + this.windowsHomeDir + " userSID: " + this.userSID + " groupSID: " + this.groupSID + " dirDrive: " + this.dirDrive + " uid: " + this.uid + " sambaGroupId " + this.sambaGroupId + " sambaGroup: " + this.sambaGroup + "\n";
        returnString = returnString + "startDate: " + this.getAccountStartDate() + " expireDate: " + this.getAccountExpireDate() + "\nactiveIn: ";
        Vector activeIn = this.getListOfApplicationsUserIsActive();
        int i = 0;
        while (i != activeIn.size()) {
            returnString = returnString.concat((String)activeIn.get(i)) + ",";
            ++i;
        }
        returnString = returnString.substring(0, returnString.length() - 1) + "\ninactiveIn: ";
        Vector inActiveIn = this.getListOfApplicationsUserIsInactive();
        int i2 = 0;
        while (i2 != inActiveIn.size()) {
            returnString = returnString.concat((String)inActiveIn.get(i2)) + ",";
            ++i2;
        }
        returnString = returnString.substring(0, returnString.length() - 1);
        return returnString;
    }

    public boolean isActiveInRealm(String realm) {
        if (this.activeMap_ == null) {
            return false;
        }
        Long active = (Long)this.activeMap_.get(realm);
        if (active == null) {
            return false;
        }
        return active > 0L;
    }

    public String getActiveInRealm(String realm) {
        return "" + this.isActiveInRealm(realm);
    }

    public boolean isActiveAtCurrentApplication() {
        return this.getActive().equals("active");
    }

    public String getActiveAtCurrentApplication() {
        return "" + this.isActiveAtCurrentApplication();
    }

    public String getActive() {
        if (this.currentApplication_ == null) {
            return "not available";
        }
        if (this.activeMap_ == null) {
            return "not available";
        }
        Long active = (Long)this.activeMap_.get(this.currentApplication_);
        if (active == null) {
            return "not available";
        }
        if (active > 0L) {
            return "active";
        }
        return "inactive";
    }

    public void setNameOfCurrentAplication(String realm) {
        this.currentApplication_ = realm;
    }

    public void setActiveAtCurrentApplication(String realm, boolean value) {
        if (this.activeMap_ == null) {
            return;
        }
        Long valueToAdd = null;
        valueToAdd = value ? new Long(1L) : new Long(0L);
        this.activeMap_.put(realm, valueToAdd);
    }

    public boolean isHasToChangePassword() {
        return this.hasToChangePassword;
    }

    public String getHasToChangePassword() {
        return "" + this.isHasToChangePassword();
    }

    public void setHasToChangePassword(boolean hasToChangePassword) {
        this.hasToChangePassword = hasToChangePassword;
    }

    public String getLastLoginDate() {
        if (this.lastLoginDate == null) {
            return "not available";
        }
        if (this.lastLoginDate == 0L) {
            return "not available";
        }
        return DateHandler.toString(new java.sql.Date(this.lastLoginDate));
    }

    public String getLastLoginRealm() {
        return this.lastLoginRealm;
    }

    public void setLastLoginDate(Long lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public void setLastLoginRealm(String lastLoginRealm) {
        this.lastLoginRealm = lastLoginRealm;
    }

    public Vector getListOfApplicationsUserIsActive() {
        Vector<String> active = new Vector<String>();
        if (this.activeMap_ == null) {
            return active;
        }
        Iterator iter = this.activeMap_.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Long appActive = (Long)this.activeMap_.get(key);
            if (appActive == null || appActive <= 0L) continue;
            active.add(key);
        }
        return active;
    }

    public Vector getListOfApplicationsUserIsInactive() {
        Vector<String> inactive = new Vector<String>();
        if (this.activeMap_ == null) {
            return inactive;
        }
        Iterator iter = this.activeMap_.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Long appActive = (Long)this.activeMap_.get(key);
            if (appActive == null || appActive != 0L) continue;
            inactive.add(key);
        }
        return inactive;
    }

    public InstitutVO getMainInstitute() {
        return this.mainInstitute;
    }

    public InstitutVO getInstitut() {
        return this.mainInstitute;
    }

    public void setMainInstitute(InstitutVO Institut) {
        this.mainInstitute = Institut;
    }

    public ExtendedUserVO(ExtendedUserVO vo) {
        this();
        boolean success;
        Serializable data;
        String key;
        if (vo == null) {
            return;
        }
        this.changePeriode = vo.getChangePeriode();
        this.name_ = vo.getName();
        this.id_ = vo.getID();
        this.setGroups(vo.getGroups());
        this.hasToChangePassword = vo.isHasToChangePassword();
        this.mainInstitute = vo.getMainInstitute();
        this.additionalInstitutes = vo.getAdditionalInstitutes();
        this.currentApplication_ = vo.getCurrentApplication();
        this.activeMap_ = vo.activeMap_;
        this.applictationAuthenticationEnabled = vo.isApplicationAuthenticationEnabled();
        this.setLdapAuthenticationEnabled(vo.isLdapAuthenticationEnabled());
        this.lastLoginRealm = vo.getLastLoginRealm();
        PropertySetVO peropertiesVO = vo.getProperties();
        HashMap dataVO = peropertiesVO.getDataEntityVO();
        HashMap dateVO = peropertiesVO.getDateEntityVO();
        HashMap decimalVO = peropertiesVO.getDecimalEntityVO();
        HashMap numberVO = peropertiesVO.getNumberEntityVO();
        HashMap stringVO = peropertiesVO.getStringEntityVO();
        this.propertySet.setString(PROPERTY_EMAIL, vo.getEmail());
        this.propertySet.setString(PROPERTY_FULLNAME, vo.getFullname());
        this.propertySet.setDate(ACCOUNT_EXPIRE_DATE, vo.getExpireDate());
        this.propertySet.setDate(ACCOUNT_START_DATE, vo.getStartDate());
        Set set = null;
        Iterator iter = null;
        set = dataVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            data = (DataEntityVO)dataVO.get(key);
            this.propertySet.setData(((DataEntityVO)data).getKey(), ((DataEntityVO)data).getBytes());
        }
        set = decimalVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            data = (DecimalEntityVO)decimalVO.get(key);
            if (((DecimalEntityVO)data).getType() == 4) {
                this.propertySet.setDouble(((DecimalEntityVO)data).getKey(), ((DecimalEntityVO)data).getValue());
                continue;
            }
            success = false;
        }
        set = stringVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            data = (StringEntityVO)stringVO.get(key);
            if (data == null) {
                data = new StringEntityVO();
                ((StringEntityVO)data).setKey(key);
                ((StringEntityVO)data).setValue("");
            }
            if (((StringEntityVO)data).getValue() == null) {
                ((StringEntityVO)data).setValue("");
            }
            this.propertySet.setString(((StringEntityVO)data).getKey(), ((StringEntityVO)data).getValue());
        }
        set = dateVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            data = (DateEntityVO)dateVO.get(key);
            this.propertySet.setDate(((DateEntityVO)data).getKey(), ((DateEntityVO)data).getValue());
        }
        set = numberVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            data = (NumberEntityVO)numberVO.get(key);
            if (((NumberEntityVO)data).getType() == 1) {
                if (((NumberEntityVO)data).getNumber() == new Long(1L)) {
                    this.propertySet.setBoolean(((NumberEntityVO)data).getKey(), true);
                    continue;
                }
                this.propertySet.setBoolean(((NumberEntityVO)data).getKey(), false);
                continue;
            }
            if (((NumberEntityVO)data).getType() == 2) {
                this.propertySet.setLong(((NumberEntityVO)data).getKey(), ((NumberEntityVO)data).getNumber().intValue());
                continue;
            }
            if (((NumberEntityVO)data).getType() == 3) {
                this.propertySet.setLong(((NumberEntityVO)data).getKey(), ((NumberEntityVO)data).getNumber());
                continue;
            }
            success = false;
        }
        this.lastLoginDate = vo.lastLoginDate;
        this.homeDirectory = vo.getHomeDirectory();
        this.loginShell = vo.getLoginShell();
        this.timeToChangePWD = vo.timeToChangePWD;
        this.windowsDomain = vo.getWindowsDomain();
        this.logonScript = vo.logonScript;
        this.profilePath = vo.profilePath;
        this.windowsHomeDir = vo.windowsHomeDir;
        this.workstation = vo.workstation;
        this.userSID = vo.userSID;
        this.groupSID = vo.groupSID;
        this.dirDrive = vo.dirDrive;
        this.uid = vo.uid;
        this.sambaGroupId = vo.sambaGroupId;
        this.sambaGroup = vo.sambaGroup;
        this.isLogged = vo.isLogged;
        this.loggedOutSuccessfully = vo.loggedOutSuccessfully;
    }

    public void setData(ExtendedUserVO vo) {
        boolean success;
        Serializable data;
        String key;
        if (vo == null) {
            return;
        }
        this.name_ = vo.getName();
        this.id_ = vo.getID();
        this.setGroups(vo.getGroups());
        this.hasToChangePassword = vo.isHasToChangePassword();
        this.mainInstitute = vo.getMainInstitute();
        this.additionalInstitutes = vo.getAdditionalInstitutes();
        this.currentApplication_ = vo.getCurrentApplication();
        this.activeMap_ = vo.activeMap_;
        this.setApplicationAuthenticationEnabled(vo.isApplicationAuthenticationEnabled());
        this.setLdapAuthenticationEnabled(vo.isLdapAuthenticationEnabled());
        this.lastLoginRealm = vo.getLastLoginRealm();
        PropertySetVO peropertiesVO = vo.getProperties();
        HashMap dataVO = peropertiesVO.getDataEntityVO();
        HashMap dateVO = peropertiesVO.getDateEntityVO();
        HashMap decimalVO = peropertiesVO.getDecimalEntityVO();
        HashMap numberVO = peropertiesVO.getNumberEntityVO();
        HashMap stringVO = peropertiesVO.getStringEntityVO();
        this.propertySet.setString(PROPERTY_EMAIL, vo.getEmail());
        this.propertySet.setString(PROPERTY_FULLNAME, vo.getFullname());
        this.propertySet.setDate(ACCOUNT_EXPIRE_DATE, vo.getExpireDate());
        this.propertySet.setDate(ACCOUNT_START_DATE, vo.getStartDate());
        Set set = null;
        Iterator iter = null;
        set = dataVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            data = (DataEntityVO)dataVO.get(key);
            this.propertySet.setData(((DataEntityVO)data).getKey(), ((DataEntityVO)data).getBytes());
        }
        set = decimalVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            data = (DecimalEntityVO)decimalVO.get(key);
            if (((DecimalEntityVO)data).getType() == 4) {
                this.propertySet.setDouble(((DecimalEntityVO)data).getKey(), ((DecimalEntityVO)data).getValue());
                continue;
            }
            success = false;
        }
        set = stringVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            data = (StringEntityVO)stringVO.get(key);
            if (data == null) {
                data = new StringEntityVO();
                ((StringEntityVO)data).setKey(key);
                ((StringEntityVO)data).setValue("");
            }
            if (((StringEntityVO)data).getValue() == null) {
                ((StringEntityVO)data).setValue("");
            }
            this.propertySet.setString(((StringEntityVO)data).getKey(), ((StringEntityVO)data).getValue());
        }
        set = dateVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            data = (DateEntityVO)dateVO.get(key);
            this.propertySet.setDate(((DateEntityVO)data).getKey(), ((DateEntityVO)data).getValue());
        }
        set = numberVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            data = (NumberEntityVO)numberVO.get(key);
            if (((NumberEntityVO)data).getType() == 1) {
                if (((NumberEntityVO)data).getNumber() == new Long(1L)) {
                    this.propertySet.setBoolean(((NumberEntityVO)data).getKey(), true);
                    continue;
                }
                this.propertySet.setBoolean(((NumberEntityVO)data).getKey(), false);
                continue;
            }
            if (((NumberEntityVO)data).getType() == 2) {
                this.propertySet.setLong(((NumberEntityVO)data).getKey(), ((NumberEntityVO)data).getNumber().intValue());
                continue;
            }
            if (((NumberEntityVO)data).getType() == 3) {
                this.propertySet.setLong(((NumberEntityVO)data).getKey(), ((NumberEntityVO)data).getNumber());
                continue;
            }
            success = false;
        }
    }

    public String getCurrentApplication() {
        return this.currentApplication_;
    }

    public Long getSambaGroupId() {
        return this.sambaGroupId;
    }

    public String getSambaGroup() {
        return this.sambaGroup;
    }

    public void setSambaGroup(String sambaGroup) {
        this.sambaGroup = sambaGroup;
    }

    public void setSambaGroupId(Long id) {
        this.sambaGroupId = id;
    }

    public String getHomeDirectory() {
        if (this.homeDirectory == null || this.homeDirectory.length() == 0) {
            this.homeDirectory = "not available";
        }
        return this.homeDirectory;
    }

    public void setHomeDirectory(String homeDirectory) {
        if (homeDirectory == null) {
            return;
        }
        this.homeDirectory = homeDirectory;
    }

    public String getLoginShell() {
        return this.loginShell;
    }

    public void setLoginShell(String loginShell) {
        if (loginShell == null) {
            return;
        }
        this.loginShell = loginShell;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        if (uid == null) {
            return;
        }
        this.uid = uid;
    }

    public String getWindowsDomain() {
        if (this.windowsDomain == null) {
            return "not available";
        }
        return this.windowsDomain;
    }

    public String getWindowsHomeDir() {
        if (this.windowsHomeDir == null) {
            return "not available";
        }
        return this.windowsHomeDir;
    }

    public void setWindowsDomain(String windowsDomain) {
        this.windowsDomain = windowsDomain;
    }

    public void setWindowsHomeDir(String windowsHomeDir) {
        this.windowsHomeDir = windowsHomeDir;
    }

    public String getWorkstation() {
        if (this.workstation == null) {
            return "not available";
        }
        return this.workstation;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public String getLogonScript() {
        if (this.logonScript == null) {
            return "not available";
        }
        return this.logonScript;
    }

    public void setLogonScript(String logonScript) {
        this.logonScript = logonScript;
    }

    public String getProfilePath() {
        if (this.profilePath == null) {
            return "not available";
        }
        return this.profilePath;
    }

    public void setProfilePath(String profilePath) {
        this.profilePath = profilePath;
    }

    public String getGroupSID() {
        return this.groupSID;
    }

    public void setGroupSID(String groupSID) {
        this.groupSID = groupSID;
    }

    public String getUserSID() {
        return this.userSID;
    }

    public void setUserSID(String userSID) {
        this.userSID = userSID;
    }

    public String getDirDrive() {
        return this.dirDrive;
    }

    public void setDirDrive(String dirDrive) {
        this.dirDrive = dirDrive;
    }

    public String getTimeToChangePasswordInDays() {
        return this.timeToChangePWD;
    }

    public void setTimeToChangePasswordInDays(String time) {
        this.timeToChangePWD = time == null ? "never" : time;
    }

    public String getChangePeriode() {
        return this.changePeriode;
    }

    public void setChangePeriode(String changePeriode) {
        this.changePeriode = changePeriode;
    }

    public boolean isApplicationAuthenticationEnabled() {
        return this.applictationAuthenticationEnabled;
    }

    public String getApplicationAuthenticationEnabled() {
        return "" + this.applictationAuthenticationEnabled;
    }

    public void setApplicationAuthenticationEnabled(boolean enabled) {
        this.applictationAuthenticationEnabled = enabled;
    }

    public boolean isLdapAuthenticationEnabled() {
        return this.ldapAuthenticationEnabled;
    }

    public String getLdapAuthenticationEnabled() {
        return "" + this.ldapAuthenticationEnabled;
    }

    public void setLdapAuthenticationEnabled(boolean enabled) {
        this.ldapAuthenticationEnabled = enabled;
    }

    public Vector getAdditionalInstitutes() {
        return this.additionalInstitutes;
    }

    public void setAdditionalInstitutes(Vector additionalInstitutes) {
        this.additionalInstitutes = additionalInstitutes;
    }

    public boolean isIsLogged() {
        return this.isLogged;
    }

    public void setIsLogged(boolean isLogged) {
        this.isLogged = isLogged;
    }

    public boolean isLoggedOutSuccessfully() {
        return this.loggedOutSuccessfully;
    }

    public void setLoggedOutSuccessfully(boolean loggedOutSuccessfully) {
        this.loggedOutSuccessfully = loggedOutSuccessfully;
    }
}

