/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.serverconnection;

import at.tugraz.genome.usermanagement.UserManagementConstants;
import at.tugraz.genome.usermanagement.serverconnection.exception.ProtocolException;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import com.opensymphony.module.user.provider.ejb.util.Base64;
import com.opensymphony.module.user.provider.ejb.util.PasswordDigester;

public abstract class AbstractServerConnection {
    protected ConfigLoader config_;
    protected static final String GET_USERVO = "getUserVO";
    protected static final String GET_USERVO_EXTENDED = "getUserVOExtended";
    protected static final String GET_DEFAULT_USERVO = "getdefaultuservo";
    protected static final String HAS_USER_HAS_ACCESS_LEVEL = "hasUserAccessLevel";
    protected static final String AUTHENTICATE_USER = "authentication";
    protected static final String AUTHENTICATE_SAML_USER = "samlAuthentication";
    protected static final String LOGOUT_USER = "logoutUser";
    protected static final String REFRESH_AUTHENTICATION_ID = "refreshAuthenticationId";
    protected static final String CHANGE_PASSWORD = "changePassword";
    protected static final String GET_USERS_OF_APPLICATION = "getAllUsersOffApplication";
    protected static final String GET_EXTENDEDUSERS_OF_APPLICATION = "getAllExtendedUsersOffApplication";
    protected static final String ADD_USER = "addUser";
    protected static final String EDIT_USER = "editUser";
    protected static final String GET_USER_BY_ID = "getUserByID";
    protected static final String GET_USER_BY_ID_EXTENDED = "getUserByIDExtended";
    protected static final String GET_TEMPLATEUSERS_OF_REALM = "getTemplateUsersOfRealm";
    protected static final String GET_USERID_FROM_USERNAME = "getUserIDFromName";
    protected static final String DISABLE_USER_IN_REALM = "admin/disableUserInApplication";
    protected static final String ENABLE_USER_IN_REALM = "admin/enableUserInApplication";
    protected static final String EXISTS_USER = "admin/existsUser";
    protected static final String COPY_ACLS_FROM_USER = "admin/copyAcl";
    protected static final String GET_USER_BY_ID_EXTENDED_WITHOUT_ADMIN = "getUserByIDExtendedWithoutAdmin";
    protected static final String GET_ALL_GROUPS_ENABLED_IN_APPLICATION = "admin/getAllGroupsEnabledInApplication";
    protected static final String ADD_USER_TO_GROUP = "admin/addUserToGroup";
    protected static final String REMOVE_USER_FROM_GROUP = "admin/removeUserFromGroup";
    protected static final String GET_USERVO_REGEX = "admin/getUserVORegEx";
    protected static final String GET_USERVOEXTENDED_REGEX = "admin/getUserVOExtendedRegExp";
    protected static final String CREATE_GROUP = "admin/createGroup";
    protected static final String GET_ACL_OF_USER = "rights/getAclsOfUser";
    protected static final String GET_ACL_OF_GROUP = "rights/getAclsOfGroup";
    protected static final String GET_RESOURCES_OF_APPLICATION = "rights/getAllResourcesOfApplication";
    protected static final String SET_ACL_OF_USER = "rights/setAclsOfUser";
    protected static final String SET_ACL_OF_GROUP = "rights/setAclsOfGroup";
    protected static final String DELETE_GROUP = "admin/deleteGroup";
    protected static final String GET_COOKIE_KEY = "cookie/getCookieKey";
    protected static final String GET_INFOPRMATION_ABOUT_RESOURCE_BY_USER = "rights/getInformationAboutUserForResource";
    protected static final String GET_ACL_BY_RESOURCEKEY_AND_USER = "rights/getAclOfResourceByUser";
    protected static final String GET_ACL_BY_RESOURCEKEY_AND_GROUP = "rights/getAclOfResourceByGroup";
    protected static final String CREATE_ACL = "rights/createAcl";
    protected static final String DELETE_ACL = "rights/deleteAcl";
    protected static final String IS_USER_ALLOWED = "/isUserAllowedInApplication";
    protected static final String GET_ALL_INSTITUTES = "/institut/getAllInstitutes";
    protected static final String GET_ALL_USERS_FROM_INSTITUT = "/institut/getAllUsersFromInstitut";
    protected static final String GET_USERS_WITH_PROPERTYKEY = "/admin/getUsersWithPropertyKey";
    protected static final String AUTHENTICATION_ID = "Authentication_Id=";
    protected static final String USER_ID = "userID=";
    protected static final String APPLICATION_PASSWORD = "appPasswd=";
    protected static final String VERSION_OF_KEY = UserManagementConstants.VERSION_OF_KEY + "=";
    protected static final String COOKIE_MAX_AGE = UserManagementConstants.COOKIE_MAX_AGE + "=";
    protected static final String ADMIN_NAME = "admin=";
    protected static final String USERNAME = "username=";
    protected static final String GROUPNAME = "groupname=";
    protected static final String APPLICATION = "application=";
    protected static final String EMAIL = "email=";
    protected static final String FULLNAME = "fullname=";
    protected static final String PASSWORD = "password=";
    protected static final String OLD_PASSWORD = "oldpassword=";
    protected static final String ACCESS_LEVEL = "accessLevel=";
    protected static final String RESOURCE = "resource=";
    protected static final String DESTINATION_USER = "destination=";
    protected static final String WITH_GROUP_USERS = "groupUsers=";
    protected static final String INCLUDE_GLOBALLY_DISABLED_USERS = "includeGloballyDisabledUsers=";
    protected static final String SOURCE_USER = "source=";
    protected static final String REG_EXPRESSION = "regex=";
    protected static final String ACL_ID = "aclId=";
    protected static final String RESOURCE_KEY = "resourceKey=";
    protected static final String INSTITUT_ID = "institutId=";
    protected static final String PROPERTY_KEY = "propertyKey=";
    protected static final String PASSWORD_CHANGEPERIOD = "period=";
    protected static String PROTOCOL;
    protected static String PORT;
    protected static String SERVERNAME;
    protected static String URL;

    public AbstractServerConnection(ConfigLoader config) {
        this.config_ = config;
    }

    private String createHash(String original) {
        byte[] digested = PasswordDigester.digest(original.getBytes());
        byte[] encoded = Base64.encode(digested);
        return new String(encoded);
    }

    private boolean compareHash(String hashedValue, String unhashedValue) {
        return hashedValue.equals(this.createHash(unhashedValue));
    }

    protected static boolean checkUrl(String url) throws ProtocolException {
        if (url.length() > 1024) {
            throw new ProtocolException("http request to long >2550!");
        }
        return true;
    }

    protected void checkConfig() {
        if (PORT == null) {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!                                         !");
            System.out.println("! No Port for Usermanagement server set   !");
            System.out.println("!                                         !");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        if (SERVERNAME == null) {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!                                         !");
            System.out.println("! No URL for Usermanagement server set   !");
            System.out.println("!                                         !");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        if (PROTOCOL == null) {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!                                         !");
            System.out.println("! No PROTOCOL for Usermanagement server set   !");
            System.out.println("!                                         !");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }
}

