/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.serverconnection;

import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ejb.Connection;
import at.tugraz.genome.usermanagement.serverconnection.ejb.ServerConnectionEJB;
import at.tugraz.genome.usermanagement.serverconnection.exception.ProtocolException;
import at.tugraz.genome.usermanagement.serverconnection.http.ServerConnectionHTTP;
import at.tugraz.genome.usermanagement.serverconnection.https.ServerConnectionHTTPS;
import at.tugraz.genome.usermanagement.serverconnection.soap.ServerConnectionSOAP;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerConnectionFactory {
    private static Connection myServerConnection;
    private static final Log logger_;
    private String protocol_;
    private ConfigLoader config_;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$serverconnection$ServerConnectionFactory;

    ServerConnectionFactory() {
    }

    public ServerConnection makeConnection(String applicationName) throws ProtocolException, Exception {
        this.config_ = ConfigLoader.getInstance(applicationName);
        this.protocol_ = this.config_.getProperties().getProperty("protocol");
        logger_.debug((Object)("will load Protocoll " + this.protocol_ + " for the connection to the usermanagemnt server"));
        if (this.protocol_ == null) {
            this.protocol_ = "";
        }
        if (this.protocol_.equalsIgnoreCase("EJB")) {
            return new ServerConnectionEJB(this.config_);
        }
        if (this.protocol_.equalsIgnoreCase("RMI")) {
            return new ServerConnectionEJB(this.config_);
        }
        if (this.protocol_.equalsIgnoreCase("HTTP")) {
            return new ServerConnectionHTTP(this.config_);
        }
        if (this.protocol_.equalsIgnoreCase("HTTPS")) {
            this.checkForJSSE();
            return new ServerConnectionHTTPS(this.config_);
        }
        if (this.protocol_.equalsIgnoreCase("SOAP")) {
            return new ServerConnectionSOAP(this.config_);
        }
        throw new ProtocolException("protocol not supported");
    }

    private boolean checkForJSSE() throws ProtocolException {
        try {
            Class.forName("com.sun.net.ssl.internal.ssl.Provider");
            return true;
        }
        catch (Exception e) {
            throw new ProtocolException("JSEE is not installed correcttly!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$serverconnection$ServerConnectionFactory == null ? (class$at$tugraz$genome$usermanagement$serverconnection$ServerConnectionFactory = ServerConnectionFactory.class$("at.tugraz.genome.usermanagement.serverconnection.ServerConnectionFactory")) : class$at$tugraz$genome$usermanagement$serverconnection$ServerConnectionFactory));
    }
}

