/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.serverconnection.soap;

import at.tugraz.genome.crypt.SecurityFactory;
import at.tugraz.genome.usermanagement.UserManagementConstants;
import at.tugraz.genome.usermanagement.server.MessageBean;
import at.tugraz.genome.usermanagement.server.acl.VO.AclVO;
import at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO;
import at.tugraz.genome.usermanagement.server.authentication.AuthenticationToken;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.serverconnection.AbstractServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import at.tugraz.genome.usermanagement.serverconnection.soap.util.AuthenticationHandlerSOAP;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.encoding.ser.MapDeserializerFactory;
import org.apache.axis.encoding.ser.MapSerializerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.util.FilterDoubleEntries;
import server.Management.util.MessageFromServer;

public class ServerConnectionSOAP
extends AbstractServerConnection
implements ServerConnection {
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$serverconnection$soap$ServerConnectionSOAP == null ? (class$at$tugraz$genome$usermanagement$serverconnection$soap$ServerConnectionSOAP = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.serverconnection.soap.ServerConnectionSOAP")) : class$at$tugraz$genome$usermanagement$serverconnection$soap$ServerConnectionSOAP));
    private AuthenticationHandlerSOAP authenticationHandler_;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$serverconnection$soap$ServerConnectionSOAP;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$types$VO$DataEntityVO;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$types$VO$DateEntityVO;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$types$VO$DecimalEntityVO;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$types$VO$NumberEntityVO;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$types$VO$PropertySetVO;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$types$VO$StringEntityVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutMembersVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$user$VO$ExtendedUserVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$user$VO$UserVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$acl$VO$AclVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$group$VO$SmallGroupVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$resource$VO$ResourceVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$application$VO$ApplicationVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$user$VO$UserVOToAdd;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$right$VO$RightOfResourceVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$admin$VO$AdminsgroupVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$admin$VO$AdminVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$logging$VO$LoggingVO;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$unixserver$VO$LdapAccountVO;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$MessageBean;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$authentication$AuthenticationToken;

    public ServerConnectionSOAP(ConfigLoader config) {
        super(config);
        AbstractServerConnection.PORT = this.config_.getProperties().getProperty("soap_port");
        AbstractServerConnection.SERVERNAME = this.config_.getProperties().getProperty("soap_url");
        AbstractServerConnection.PROTOCOL = this.config_.getProperties().getProperty("protocol").toLowerCase();
        AbstractServerConnection.URL = UserManagementConstants.AXIS_HTTP + AbstractServerConnection.SERVERNAME + ":" + AbstractServerConnection.PORT + UserManagementConstants.AXIS_URL;
        logger_.info((Object)"Initializing UserManagement SOAP server connection");
        logger_.info((Object)("Initializing UserManagement SOAP server connection " + AbstractServerConnection.URL));
        this.authenticationHandler_ = AuthenticationHandlerSOAP.getInstance(config);
        this.checkConfig();
    }

    public Object getUserManagementBySOAP(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        if (parameters == null) {
            return null;
        }
        String endpoint = AbstractServerConnection.URL + "UserConnector/";
        try {
            Service service = new Service();
            Call call = null;
            logger_.info((Object)("will connect to " + endpoint));
            if (targetObjectURI.compareTo("urn:UserConnector") == 0) {
                call = this.getCall("UserConnector", endpoint, methodName);
            }
            if (call != null) {
                result = call.invoke(parameters.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Object getResourceManagementBySOAP(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        if (parameters == null) {
            return null;
        }
        String endpoint = AbstractServerConnection.URL + "ResourceConnector/";
        try {
            Service service = new Service();
            Call call = null;
            logger_.info((Object)("will connect to " + endpoint));
            if (targetObjectURI.compareTo("urn:ResourceConnector") == 0) {
                call = this.getCall("ResourceConnector", endpoint, methodName);
            }
            if (call != null) {
                result = call.invoke(parameters.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Object getGroupManagementBySOAP(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        if (parameters == null) {
            return null;
        }
        String endpoint = AbstractServerConnection.URL + "GroupConnector/";
        try {
            Service service = new Service();
            Call call = null;
            logger_.info((Object)("will connect to " + endpoint));
            if (targetObjectURI.compareTo("urn:GroupConnector") == 0) {
                call = this.getCall("GroupConnector", endpoint, methodName);
            }
            if (call != null) {
                result = call.invoke(parameters.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Object getRightsManagementBySOAP(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        if (parameters == null) {
            return null;
        }
        String endpoint = AbstractServerConnection.URL + "RightsConnector/";
        try {
            Service service = new Service();
            Call call = null;
            logger_.info((Object)("will connect to " + endpoint));
            if (targetObjectURI.compareTo("urn:RightsConnector") == 0) {
                call = this.getCall("RightsConnector", endpoint, methodName);
            }
            if (call != null) {
                result = call.invoke(parameters.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Object getAclManagementBySOAP(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        if (parameters == null) {
            return null;
        }
        String endpoint = AbstractServerConnection.URL + "AclConnector/";
        try {
            Service service = new Service();
            Call call = null;
            logger_.info((Object)("will connect to " + endpoint));
            if (targetObjectURI.compareTo("urn:AclConnector") == 0) {
                call = this.getCall("AclConnector", endpoint, methodName);
            }
            if (call != null) {
                result = call.invoke(parameters.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Object getApplicationManagementBySOAP(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        if (parameters == null) {
            return null;
        }
        String endpoint = AbstractServerConnection.URL + "ApplicationConnector/";
        try {
            Service service = new Service();
            Call call = null;
            logger_.info((Object)("will connect to " + endpoint));
            if (targetObjectURI.compareTo("urn:ApplicationConnector") == 0) {
                call = this.getCall("ApplicationConnector", endpoint, methodName);
            }
            if (call != null) {
                result = call.invoke(parameters.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Object getInstitutManagementBySOAP(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        if (parameters == null) {
            return null;
        }
        String endpoint = AbstractServerConnection.URL + "InstitutConnector/";
        try {
            Service service = new Service();
            Call call = null;
            logger_.info((Object)("will connect to " + endpoint));
            if (targetObjectURI.compareTo("urn:InstitutConnector") == 0) {
                call = this.getCall("InstitutConnector", endpoint, methodName);
            }
            if (call != null) {
                result = call.invoke(parameters.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public UserVO getUserByID(Long id, String applicationname, String applicationPassword) throws UserSecurityException {
        if (id == null || applicationname == null || applicationPassword == null) {
            return null;
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(applicationname, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            return null;
        }
        try {
            Vector<Long> params = new Vector<Long>();
            params.add(id);
            return (UserVO)this.getUserManagementBySOAP("urn:UserConnector", "getUserByID", params);
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public UserVO getUserVO(String username, String authenticationID, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || username.length() == 0) {
            return null;
        }
        try {
            this.checkRegisteredAndisLogged(username, applicationPassword, authenticationID, applicationname);
        }
        catch (UserSecurityException ex) {
            logger_.error((Object)ex.toString());
            return null;
        }
        try {
            Vector<String> params = new Vector<String>();
            params.add(username);
            return (UserVO)this.getUserManagementBySOAP("urn:UserConnector", "getUserVO", params);
        }
        catch (Exception ex) {
            logger_.error((Object)ex.toString());
            return null;
        }
    }

    public ExtendedUserVO getUserVOExtended(String name, String applicationname, String authenticationID, String applicationpassword) throws UserSecurityException {
        if (applicationname == null || applicationpassword == null || authenticationID == null || name == null) {
            throw new UserSecurityException("unsufficient data");
        }
        try {
            Vector<String> params = new Vector<String>();
            params.add(name);
            ExtendedUserVO result = (ExtendedUserVO)this.getUserManagementBySOAP("urn:UserConnector", "getUserVOExtended", params);
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean hasUserAccessLevel(String username, String authenticationID, String applicationname, String resource, String accessLevel, String applicationPassword) throws RemoteException, UserSecurityException {
        if (username == null || applicationname == null || resource == null || accessLevel == null) {
            return false;
        }
        try {
            this.checkRegisteredAndisLogged(username, applicationPassword, authenticationID, applicationname);
        }
        catch (UserSecurityException ex) {
            logger_.error((Object)ex.toString());
            return false;
        }
        Vector<String> params = new Vector<String>();
        params.add(username);
        params.add(applicationname);
        params.add(resource);
        params.add(accessLevel);
        return (Boolean)this.getRightsManagementBySOAP("urn:RightsConnector", "hasUserAccessLevel", params);
    }

    public AuthenticationToken authenticateUser(String applicationname, String username, String password, String applicationpassword, String ipAddress) throws RemoteException, UserSecurityException {
        if (username == null || applicationname == null || password == null || applicationpassword == null || ipAddress == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(applicationname).encrypt(password);
        Vector<Object> params = new Vector<Object>();
        params.add(applicationname);
        params.add(username);
        params.add(encryptedPassword);
        params.add(ipAddress);
        params.add(new Long(ConfigLoader.getInstance(applicationname).getCookieMaxAge()));
        return (AuthenticationToken)this.getRightsManagementBySOAP("urn:RightsConnector", "authenticateUser", params);
    }

    public AuthenticationToken authenticateSamlUser(String applicationname, String username, String applicationpassword, String ipAddress, String samlAlias, String samlRealm) throws RemoteException, UserSecurityException {
        if (username == null || applicationname == null || applicationpassword == null || ipAddress == null || samlAlias == null || samlRealm == null) {
            throw new UserSecurityException("unsufficient data");
        }
        String encryptedSamlAlias = SecurityFactory.getInstance().getNewestCookieEncrypter(applicationname).encrypt(samlAlias);
        Vector<Object> params = new Vector<Object>();
        params.add(applicationname);
        params.add(username);
        params.add(ipAddress);
        params.add(encryptedSamlAlias);
        params.add(samlRealm);
        params.add(new Long(ConfigLoader.getInstance(applicationname).getCookieMaxAge()));
        return (AuthenticationToken)this.getRightsManagementBySOAP("urn:RightsConnector", "authenticateUser", params);
    }

    public MessageBean changePassword(String username, String adminusername, String authenticationID, String newpassword, String oldpassword, String changePeriode, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || newpassword == null || authenticationID == null || applicationname == null || applicationPassword == null || oldpassword == null) {
            return new MessageBean("username or new password null");
        }
        if (newpassword != null && newpassword.length() < 8) {
            return new MessageBean("password must execced 8 characters, cannot create new user");
        }
        if (!newpassword.matches("(.)*([0-9])+(.)*")) {
            return new MessageBean("password must contain at least one number (0-9), cannot create new user");
        }
        if (!newpassword.matches("(.)*(\\p{Punct})+(.)*")) {
            return new MessageBean("password must contain at least special character (!@#$%^&*()), cannot create new user");
        }
        if (adminusername == null) {
            adminusername = "";
        }
        if (oldpassword == null) {
            oldpassword = "";
        }
        String newPasswordEncrypted = SecurityFactory.getInstance().getCookieEncrypter(applicationname).encrypt(newpassword);
        String oldPasswordEncrypted = SecurityFactory.getInstance().getCookieEncrypter(applicationname).encrypt(oldpassword);
        if (adminusername.length() > 0 && this.checkRegisteredAndisAdmin(adminusername, applicationPassword, authenticationID, applicationname)) {
            MessageBean msg = new MessageBean();
            Vector<String> params = new Vector<String>();
            params.add(username);
            params.add(newPasswordEncrypted);
            params.add(changePeriode);
            msg = (MessageBean)this.getUserManagementBySOAP("urn:UserConnector", "setPassword", params);
            if (!msg.isError()) {
                logger_.info((Object)("administrator set new password for user: " + username));
            } else {
                logger_.info((Object)("could not set new password for user as adminstrator : " + msg.getMessage()));
            }
            return msg;
        }
        if (!this.checkRegisteredAndisLogged(username, applicationPassword, authenticationID, applicationname)) {
            MessageBean msg = new MessageBean("user not loged in or application not registered");
            return msg;
        }
        Vector<Object> params = new Vector<Object>();
        params.add(username);
        params.add(oldPasswordEncrypted);
        if (!((Boolean)this.getUserManagementBySOAP("urn:UserConnector", "checkPassword", params)).booleanValue()) {
            throw new UserSecurityException("old password does not match");
        }
        params.clear();
        params.add(username);
        params.add(newPasswordEncrypted);
        params.add(changePeriode);
        params.add(new Boolean(true));
        return (MessageBean)this.getUserManagementBySOAP("urn:UserConnector", "setPassword", params);
    }

    public Vector getExtendedUsersOfApplication(String applicationname, String applicationpassword, boolean withGroupMembers, boolean includeGlobalyDisabledUsers) throws UserSecurityException {
        if (applicationname == null || applicationpassword == null) {
            return null;
        }
        if (!this.checkApplicationIsRegistered(applicationname, applicationpassword)) {
            return null;
        }
        Vector result = null;
        Vector<Object> params = new Vector<Object>();
        params.add(applicationname);
        params.add(new Boolean(includeGlobalyDisabledUsers));
        result = withGroupMembers ? (Vector)this.getApplicationManagementBySOAP("urn:ApplicationConnector", "getAllUsersOfApplicationWithGroups", params) : (Vector)this.getApplicationManagementBySOAP("urn:ApplicationConnector", "getAllExtendedUsersEnabledInApplication", params);
        if (result == null) {
            result = new Vector();
        }
        Iterator iter = ((AbstractList)result).iterator();
        while (iter.hasNext()) {
            ExtendedUserVO vo = (ExtendedUserVO)iter.next();
            vo.setNameOfCurrentAplication(applicationname);
        }
        return result;
    }

    public Vector getExtendedUsersOfApplication(String applicationname, String applicationpassword, boolean withGroupMembers) throws UserSecurityException {
        return this.getExtendedUsersOfApplication(applicationname, applicationpassword, withGroupMembers, true);
    }

    public MessageBean addUser(ExtendedUserVO userVO, String applicationname, String templateUser, String password, String periodeOfChanging, String authenticationID, String adminUsername, String applicationPassword, boolean addToApplication) throws UserSecurityException {
        block14: {
            if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
                return new MessageBean("not sufficient data");
            }
            MessageFromServer message = this.existsUser(userVO.getName(), userVO.getFullname(), userVO.getEmail(), authenticationID, adminUsername, applicationname, applicationPassword);
            if (message.isError()) {
                throw new UserSecurityException(message.getMessage());
            }
            if (password != null && password.length() < 8) {
                return new MessageBean("password must execced 8 characters, cannot create new user");
            }
            if (!password.matches("(.)*([0-9])+(.)*")) {
                return new MessageBean("password must contain at least one number (0-9), cannot create new user");
            }
            if (!password.matches("(.)*(\\p{Punct})+(.)*")) {
                return new MessageBean("password must contain at least special character (!@#$%^&*()), cannot create new user");
            }
            String passwd = SecurityFactory.getInstance().getCookieEncrypter(applicationname).encrypt(password);
            String templateUserName = templateUser;
            String realmToEnable = applicationname;
            logger_.debug((Object)("will make user: " + userVO.getName() + ", passwd: " + passwd));
            logger_.debug((Object)("start: " + userVO.getAccountStartDate() + ", stop: " + userVO.getAccountExpireDate()));
            Long newId = new Long(0L);
            if (templateUserName != null) {
                logger_.debug((Object)"try to make user");
                try {
                    MessageBean msg = null;
                    Vector<Object> params = new Vector<Object>();
                    params.add(userVO.getName());
                    params.add(userVO.getFullname());
                    params.add(passwd);
                    params.add(periodeOfChanging);
                    msg = (MessageBean)this.getUserManagementBySOAP("urn:UserConnector", "createUser", params);
                    if (!msg.isError()) {
                        params.clear();
                        params.add(userVO.getName());
                        ExtendedUserVO createdUser = (ExtendedUserVO)this.getUserManagementBySOAP("urn:UserConnector", "getUserVOExtended", params);
                        if (createdUser != null) {
                            logger_.debug((Object)"created user");
                            if (!this.copyToAdd(templateUserName, createdUser.getName(), realmToEnable)) {
                                newId = new Long(0L);
                            } else {
                                logger_.debug((Object)"copied user successfully");
                                newId = createdUser.getID();
                            }
                            createdUser.setEmail(userVO.getEmail());
                            createdUser.setFullname(userVO.getFullname());
                            createdUser.setExpireDate(userVO.getExpireDate());
                            createdUser.setStartDate(userVO.getStartDate());
                            newId = createdUser.getID();
                            params.clear();
                            params.add(createdUser);
                            params.add(new Boolean(true));
                            this.getUserManagementBySOAP("urn:UserConnector", "setUserVO", params);
                            if (addToApplication) {
                                params.clear();
                                params.add(applicationname);
                                params.add(userVO.getName());
                                this.getApplicationManagementBySOAP("urn:ApplicationConnector", "addUserToApplication", params);
                            } else {
                                logger_.debug((Object)"created user, but dit not add the user to the application =>add user to group");
                            }
                            return new MessageBean();
                        }
                        break block14;
                    }
                    throw new UserSecurityException(msg.getMessage());
                }
                catch (Exception ex1) {
                    throw new UserSecurityException("user already exists");
                }
            }
        }
        return null;
    }

    public void editUser(ExtendedUserVO userVO, String authenticationID, String adminUsername, String applicationname, String applicationPassword) throws UserSecurityException {
        if (userVO == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return;
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
            return;
        }
        try {
            Vector<Serializable> params = new Vector<Serializable>();
            params.add(userVO);
            params.add(new Boolean(true));
            this.getUserManagementBySOAP("urn:UserConnector", "setUserVO", params);
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return;
        }
    }

    public void editUser(ExtendedUserVO userVO, String authenticationID, String applicationname, String applicationPassword) throws UserSecurityException {
        if (userVO == null || authenticationID == null || applicationname == null || applicationPassword == null) {
            return;
        }
        if (!this.checkRegisteredAndisLogged(userVO.getName(), applicationPassword, authenticationID, applicationname)) {
            return;
        }
        try {
            Vector<Serializable> params = new Vector<Serializable>();
            params.add(userVO);
            params.add(new Boolean(false));
            this.getUserManagementBySOAP("urn:UserConnector", "setUserVO", params);
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return;
        }
    }

    public ExtendedUserVO getUserByIDExtended(Long id, String adminUsername, String authenticationID, String applicationname, String applicationPassword) throws UserSecurityException {
        if (id == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return null;
        }
        if (!this.checkRegisteredAndisAdmin(adminUsername, applicationPassword, authenticationID, applicationname)) {
            return null;
        }
        try {
            Vector<Long> params = new Vector<Long>();
            params.add(id);
            ExtendedUserVO vo = (ExtendedUserVO)this.getUserManagementBySOAP("urn:UserConnector", "getUserByIDExtended", params);
            if (vo == null) {
                return null;
            }
            vo.setNameOfCurrentAplication(applicationname);
            return vo;
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Vector getUsersOfApplication(String applicationname, String applicationPassword, boolean withGroupMembers, boolean includeGlobalyDisabledUsers) throws UserSecurityException {
        if (applicationname == null || applicationPassword == null) {
            return null;
        }
        if (!this.checkApplicationIsRegistered(applicationname, applicationPassword)) {
            return null;
        }
        Vector userList = new Vector();
        try {
            Vector<Object> params = new Vector<Object>();
            params.add(applicationname);
            params.add(new Boolean(includeGlobalyDisabledUsers));
            userList = !withGroupMembers ? (Vector)this.getApplicationManagementBySOAP("urn:ApplicationConnector", "getAllUsersEnabledInApplication", params) : (Vector)this.getApplicationManagementBySOAP("urn:ApplicationConnector", "getAllUsersOfApplicationWithGroups", params);
            int i = 0;
            while (i < userList.size()) {
                userList.set(i, (UserVO)userList.get(i));
                ++i;
            }
            return userList;
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Vector getUsersOfApplication(String applicationname, String applicationPassword, boolean withGroupMembers) throws UserSecurityException {
        return this.getUsersOfApplication(applicationname, applicationPassword, withGroupMembers, true);
    }

    public MessageFromServer existsUser(String username, String fullname, String email, String authenticationID, String adminUsername, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || fullname == null || email == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return null;
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
            return null;
        }
        Vector<String> params = new Vector<String>();
        params.add(username);
        params.add(fullname);
        params.add(email);
        return (MessageFromServer)this.getUserManagementBySOAP("urn:UserConnector", "existsUser", params);
    }

    public boolean enableUserInApplication(String username, String authenticationID, String adminUsername, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return false;
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
            return false;
        }
        Vector<String> params = new Vector<String>();
        params.add(applicationname);
        params.add(username);
        return (Boolean)this.getApplicationManagementBySOAP("urn:ApplicationConnector", "enableUserInApplication", params);
    }

    public boolean disableUserInApplication(String username, String authenticationID, String adminUsername, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return false;
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
            return false;
        }
        Vector<String> params = new Vector<String>();
        params.add(applicationname);
        params.add(username);
        return (Boolean)this.getApplicationManagementBySOAP("urn:ApplicationConnector", "disableUserInApplication", params);
    }

    public boolean copyAcl(String sourceUser, String destinationUser, String authenticationID, String adminUsername, String applicationname, String applicationPassword) throws UserSecurityException {
        if (sourceUser == null || destinationUser == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return false;
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
            return false;
        }
        Vector<String> params = new Vector<String>();
        params.add(sourceUser);
        params.add(destinationUser);
        params.add(applicationname);
        return (Boolean)this.getAclManagementBySOAP("urn:AclConnector", "copy", params);
    }

    public ExtendedUserVO getUserByIDExtended(Long id, String applicationname, String applicationPassword) throws UserSecurityException {
        if (id == null || applicationname == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(applicationname, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            Vector<Long> params = new Vector<Long>();
            params.add(id);
            ExtendedUserVO vo = (ExtendedUserVO)this.getUserManagementBySOAP("urn:UserConnector", "getUserByIDExtended", params);
            vo.setNameOfCurrentAplication(applicationname);
            return vo;
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Long getUserIDFromName(String username, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || applicationname == null || applicationPassword == null) {
            return null;
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(applicationname, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            Vector<String> params = new Vector<String>();
            params.add(username);
            return (Long)this.getUserManagementBySOAP("urn:UserConnector", "getUserIDFromName", params);
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Vector getGroupsEnabledInApplication(String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector<String> params = new Vector<String>();
        params.add(application);
        try {
            Vector list = (Vector)this.getApplicationManagementBySOAP("urn:ApplicationConnector", "getAllGroupsEnabledInApplication", params);
            Iterator iter = ((AbstractList)list).iterator();
            while (iter.hasNext()) {
                SmallGroupVO vo = (SmallGroupVO)iter.next();
                vo.setNameOfCurrentAplication(application);
            }
            return list;
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public boolean addUserToGroup(String username, String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null || authenticationID == null || adminUsername == null || groupname == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            Vector<String> params = new Vector<String>();
            params.add(username);
            params.add(groupname);
            return (Boolean)this.getGroupManagementBySOAP("urn:GroupConnector", "addUserToGroup", params);
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public boolean removeUserFromGroup(String username, String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || groupname == null || application == null || applicationPassword == null || authenticationID == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            Vector<String> params = new Vector<String>();
            params.add(username);
            params.add(groupname);
            return (Boolean)this.getGroupManagementBySOAP("urn:GroupConnector", "deleteUserFromGroup", params);
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public Vector getUserVORegEx(String regExpression, String application, String applicationPassword) throws UserSecurityException {
        if (regExpression == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            Vector<String> params = new Vector<String>();
            params.add(regExpression);
            params.add(application);
            Vector result = (Vector)this.getUserManagementBySOAP("urn:UserConnector", "findUserVOByRegEx", params);
            return result;
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Vector getUserVOExtendedRegEx(String regExpression, String application, String applicationPassword) throws UserSecurityException {
        if (regExpression == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            Vector<String> params = new Vector<String>();
            params.add(regExpression);
            params.add(application);
            Vector result = (Vector)this.getUserManagementBySOAP("urn:UserConnector", "findUserVOExtendedByRegEx", params);
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean createGroup(String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || application == null || applicationPassword == null || authenticationID == null || applicationPassword == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        Vector<String> params = new Vector<String>();
        params.add(groupname);
        if (((Boolean)this.getGroupManagementBySOAP("urn:GroupConnector", "createGroup", params)).booleanValue()) {
            params.add(application);
            return (Boolean)this.getGroupManagementBySOAP("urn:GroupConnector", "enableGroupInApplication", params);
        }
        return false;
    }

    public boolean deleteGroup(String groupname, String adminUsername, String authenticationID, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || adminUsername == null || authenticationID == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        Vector<String> params = new Vector<String>();
        params.add(groupname);
        int size = ((Vector)this.getGroupManagementBySOAP("urn:GroupConnector", "getAllUsersOfGroup", params)).size();
        if (size > 0) {
            throw new UserSecurityException("not allowed to delete groups, which contain users (" + size + ")");
        }
        return (Boolean)this.getGroupManagementBySOAP("urn:GroupConnector", "deleteGroup", params);
    }

    public Vector getAclsOfUser(String username, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector<String> params = new Vector<String>();
        params.add(application);
        params.add(username);
        return (Vector)this.getAclManagementBySOAP("urn:AclConnector", "getAllAclOfRealmOfUser", params);
    }

    public Vector getAclsOfGroup(String groupname, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector<String> params = new Vector<String>();
        params.add(application);
        params.add(groupname);
        return (Vector)this.getAclManagementBySOAP("urn:AclConnector", "getAllAclOfRealmOfGroup", params);
    }

    public boolean setAclsOfUser(String username, Long id, String accessLevel, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null || id == null || accessLevel == null || authenticationID == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        try {
            if (accessLevel.length() == 0) {
                Vector<Object> params = new Vector<Object>();
                params.add(id);
                AclVO acl = (AclVO)this.getAclManagementBySOAP("urn:AclConnector", "getAclByID", params);
                String key = acl.getResourceKey();
                params.clear();
                params.add(application);
                params.add(key);
                params.add(username);
                return (Boolean)this.getAclManagementBySOAP("urn:AclConnector", "deleteAclOfUser", params);
            }
            Vector<Object> params = new Vector<Object>();
            params.add(id);
            params.add(accessLevel);
            return (Boolean)this.getAclManagementBySOAP("urn:AclConnector", "updateAcl", params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean setAclsOfGroup(String groupname, Long id, String accessLevel, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || application == null || applicationPassword == null || id == null || accessLevel == null || authenticationID == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        try {
            Vector<Object> params = new Vector<Object>();
            params.add(id);
            params.add(accessLevel);
            return (Boolean)this.getAclManagementBySOAP("urn:AclConnector", "updateAcl", params);
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public Vector getAllResourcesOfApplication(String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector<String> params = new Vector<String>();
        params.add(application);
        return (Vector)this.getResourceManagementBySOAP("urn:ResourceConnector", "getResourcesOfApplication", params);
    }

    public Vector getInformationAboutUserForResource(String username, String resourceKey, String application, String applicationPassword) throws UserSecurityException {
        return null;
    }

    public AclVO getAclOfResourceByUser(String username, String resourceKey, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || resourceKey == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector<String> params = new Vector<String>();
        params.add(application);
        params.add(resourceKey);
        params.add(username);
        return (AclVO)this.getAclManagementBySOAP("urn:AclConnector", "getAclByRealmAndResourceKeyAndUser", params);
    }

    public AclVO getAclOfResourceByGroup(String groupname, String resourceKey, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || resourceKey == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector<String> params = new Vector<String>();
        params.add(application);
        params.add(resourceKey);
        params.add(groupname);
        return (AclVO)this.getAclManagementBySOAP("urn:AclConnector", "getAclByRealmAndResourceKeyAndGroup", params);
    }

    public boolean createAcl(String username, String groupname, String resourceKey, String accessLevel, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null || adminUsername == null || authenticationID == null || resourceKey == null || accessLevel == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        if (username == null) {
            username = "";
        }
        if (groupname == null) {
            groupname = "";
        }
        Vector<String> params = new Vector<String>();
        params.add(application);
        params.add(resourceKey);
        params.add(username);
        params.add(groupname);
        params.add(accessLevel);
        MessageBean msg = (MessageBean)this.getAclManagementBySOAP("urn:AclConnector", "createAcl", params);
        if (msg.isError()) {
            throw new UserSecurityException(msg.getMessage());
        }
        return true;
    }

    public boolean deleteAcl(Long id, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (id == null || application == null || applicationPassword == null || authenticationID == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        Vector<Long> params = new Vector<Long>();
        params.add(id);
        return (Boolean)this.getAclManagementBySOAP("urn:AclConnector", "deleteAclById", params);
    }

    public Vector getAccessrightsByUser(Long id, String application, String applicationPassword) throws UserSecurityException {
        if (id == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector<Object> params = new Vector<Object>();
        params.add(id);
        UserVO user = (UserVO)this.getUserManagementBySOAP("urn:UserConnector", "getUserByID", params);
        params.clear();
        params.add(application);
        params.add(user.getName());
        return (Vector)this.getRightsManagementBySOAP("urn:RightsConnector", "getRightOfResource", params);
    }

    public Vector getAccessrightsByUser(String username, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector<String> params = new Vector<String>();
        params.add(application);
        params.add(username);
        return (Vector)this.getRightsManagementBySOAP("urn:RightsConnector", "getRightOfResource", params);
    }

    public boolean checkLogin(String username, String id, String application) throws UserSecurityException {
        if (username == null || application == null || id == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isLogged(username, id)) {
            return false;
        }
        return AuthenticationHandlerSOAP.isUserallowedInApplication(username, application);
    }

    public Vector getAllInstitutes(String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector params = new Vector();
        return (Vector)this.getInstitutManagementBySOAP("urn:InstitutConnector", "getAll", params);
    }

    public Vector getAllUsersFromInstitut(Long institutId, String adminusername, String application, String applicationPassword) throws UserSecurityException {
        if (institutId == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        if (!AuthenticationHandlerSOAP.isUserAdminOfApplication(adminusername, application)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector<Long> params = new Vector<Long>();
        params.add(institutId);
        return (Vector)this.getInstitutManagementBySOAP("urn:InstitutConnector", "getAllUsersOfInstitut", params);
    }

    public Vector getAllUsersWithProperty(String propertyKey, String adminusername, String application, String applicationPassword) throws UserSecurityException {
        if (propertyKey == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        if (!AuthenticationHandlerSOAP.isUserAdminOfApplication(adminusername, application)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector userList = null;
        Vector<ExtendedUserVO> result = new Vector<ExtendedUserVO>();
        Vector<String> params = new Vector<String>();
        params.add(application);
        userList = (Vector)this.getApplicationManagementBySOAP("urn:ApplicationConnector", "getAllUsersEnabledInApplication", params);
        userList = FilterDoubleEntries.filterUsers(userList);
        Iterator iter = ((AbstractList)userList).iterator();
        while (iter.hasNext()) {
            ExtendedUserVO vo = (ExtendedUserVO)iter.next();
            if (!vo.getProperties().getKeys().contains(propertyKey)) continue;
            result.add(vo);
        }
        return result;
    }

    private Call getCall(String connectorName, String endpoint, String methodName) {
        Service service = new Service();
        Call call = null;
        try {
            call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(endpoint));
            call.setOperationName(new QName(connectorName, methodName));
            logger_.info((Object)(connectorName + " - methodName : " + methodName));
            QName qnInstitutMember = new QName("urn:BeanService", "InstitutMembersVO");
            QName qnInstitut = new QName("urn:BeanService", "InstitutVO");
            QName qnExtendedUserVO = new QName("urn:BeanService", "ExtendedUserVO");
            QName qnUserVO = new QName("urn:BeanService", "UserVO");
            QName qnSmallGroupVO = new QName("urn:BeanService", "SmallGroupVO");
            QName qnAclVO = new QName("urn:BeanService", "AclVO");
            QName qnResourceVO = new QName("urn:BeanService", "ResourceVO");
            QName qnApplicationVO = new QName("urn:BeanService", "ApplicationVO");
            QName qnAuthenticationToken = new QName("urn:BeanService", "AuthenticationToken");
            QName qnUserVOToAdd = new QName("urn:BeanService", "UserVOToAdd");
            QName qnRightOfResourceVO = new QName("urn:BeanService", "RightOfResourceVO");
            QName qnAdminsgroupVO = new QName("urn:BeanService", "AdminsgroupVO");
            QName qnAdminVO = new QName("urn:BeanService", "AdminVO");
            QName qnLoggingVO = new QName("urn:BeanService", "LoggingVO");
            QName qnLdapAccountVO = new QName("urn:BeanService", "LdapAccountVO");
            QName qnUnixServerVO = new QName("urn:BeanService", "UnixServerVO");
            QName qnChangePeriode = new QName("urn:BeanService", "ChangePeriode");
            QName qnMessageBean = new QName("urn:BeanService", "MessageBean");
            QName qnDataEntityVO = new QName("urn:BeanService", "DataEntityVO");
            QName qnDateEntityVO = new QName("urn:BeanService", "DateEntityVO");
            QName qnDecimalEntityVO = new QName("urn:BeanService", "DecimalEntityVO");
            QName qnNumberEntityVO = new QName("urn:BeanService", "NumberEntityVO");
            QName qnPropertySetVO = new QName("urn:BeanService", "PropertySetVO");
            QName qnStringEntityVO = new QName("urn:BeanService", "StringEntityVO");
            QName qnHashMap = new QName("urn:BeanService", "HashMap");
            call.registerTypeMapping(class$java$util$HashMap == null ? (class$java$util$HashMap = ServerConnectionSOAP.class$("java.util.HashMap")) : class$java$util$HashMap, qnHashMap, (SerializerFactory)new MapSerializerFactory(class$java$util$HashMap == null ? (class$java$util$HashMap = ServerConnectionSOAP.class$("java.util.HashMap")) : class$java$util$HashMap, qnHashMap), (DeserializerFactory)new MapDeserializerFactory(class$java$util$HashMap == null ? (class$java$util$HashMap = ServerConnectionSOAP.class$("java.util.HashMap")) : class$java$util$HashMap, qnHashMap));
            call.registerTypeMapping(class$com$opensymphony$module$propertyset$ejb$types$VO$DataEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$DataEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.DataEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$DataEntityVO, qnDataEntityVO, (SerializerFactory)new BeanSerializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$DataEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$DataEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.DataEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$DataEntityVO, qnDataEntityVO), (DeserializerFactory)new BeanDeserializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$DataEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$DataEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.DataEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$DataEntityVO, qnDataEntityVO));
            call.registerTypeMapping(class$com$opensymphony$module$propertyset$ejb$types$VO$DateEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$DateEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.DateEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$DateEntityVO, qnDateEntityVO, (SerializerFactory)new BeanSerializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$DateEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$DateEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.DateEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$DateEntityVO, qnDateEntityVO), (DeserializerFactory)new BeanDeserializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$DateEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$DateEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.DateEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$DateEntityVO, qnDateEntityVO));
            call.registerTypeMapping(class$com$opensymphony$module$propertyset$ejb$types$VO$DecimalEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$DecimalEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.DecimalEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$DecimalEntityVO, qnDecimalEntityVO, (SerializerFactory)new BeanSerializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$DecimalEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$DecimalEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.DecimalEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$DecimalEntityVO, qnDecimalEntityVO), (DeserializerFactory)new BeanDeserializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$DecimalEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$DecimalEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.DecimalEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$DecimalEntityVO, qnDecimalEntityVO));
            call.registerTypeMapping(class$com$opensymphony$module$propertyset$ejb$types$VO$NumberEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$NumberEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.NumberEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$NumberEntityVO, qnNumberEntityVO, (SerializerFactory)new BeanSerializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$NumberEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$NumberEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.NumberEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$NumberEntityVO, qnNumberEntityVO), (DeserializerFactory)new BeanDeserializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$NumberEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$NumberEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.NumberEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$NumberEntityVO, qnNumberEntityVO));
            call.registerTypeMapping(class$com$opensymphony$module$propertyset$ejb$types$VO$PropertySetVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$PropertySetVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.PropertySetVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$PropertySetVO, qnPropertySetVO, (SerializerFactory)new BeanSerializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$PropertySetVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$PropertySetVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.PropertySetVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$PropertySetVO, qnPropertySetVO), (DeserializerFactory)new BeanDeserializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$PropertySetVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$PropertySetVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.PropertySetVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$PropertySetVO, qnPropertySetVO));
            call.registerTypeMapping(class$com$opensymphony$module$propertyset$ejb$types$VO$StringEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$StringEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.StringEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$StringEntityVO, qnStringEntityVO, (SerializerFactory)new BeanSerializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$StringEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$StringEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.StringEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$StringEntityVO, qnStringEntityVO), (DeserializerFactory)new BeanDeserializerFactory(class$com$opensymphony$module$propertyset$ejb$types$VO$StringEntityVO == null ? (class$com$opensymphony$module$propertyset$ejb$types$VO$StringEntityVO = ServerConnectionSOAP.class$("com.opensymphony.module.propertyset.ejb.types.VO.StringEntityVO")) : class$com$opensymphony$module$propertyset$ejb$types$VO$StringEntityVO, qnStringEntityVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutMembersVO == null ? (class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutMembersVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.institut.VO.InstitutMembersVO")) : class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutMembersVO, qnInstitutMember, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutMembersVO == null ? (class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutMembersVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.institut.VO.InstitutMembersVO")) : class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutMembersVO, qnInstitutMember), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutMembersVO == null ? (class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutMembersVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.institut.VO.InstitutMembersVO")) : class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutMembersVO, qnInstitutMember));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutVO == null ? (class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.institut.VO.InstitutVO")) : class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutVO, qnInstitut, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutVO == null ? (class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.institut.VO.InstitutVO")) : class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutVO, qnInstitut), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutVO == null ? (class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.institut.VO.InstitutVO")) : class$at$tugraz$genome$usermanagement$server$institut$VO$InstitutVO, qnInstitut));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$user$VO$ExtendedUserVO == null ? (class$at$tugraz$genome$usermanagement$server$user$VO$ExtendedUserVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO")) : class$at$tugraz$genome$usermanagement$server$user$VO$ExtendedUserVO, qnExtendedUserVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$user$VO$ExtendedUserVO == null ? (class$at$tugraz$genome$usermanagement$server$user$VO$ExtendedUserVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO")) : class$at$tugraz$genome$usermanagement$server$user$VO$ExtendedUserVO, qnExtendedUserVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$user$VO$ExtendedUserVO == null ? (class$at$tugraz$genome$usermanagement$server$user$VO$ExtendedUserVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO")) : class$at$tugraz$genome$usermanagement$server$user$VO$ExtendedUserVO, qnExtendedUserVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$user$VO$UserVO == null ? (class$at$tugraz$genome$usermanagement$server$user$VO$UserVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.user.VO.UserVO")) : class$at$tugraz$genome$usermanagement$server$user$VO$UserVO, qnUserVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$user$VO$UserVO == null ? (class$at$tugraz$genome$usermanagement$server$user$VO$UserVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.user.VO.UserVO")) : class$at$tugraz$genome$usermanagement$server$user$VO$UserVO, qnUserVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$user$VO$UserVO == null ? (class$at$tugraz$genome$usermanagement$server$user$VO$UserVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.user.VO.UserVO")) : class$at$tugraz$genome$usermanagement$server$user$VO$UserVO, qnUserVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$acl$VO$AclVO == null ? (class$at$tugraz$genome$usermanagement$server$acl$VO$AclVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.acl.VO.AclVO")) : class$at$tugraz$genome$usermanagement$server$acl$VO$AclVO, qnAclVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$acl$VO$AclVO == null ? (class$at$tugraz$genome$usermanagement$server$acl$VO$AclVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.acl.VO.AclVO")) : class$at$tugraz$genome$usermanagement$server$acl$VO$AclVO, qnAclVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$acl$VO$AclVO == null ? (class$at$tugraz$genome$usermanagement$server$acl$VO$AclVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.acl.VO.AclVO")) : class$at$tugraz$genome$usermanagement$server$acl$VO$AclVO, qnAclVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$group$VO$SmallGroupVO == null ? (class$at$tugraz$genome$usermanagement$server$group$VO$SmallGroupVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO")) : class$at$tugraz$genome$usermanagement$server$group$VO$SmallGroupVO, qnSmallGroupVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$group$VO$SmallGroupVO == null ? (class$at$tugraz$genome$usermanagement$server$group$VO$SmallGroupVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO")) : class$at$tugraz$genome$usermanagement$server$group$VO$SmallGroupVO, qnSmallGroupVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$group$VO$SmallGroupVO == null ? (class$at$tugraz$genome$usermanagement$server$group$VO$SmallGroupVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO")) : class$at$tugraz$genome$usermanagement$server$group$VO$SmallGroupVO, qnSmallGroupVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$resource$VO$ResourceVO == null ? (class$at$tugraz$genome$usermanagement$server$resource$VO$ResourceVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.resource.VO.ResourceVO")) : class$at$tugraz$genome$usermanagement$server$resource$VO$ResourceVO, qnResourceVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$resource$VO$ResourceVO == null ? (class$at$tugraz$genome$usermanagement$server$resource$VO$ResourceVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.resource.VO.ResourceVO")) : class$at$tugraz$genome$usermanagement$server$resource$VO$ResourceVO, qnResourceVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$resource$VO$ResourceVO == null ? (class$at$tugraz$genome$usermanagement$server$resource$VO$ResourceVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.resource.VO.ResourceVO")) : class$at$tugraz$genome$usermanagement$server$resource$VO$ResourceVO, qnResourceVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$application$VO$ApplicationVO == null ? (class$at$tugraz$genome$usermanagement$server$application$VO$ApplicationVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO")) : class$at$tugraz$genome$usermanagement$server$application$VO$ApplicationVO, qnApplicationVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$application$VO$ApplicationVO == null ? (class$at$tugraz$genome$usermanagement$server$application$VO$ApplicationVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO")) : class$at$tugraz$genome$usermanagement$server$application$VO$ApplicationVO, qnApplicationVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$application$VO$ApplicationVO == null ? (class$at$tugraz$genome$usermanagement$server$application$VO$ApplicationVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO")) : class$at$tugraz$genome$usermanagement$server$application$VO$ApplicationVO, qnApplicationVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$user$VO$UserVOToAdd == null ? (class$at$tugraz$genome$usermanagement$server$user$VO$UserVOToAdd = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.user.VO.UserVOToAdd")) : class$at$tugraz$genome$usermanagement$server$user$VO$UserVOToAdd, qnUserVOToAdd, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$user$VO$UserVOToAdd == null ? (class$at$tugraz$genome$usermanagement$server$user$VO$UserVOToAdd = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.user.VO.UserVOToAdd")) : class$at$tugraz$genome$usermanagement$server$user$VO$UserVOToAdd, qnUserVOToAdd), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$user$VO$UserVOToAdd == null ? (class$at$tugraz$genome$usermanagement$server$user$VO$UserVOToAdd = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.user.VO.UserVOToAdd")) : class$at$tugraz$genome$usermanagement$server$user$VO$UserVOToAdd, qnUserVOToAdd));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$right$VO$RightOfResourceVO == null ? (class$at$tugraz$genome$usermanagement$server$right$VO$RightOfResourceVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.right.VO.RightOfResourceVO")) : class$at$tugraz$genome$usermanagement$server$right$VO$RightOfResourceVO, qnRightOfResourceVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$right$VO$RightOfResourceVO == null ? (class$at$tugraz$genome$usermanagement$server$right$VO$RightOfResourceVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.right.VO.RightOfResourceVO")) : class$at$tugraz$genome$usermanagement$server$right$VO$RightOfResourceVO, qnRightOfResourceVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$right$VO$RightOfResourceVO == null ? (class$at$tugraz$genome$usermanagement$server$right$VO$RightOfResourceVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.right.VO.RightOfResourceVO")) : class$at$tugraz$genome$usermanagement$server$right$VO$RightOfResourceVO, qnRightOfResourceVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$admin$VO$AdminsgroupVO == null ? (class$at$tugraz$genome$usermanagement$server$admin$VO$AdminsgroupVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.admin.VO.AdminsgroupVO")) : class$at$tugraz$genome$usermanagement$server$admin$VO$AdminsgroupVO, qnAdminsgroupVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$admin$VO$AdminsgroupVO == null ? (class$at$tugraz$genome$usermanagement$server$admin$VO$AdminsgroupVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.admin.VO.AdminsgroupVO")) : class$at$tugraz$genome$usermanagement$server$admin$VO$AdminsgroupVO, qnAdminsgroupVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$admin$VO$AdminsgroupVO == null ? (class$at$tugraz$genome$usermanagement$server$admin$VO$AdminsgroupVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.admin.VO.AdminsgroupVO")) : class$at$tugraz$genome$usermanagement$server$admin$VO$AdminsgroupVO, qnAdminsgroupVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$admin$VO$AdminVO == null ? (class$at$tugraz$genome$usermanagement$server$admin$VO$AdminVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.admin.VO.AdminVO")) : class$at$tugraz$genome$usermanagement$server$admin$VO$AdminVO, qnAdminVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$admin$VO$AdminVO == null ? (class$at$tugraz$genome$usermanagement$server$admin$VO$AdminVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.admin.VO.AdminVO")) : class$at$tugraz$genome$usermanagement$server$admin$VO$AdminVO, qnAdminVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$admin$VO$AdminVO == null ? (class$at$tugraz$genome$usermanagement$server$admin$VO$AdminVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.admin.VO.AdminVO")) : class$at$tugraz$genome$usermanagement$server$admin$VO$AdminVO, qnAdminVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$logging$VO$LoggingVO == null ? (class$at$tugraz$genome$usermanagement$server$logging$VO$LoggingVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.logging.VO.LoggingVO")) : class$at$tugraz$genome$usermanagement$server$logging$VO$LoggingVO, qnLoggingVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$logging$VO$LoggingVO == null ? (class$at$tugraz$genome$usermanagement$server$logging$VO$LoggingVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.logging.VO.LoggingVO")) : class$at$tugraz$genome$usermanagement$server$logging$VO$LoggingVO, qnLoggingVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$logging$VO$LoggingVO == null ? (class$at$tugraz$genome$usermanagement$server$logging$VO$LoggingVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.logging.VO.LoggingVO")) : class$at$tugraz$genome$usermanagement$server$logging$VO$LoggingVO, qnLoggingVO));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$unixserver$VO$LdapAccountVO == null ? (class$at$tugraz$genome$usermanagement$server$unixserver$VO$LdapAccountVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.unixserver.VO.LdapAccountVO")) : class$at$tugraz$genome$usermanagement$server$unixserver$VO$LdapAccountVO, qnLdapAccountVO, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$unixserver$VO$LdapAccountVO == null ? (class$at$tugraz$genome$usermanagement$server$unixserver$VO$LdapAccountVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.unixserver.VO.LdapAccountVO")) : class$at$tugraz$genome$usermanagement$server$unixserver$VO$LdapAccountVO, qnLdapAccountVO), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$unixserver$VO$LdapAccountVO == null ? (class$at$tugraz$genome$usermanagement$server$unixserver$VO$LdapAccountVO = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.unixserver.VO.LdapAccountVO")) : class$at$tugraz$genome$usermanagement$server$unixserver$VO$LdapAccountVO, qnLdapAccountVO));
            call.registerTypeMapping(class$java$lang$String == null ? (class$java$lang$String = ServerConnectionSOAP.class$("java.lang.String")) : class$java$lang$String, qnChangePeriode, (SerializerFactory)new BeanSerializerFactory(class$java$lang$String == null ? (class$java$lang$String = ServerConnectionSOAP.class$("java.lang.String")) : class$java$lang$String, qnChangePeriode), (DeserializerFactory)new BeanDeserializerFactory(class$java$lang$String == null ? (class$java$lang$String = ServerConnectionSOAP.class$("java.lang.String")) : class$java$lang$String, qnChangePeriode));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$MessageBean == null ? (class$at$tugraz$genome$usermanagement$server$MessageBean = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.MessageBean")) : class$at$tugraz$genome$usermanagement$server$MessageBean, qnMessageBean, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$MessageBean == null ? (class$at$tugraz$genome$usermanagement$server$MessageBean = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.MessageBean")) : class$at$tugraz$genome$usermanagement$server$MessageBean, qnMessageBean), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$MessageBean == null ? (class$at$tugraz$genome$usermanagement$server$MessageBean = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.MessageBean")) : class$at$tugraz$genome$usermanagement$server$MessageBean, qnMessageBean));
            call.registerTypeMapping(class$at$tugraz$genome$usermanagement$server$authentication$AuthenticationToken == null ? (class$at$tugraz$genome$usermanagement$server$authentication$AuthenticationToken = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.authentication.AuthenticationToken")) : class$at$tugraz$genome$usermanagement$server$authentication$AuthenticationToken, qnAuthenticationToken, (SerializerFactory)new BeanSerializerFactory(class$at$tugraz$genome$usermanagement$server$authentication$AuthenticationToken == null ? (class$at$tugraz$genome$usermanagement$server$authentication$AuthenticationToken = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.authentication.AuthenticationToken")) : class$at$tugraz$genome$usermanagement$server$authentication$AuthenticationToken, qnAuthenticationToken), (DeserializerFactory)new BeanDeserializerFactory(class$at$tugraz$genome$usermanagement$server$authentication$AuthenticationToken == null ? (class$at$tugraz$genome$usermanagement$server$authentication$AuthenticationToken = ServerConnectionSOAP.class$("at.tugraz.genome.usermanagement.server.authentication.AuthenticationToken")) : class$at$tugraz$genome$usermanagement$server$authentication$AuthenticationToken, qnAuthenticationToken));
        }
        catch (MalformedURLException ex) {
        }
        catch (ServiceException ex) {}
        return call;
    }

    private boolean checkAll(String username, String applicationPassword, String authenticationID, String applicationname, String adminUsername) throws UserSecurityException {
        boolean checkAll = true;
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(applicationname, applicationPassword)) {
            checkAll = false;
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        if (!AuthenticationHandlerSOAP.isUserAdminOfApplication(adminUsername, applicationname)) {
            checkAll = false;
            logger_.error((Object)"user is not adminstrator of this application");
            throw new UserSecurityException("user is not adminstrator of this application");
        }
        if (!AuthenticationHandlerSOAP.isLogged(username, authenticationID)) {
            checkAll = false;
            logger_.error((Object)("User is not logged in, ID unknown (ValueObject created at Client?) " + username));
            throw new UserSecurityException("User is not logged in, ID unknown (ValueObject created at Client?)");
        }
        return checkAll;
    }

    private boolean checkRegisteredAndisLogged(String username, String applicationPassword, String authenticationID, String applicationname) throws UserSecurityException {
        boolean checkAll = true;
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(applicationname, applicationPassword)) {
            checkAll = false;
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        if (!AuthenticationHandlerSOAP.isLogged(username, authenticationID)) {
            checkAll = false;
            logger_.error((Object)"User is not logged in, ID unknown (ValueObject created at Client?)");
            throw new UserSecurityException("User is not logged in, ID unknown (ValueObject created at Client?)");
        }
        return checkAll;
    }

    private boolean checkRegisteredAndisAdmin(String username, String applicationPassword, String authenticationID, String applicationname) throws UserSecurityException {
        boolean checkAll = true;
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(applicationname, applicationPassword)) {
            checkAll = false;
            logger_.error((Object)("Application is not registered under this name and password: " + applicationname));
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        if (!AuthenticationHandlerSOAP.isUserAdminOfApplication(username, applicationname)) {
            checkAll = false;
            logger_.error((Object)"user is not adminstrator of this application");
            throw new UserSecurityException("user is not adminstrator of this application");
        }
        return checkAll;
    }

    private boolean checkApplicationIsRegistered(String application, String applicationPassword) throws UserSecurityException {
        boolean checkAll = true;
        if (!AuthenticationHandlerSOAP.isApplicationRegistered(application, applicationPassword)) {
            checkAll = false;
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        return checkAll;
    }

    private boolean copy(String templateUser, String newUser, String realm) {
        if (templateUser == null || newUser == null) {
            return false;
        }
        if (templateUser.length() == 0 || newUser.length() == 0) {
            return false;
        }
        try {
            Serializable vo;
            Vector AclTmp = new Vector();
            Vector AppTmp = new Vector();
            Vector GroupTmp = new Vector();
            Vector<String> params = new Vector<String>();
            params.add(realm);
            params.add(templateUser);
            AclTmp = (Vector)this.getAclManagementBySOAP("urn:AclConnector", "getAllAclOfRealmOfUser", params);
            params.clear();
            params.add(templateUser);
            AppTmp = (Vector)this.getUserManagementBySOAP("urn:UserConnector", "getApplicationsForUser", params);
            GroupTmp = (Vector)this.getGroupManagementBySOAP("urn:GroupConnector", "getAllGroupsOfUser", params);
            if (AclTmp == null) {
                AclTmp = new Vector();
            }
            if (AppTmp == null) {
                AppTmp = new Vector();
            }
            if (GroupTmp == null) {
                GroupTmp = new Vector();
            }
            logger_.debug((Object)"got Template User data");
            logger_.debug((Object)("AclTmp : " + AclTmp.size()));
            logger_.debug((Object)("AppTmp : " + AppTmp.size()));
            logger_.debug((Object)("GroupTmp : " + GroupTmp.size()));
            Iterator iter = ((AbstractList)AclTmp).iterator();
            while (iter.hasNext()) {
                vo = (AclVO)iter.next();
                logger_.debug((Object)("acl=> key : " + ((AclVO)vo).getResourceKey() + "userID: " + ((AclVO)vo).getUserId() + " groupId: " + ((AclVO)vo).getGroupId() + " access: " + ((AclVO)vo).getAccessLevel() + " realm:  " + ((AclVO)vo).getRealm()));
                Vector<String> paramsAcl = new Vector<String>();
                paramsAcl.add(((AclVO)vo).getRealm());
                paramsAcl.add(((AclVO)vo).getResourceKey());
                paramsAcl.add(newUser);
                paramsAcl.add(null);
                paramsAcl.add(((AclVO)vo).getAccessLevel());
                if (!((MessageBean)this.getAclManagementBySOAP("urn:AclConnector", "createAcl", paramsAcl)).isError()) continue;
                logger_.error((Object)("ERROR: could not create Acl " + ((AclVO)vo).getRealm() + ", " + ((AclVO)vo).getResourceKey()));
            }
            logger_.debug((Object)"copied ACLs");
            iter = ((AbstractList)AppTmp).iterator();
            while (iter.hasNext()) {
                vo = (ApplicationVO)iter.next();
                logger_.debug((Object)("app: " + ((ApplicationVO)vo).getApplicationname()));
                Vector<String> paramsApp = new Vector<String>();
                paramsApp.add(((ApplicationVO)vo).getApplicationname());
                paramsApp.add(newUser);
                this.getApplicationManagementBySOAP("urn:ApplicationConnector", "enableUserInApplication", paramsApp);
            }
            logger_.debug((Object)"copied Apps");
            iter = ((AbstractList)GroupTmp).iterator();
            while (iter.hasNext()) {
                vo = (SmallGroupVO)iter.next();
                logger_.debug((Object)("group : " + ((SmallGroupVO)vo).getName()));
                Vector<String> paramsGroup = new Vector<String>();
                paramsGroup.add(newUser);
                paramsGroup.add(((SmallGroupVO)vo).getName());
                this.getGroupManagementBySOAP("urn:GroupConnector", "addUserToGroup", paramsGroup);
            }
            logger_.debug((Object)"copied groups");
            return true;
        }
        catch (Exception ex) {
            logger_.error((Object)("could not copy from template user " + ex.toString()));
            return false;
        }
    }

    private boolean copyToAdd(String templateUser, String newUser, String realmToEnable) {
        if (templateUser == null || newUser == null) {
            logger_.error((Object)"templateUser and newUser null");
            return false;
        }
        if (templateUser.length() == 0 || newUser.length() == 0) {
            logger_.error((Object)"no zero length strings");
            return false;
        }
        Vector<String> paramsApp = new Vector<String>();
        Vector appList = (Vector)this.getApplicationManagementBySOAP("urn:ApplicationConnector", "getAllApplications", paramsApp);
        Vector AclTmp = new Vector();
        Vector AppTmp = new Vector();
        Vector GroupTmp = new Vector();
        Iterator app = ((AbstractList)appList).iterator();
        try {
            Serializable vo;
            while (app.hasNext()) {
                String realm = ((ApplicationVO)app.next()).getApplicationname();
                Vector<String> paramsAcl = new Vector<String>();
                paramsAcl.add(realm);
                paramsAcl.add(templateUser);
                Vector aclOfRealmOfUser = (Vector)this.getAclManagementBySOAP("urn:AclConnector", "getAllAclOfRealmOfUser", paramsAcl);
                AclTmp.addAll(aclOfRealmOfUser);
            }
            Vector<String> params = new Vector<String>();
            params.add(templateUser);
            AppTmp = (Vector)this.getUserManagementBySOAP("urn:UserConnector", "getApplicationsForUser", params);
            GroupTmp = (Vector)this.getGroupManagementBySOAP("urn:GroupConnector", "getAllGroupsOfUser", params);
            if (AclTmp == null) {
                AclTmp = new Vector();
            }
            if (AppTmp == null) {
                AppTmp = new Vector();
            }
            if (GroupTmp == null) {
                GroupTmp = new Vector();
            }
            logger_.debug((Object)"got Template User data");
            logger_.debug((Object)("AclTmp : " + AclTmp.size()));
            logger_.debug((Object)("AppTmp : " + AppTmp.size()));
            logger_.debug((Object)("GroupTmp : " + GroupTmp.size()));
            Iterator iter = ((AbstractList)AclTmp).iterator();
            while (iter.hasNext()) {
                vo = (AclVO)iter.next();
                logger_.debug((Object)("acl=> key : " + ((AclVO)vo).getResourceKey() + "userID: " + ((AclVO)vo).getUserId() + " groupId: " + ((AclVO)vo).getGroupId() + " access: " + ((AclVO)vo).getAccessLevel() + " realm:  " + ((AclVO)vo).getRealm()));
                Vector<String> paramsAcl = new Vector<String>();
                paramsAcl.add(((AclVO)vo).getRealm());
                paramsAcl.add(((AclVO)vo).getResourceKey());
                paramsAcl.add(newUser);
                paramsAcl.add(null);
                paramsAcl.add(((AclVO)vo).getAccessLevel());
                if (!((MessageBean)this.getAclManagementBySOAP("urn:AclConnector", "createAcl", paramsAcl)).isError()) continue;
                logger_.debug((Object)"ERROR");
            }
            logger_.debug((Object)"copied ACLs successfully");
            paramsApp.clear();
            paramsApp.add(realmToEnable);
            paramsApp.add(newUser);
            this.getApplicationManagementBySOAP("urn:ApplicationConnector", "enableUserInApplication", paramsApp);
            logger_.debug((Object)("enabled user in : " + realmToEnable));
            logger_.debug((Object)"copied Apps");
            iter = ((AbstractList)GroupTmp).iterator();
            while (iter.hasNext()) {
                vo = (SmallGroupVO)iter.next();
                logger_.debug((Object)("group : " + ((SmallGroupVO)vo).getName()));
                Vector<String> paramsGroup = new Vector<String>();
                paramsGroup.add(newUser);
                paramsGroup.add(((SmallGroupVO)vo).getName());
                this.getGroupManagementBySOAP("urn:GroupConnector", "addUserToGroup", paramsGroup);
            }
            logger_.debug((Object)"copied groups");
            return true;
        }
        catch (Exception ex) {
            logger_.debug((Object)("could not copy from template user " + ex.toString()));
            return false;
        }
    }

    public String getCookieKey(String applicationname) throws UserSecurityException {
        return AuthenticationHandlerSOAP.getCookieKey(applicationname);
    }

    public boolean logoutUser(String username, String applicationname) throws UserSecurityException {
        Vector<String> params = new Vector<String>();
        params.add(username);
        params.add(applicationname);
        return (Boolean)this.getRightsManagementBySOAP("urn:RightsConnector", "logoutUser", params);
    }

    public String refreshAuthenticationId(String username, String authenticationId, String realm) throws UserSecurityException {
        Vector<Object> params = new Vector<Object>();
        params.add(username);
        params.add(authenticationId);
        params.add(new Long(ConfigLoader.getInstance(realm).getCookieMaxAge()));
        String authId = (String)this.getRightsManagementBySOAP("urn:RightsConnector", "logoutUser", params);
        if (authId.equalsIgnoreCase("false")) {
            throw new UserSecurityException("The refresh of the authentication ID did not work");
        }
        return authId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

