/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.taglib;

import at.tugraz.genome.usermanagement.UserManagementConstants;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnectionManager;
import at.tugraz.genome.usermanagement.serverconnection.cache.PermissionCache;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckPermissionTag
extends TagSupport {
    private String userName = null;
    private String resourceKey;
    private String accessLevel;
    private String applicationname;
    private String applicationkey;
    private String authenticationID;
    private ServerConnection serverConnection = null;
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$taglib$CheckPermissionTag == null ? (class$at$tugraz$genome$usermanagement$taglib$CheckPermissionTag = CheckPermissionTag.class$("at.tugraz.genome.usermanagement.taglib.CheckPermissionTag")) : class$at$tugraz$genome$usermanagement$taglib$CheckPermissionTag));
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$taglib$CheckPermissionTag;

    public void setApplicationName(String name) {
        this.applicationname = name;
    }

    public String getApplicationName() {
        return this.applicationname;
    }

    public void setAccessLevel(String level) {
        this.accessLevel = level;
    }

    public String getAccessLevel() {
        return this.accessLevel;
    }

    public void setResourceKey(String key) {
        this.resourceKey = key;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public int doStartTag() throws JspException {
        HttpSession session = this.pageContext.getSession();
        try {
            this.userName = ((UserVO)session.getAttribute(UserManagementConstants.USER)).getName();
        }
        catch (Exception ex) {
            this.userName = (String)session.getAttribute(UserManagementConstants.USER);
        }
        if (this.userName == null) {
            return 0;
        }
        if (this.applicationname == null) {
            this.applicationname = (String)session.getAttribute(UserManagementConstants.APPLICATIONNAME);
        }
        if (this.applicationname == null) {
            logger_.error((Object)"no applicationame defined");
            return 0;
        }
        this.applicationkey = ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword");
        if (this.applicationkey == null) {
            logger_.error((Object)"no applicationkey defined");
            return 0;
        }
        this.authenticationID = (String)session.getAttribute("Authentication_Id");
        if (this.authenticationID == null) {
            logger_.error((Object)"no authenticationID in session stored");
            return 0;
        }
        this.serverConnection = ServerConnectionManager.getInstance().getConnection(this.applicationname);
        if (this.serverConnection == null) {
            logger_.error((Object)"no connection to UserManagement server");
            return 0;
        }
        try {
            if (PermissionCache.hasPermission(this.userName, this.authenticationID, this.applicationname, this.resourceKey, this.accessLevel, this.applicationkey)) {
                logger_.debug((Object)("access granted to resource: " + this.resourceKey + ", with level: " + this.accessLevel + " for user " + this.userName));
                return 1;
            }
            logger_.debug((Object)("access denied to resource: " + this.resourceKey + ", with level: " + this.accessLevel + " for user " + this.userName));
            return 0;
        }
        catch (Exception ex) {
            logger_.error((Object)ex.toString());
            return 0;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

